/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.smd.kb.BusinessArea;
import com.ibm.cognos.smd.kb.BusinessAreaApplicability;
import com.ibm.cognos.smd.kb.BusinessDomain;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.kb.ConceptInventoryExtended;
import com.ibm.cognos.smd.kb.SignifierContainer;
import com.ibm.cognos.smd.utilities.FileUtility;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ExtensionSource {
    private static final String BASE_SOURCE_ID = "smd.kb.core";
    private String mSourceID = null;
    private ConceptInventory mConceptInventory = null;
    private List<BusinessDomain> mDomains = new ArrayList<BusinessDomain>();
    private List<SignifierContainer> mSignifierContainers = new ArrayList<SignifierContainer>();

    static ExtensionSource load(String sourceID, boolean isDirOrRes) {
        ExtensionSource out = sourceID != null ? new ExtensionSource(sourceID, isDirOrRes) : new ExtensionSource(BASE_SOURCE_ID, ConceptInventory.getCoreInventory());
        return out;
    }

    ExtensionSource(String sourceID, boolean isDirOrRes) {
        this.mSourceID = sourceID;
        this.mConceptInventory = new ConceptInventoryExtended(this);
        this.loadExtensionArtifacts(isDirOrRes);
        this.mConceptInventory.calculateActivationSpreads();
    }

    protected ExtensionSource(String sourceID, ConceptInventory coreKB) {
        this.mSourceID = sourceID;
        this.mConceptInventory = coreKB;
    }

    String getSourceID() {
        return this.mSourceID;
    }

    public boolean isCoreSource() {
        return BASE_SOURCE_ID.equals(this.mSourceID);
    }

    public boolean hasDomains() {
        return !this.mDomains.isEmpty();
    }

    public ConceptInventory getConceptInventory() {
        return this.mConceptInventory;
    }

    public List<BusinessAreaApplicability> findApplicableBusinessAreas(List<IConcept> modelConcepts) {
        ArrayList<BusinessAreaApplicability> vOut = new ArrayList<BusinessAreaApplicability>();
        Collections.sort(vOut, new BusinessAreaApplicability.BAAComparator());
        for (BusinessDomain bd : this.mDomains) {
            bd.findApplicableBusinessAreas(modelConcepts, vOut);
        }
        return vOut;
    }

    private void loadExtensionArtifacts(boolean isDirOrRes) {
        long b4 = ToolBox.logPerfIndicators("/extension/setup/time", 0L);
        try {
            if (isDirOrRes) {
                List<File> xmlFiles = FileUtility.collectFiles(this.mSourceID, ".xml");
                for (File f : xmlFiles) {
                    this.readContent(new FileInputStream(f));
                }
            } else {
                InputStream exStr = this.openExtensionResources(this.mSourceID);
                this.readContent(exStr);
            }
        }
        catch (FileNotFoundException fe) {
            throw new RuntimeException(fe);
        }
        ToolBox.logPerfIndicators(this.mSourceID + "/extension/setup/time", b4);
    }

    List<SignifierContainer> collectSignifierContainers() {
        ArrayList<SignifierContainer> containers = new ArrayList<SignifierContainer>();
        for (BusinessDomain bd : this.mDomains) {
            bd.collectSignifierContainers(containers);
        }
        for (SignifierContainer sc : this.mSignifierContainers) {
            containers.add(sc);
        }
        return containers;
    }

    private InputStream openExtensionResources(String resSrc) {
        InputStream str = this.getClass().getResourceAsStream(resSrc);
        if (str == null) {
            throw new RuntimeException("unable to access the extension source:" + resSrc);
        }
        return str;
    }

    private void readContent(InputStream source) {
        try {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read(source);
            Element elmRoot = document.getRootElement();
            if ("domain".equals(elmRoot.getName())) {
                this.newDomain(elmRoot);
            } else if ("analysisArea".equals(elmRoot.getName())) {
                this.newAnalysisArea(elmRoot);
            } else if ("concepts".equals(elmRoot.getName())) {
                this.newConceptContainer(elmRoot);
            } else if ("conceptSignifiers".equals(elmRoot.getName())) {
                this.newSignifierContainer(elmRoot);
            } else if ("extension".equals(elmRoot.getName())) {
                this.newExtension(elmRoot);
            } else {
                System.err.println("Unrecognized extension content: " + elmRoot.getName() + "\n Expecting one of 'domain', 'analysisArea', 'extension', 'concepts', or 'conceptSignifiers' ");
            }
        }
        catch (DocumentException e) {
            throw new RuntimeException("Failed to set up the extension source!", e);
        }
    }

    BusinessDomain findDomain(String dName) {
        for (BusinessDomain bd : this.mDomains) {
            if (!bd.getName().equals(dName)) continue;
            return bd;
        }
        return null;
    }

    private void newDomain(Element elmSpec) {
        String dName = elmSpec.attributeValue("name");
        ToolBox.Assert(dName != null && dName.length() > 0, "Expecting a valid name for 'domain'");
        BusinessDomain baseDomain = null;
        String sExtends = elmSpec.attributeValue("extends");
        if (sExtends != null && sExtends.length() > 0) {
            ToolBox.Assert(!sExtends.equals(dName), "Domain cannot inherit from self. Double check the definition for Domain: ", dName);
            baseDomain = this.findDomain(sExtends);
            ToolBox.Assert(baseDomain != null, "Unable to find the base Domain for Domain: ", dName);
        }
        BusinessDomain newDomain = new BusinessDomain(this, dName, baseDomain);
        this.mDomains.add(newDomain);
        newDomain.setup(elmSpec);
    }

    private void newAnalysisArea(Element elmSpec) {
        String dName = elmSpec.attributeValue("name");
        ToolBox.Assert(dName != null && dName.length() > 0, "Expecting a valid name for 'analysis area'");
        String sDomain = elmSpec.attributeValue("domain");
        ToolBox.Assert(sDomain != null && sDomain.length() > 0, "Exoecting a valid 'domain' for analysis area: ", dName);
        BusinessDomain objDomain = this.findDomain(sDomain);
        ToolBox.Assert(objDomain != null, "Unable to find the base Domain '", sDomain, "' specified for analysisArea:", dName);
        BusinessArea newArea = new BusinessArea(this, dName, objDomain);
        objDomain.addAreaOfAnalysis(newArea);
        newArea.setup(elmSpec);
    }

    private void newExtension(Element elmSpec) {
        Element elm = elmSpec.element("concepts");
        if (elm != null) {
            this.newConceptContainer(elm);
        }
        if ((elm = elmSpec.element("conceptSignifiers")) != null) {
            this.newSignifierContainer(elm);
        }
    }

    private void newConceptContainer(Element elmSpec) {
        this.mConceptInventory.loadConcepts(elmSpec, null);
    }

    private void newSignifierContainer(Element elmSpec) {
        SignifierContainer cont = new SignifierContainer(this);
        cont.setup(elmSpec);
        this.mSignifierContainers.add(cont);
    }
}

