/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.analyzer.LexicalInfo;
import com.ibm.cognos.smd.kb.ActivationSpread;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.kb.ExtensionSource;
import com.ibm.cognos.smd.kb.Signifier;
import com.ibm.cognos.smd.kb.SignifierContainer;
import com.ibm.cognos.smd.kb.SignifierData;
import com.ibm.cognos.smd.utilities.TextSearchEngine;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class LexicalClueInventory {
    private SignifierContainer mSignifierContainer;
    private Locale mLocale;
    private String mSourceName;
    private Set<String> mClues = null;
    private LexicalInfo mLexicalInfo = new LexicalInfo();
    private TextSearchEngine mSearchEngine = new TextSearchEngine();
    private ExtensionSource mExtensionSrc;

    static LexicalClueInventory create(ExtensionSource srcExtension, Locale aLocale, InputStream sourceStream, String sourceName) {
        LexicalClueInventory out = new LexicalClueInventory(srcExtension, aLocale, sourceName);
        out.readContent(sourceStream);
        return out;
    }

    private LexicalClueInventory(ExtensionSource srcExtension, Locale aLocale, String sourceName) {
        this.mLocale = aLocale;
        this.mSourceName = sourceName;
        this.mSignifierContainer = new SignifierContainer(srcExtension, this.mLocale);
        this.mExtensionSrc = srcExtension;
    }

    void setExtensionSource(ExtensionSource srcExtension) {
        this.mExtensionSrc = srcExtension;
    }

    final SignifierContainer getSignifierContainer() {
        return this.mSignifierContainer;
    }

    public List<ActivationSpread> getActivationFor(Map<Signifier, Float> signifiers, DataItemExtension dix) {
        ConceptInventory aKB = this.mExtensionSrc.getConceptInventory();
        ArrayList<ActivationSpread> out = new ArrayList<ActivationSpread>(signifiers.size());
        for (Map.Entry<Signifier, Float> entry : signifiers.entrySet()) {
            Signifier sig = entry.getKey();
            ActivationSpread as = aKB.getActivationSpread(sig.getConcept());
            if (as == null) continue;
            out.add(as);
            if (dix == null) continue;
            dix.addCandidate(as, entry.getValue());
        }
        return out;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public String getCluseSourceName() {
        return this.mSourceName;
    }

    public Set<String> getLexicalClues() {
        if (this.mClues != null) {
            return this.mClues;
        }
        this.mClues = new HashSet<String>(300);
        this.mSignifierContainer.collectLexicalClues(this.mClues);
        if (!this.mExtensionSrc.isCoreSource()) {
            for (SignifierContainer sc : this.mExtensionSrc.collectSignifierContainers()) {
                sc.collectLexicalClues(this.mClues);
            }
        }
        if (this.mClues != null) {
            for (String s : this.mClues) {
                if (this.isAbbreviation(s)) continue;
                this.mSearchEngine.addKeyword(s);
            }
        }
        return this.mClues;
    }

    public Set<String> getLexicalCluesForConcepts(List<Concept> concepts) {
        HashSet<String> outClues = new HashSet<String>(concepts.size() * 2);
        this.mSignifierContainer.collectCluesForConcepts(outClues, concepts);
        if (!this.mExtensionSrc.isCoreSource()) {
            for (SignifierContainer sc : this.mExtensionSrc.collectSignifierContainers()) {
                sc.collectCluesForConcepts(outClues, concepts);
            }
        }
        return outClues;
    }

    public LexicalInfo getLexicalInfo() {
        return this.mLexicalInfo;
    }

    public TextSearchEngine getSearchEngine() {
        return this.mSearchEngine;
    }

    public SignifierData getDataSignifier(Concept c) {
        return this.mSignifierContainer.getDataSignifier(c);
    }

    public boolean isAbbreviation(String clue) {
        if (clue.length() > 2) {
            return false;
        }
        return !this.mLexicalInfo.isCompounding() && !this.isForAsianLanguage();
    }

    public boolean requiresTokenBasedSearch() {
        return this.mLexicalInfo.isCompounding() || this.isForAsianLanguage();
    }

    public boolean isForAsianLanguage() {
        return Locale.JAPANESE.getLanguage().equals(this.mLocale.getLanguage()) || Locale.CHINESE.getLanguage().equals(this.mLocale.getLanguage()) || Locale.KOREAN.getLanguage().equals(this.mLocale.getLanguage());
    }

    public Map<Signifier, Float> collectSignifiers(List<String> multiPartClue, List<String> usedClues) {
        HashMap<Signifier, Float> out = new HashMap<Signifier, Float>();
        this.doCollect(this.mSignifierContainer, multiPartClue, usedClues, out);
        if (!this.mExtensionSrc.isCoreSource()) {
            for (SignifierContainer sc : this.mExtensionSrc.collectSignifierContainers()) {
                this.doCollect(sc, multiPartClue, usedClues, out);
            }
        }
        if (out.isEmpty() || out.size() == 1) {
            return out;
        }
        boolean uniformConcepts = true;
        Concept lastConcept = null;
        Concept patternConcept = null;
        boolean involvesPattern = false;
        Iterator iter = out.entrySet().iterator();
        while (iter.hasNext()) {
            Signifier s = (Signifier)iter.next().getKey();
            if (!involvesPattern && s.includesPattern()) {
                involvesPattern = true;
                patternConcept = s.getConcept();
            }
            uniformConcepts = this.checkUniformity(lastConcept, s.getConcept());
            lastConcept = s.getConcept();
        }
        if (involvesPattern && uniformConcepts) {
            Iterator iter1 = out.entrySet().iterator();
            while (iter1.hasNext()) {
                Signifier s = (Signifier)iter1.next().getKey();
                if (s.includesPattern() || s.getConcept().is(patternConcept)) continue;
                iter1.remove();
            }
        }
        return out;
    }

    public Signifier lookupSignifierByName(String sigName) {
        return this.mSignifierContainer.lookupNameBasedSignifier(sigName);
    }

    private boolean checkUniformity(Concept last, Concept curr) {
        if (last == null) {
            return true;
        }
        if (last.isAttribute() && !curr.isAttribute()) {
            return false;
        }
        if (last.isCategory() && !curr.isCategory()) {
            return false;
        }
        return !last.isMetric() || curr.isMetric();
    }

    private void doCollect(SignifierContainer aSignifierContainer, List<String> multiPartClue, List<String> usedClues, Map<Signifier, Float> out) {
        for (String clue : multiPartClue) {
            float match;
            Collection<?> signifiers = aSignifierContainer.lookupSignifiers(clue);
            if (signifiers == null) continue;
            if (usedClues != null && !usedClues.contains(clue)) {
                usedClues.add(clue);
            }
            Iterator<?> itr = signifiers.iterator();
            if (signifiers.size() == 1) {
                Signifier sig = (Signifier)itr.next();
                float match2 = sig.evaluateLabel(multiPartClue);
                if (!(match2 > 0.0f)) continue;
                out.put(sig, Float.valueOf(match2));
                continue;
            }
            Signifier maxSig = null;
            float maxMatch = 0.0f;
            while (itr.hasNext()) {
                Signifier sig = (Signifier)itr.next();
                match = sig.evaluateLabel(multiPartClue);
                if (!(match > maxMatch)) continue;
                maxMatch = match;
                maxSig = sig;
            }
            if (!(maxMatch > 0.0f)) continue;
            out.put(maxSig, Float.valueOf(maxMatch));
            for (Signifier sig : signifiers) {
                if (maxSig.equals(sig) || !((double)Math.abs((match = sig.evaluateLabel(multiPartClue)) - maxMatch) < 0.001)) continue;
                out.put(sig, Float.valueOf(match));
            }
        }
    }

    private void readContent(InputStream source) {
        long b4 = ToolBox.logPerfIndicators("/KBClues/setup/time", 0L);
        try {
            try {
                SAXReader saxReader = new SAXReader();
                Document document = saxReader.read(source);
                Element elmRoot = document.getRootElement();
                this.parseTokenizerSection(elmRoot);
                this.parseWordStemmingSection(elmRoot);
                Element elmSignifiers = elmRoot.element("conceptSignifiers");
                if (elmSignifiers != null) {
                    this.mSignifierContainer.setup(elmSignifiers);
                }
                if ((elmSignifiers = elmRoot.element("signifiers")) != null) {
                    this.mSignifierContainer.setupGeneric(elmSignifiers);
                }
                ToolBox.trace(this.mSourceName + "/KBClues/setup/totalClues", Integer.toString(this.getLexicalClues().size()));
                ToolBox.logPerfIndicators("/KBClues/setup/time", b4);
            }
            catch (DocumentException e) {
                throw new RuntimeException("Failed to set up the knowledge base clues!", e);
            }
            finally {
                if (null != source) {
                    source.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to set up the knowledge base clues!", e);
        }
    }

    private void parseTokenizerSection(Element elmRoot) {
        Element elmDel = (Element)elmRoot.selectSingleNode("tokenizer/delimitingPattern");
        if (elmDel != null) {
            this.mLexicalInfo.setDelimitingPattern(elmDel.getTextTrim());
        }
        List elmSymbols = elmRoot.selectNodes("tokenizer/embeddedSymbolsToDetect/s");
        for (Element elm : elmSymbols) {
            this.mLexicalInfo.addEmbeddedSymbolToDetect(elm.getTextTrim());
        }
        Element elmComp = (Element)elmRoot.selectSingleNode("tokenizer/isCompounding");
        if (elmComp != null) {
            this.mLexicalInfo.setIsCompounding("true".equals(elmComp.getTextTrim()));
        }
    }

    private void parseWordStemmingSection(Element elmRoot) {
        Element elmPre = (Element)elmRoot.selectSingleNode("wordStemming/preFixSubstitutions");
        this.parseReplacementEntries(elmPre, this.mLexicalInfo.getPrefixReplacement());
        elmPre = (Element)elmRoot.selectSingleNode("wordStemming/inFixSubstitutions");
        this.parseReplacementEntries(elmPre, this.mLexicalInfo.getInfixReplacement());
        elmPre = (Element)elmRoot.selectSingleNode("wordStemming/suFfixSubstitutions");
        this.parseReplacementEntries(elmPre, this.mLexicalInfo.getSuffixReplacement());
        elmPre = (Element)elmRoot.selectSingleNode("wordStemming/specialCases");
        this.parseReplacementEntries(elmPre, this.mLexicalInfo.getSpecialReplacements());
    }

    private void parseReplacementEntries(Element elmSec, Map<String, String> replaceMap) {
        if (elmSec == null) {
            return;
        }
        List elmReps = elmSec.elements("replace");
        for (Element elmRep : elmReps) {
            String src = elmRep.attributeValue("src");
            String with = elmRep.attributeValue("with");
            ToolBox.Assert(src != null && src.length() > 0, "Expecting a valid source for word stemming replacement instruction", elmRep.asXML());
            replaceMap.put(src.toUpperCase(this.mLocale), with == null || with.length() == 0 ? null : with.toUpperCase(this.mLocale));
        }
    }
}

