/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.smd.kb.ExtensionSource;
import com.ibm.cognos.smd.kb.LexicalClueInventory;
import java.io.InputStream;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

public class LexicalClueInventoryManager {
    private static final String DEFAULT_KB_CLUES = "/config/KnowledgeBaseClues_en.xml";
    private static final String KB_CLUES_BASE_NAME = "/config/KnowledgeBaseClues";
    private static LexicalClueInventoryManager gInstance = null;
    private ConcurrentHashMap<String, LexicalClueInventory> mInventories = new ConcurrentHashMap(10);

    public static LexicalClueInventoryManager getInstance() {
        return gInstance;
    }

    private LexicalClueInventoryManager() {
    }

    public LexicalClueInventory getLexicalInventoryFor(ExtensionSource srcExtension, Locale locale) {
        return this.findOrAddInventory(srcExtension, locale);
    }

    private LexicalClueInventory findOrAddInventory(ExtensionSource srcExtension, Locale aLocale) {
        String key = aLocale.getDisplayName() + srcExtension.getSourceID();
        LexicalClueInventory out = this.mInventories.get(key);
        if (out != null) {
            return out;
        }
        StringBuilder sourceName = new StringBuilder();
        InputStream sourceStream = this.getCluesSource(aLocale, sourceName);
        out = LexicalClueInventory.create(srcExtension, aLocale, sourceStream, sourceName.toString());
        this.mInventories.put(key, out);
        return out;
    }

    private InputStream getCluesSource(Locale aLocale, StringBuilder sb) {
        sb.append(KB_CLUES_BASE_NAME);
        sb.append("_");
        sb.append(aLocale.getLanguage());
        sb.append(".xml");
        InputStream str = this.getClass().getResourceAsStream(sb.toString());
        if (str == null) {
            sb.setLength(0);
            sb.append(DEFAULT_KB_CLUES);
            str = this.getClass().getResourceAsStream(sb.toString());
        }
        if (str == null) {
            throw new RuntimeException("Unable to locate the knowledge base clues.");
        }
        return str;
    }

    static {
        gInstance = new LexicalClueInventoryManager();
    }
}

