/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.api.smd.kb.IRelation;
import com.ibm.cognos.smd.utilities.ToolBox;

public class Relation
implements IRelation {
    private boolean mIsWholePart = false;
    private ECardinality mCard = ECardinality.Unknown;
    private String mLabel = null;
    private IConcept mEndFrom = null;
    private IConcept mEndTo = null;

    Relation(IConcept one, IConcept two, String label, String card, boolean isWholePart) {
        ToolBox.Assert(!isWholePart || isWholePart && "1:n".equals(card), "Whole-part relationships are expected to have a 1:n cardinality.");
        this.mEndFrom = one;
        this.mEndTo = two;
        this.mIsWholePart = isWholePart;
        this.mCard = ECardinality.convertFrom((String)card);
        this.mLabel = label;
    }

    Relation(IConcept one, IConcept two, String label, ECardinality eCard, boolean isWholePart) {
        this.mEndFrom = one;
        this.mEndTo = two;
        this.mIsWholePart = isWholePart;
        this.mCard = eCard;
        this.mLabel = label;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public boolean isWholePart() {
        return this.mIsWholePart;
    }

    public ECardinality getCardinality() {
        return this.mCard;
    }

    public IConcept getFromEnd() {
        return this.mEndFrom;
    }

    public IConcept getToEnd() {
        return this.mEndTo;
    }
}

