/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.Signifier;
import com.ibm.cognos.smd.kb.SignifierLabel;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SignifierComplex
extends Signifier {
    private List<Signifier> mNestedSignifiers;
    private Signifier.ESigType mType = Signifier.ESigType.eCombinationAny;

    protected SignifierComplex(Concept c, String sType) {
        super(c);
        if (sType != null) {
            ToolBox.Assert("any".equals(sType) || "sequence".equals(sType), "Expecting either 'any' or 'sequence' for a combination signifier type");
            if ("sequence".equals(sType)) {
                this.mType = Signifier.ESigType.eCombinationSequence;
            }
        }
    }

    void addNestedSignifier(SignifierLabel s) {
        ToolBox.Assert(this.mType == Signifier.ESigType.eCombinationSequence || this.mType == Signifier.ESigType.eCombinationAny, "Nested Signifiers are allowed only for sinifiers of type 'combination' or 'sequence'");
        if (this.mNestedSignifiers == null) {
            this.mNestedSignifiers = new ArrayList<Signifier>(5);
        }
        this.mNestedSignifiers.add(s);
    }

    @Override
    public List<String> getLabelClues() {
        if (this.mNestedSignifiers == null) {
            return null;
        }
        ArrayList<String> combinedClues = new ArrayList<String>(this.mNestedSignifiers.size() * 2);
        for (Signifier s : this.mNestedSignifiers) {
            combinedClues.addAll(s.getLabelClues());
        }
        return combinedClues;
    }

    @Override
    public float evaluateLabel(List<String> multiPartClue) {
        switch (this.mType) {
            case eCombinationAny: {
                return this.evaluateCombination(multiPartClue);
            }
            case eCombinationSequence: {
                return this.evaluateSequence(multiPartClue);
            }
        }
        return 0.0f;
    }

    @Override
    public boolean includesPattern() {
        for (Signifier s : this.mNestedSignifiers) {
            if (!s.includesPattern()) continue;
            return true;
        }
        return false;
    }

    private float evaluateCombination(List<String> multiPartClue) {
        int idx;
        if (this.mNestedSignifiers == null) {
            return 0.0f;
        }
        if (this.mNestedSignifiers.size() > multiPartClue.size()) {
            return 0.0f;
        }
        float[] nestedResuts = new float[this.mNestedSignifiers.size()];
        Arrays.fill(nestedResuts, 0.0f);
        for (idx = 0; idx < this.mNestedSignifiers.size(); ++idx) {
            nestedResuts[idx] = this.mNestedSignifiers.get(idx).evaluateLabel(multiPartClue);
        }
        for (idx = 0; idx < nestedResuts.length; ++idx) {
            if (nestedResuts[idx] != 0.0f) continue;
            return 0.0f;
        }
        return (float)this.mNestedSignifiers.size() / (float)multiPartClue.size();
    }

    private float evaluateSequence(List<String> multiPartClue) {
        if (this.mNestedSignifiers == null) {
            return 0.0f;
        }
        int idxClue = -1;
        for (int idx = 0; idx < this.mNestedSignifiers.size(); ++idx) {
            if ((idxClue = this.findNextMatchInSequence(idx, idxClue + 1, multiPartClue)) != -1) continue;
            return 0.0f;
        }
        return 1.0f;
    }

    private int findNextMatchInSequence(int seqIdx, int startTokenIdx, List<String> multiPartClue) {
        if (startTokenIdx >= multiPartClue.size()) {
            return -1;
        }
        SignifierLabel nestedSig = (SignifierLabel)this.mNestedSignifiers.get(seqIdx);
        for (int idx = startTokenIdx; idx < multiPartClue.size(); ++idx) {
            if (!nestedSig.evaluateSingle(multiPartClue.get(idx))) continue;
            return idx;
        }
        return -1;
    }
}

