/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ExtensionSource;
import com.ibm.cognos.smd.kb.Signifier;
import com.ibm.cognos.smd.kb.SignifierComplex;
import com.ibm.cognos.smd.kb.SignifierData;
import com.ibm.cognos.smd.kb.SignifierLabel;
import com.ibm.cognos.smd.utilities.SmdMessage;
import com.ibm.cognos.smd.utilities.ToolBox;
import com.ibm.icu.text.DateFormatSymbols;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.dom4j.Element;

final class SignifierContainer {
    private Locale mLocale;
    private ExtensionSource mExtensionSource;
    private DateFormatSymbols mICUDateFormatSymbols;
    private MultiMap mClues2Signifiers;
    private Map<Concept, SignifierData> mConcept2DataSignifiers;
    private Map<String, Signifier> mNameBasedSignifiers;

    SignifierContainer(ExtensionSource srcExtension, Locale aLocale) {
        this.mLocale = aLocale;
        this.mExtensionSource = srcExtension;
        this.mICUDateFormatSymbols = new DateFormatSymbols(this.mLocale);
        this.mClues2Signifiers = new MultiValueMap();
        this.mConcept2DataSignifiers = new HashMap<Concept, SignifierData>(20);
        this.mNameBasedSignifiers = new HashMap<String, Signifier>(10);
    }

    SignifierContainer(ExtensionSource srcExtension) {
        this(srcExtension, new Locale("en"));
    }

    void collectCluesForConcepts(Set<String> outClues, List<Concept> concepts) {
        for (Object e : this.mClues2Signifiers.entrySet()) {
            Map.Entry entry = (Map.Entry)e;
            boolean bConceptMatches = false;
            for (Signifier sig : (Collection)entry.getValue()) {
                if (!concepts.contains(sig.getConcept())) continue;
                bConceptMatches = true;
                break;
            }
            if (!bConceptMatches) continue;
            outClues.add((String)entry.getKey());
        }
    }

    void collectLexicalClues(Set<String> clues) {
        clues.addAll(this.mClues2Signifiers.keySet());
        if (this.mNameBasedSignifiers != null) {
            for (Map.Entry<String, Signifier> e : this.mNameBasedSignifiers.entrySet()) {
                clues.addAll(e.getValue().getLabelClues());
            }
        }
    }

    SignifierData getDataSignifier(Concept c) {
        return this.mConcept2DataSignifiers.get(c);
    }

    Collection<?> lookupSignifiers(String clue) {
        Collection signifiers = (Collection)this.mClues2Signifiers.get((Object)clue);
        return signifiers;
    }

    Signifier lookupNameBasedSignifier(String sigName) {
        return this.mNameBasedSignifiers.get(sigName);
    }

    void setup(Element elmRoot) {
        List elmConcepts = elmRoot.elements("conceptSignifier");
        for (Element elmCon : elmConcepts) {
            this.newConceptSignifier(elmCon);
        }
    }

    void setupGeneric(Element elmRoot) {
        List elmSigs = elmRoot.elements("signifier");
        for (Element elmSig : elmSigs) {
            this.newNameBasedSignifier(elmSig);
        }
    }

    private void registerClues(Signifier sig) {
        if (sig.getLabelClues() != null) {
            for (String ls : sig.getLabelClues()) {
                this.mClues2Signifiers.put((Object)ls, (Object)sig);
            }
        }
    }

    private void newConceptSignifier(Element elmSig) {
        String aValue = elmSig.attributeValue("conceptName");
        ToolBox.Assert(aValue != null && aValue.length() > 0, "Expecting a valid concept name for conceptSignifier");
        Concept baseConcept = (Concept)this.mExtensionSource.getConceptInventory().getConcept(aValue);
        ToolBox.Assert(baseConcept != null, "Unable to locate the signifier's base concept:", aValue);
        List listChildren = elmSig.elements();
        for (Element elmChild : listChildren) {
            Signifier sig;
            String tagName = elmChild.getName();
            if (tagName.equals("label")) {
                sig = this.parseLabelSignifier(baseConcept, elmChild);
                this.registerClues(sig);
                continue;
            }
            if (tagName.equals("data")) {
                sig = this.parseDataSignifier(baseConcept, elmChild);
                this.mConcept2DataSignifiers.put(baseConcept, (SignifierData)sig);
                continue;
            }
            if (tagName.equals("combination")) {
                sig = this.parseComplexSignifier(baseConcept, elmChild);
                this.registerClues(sig);
                continue;
            }
            ToolBox.Assert(false, "Unexpected element for ConceptSignifier:", tagName);
        }
    }

    private void newNameBasedSignifier(Element elmSig) {
        String aName = elmSig.attributeValue("name");
        ToolBox.Assert(aName != null && aName.length() > 0, "Expecting a valid signifier name");
        ToolBox.Assert(this.mNameBasedSignifiers.get(aName) == null, "Another signifier with the same name already exists:", aName);
        List listChildren = elmSig.elements();
        for (Element elmChild : listChildren) {
            Signifier sig;
            String tagName = elmChild.getName();
            if (tagName.equals("label")) {
                sig = this.parseLabelSignifier(null, elmChild);
                this.mNameBasedSignifiers.put(aName, sig);
                continue;
            }
            if (tagName.equals("data")) {
                ToolBox.Assert(false, "Data clues are not currently supported for name-based signifiers:", aName);
                continue;
            }
            if (tagName.equals("combination")) {
                sig = this.parseComplexSignifier(null, elmChild);
                this.mNameBasedSignifiers.put(aName, sig);
                continue;
            }
            ToolBox.Assert(false, "Unexpected element:", tagName, " for signifier:", aName);
        }
    }

    private SignifierLabel parseLabelSignifier(Concept baseConcept, Element elmSignifier) {
        SignifierLabel sig = new SignifierLabel(baseConcept);
        List elmLabelSigs = elmSignifier.elements("clue");
        for (Element elmLabel : elmLabelSigs) {
            this.addClues(sig.getLabelClues(), sig.getLabelPatterns(), elmLabel, true);
        }
        ToolBox.Assert(sig.getLabelClues().isEmpty() || sig.getLabelPatterns().isEmpty(), "Patterns and non-patterns clues cannot be mixed!");
        return sig;
    }

    private SignifierData parseDataSignifier(Concept baseConcept, Element elmSignifier) {
        SignifierData sig = new SignifierData(baseConcept);
        List elmLabelSigs = elmSignifier.selectNodes("value");
        for (Element elmLabel : elmLabelSigs) {
            this.addClues(sig.getValueClues(), null, elmLabel, false);
        }
        List elmRanges = elmSignifier.elements("range");
        for (Element elmRange : elmRanges) {
            String sFrom = elmRange.attributeValue("from");
            String sTo = elmRange.attributeValue("to");
            sig.addRange(sFrom, sTo);
        }
        return sig;
    }

    private SignifierComplex parseComplexSignifier(Concept baseConcept, Element elmSignifier) {
        String sigType = elmSignifier.attributeValue("type");
        SignifierComplex sigParent = new SignifierComplex(baseConcept, sigType);
        List elmLNestedSigs = elmSignifier.elements("label");
        for (Element elmSig : elmLNestedSigs) {
            SignifierLabel sig = this.parseLabelSignifier(baseConcept, elmSig);
            sigParent.addNestedSignifier(sig);
        }
        return sigParent;
    }

    private void addClues(List<String> sigClues, List<String> sigPatterns, Element elmClue, boolean isLabel) {
        String resType = elmClue.attributeValue("type");
        if (resType == null || resType.length() == 0) {
            resType = "text";
        }
        EResType eResType = EResType.valueOf(resType);
        String s = null;
        String resValues = elmClue.getText();
        block6: for (String resVal : resValues.split("\\s+")) {
            switch (eResType) {
                case resMessage: {
                    s = SmdMessage.renderMessage(resVal, this.mLocale, isLabel);
                    if (s == null || s.length() <= 0) continue block6;
                    sigClues.add(s);
                    continue block6;
                }
                case resSection: {
                    sigClues.addAll(SmdMessage.renderMessagesInSection(resVal, this.mLocale, isLabel));
                    continue block6;
                }
                case ICU: {
                    this.addICUResources(sigClues, resVal);
                    continue block6;
                }
                case pattern: {
                    ToolBox.Assert(isLabel, "Clues of type 'pattern' are currently supported only for label clues");
                    sigPatterns.add(resVal);
                    continue block6;
                }
                default: {
                    sigClues.add(isLabel ? resVal.toUpperCase(this.mLocale) : resVal);
                }
            }
        }
    }

    private void addICUResources(List<String> sigClues, String icuResKey) {
        if ("ICU_MONTH_NAMES".equals(icuResKey)) {
            this.addArrayToList(sigClues, this.mICUDateFormatSymbols.getShortMonths());
            this.addArrayToList(sigClues, this.mICUDateFormatSymbols.getMonths());
        } else if ("ICU_WEEK_DAY_NAMES".equals(icuResKey)) {
            this.addArrayToList(sigClues, this.mICUDateFormatSymbols.getShortWeekdays());
            this.addArrayToList(sigClues, this.mICUDateFormatSymbols.getWeekdays());
        } else {
            ToolBox.Assert(false, "Unexpected ICU resource key:", icuResKey);
        }
    }

    private void addArrayToList(List<String> sigClues, String[] array) {
        for (String s : array) {
            sigClues.add(s);
        }
    }

    private static enum EResType {
        resMessage,
        resSection,
        text,
        ICU,
        pattern;

    }
}

