/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.DataHints;
import com.ibm.cognos.smd.kb.Signifier;
import com.ibm.cognos.smd.utilities.SmdConfig;
import java.util.ArrayList;
import java.util.List;

class SignifierData
extends Signifier {
    private static final int VALUE_MATCH_THRESHOLD = SmdConfig.getInstance().getValue("dataValueMatch", "valueMatchThreshold", 3);
    private static final int USE_CASE_Insensitive_Match = SmdConfig.getInstance().getValue("dataValueMatch", "useCaseInsensitiveMatch", 1);
    private List<String> mDataValues = new ArrayList<String>();
    private List<DataHints.Range> mRanges;

    SignifierData(Concept c) {
        super(c);
    }

    @Override
    public List<String> getLabelClues() {
        return null;
    }

    @Override
    public List<String> getValueClues() {
        return this.mDataValues;
    }

    @Override
    public float evaluateLabel(List<String> multiPartClue) {
        return 0.0f;
    }

    @Override
    public float evaluateDataValues(DataItemExtension dix) {
        if (!this.mDataValues.isEmpty()) {
            return this.matchDataValues(dix.getSampleDataPoints());
        }
        if (this.mRanges != null) {
            return DataHints.evaluateRanges(this.mRanges, dix.getDataItem());
        }
        return -1.0f;
    }

    private float matchDataValues(List<IValue> dataSample) {
        if (dataSample == null || dataSample.isEmpty()) {
            return -1.0f;
        }
        int hitNum = 0;
        if (USE_CASE_Insensitive_Match == 1) {
            for (IValue v : dataSample) {
                if (!this.containsValue(v.stringValue()) || ++hitNum != VALUE_MATCH_THRESHOLD) continue;
                return 1.0f;
            }
        } else {
            for (IValue v : dataSample) {
                if (!this.mDataValues.contains(v.stringValue()) || ++hitNum != VALUE_MATCH_THRESHOLD) continue;
                return 1.0f;
            }
        }
        return (float)hitNum / (float)VALUE_MATCH_THRESHOLD;
    }

    @Override
    public boolean includesPattern() {
        return false;
    }

    private boolean containsValue(String v) {
        for (String s : this.mDataValues) {
            if (!s.equalsIgnoreCase(v)) continue;
            return true;
        }
        return false;
    }

    void addRange(String sFrom, String sTo) {
        this.mRanges = DataHints.addRange(this.mRanges, sFrom, sTo);
    }
}

