/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.Signifier;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.List;

class SignifierLabel
extends Signifier {
    private List<String> mLabelClues = new ArrayList<String>(5);
    private List<String> mLabelPatterns = new ArrayList<String>(2);

    SignifierLabel(Concept c) {
        super(c);
    }

    @Override
    public List<String> getLabelClues() {
        return this.mLabelClues;
    }

    public List<String> getLabelPatterns() {
        return this.mLabelPatterns;
    }

    @Override
    public float evaluateLabel(List<String> multiPartClue) {
        for (String clue : multiPartClue) {
            if (!this.evaluateSingle(clue)) continue;
            return (float)(1.0 / (double)multiPartClue.size());
        }
        return 0.0f;
    }

    @Override
    public boolean includesPattern() {
        return !this.mLabelPatterns.isEmpty();
    }

    boolean evaluateSingle(String singleToken) {
        if (!this.mLabelClues.isEmpty()) {
            return this.mLabelClues.contains(singleToken);
        }
        for (String pattern : this.mLabelPatterns) {
            if ("ANY".equals(pattern)) {
                return true;
            }
            ToolBox.Assert(false, "Unexpected label clue pattern:", pattern);
        }
        return false;
    }
}

