/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.model;

import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.api.smd.kb.IConceptInventory;
import com.ibm.cognos.aurora.core.model.DataItemStats;
import com.ibm.cognos.aurora.core.model.SimpleDataItem;
import com.ibm.cognos.aurora.core.xml.DOM4JUtil;
import com.ibm.cognos.smd.model.graph.HeapAssociativeModel;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class ModelDumpReader {
    private IAssociativeModel mModel;
    private Map<String, INode> mNodeIdMap = new HashMap<String, INode>(100);

    public static IAssociativeModel loadModel(File modelFile, IConceptInventory conceptInv) throws IOException, DocumentException {
        HeapAssociativeModel model = new HeapAssociativeModel(conceptInv);
        Document doc = DOM4JUtil.parseDocument((File)modelFile);
        Element elmRoot = doc.getRootElement();
        ModelDumpReader mdr = new ModelDumpReader(model);
        mdr.parseModel(elmRoot);
        return model;
    }

    ModelDumpReader(IAssociativeModel model) {
        this.mModel = model;
    }

    private void parseModel(Element elmRoot) {
        IDataContainer rootContainer = this.mModel.getRootContainer();
        ToolBox.Assert("dataContainer".equals(elmRoot.getName()), "Expecting a 'dataContainer' as root element");
        this.parseContainer(elmRoot, rootContainer);
        this.parseAllEdges(elmRoot);
    }

    private void parseContainer(Element containerElem, IDataContainer parent) {
        IDataContainer container = parent.createChild(containerElem.attributeValue("name"), containerElem.attributeValue("type"));
        for (Element nodeElem : containerElem.elements("node")) {
            this.parseNode(nodeElem, container);
        }
        List elmChildren = containerElem.elements("dataContainer");
        for (Element subContainerElem : elmChildren) {
            this.parseContainer(subContainerElem, container);
        }
    }

    private void parseNode(Element nodeElem, IDataContainer container) {
        IAssociativeModel model = container.getModel();
        String nodeId = nodeElem.attributeValue("id");
        String confidenceStr = nodeElem.attributeValue("confidence");
        IConcept nodeConcept = this.getNodeConcept(nodeElem);
        ENodeType type = null;
        if (nodeConcept.isCategory()) {
            type = ENodeType.CATEGORY;
        } else if (nodeConcept.isAttribute()) {
            type = ENodeType.ATTRIBUTE;
        } else if (nodeConcept.isMetric()) {
            type = ENodeType.METRIC;
        } else {
            ToolBox.Assert(false, "Unsupported node type: ", nodeConcept.getName());
        }
        INode node = model.createNode(type, nodeConcept, this.parseDataItem(nodeElem, container), null != confidenceStr ? Float.parseFloat(confidenceStr) : 0.0f);
        container.addNode(node);
        this.mNodeIdMap.put(nodeId, node);
    }

    private IConcept getNodeConcept(Element nodeElem) {
        Element elmConcept = nodeElem.element("concept");
        ToolBox.Assert(elmConcept != null, "Expecting a valid concept element for node:", nodeElem.asXML());
        return this.mModel.getConceptInventory().getConcept(elmConcept.attributeValue("name"));
    }

    private IDataItem parseDataItem(Element nodeElem, IDataContainer container) {
        Element dataItemElem = nodeElem.element("dataItem");
        if (dataItemElem == null) {
            return null;
        }
        SimpleDataItem dataItem = new SimpleDataItem(container, dataItemElem.attributeValue("name"));
        dataItem.setDataType(DataTypes.fromStringType((String)dataItemElem.attributeValue("dType")));
        DataItemStats stats = (DataItemStats)dataItem.getStats();
        String countStr = dataItemElem.attributeValue("numValues");
        String distinctCountStr = dataItemElem.attributeValue("numDistinctValues");
        String minValStr = dataItemElem.attributeValue("minValue");
        String maxValStr = dataItemElem.attributeValue("maxValue");
        String densityStr = dataItemElem.attributeValue("density");
        stats.setCount(countStr != null ? Long.parseLong(countStr) : 0L);
        stats.setDistinctCount(distinctCountStr != null ? Long.parseLong(distinctCountStr) : 0L);
        IValue minValue = dataItem.getDataType().newValue();
        if (minValStr != null) {
            minValue.assignFrom(minValStr);
        }
        stats.setMinValue(minValue);
        IValue maxValue = dataItem.getDataType().newValue();
        if (maxValue != null) {
            maxValue.assignFrom(maxValStr);
        }
        stats.setMaxValue(maxValue);
        if (densityStr != null) {
            stats.setDensity(Float.parseFloat(densityStr));
        }
        container.addDataItem((IDataItem)dataItem);
        return dataItem;
    }

    private void parseAllEdges(Element elmRoot) {
        List elmEdges = elmRoot.selectNodes(".//node/edge");
        for (Element elmEdge : elmEdges) {
            Element elmFromNode = elmEdge.getParent();
            this.mModel.createEdge(this.lookupNode(elmFromNode.attributeValue("id")), this.lookupNode(elmEdge.attributeValue("to")), elmEdge.attributeValue("label"), ECardinality.convertFrom((String)elmEdge.attributeValue("card")), "yes".equals(elmEdge.attributeValue("wholePart")));
        }
    }

    private INode lookupNode(String nid) {
        INode n = this.mNodeIdMap.get(nid);
        ToolBox.Assert(n != null, "Unable to look up node by id:", nid);
        return n;
    }
}

