/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.model.graph;

import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.IQualityOfService;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.ISession;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.api.smd.kb.IConceptInventory;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.api.util.MultiPartIdentifier;
import com.ibm.cognos.aurora.core.model.DataContainer;
import com.ibm.cognos.aurora.core.util.collection.IFilter;
import com.ibm.cognos.smd.model.graph.HeapEdge;
import com.ibm.cognos.smd.model.graph.HeapNode;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class HeapAssociativeModel
implements IAssociativeModel {
    private final IConceptInventory mConceptInv;
    private final Map<String, IPhysicalModel> mPhysicalModelsByName = new HashMap<String, IPhysicalModel>();
    private final IDataContainer mRootContainer;
    private final List<HeapNode> mNodes = new ArrayList<HeapNode>();
    private final List<HeapEdge> mEdges = new ArrayList<HeapEdge>();
    private final Date mCreationTime = new Date();

    public HeapAssociativeModel(IConceptInventory conceptInv) {
        this.mConceptInv = conceptInv;
        this.mRootContainer = new DataContainer((IAssociativeModel)this, null, "root", "root");
    }

    public IQueryLogicalStorage getQLS() {
        return null;
    }

    public IConceptInventory getConceptInventory() {
        return this.mConceptInv;
    }

    public Date getCreationTime() {
        return this.mCreationTime;
    }

    public Collection<IPhysicalModel> getPhysicalModels() {
        return Collections.unmodifiableCollection(this.mPhysicalModelsByName.values());
    }

    public IPhysicalModel getPhysicalModel(String dataSourceName) {
        return this.mPhysicalModelsByName.get(dataSourceName);
    }

    public void addPhysicalModel(IPhysicalModel physicalModel) {
        this.mPhysicalModelsByName.put(physicalModel.getDataSource().getName(), physicalModel);
    }

    public IDataContainer getRootContainer() {
        return this.mRootContainer;
    }

    public IDataItem findDataItem(MultiPartIdentifier id) {
        if (id.length() < 2) {
            throw new IllegalArgumentException("Invalid data item id: " + id.toUniqueName());
        }
        return this.findDataItem(id, 1, this.mRootContainer);
    }

    private IDataItem findDataItem(MultiPartIdentifier id, int index, IDataContainer container) {
        if (index == id.length() - 1) {
            return container.getDataItemByName(id.getPart(index));
        }
        IDataContainer child = container.getChild(id.getPart(index));
        if (null == child) {
            return null;
        }
        return this.findDataItem(id, index + 1, child);
    }

    public Set<IConcept> getAllConcepts() {
        HashSet<IConcept> conceptsFound = new HashSet<IConcept>();
        for (INode n : this.getNodes()) {
            IConcept concept = n.getConcept();
            if (null == concept) continue;
            conceptsFound.add(concept);
        }
        return conceptsFound;
    }

    public int nodeCount() {
        return this.mNodes.size();
    }

    public Iterable<INode> getNodes() {
        return this.mNodes;
    }

    public INode findNode(String id) {
        for (HeapNode node : this.mNodes) {
            if (!node.getId().equals(id)) continue;
            return node;
        }
        return null;
    }

    public Iterable<INode> findNodes(final IFilter<INode> condition) {
        return new Iterable<INode>(){

            @Override
            public Iterator<INode> iterator() {
                return new FilteringNodeIterator(HeapAssociativeModel.this.getNodes().iterator(), (IFilter<INode>)condition);
            }
        };
    }

    public void deleteNode(String id) {
        INode node = this.findNode(id);
        if (null == node) {
            return;
        }
        this.mNodes.remove(node);
        LinkedList edges = new LinkedList();
        CollectionUtils.addAll(edges, node.getEdges(new String[0]).iterator());
        for (IEdge e : edges) {
            ((HeapNode)e.getStart()).removeOutEdge(e);
            ((HeapNode)e.getEnd()).removeInEdge(e);
            this.mEdges.remove(e);
        }
    }

    public INode createNode(ENodeType type, IConcept concept, IDataItem dataItem, float confidenceLevel) {
        HeapNode newNode = new HeapNode(this, Integer.toString(this.mNodes.size()), type, concept, dataItem, confidenceLevel);
        this.mNodes.add(newNode);
        return newNode;
    }

    public int edgeCount() {
        return this.mEdges.size();
    }

    public Iterable<IEdge> getEdges() {
        return this.mEdges;
    }

    public IEdge findEdge(String id) {
        for (HeapEdge e : this.mEdges) {
            if (!e.getId().equals(id)) continue;
            return e;
        }
        return null;
    }

    public Iterable<IEdge> findEdges(final IFilter<IEdge> condition) {
        return new Iterable<IEdge>(){

            @Override
            public Iterator<IEdge> iterator() {
                return new FilteringEdgeIterator(HeapAssociativeModel.this.getEdges().iterator(), (IFilter<IEdge>)condition);
            }
        };
    }

    public IEdge createEdge(INode from, INode to, String label, ECardinality cardinality, boolean isWholePart) {
        HeapEdge newEdge = new HeapEdge(this, Integer.toString(this.mEdges.size()), from, to, label, cardinality, isWholePart);
        this.mEdges.add(newEdge);
        ((HeapNode)from).addOutEdge(newEdge);
        ((HeapNode)to).addInEdge(newEdge);
        return newEdge;
    }

    public void deleteEdge(String id) {
        IEdge edge = this.findEdge(id);
        if (null == edge) {
            return;
        }
        ((HeapNode)edge.getStart()).removeOutEdge(edge);
        ((HeapNode)edge.getEnd()).removeInEdge(edge);
        this.mEdges.remove(edge);
    }

    public String getFilePath() {
        throw new UnsupportedOperationException();
    }

    public void saveTo(String path) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void loadFrom(String path) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void dumpToXML(String path, ISession userSession) {
        throw new UnsupportedOperationException();
    }

    public String dumpToXML(ISession userSession) {
        throw new UnsupportedOperationException();
    }

    public void rebuildIndexes() {
        throw new UnsupportedOperationException();
    }

    public List<IHierarchy> getHierarchies(ISession userSession) {
        throw new UnsupportedOperationException();
    }

    public IHierarchy getHierarchy(ISession userSession, String name) {
        throw new UnsupportedOperationException();
    }

    public IHierarchy createHierarchy(ISession userSession, IAttribute[] attributes, String name) {
        throw new UnsupportedOperationException();
    }

    public List<IAttribute> getQueryAttributes(ISession userSession) {
        throw new UnsupportedOperationException();
    }

    public IAttribute getQueryAttribute(ISession userSession, String name) {
        throw new UnsupportedOperationException();
    }

    public String qualityOfService(IQualityOfService.QOS_FEATURE input) {
        return null;
    }

    private static final class FilteringEdgeIterator
    implements Iterator<IEdge> {
        private final Iterator<IEdge> mSource;
        private final IFilter<IEdge> mCondition;
        private boolean mHasNext = false;
        private IEdge mNext = null;

        FilteringEdgeIterator(Iterator<IEdge> source, IFilter<IEdge> condition) {
            this.mSource = source;
            this.mCondition = condition;
            this.moveToNext();
        }

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public IEdge next() {
            if (!this.mHasNext) {
                return null;
            }
            IEdge result = this.mNext;
            this.moveToNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void moveToNext() {
            this.mHasNext = false;
            this.mNext = null;
            while (this.mSource.hasNext()) {
                this.mNext = this.mSource.next();
                if (!this.mCondition.passes((Object)this.mNext)) continue;
                this.mHasNext = true;
                break;
            }
        }
    }

    private static final class FilteringNodeIterator
    implements Iterator<INode> {
        private final Iterator<INode> mSource;
        private final IFilter<INode> mCondition;
        private boolean mHasNext = false;
        private INode mNext = null;

        FilteringNodeIterator(Iterator<INode> source, IFilter<INode> condition) {
            this.mSource = source;
            this.mCondition = condition;
            this.moveToNext();
        }

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public INode next() {
            if (!this.mHasNext) {
                return null;
            }
            INode result = this.mNext;
            this.moveToNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void moveToNext() {
            this.mHasNext = false;
            this.mNext = null;
            while (this.mSource.hasNext()) {
                this.mNext = this.mSource.next();
                if (!this.mCondition.passes((Object)this.mNext)) continue;
                this.mHasNext = true;
                break;
            }
        }
    }
}

