/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.model.graph;

import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.model.NodeFilters;
import com.ibm.cognos.aurora.core.util.collection.UnionIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class HeapNode
implements INode {
    private final IAssociativeModel mModel;
    private final String mId;
    private final ENodeType mType;
    private final Map<String, Object> mProps = new HashMap<String, Object>();
    private IConcept mConcept;
    private IDataItem mDataItem;
    private float mConfidenceLevel;
    private final List<IEdge> mOutEdges = new ArrayList<IEdge>();
    private final List<IEdge> mInEdges = new ArrayList<IEdge>();

    public HeapNode(IAssociativeModel model, String id, ENodeType type, IConcept concept, IDataItem dataItem, float confidenceLevel) {
        this.mModel = model;
        this.mId = id;
        this.mType = type;
        this.mConcept = concept;
        this.mDataItem = dataItem;
        this.mConfidenceLevel = confidenceLevel;
    }

    public IAssociativeModel getModel() {
        return this.mModel;
    }

    public String getId() {
        return this.mId;
    }

    public String getLabel() {
        String label = (String)this.getProperty("__label");
        if (null != label) {
            return label;
        }
        if (null != this.mDataItem) {
            return this.mDataItem.getName();
        }
        return null;
    }

    public Object getProperty(String name) {
        return this.mProps.get(name);
    }

    public void setProperty(String name, Object value) {
        if (null == value) {
            this.mProps.remove(name);
        } else {
            this.mProps.put(name, value);
        }
    }

    public ENodeType getType() {
        return this.mType;
    }

    public boolean isAttribute() {
        return ENodeType.ATTRIBUTE == this.mType;
    }

    public boolean isCategory() {
        return ENodeType.CATEGORY == this.mType;
    }

    public boolean isMetric() {
        return ENodeType.METRIC == this.mType;
    }

    public boolean isValue() {
        return ENodeType.VALUE == this.mType;
    }

    public IConcept getConcept() {
        return this.mConcept;
    }

    public void setConcept(IConcept concept) {
        this.mConcept = concept;
    }

    public IDataItem getDataItem() {
        return this.mDataItem;
    }

    public void setDataItem(IDataItem dataItem) {
        this.mDataItem = dataItem;
    }

    public void setConfidenceLevel(float conf) {
        this.mConfidenceLevel = conf;
    }

    public float getConfidenceLevel() {
        return this.mConfidenceLevel;
    }

    public Iterable<IEdge> getEdges(final String ... labels) {
        return new Iterable<IEdge>(){

            @Override
            public Iterator<IEdge> iterator() {
                UnionIterator iter = new UnionIterator(new Iterator[]{HeapNode.this.mOutEdges.iterator(), HeapNode.this.mInEdges.iterator()});
                if (labels.length > 0) {
                    return new LabelFilteringEdgeIter((Iterator<IEdge>)iter, labels);
                }
                return iter;
            }
        };
    }

    public Iterable<IEdge> getOutEdges(final String ... labels) {
        return new Iterable<IEdge>(){

            @Override
            public Iterator<IEdge> iterator() {
                if (labels.length > 0) {
                    return new LabelFilteringEdgeIter(HeapNode.this.mOutEdges.iterator(), labels);
                }
                return HeapNode.this.mOutEdges.iterator();
            }
        };
    }

    public Iterable<IEdge> getInEdges(final String ... labels) {
        return new Iterable<IEdge>(){

            @Override
            public Iterator<IEdge> iterator() {
                if (labels.length > 0) {
                    return new LabelFilteringEdgeIter(HeapNode.this.mInEdges.iterator(), labels);
                }
                return HeapNode.this.mInEdges.iterator();
            }
        };
    }

    public boolean connectsWith(INode other) {
        for (IEdge e : this.getEdges(new String[0])) {
            if (!e.getStart().equals(other) && !e.getEnd().equals(other)) continue;
            return true;
        }
        return false;
    }

    void addOutEdge(IEdge e) {
        this.mOutEdges.add(e);
    }

    void removeOutEdge(IEdge e) {
        this.mOutEdges.remove(e);
    }

    void addInEdge(IEdge e) {
        this.mInEdges.add(e);
    }

    void removeInEdge(IEdge e) {
        this.mInEdges.remove(e);
    }

    public Iterable<INode> getMetricNodesInScope() {
        List cMetrics = this.getConcept().getMetricConceptsInScope();
        if (cMetrics == null) {
            return null;
        }
        ArrayList<INode> out = new ArrayList<INode>(cMetrics.size() * 2);
        for (IConcept c : cMetrics) {
            CollectionUtils.addAll(out, this.mModel.findNodes(NodeFilters.hasConcept((IConcept)c)).iterator());
        }
        return out;
    }

    public boolean isInScopeWith(INode other) {
        return this.getConcept().isInScopeWith(other.getConcept());
    }

    public String toString() {
        IDataItem di;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLabel());
        IConcept concept = this.getConcept();
        if (null != concept) {
            sb.append('(').append(concept.getName()).append(')');
        }
        if (null != (di = this.getDataItem())) {
            sb.append('[').append(di.getName()).append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.mId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeapNode)) {
            return false;
        }
        HeapNode other = (HeapNode)o;
        return this.mId.equals(other.mId);
    }

    private static final class LabelFilteringEdgeIter
    implements Iterator<IEdge> {
        private final Iterator<IEdge> mSource;
        private final String[] mLabels;
        private IEdge mNext = null;

        LabelFilteringEdgeIter(Iterator<IEdge> source, String[] labels) {
            this.mSource = source;
            this.mLabels = labels;
            this.fetchNext();
        }

        private void fetchNext() {
            while (this.mSource.hasNext()) {
                this.mNext = this.mSource.next();
                for (String label : this.mLabels) {
                    if (!label.equals(this.mNext.getLabel())) continue;
                    return;
                }
            }
            this.mNext = null;
        }

        @Override
        public boolean hasNext() {
            return null != this.mNext;
        }

        @Override
        public IEdge next() {
            if (null == this.mNext) {
                return null;
            }
            IEdge current = this.mNext;
            this.fetchNext();
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

