/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.question;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.smd.SmdReqContext;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.core.model.NodeFilters;
import com.ibm.cognos.smd.SmartMetadataImpl;
import com.ibm.cognos.smd.analyzer.AnalyzerBase;
import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.analyzer.LexicalClueExtractor;
import com.ibm.cognos.smd.kb.ActivationSpread;
import com.ibm.cognos.smd.kb.CascadingLexicalClueResolver;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.kb.ExtensionManager;
import com.ibm.cognos.smd.kb.ExtensionSource;
import com.ibm.cognos.smd.kb.LexicalClueInventory;
import com.ibm.cognos.smd.kb.LexicalClueInventoryManager;
import com.ibm.cognos.smd.question.QuestionExposition;
import com.ibm.cognos.smd.utilities.LinguisticTools;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Element;

public final class QuestionAnalyzer
extends AnalyzerBase {
    private static final String DEFAULT_KB_RESOURCE = "/com/ibm/cognos/smd/question/QuestionKB.xml";
    private ConceptInventory mQuestionKB;
    private CascadingLexicalClueResolver mQuestionClueInventory;
    private LexicalClueExtractor mQuestionClueExtractor;
    private Concept mBaseQuestionConcept;
    private Concept mConceptDate;
    private List<INode> mModelAttrNodes;
    private List<INode> mModelMetricNodes;

    public QuestionAnalyzer(SmartMetadataImpl smd, IAssociativeModel model, SmdReqContext context) {
        super(smd, model, context);
        this.setupQuestionInventories();
        this.mConceptDate = (Concept)this.mQuestionKB.getConcept("cDate");
        this.mBaseQuestionConcept = (Concept)this.mQuestionKB.getConcept("cQuestion");
        this.mModelAttrNodes = this.collectAttributeNodes();
        this.mModelMetricNodes = this.collectMetricNodes();
    }

    public QuestionExposition analyze(String questionText) {
        long b4 = System.nanoTime();
        Element elmCurr = this.getReport().addEntry(true, "breakupQuestion", "in", questionText);
        OverallInfo overallInfo = this.breakupQuestion(questionText);
        this.getReport().resetCurrent(elmCurr);
        elmCurr = this.getReport().addEntry(true, "overallIntents", new String[0]);
        this.determineOverallIntents(overallInfo);
        this.getReport().resetCurrent(elmCurr);
        elmCurr = this.getReport().addEntry(true, "bindModel", new String[0]);
        QuestionExposition output = this.bindModel(overallInfo);
        this.getReport().resetCurrent(elmCurr);
        this.getReport().addEntry(false, "performance", "time-ms", ToolBox.elapsedTimeAsString(b4));
        output.setDeterminationReport(this.getReport());
        return output;
    }

    public List<String> collectLookAheadVocabulary() {
        ArrayList<String> out = new ArrayList<String>(500);
        Locale contentLocale = this.getContentLocale();
        List<Concept> inUseConcepts = this.collectConceptsForLookAheadVocabulary();
        for (String clue : this.mQuestionClueInventory.getLexicalCluesForConcepts(inUseConcepts)) {
            out.add(clue.toLowerCase(contentLocale));
        }
        this.collectLookAheadVocabularyForDataItems(out, this.mModelAttrNodes);
        this.collectLookAheadVocabularyForDataItems(out, this.mModelMetricNodes);
        return out;
    }

    void collectLookAheadVocabularyForDataItems(List<String> out, List<INode> vNodes) {
        for (INode attrNode : vNodes) {
            out.add(attrNode.getDataItem().getName());
            if (!this.shouldIncludeValues(attrNode)) continue;
            DataItemExtension dix = new DataItemExtension(attrNode.getDataItem(), 0);
            List<IValue> dataSample = dix.getSampleDataPoints();
            for (IValue v : dataSample) {
                out.add(v.stringValue());
            }
        }
    }

    private List<Concept> collectConceptsForLookAheadVocabulary() {
        NavigationHelper hlpr = new NavigationHelper(super.getModel());
        List rootNodes = hlpr.getRootNodes();
        ArrayList<Concept> out = new ArrayList<Concept>(rootNodes.size() + 10);
        for (INode aNode : rootNodes) {
            if (out.contains(aNode.getConcept())) continue;
            out.add((Concept)aNode.getConcept());
        }
        this.mQuestionKB.collectAllConcepts(out);
        return out;
    }

    private OverallInfo breakupQuestion(String questionText) {
        List<String> words = LinguisticTools.detectWords(questionText);
        List<String> modifiedLists = this.refineForKnownWordCombinations(words);
        OverallInfo out = new OverallInfo(questionText);
        for (String aWord : modifiedLists) {
            List<String> possibleWordStems;
            QElementInfo infoElement = out.addWord(aWord);
            infoElement.mTokens = this.mQuestionClueExtractor.identifyClues(aWord);
            if (infoElement.mTokens.size() == 1 && aWord.equalsIgnoreCase((String)infoElement.mTokens.get(0)) && !(possibleWordStems = this.mQuestionClueExtractor.getPossibleStems(aWord)).isEmpty()) {
                infoElement.mTokens.addAll(possibleWordStems);
            }
            List<ActivationSpread> as = this.mQuestionClueInventory.getActivationFor(infoElement.mTokens, null);
            this.getContext().addActivation(aWord.toString(), as);
            infoElement.addCandidate(as);
        }
        return out;
    }

    private void determineOverallIntents(OverallInfo overallInfo) {
        List<ActivationSpread> listAS = this.mQuestionClueInventory.getActivationFor(overallInfo.getOverallTokens(), null);
        this.getContext().addActivation(overallInfo.mQuestion, listAS);
        if (listAS == null || listAS.isEmpty()) {
            return;
        }
        for (ActivationSpread as : listAS) {
            Concept c = as.getConcepts()[0];
            if (!c.is(this.mBaseQuestionConcept)) continue;
            overallInfo.addOverallIntent(c);
        }
    }

    private void setupQuestionInventories() {
        Properties props = new Properties();
        props.put("smd.kb.extensionRes", DEFAULT_KB_RESOURCE);
        ExtensionSource extSrc = ExtensionManager.getInstance().getExtensionSource(props);
        this.mQuestionKB = extSrc.getConceptInventory();
        LexicalClueInventoryManager clueMngr = LexicalClueInventoryManager.getInstance();
        LexicalClueInventory primaryClues = clueMngr.getLexicalInventoryFor(extSrc, super.getContentLocale());
        this.mQuestionClueInventory = new CascadingLexicalClueResolver(primaryClues, null);
        this.mQuestionClueExtractor = new LexicalClueExtractor(primaryClues, super.getReport());
    }

    private QuestionExposition bindModel(OverallInfo overallInfo) {
        QuestionExposition quesExpo = new QuestionExposition(this.getReport(), overallInfo.mIntents);
        for (QElementInfo wi : overallInfo.mWords) {
            boolean bFoundNode = this.matchNodesLierally(wi, quesExpo);
            if (!bFoundNode) {
                bFoundNode = this.matchNodesSemantically(wi, quesExpo, "semanticMatch");
            }
            if (!bFoundNode) {
                bFoundNode = this.suggestNodes(wi, quesExpo);
            }
            wi.setMatched(bFoundNode);
        }
        if (!overallInfo.isFullyAccounted()) {
            this.overallMatching(overallInfo, quesExpo);
        }
        return quesExpo;
    }

    private boolean matchNodesLierally(QElementInfo wi, QuestionExposition expo) {
        for (INode attrNode : this.mModelAttrNodes) {
            if (!attrNode.getDataItem().getName().equals(wi.mWord)) continue;
            expo.addNode(NavigationHelper.getCategoryFromAttribute((INode)attrNode), 1.0f, "exactNameMatch");
            return true;
        }
        for (INode metNode : this.mModelMetricNodes) {
            if (!metNode.getDataItem().getName().equals(wi.mWord)) continue;
            expo.addNode(metNode, 1.0f, "exactNameMatch");
            return true;
        }
        return false;
    }

    private void overallMatching(OverallInfo overallInfo, QuestionExposition expo) {
        INode aNode;
        if (!expo.containsMetric() && (aNode = this.selectNodeByMatchingTokens(this.mModelMetricNodes, overallInfo.mWords)) != null) {
            expo.addNode(aNode, 0.5f, "nameMatch");
        }
        if (!expo.containsCategory() && (aNode = this.selectNodeByMatchingTokens(this.mModelAttrNodes, overallInfo.mWords)) != null) {
            INode categoryNode = NavigationHelper.getCategoryFromAttribute((INode)aNode);
            expo.addNode(categoryNode, 0.5f, "nameMatch");
        }
    }

    private boolean doNamesMatch(INode aNode, String inWord) {
        IDataItem di = aNode.getDataItem();
        if (null != di) {
            return di.getName().equalsIgnoreCase(inWord);
        }
        for (INode attrNode : NavigationHelper.getAttributeNodes((INode)aNode)) {
            if (!attrNode.getDataItem().getName().equalsIgnoreCase(inWord)) continue;
            return true;
        }
        return false;
    }

    private INode selectNodeByMatchingTokens(List<INode> nodes, List<QElementInfo> words) {
        int maxHit = 0;
        INode outMetric = null;
        for (INode aNode : nodes) {
            String diName = aNode.getDataItem().getName().toUpperCase(this.getContentLocale());
            int hitNo = 0;
            for (QElementInfo wi : words) {
                for (String token : wi.mTokens) {
                    if (!diName.contains(token)) continue;
                    ++hitNo;
                }
                if (!wi.mTokens.isEmpty() || wi.isProposition() || !diName.contains(wi.mWord.toUpperCase(this.getContentLocale()))) continue;
                ++hitNo;
            }
            if (hitNo <= maxHit) continue;
            maxHit = hitNo;
            outMetric = aNode;
        }
        return outMetric;
    }

    private List<INode> collectMetricNodes() {
        ArrayList<INode> outNodes = new ArrayList<INode>();
        Iterator iter = this.getModel().findNodes(NodeFilters.isMetric()).iterator();
        while (iter.hasNext()) {
            outNodes.add((INode)iter.next());
        }
        return outNodes;
    }

    private List<INode> collectAttributeNodes() {
        ArrayList<INode> outNodes = new ArrayList<INode>();
        for (INode node : this.getModel().findNodes(NodeFilters.isCategory())) {
            outNodes.addAll(NavigationHelper.getAttributeNodes((INode)node));
        }
        return outNodes;
    }

    private boolean matchNodesSemantically(QElementInfo wi, QuestionExposition expo, String strReason) {
        if (wi.mCandidates == null) {
            return false;
        }
        boolean bFoundNode = false;
        for (Concept c : wi.mCandidates) {
            if (!this.matchNodesSemantically(c, wi.mWord, expo, strReason)) continue;
            bFoundNode = true;
        }
        return bFoundNode;
    }

    private boolean matchNodesSemantically(IConcept c, String inWord, QuestionExposition expo, String strReason) {
        boolean bFoundNode = false;
        if (c.isCommonAttribute()) {
            return bFoundNode;
        }
        for (INode aNode : this.getModel().findNodes(NodeFilters.hasConcept((IConcept)c))) {
            INode nodeToAdd;
            INode iNode = nodeToAdd = c.isAttribute() ? NavigationHelper.getCategoryFromAttribute((INode)aNode) : aNode;
            if (this.doNamesMatch(aNode, inWord)) {
                expo.addNode(nodeToAdd, 1.0f, strReason);
            } else {
                expo.addNode(nodeToAdd, 0.8f, strReason);
            }
            bFoundNode = true;
        }
        return bFoundNode;
    }

    private boolean suggestNodes(QElementInfo wi, QuestionExposition expo) {
        List<INode> suggestions = null;
        if (wi.mCandidates != null) {
            for (Concept c : wi.mCandidates) {
                boolean bFound;
                if (!c.isTemporal() || c.is(this.mConceptDate) || !(bFound = this.matchNodesSemantically(this.mConceptDate, wi.mWord, expo, "dateTemporalMatch"))) continue;
                return true;
            }
        }
        if ((suggestions = this.findNodesByValue(wi.mWord, expo)) != null) {
            expo.addNodes(suggestions, 0.7f, "valueMatch");
            return true;
        }
        if (!wi.isProposition()) {
            ArrayList<QElementInfo> words = new ArrayList<QElementInfo>(1);
            words.add(wi);
            INode aNode = this.selectNodeByMatchingTokens(this.mModelAttrNodes, words);
            if (aNode != null) {
                INode categoryNode = NavigationHelper.getCategoryFromAttribute((INode)aNode);
                expo.addNode(categoryNode, 0.6f, "nameMatch");
                return true;
            }
        }
        return false;
    }

    private List<INode> findNodesByValue(String value, QuestionExposition expo) {
        ArrayList<INode> outNodes = null;
        for (INode attr : this.mModelAttrNodes) {
            if (!this.shouldIncludeValues(attr)) continue;
            DataItemExtension dix = new DataItemExtension(attr.getDataItem(), 0);
            List<IValue> dataSample = dix.getSampleDataPoints();
            for (IValue v : dataSample) {
                if (!value.equals(v.stringValue())) continue;
                outNodes = new ArrayList<INode>(1);
                outNodes.add(NavigationHelper.getCategoryFromAttribute((INode)attr));
                expo.addRestriction(attr, value);
                return outNodes;
            }
        }
        return outNodes;
    }

    private boolean shouldIncludeValues(INode attrNode) {
        return attrNode.getDataItem().getDataType().isString();
    }

    private void collectMultiWordClues(List<INode> nodes, List<MultiWordClues> itemClues) {
        for (INode aNode : nodes) {
            List<String> diClues = super.getClueExtractor().identifyClues(aNode.getDataItem().getName());
            if (diClues.size() <= 1) continue;
            itemClues.add(new MultiWordClues(diClues));
        }
    }

    private List<String> refineForKnownWordCombinations(List<String> inWords) {
        ArrayList<String> outWords = new ArrayList<String>(inWords.size());
        ArrayList<MultiWordClues> itemClues = new ArrayList<MultiWordClues>(this.mModelAttrNodes.size() + this.mModelMetricNodes.size());
        this.collectMultiWordClues(this.mModelAttrNodes, itemClues);
        this.collectMultiWordClues(this.mModelMetricNodes, itemClues);
        Collections.sort(itemClues, new MultiWordComparator());
        for (int wIdx = 0; wIdx < inWords.size(); ++wIdx) {
            String aUnit = inWords.get(wIdx);
            if (LinguisticTools.detectWords(aUnit).size() > 1) {
                outWords.add(aUnit);
                continue;
            }
            boolean isHandled = false;
            for (MultiWordClues mwc : itemClues) {
                int nextIdx = mwc.matches(inWords, wIdx);
                if (nextIdx <= 1) continue;
                StringBuilder combinedWord = new StringBuilder(inWords.get(wIdx));
                for (int cIdx = 1; cIdx < nextIdx; ++cIdx) {
                    combinedWord.append(" ");
                    combinedWord.append(inWords.get(++wIdx));
                }
                isHandled = true;
                outWords.add(combinedWord.toString());
                break;
            }
            if (isHandled) continue;
            outWords.add(aUnit);
        }
        return outWords;
    }

    private static class MultiWordComparator
    implements Comparator<MultiWordClues> {
        private MultiWordComparator() {
        }

        @Override
        public int compare(MultiWordClues mw1, MultiWordClues mw2) {
            if (mw1.getClues().size() < mw2.getClues().size()) {
                return 1;
            }
            if (mw2.getClues().size() < mw1.getClues().size()) {
                return -1;
            }
            return 0;
        }
    }

    private final class MultiWordClues {
        private List<String> mClues;

        MultiWordClues(List<String> clues) {
            this.mClues = clues;
        }

        int matches(List<String> inWords, int wIdx) {
            int idx;
            for (idx = 0; idx < this.mClues.size() && wIdx + idx < inWords.size() && this.mClues.get(idx).equalsIgnoreCase(QuestionAnalyzer.this.getClueExtractor().identifyClues(inWords.get(wIdx + idx)).get(0)); ++idx) {
            }
            return idx;
        }

        List<String> getClues() {
            return this.mClues;
        }
    }

    private class QElementInfo {
        private String mWord;
        private List<String> mTokens;
        private List<Concept> mCandidates;
        private boolean mMatched = false;

        QElementInfo(String word) {
            this.mWord = word;
        }

        void addCandidate(List<ActivationSpread> listAS) {
            if (listAS == null || listAS.isEmpty()) {
                return;
            }
            this.mCandidates = new ArrayList<Concept>(listAS.size());
            for (ActivationSpread as : listAS) {
                this.mCandidates.add(as.getConcepts()[0]);
            }
        }

        void setMatched(boolean bFlag) {
            this.mMatched = bFlag;
        }

        boolean isMatched() {
            return this.mMatched;
        }

        boolean isProposition() {
            return this.mWord.length() <= 2;
        }
    }

    private class OverallInfo {
        private String mQuestion;
        private Set<IConcept> mIntents = new HashSet<IConcept>(3);
        private List<QElementInfo> mWords = new ArrayList<QElementInfo>();

        OverallInfo(String question) {
            this.mQuestion = question;
        }

        QElementInfo addWord(String word) {
            QElementInfo out = new QElementInfo(word);
            this.mWords.add(out);
            return out;
        }

        void addOverallIntent(IConcept cIntent) {
            this.mIntents.add(cIntent);
        }

        List<String> getOverallTokens() {
            ArrayList<String> out = new ArrayList<String>(this.mWords.size() * 2);
            for (QElementInfo qe : this.mWords) {
                if (qe.mTokens == null || qe.mTokens.isEmpty()) continue;
                out.addAll(qe.mTokens);
            }
            return out;
        }

        boolean isFullyAccounted() {
            for (QElementInfo qe : this.mWords) {
                if (qe.isProposition() || qe.isMatched()) continue;
                return false;
            }
            return true;
        }
    }
}

