/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.question;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.smd.analyzer.AnalysisReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;

public class QuestionExposition {
    static final float gMatch_Name_Concept = 1.0f;
    static final float gMatch_Concept = 0.8f;
    static final float gMatch_Value = 0.7f;
    static final float gMatch_Name_Token = 0.6f;
    static final float gMatch_Overall_Name = 0.5f;
    private AnalysisReport mReport;
    private List<IConcept> mOverallIntents = new ArrayList<IConcept>(3);
    private List<INode> mNodes = new ArrayList<INode>();
    private Map<INode, Float> mNodeConfidence = new HashMap<INode, Float>();
    private Map<INode, String> mRestrictions = new HashMap<INode, String>();

    QuestionExposition(AnalysisReport aReport, Set<IConcept> overallIntents) {
        this.mReport = aReport;
        for (IConcept cIntent : overallIntents) {
            this.mOverallIntents.add(cIntent);
        }
    }

    public List<IConcept> getOverallIntents() {
        return this.mOverallIntents;
    }

    public List<INode> getNodes() {
        return this.mNodes;
    }

    public float getNodeConfidence(INode aNode) {
        Float fConf = this.mNodeConfidence.get(aNode);
        if (fConf == null) {
            return 0.0f;
        }
        return fConf.floatValue();
    }

    public String getRestrictionFor(INode aNode) {
        return this.mRestrictions.get(aNode);
    }

    public List<INode> getDataItemNodes() {
        ArrayList<INode> out = new ArrayList<INode>(this.mNodes.size());
        for (INode aNode : this.mNodes) {
            IDataItem di = aNode.getDataItem();
            if (null != di) {
                out.add(aNode);
                continue;
            }
            out.addAll(NavigationHelper.getAttributeNodes((INode)aNode));
        }
        return out;
    }

    public Document getDeterminationReport() {
        return this.mReport.getReportDocument();
    }

    public void generateDeterminationReport(String outFilePath) {
        AnalysisReport.generateReportFile(this.mReport.getReportDocument(), outFilePath);
    }

    void addNode(INode aNode, float confidence, String reason) {
        if (!this.mNodes.contains(aNode)) {
            this.mNodes.add(aNode);
            this.mNodeConfidence.put(aNode, Float.valueOf(confidence));
            this.reportNode(aNode, confidence, reason);
        }
    }

    void addNodes(List<INode> nodes, float confidence, String reason) {
        for (INode aNode : nodes) {
            this.addNode(aNode, confidence, reason);
        }
    }

    void addRestriction(INode aNode, String filter) {
        this.mRestrictions.put(aNode, filter);
        this.mReport.addEntry(false, "nodeRestriction", "name", aNode.getDataItem().getName(), "filter", filter);
    }

    boolean containsMetric() {
        for (INode aNode : this.mNodes) {
            if (!aNode.isMetric()) continue;
            return true;
        }
        return false;
    }

    boolean containsCategory() {
        for (INode aNode : this.mNodes) {
            if (!aNode.isCategory()) continue;
            return true;
        }
        return false;
    }

    void setDeterminationReport(AnalysisReport aReport) {
        this.mReport = aReport;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Overall Intents: \n\t");
        for (IConcept c : this.mOverallIntents) {
            sb.append(c.getName());
            sb.append(", ");
        }
        sb.append("\nNodes:\n\t");
        for (INode aNode : this.getDataItemNodes()) {
            IDataItem di = aNode.getDataItem();
            sb.append(di.getName());
            String rest = this.mRestrictions.get(aNode);
            if (rest != null) {
                sb.append("( restriction_like=");
                sb.append(rest);
                sb.append(" )");
            }
            sb.append(",\n\t");
        }
        return sb.toString();
    }

    private void reportNode(INode aNode, float confidence, String reason) {
        String sConf = Float.toString(confidence);
        if (aNode.isMetric()) {
            this.mReport.addEntry(false, "bindNode", "name", aNode.getDataItem().getName(), "confidence", sConf, "reason", reason);
        } else {
            for (INode attrNode : NavigationHelper.getAttributeNodes((INode)aNode)) {
                this.mReport.addEntry(false, "bindNode", "name", attrNode.getDataItem().getName(), "confidence", sConf, "reason", reason);
            }
        }
    }
}

