/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.utilities;

import com.ibm.cognos.smd.utilities.ToolBox;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public final class FileUtility {
    public static List<File> collectFiles(String startDir, String suffix) {
        File extDir = new File(startDir);
        ToolBox.Assert(extDir.isDirectory(), "Expecting a valid folder path as the startDir:", startDir);
        ToolBox.Assert(suffix != null && suffix.length() > 0, "Expecting a valid non-empty file suffix");
        ArrayList<File> outFiles = new ArrayList<File>();
        FileUtility.doCollect(outFiles, extDir, new MyFileFilter(suffix));
        return outFiles;
    }

    private static void doCollect(List<File> outFiles, File startEntry, FileFilter myFilter) {
        if (startEntry.isDirectory()) {
            File[] children;
            for (File c : children = startEntry.listFiles(myFilter)) {
                FileUtility.doCollect(outFiles, c, myFilter);
            }
        } else {
            outFiles.add(startEntry);
        }
    }

    public static final String cleanupFileName(String inFileName) {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < inFileName.length(); ++idx) {
            char c = inFileName.charAt(idx);
            if (c == '.' || c == ':' || c == '?' || c == '/' || c == '\\' || c == '*' || c == '\"' || c == '\'' || Character.isWhitespace(c)) {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void copyFile(String sourcePath, String destinationPath) {
        try {
            File source = new File(sourcePath);
            File destination = new File(destinationPath);
            destination.getParentFile().mkdirs();
            FileChannel sourceChannel = new FileInputStream(source).getChannel();
            FileChannel destinationChannel = new FileOutputStream(destination).getChannel();
            long size = sourceChannel.size();
            sourceChannel.transferTo(0L, size, destinationChannel);
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
    }

    private static class MyFileFilter
    implements FileFilter {
        private String mSuffix;

        MyFileFilter(String suffix) {
            this.mSuffix = suffix;
        }

        @Override
        public boolean accept(File anEntry) {
            if (anEntry.isDirectory()) {
                return true;
            }
            String entryName = anEntry.getName();
            if (entryName.length() < this.mSuffix.length()) {
                return false;
            }
            return this.mSuffix.equalsIgnoreCase(entryName.substring(entryName.length() - this.mSuffix.length()));
        }
    }
}

