/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.utilities;

import com.ibm.cognos.smd.utilities.ToolBox;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class SmdConfig {
    private static final String DEFAULT_CONFIG_RESOURCE = "/config/smdConfig.xml";
    private static SmdConfig gSingleton = null;
    private Map<String, Map<String, Object>> mSections = new HashMap<String, Map<String, Object>>(20);

    private SmdConfig() {
        this.setup();
    }

    public static SmdConfig getInstance() {
        return gSingleton;
    }

    public float getValue(String section, String item, float defaultValue) {
        Map<String, Object> items = this.mSections.get(section);
        if (items == null) {
            return defaultValue;
        }
        Object value = items.get(item);
        if (value == null) {
            return defaultValue;
        }
        ToolBox.Assert(value instanceof Float, "Expecting a float data type for config. item:", section, "/", item);
        return ((Float)value).floatValue();
    }

    public int getValue(String section, String item, int defaultValue) {
        Map<String, Object> items = this.mSections.get(section);
        if (items == null) {
            return defaultValue;
        }
        Object value = items.get(item);
        if (value == null) {
            return defaultValue;
        }
        ToolBox.Assert(value instanceof Integer, "Expecting an integer data type for config. item:", section, "/", item);
        return (Integer)value;
    }

    public String getValue(String section, String item, String defaultValue) {
        Map<String, Object> items = this.mSections.get(section);
        if (items == null) {
            return defaultValue;
        }
        Object value = items.get(item);
        if (value == null) {
            return defaultValue;
        }
        ToolBox.Assert(value instanceof String, "Expecting a string data type for config. item:", section, "/", item);
        return (String)value;
    }

    private void setup() {
        long b4 = ToolBox.logPerfIndicators("/Cognfig/setup/time", 0L);
        InputStream strConfig = null;
        try {
            strConfig = this.getClass().getResourceAsStream(DEFAULT_CONFIG_RESOURCE);
            if (strConfig == null) {
                throw new RuntimeException("Unable to locate the config source:/config/smdConfig.xml");
            }
            try {
                SAXReader saxReader = new SAXReader();
                Document document = saxReader.read(strConfig);
                Element elmRoot = document.getRootElement();
                List elmSections = elmRoot.elements();
                for (Element elmSec : elmSections) {
                    this.newSection(elmSec);
                }
                ToolBox.logPerfIndicators("/Cognfig/setup/time", b4);
            }
            catch (DocumentException e) {
                throw new RuntimeException("Failed to set up the configuration entries!", e);
            }
            finally {
                if (null != strConfig) {
                    strConfig.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to set up the configuration entries!", e);
        }
    }

    private void newSection(Element elmSec) {
        String sName = elmSec.getName();
        List elmItems = elmSec.elements("item");
        if (elmItems == null || elmItems.isEmpty()) {
            return;
        }
        HashMap<String, Object> secItems = new HashMap<String, Object>();
        for (Element elmItem : elmItems) {
            String itemName = elmItem.attributeValue("name");
            ToolBox.Assert(itemName != null && itemName.length() > 0, "Expecting a valid name for configuration item:", elmItem.asXML());
            Object itemValue = this.getItemValue(elmItem);
            secItems.put(itemName, itemValue);
        }
        this.mSections.put(sName, secItems);
    }

    private Object getItemValue(Element elmItem) {
        String itemType = elmItem.attributeValue("type");
        Object outValue = null;
        outValue = "float".equals(itemType) ? Float.valueOf(elmItem.getText()) : ("int".equals(itemType) ? Integer.valueOf(elmItem.getText()) : elmItem.getTextTrim());
        return outValue;
    }

    static {
        gSingleton = new SmdConfig();
    }
}

