/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.utilities;

import com.cognos.ccl4j.resource.CCLResourceManager;
import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SmdMessage {
    private static final String SMD_BUNDLE_NAME = "smd";
    private String mMsgKey;
    private Object[] mMsgParams = null;

    public SmdMessage(String msgKey, Object[] msgParams) {
        this.mMsgKey = msgKey;
        this.mMsgParams = msgParams;
    }

    public String getMessageKey() {
        return this.mMsgKey;
    }

    public String getBundleName() {
        return SMD_BUNDLE_NAME;
    }

    public String render(String crnLocale) {
        Locale aLocale = CCLResourceManager.getLocale((String)crnLocale);
        ResourceBundle resBundle = ResourceBundle.getBundle(this.getBundleName(), aLocale);
        return this.render(resBundle, aLocale);
    }

    String render(ResourceBundle resBundle, Locale aLocale) {
        String localizedMessage = null;
        try {
            localizedMessage = resBundle.getString(this.mMsgKey);
        }
        catch (MissingResourceException mre) {
            return mre.getMessage();
        }
        if (this.mMsgParams != null && this.mMsgParams.length > 0) {
            MessageFormat aFormatter = new MessageFormat(localizedMessage, aLocale);
            localizedMessage = aFormatter.format(this.mMsgParams, new StringBuffer(), null).toString();
        }
        return localizedMessage;
    }

    public static String renderMessage(String msgKey, Locale aLocale, boolean toUpperCase) {
        ResourceBundle resBundle = ResourceBundle.getBundle(SMD_BUNDLE_NAME, aLocale);
        String s = resBundle.getString(msgKey);
        return toUpperCase ? s.toUpperCase(aLocale) : s;
    }

    public static List<String> renderMessagesInSection(String sectionKey, Locale aLocale, boolean toUpperCase) {
        ResourceBundle resBundle = ResourceBundle.getBundle(SMD_BUNDLE_NAME, aLocale);
        ArrayList<String> out = new ArrayList<String>(20);
        for (String msgKey : resBundle.keySet()) {
            String s;
            if (!msgKey.startsWith(sectionKey) || (s = resBundle.getString(msgKey)) == null || s.length() <= 0) continue;
            out.add(toUpperCase ? s.toUpperCase(aLocale) : s);
        }
        return out;
    }
}

