/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.utilities;

import com.ibm.cognos.aurora.core.util.Pair;
import com.ibm.cognos.smd.utilities.TreeNode;
import com.ibm.cognos.smd.utilities.UnicodeNode;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class TextSearchEngine {
    private final TreeNode root;
    private final boolean ci;

    public TextSearchEngine() {
        this(false);
    }

    public TextSearchEngine(boolean caseSensitive) {
        this.root = new UnicodeNode();
        this.ci = !caseSensitive;
    }

    public TextSearchEngine(TreeNode rootNode) {
        this(rootNode, false);
    }

    public TextSearchEngine(TreeNode rootNode, boolean caseSensitive) {
        this.root = rootNode;
        this.ci = !caseSensitive;
    }

    public void addKeyword(String keyword) {
        if (keyword != null && !keyword.isEmpty()) {
            TreeNode current = this.root;
            for (int i = 0; i < keyword.length(); ++i) {
                char c = keyword.charAt(i);
                if (this.ci) {
                    c = Character.toUpperCase(c);
                }
                current = current.addChildNode(c);
            }
            current.setEndNode();
        }
    }

    public JSONObject serializeToJSON() {
        JSONObject jo = new JSONObject();
        ((UnicodeNode)this.root).serialize(jo);
        return jo;
    }

    public Set<Pair<String, Pair<Integer, Integer>>> searchDistinct(String text) {
        TreeSet<Pair<String, Pair<Integer, Integer>>> distinct = new TreeSet<Pair<String, Pair<Integer, Integer>>>(new DistinctComparator());
        this.search(text, distinct);
        return distinct;
    }

    public Set<String> searchDistinctNonOverlap(String text) {
        HashSet<String> result = new HashSet<String>();
        TreeSet<Pair<String, Pair<Integer, Integer>>> keywords = new TreeSet<Pair<String, Pair<Integer, Integer>>>(new OrderedComparator());
        this.search(text, keywords);
        int minStartIndex = 0;
        for (Pair pair : keywords) {
            if ((Integer)((Pair)pair.getSecond()).getFirst() < minStartIndex) continue;
            result.add((String)pair.getFirst());
            minStartIndex = (Integer)((Pair)pair.getSecond()).getSecond() + 1;
        }
        return result;
    }

    public Set<Pair<String, Pair<Integer, Integer>>> searchWithoutOverlap(String text) {
        TreeSet<Pair<String, Pair<Integer, Integer>>> keywords = new TreeSet<Pair<String, Pair<Integer, Integer>>>(new OrderedComparator());
        this.search(text, keywords);
        int minStartIndex = 0;
        Iterator itr = keywords.iterator();
        while (itr.hasNext()) {
            Pair keyword = (Pair)itr.next();
            if ((Integer)((Pair)keyword.getSecond()).getFirst() < minStartIndex) {
                itr.remove();
                continue;
            }
            minStartIndex = (Integer)((Pair)keyword.getSecond()).getSecond() + 1;
        }
        return keywords;
    }

    public List<Pair<String, Pair<Integer, Integer>>> searchAll(String text) {
        ArrayList<Pair<String, Pair<Integer, Integer>>> result = new ArrayList<Pair<String, Pair<Integer, Integer>>>();
        this.search(text, result);
        return result;
    }

    void search(String text, Collection<Pair<String, Pair<Integer, Integer>>> found) {
        ArrayList<SearchEntry> active = new ArrayList<SearchEntry>();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (this.ci) {
                c = Character.toUpperCase(c);
            }
            active.add(new SearchEntry(this.root, i));
            Iterator itr = active.iterator();
            while (itr.hasNext()) {
                SearchEntry e = (SearchEntry)itr.next();
                TreeNode n = e.currentNode.getChildNode(c);
                if (n == null) {
                    itr.remove();
                    continue;
                }
                e.buffer.append(c);
                e.currentNode = n;
                if (!n.isEndNode()) continue;
                SearchEntry entry = e;
                if (e.currentNode.hasChildren()) {
                    entry = e.duplicate();
                } else {
                    itr.remove();
                }
                entry.end = i;
                this.addKeywordFound(found, entry);
            }
        }
    }

    TreeNode getRootNode() {
        return this.root;
    }

    public String toString() {
        return this.root.toString();
    }

    private void addKeywordFound(Collection<Pair<String, Pair<Integer, Integer>>> result, SearchEntry entry) {
        Pair found = new Pair((Object)entry.buffer.toString(), (Object)new Pair((Object)entry.start, (Object)entry.end));
        result.add((Pair<String, Pair<Integer, Integer>>)found);
    }

    private static class SearchEntry {
        private TreeNode currentNode;
        private StringBuffer buffer;
        private int start;
        private int end;

        public SearchEntry(TreeNode node, int index) {
            this.currentNode = node;
            this.buffer = new StringBuffer();
            this.start = index;
            this.end = -1;
        }

        public SearchEntry duplicate() {
            SearchEntry dup = new SearchEntry(this.currentNode, this.start);
            dup.buffer.append(this.buffer);
            return dup;
        }

        public String toString() {
            return "\"" + this.buffer.toString() + "\"=" + this.start + "," + this.end;
        }
    }

    private static class OrderedComparator
    implements Comparator<Pair<String, Pair<Integer, Integer>>> {
        private OrderedComparator() {
        }

        @Override
        public int compare(Pair<String, Pair<Integer, Integer>> o1, Pair<String, Pair<Integer, Integer>> o2) {
            if (((Pair)o1.getSecond()).getFirst() == ((Pair)o2.getSecond()).getFirst()) {
                return (Integer)((Pair)o2.getSecond()).getSecond() - (Integer)((Pair)o1.getSecond()).getSecond();
            }
            return (Integer)((Pair)o1.getSecond()).getFirst() - (Integer)((Pair)o2.getSecond()).getFirst();
        }
    }

    private static class DistinctComparator
    implements Comparator<Pair<String, Pair<Integer, Integer>>> {
        private DistinctComparator() {
        }

        @Override
        public int compare(Pair<String, Pair<Integer, Integer>> o1, Pair<String, Pair<Integer, Integer>> o2) {
            return ((String)o1.getFirst()).compareTo((String)o2.getFirst());
        }
    }
}

