/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.DefaultNodeKeyGenerator;
import com.ibm.cognos.fpm.common.graph.DefaultPath;
import com.ibm.cognos.fpm.common.graph.EdgeFilter;
import com.ibm.cognos.fpm.common.graph.EmptyTupleStore;
import com.ibm.cognos.fpm.common.graph.IDirectedGraph;
import com.ibm.cognos.fpm.common.graph.IDirectedLabeledGraph;
import com.ibm.cognos.fpm.common.graph.IGraphStatistics;
import com.ibm.cognos.fpm.common.graph.IGraphValidator;
import com.ibm.cognos.fpm.common.graph.ILabeledGraphValidator;
import com.ibm.cognos.fpm.common.graph.NodeFilter;
import com.ibm.cognos.fpm.common.graph.NodeKeyGenerator;
import com.ibm.cognos.fpm.common.graph.NodeKeyProxyCollection;
import com.ibm.cognos.fpm.common.graph.NodeKeyRelationshipFilter;
import com.ibm.cognos.fpm.common.graph.Path;
import com.ibm.cognos.fpm.common.graph.Tuple;
import com.ibm.cognos.fpm.common.graph.TupleElementIterator;
import com.ibm.cognos.fpm.common.graph.TupleStore;
import com.ibm.cognos.fpm.common.graph.TupleStoreFactory;
import com.ibm.cognos.fpm.common.graph.TupleStoreStatisticsCollector;
import com.ibm.cognos.fpm.common.utility.KeyedHashSet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

abstract class AbstractDirectedLabeledGraph<K, N>
implements IDirectedLabeledGraph<K, N> {
    static final int DEFAULT_INITIAL_CAPACITY = 500;
    static final TupleStore EMPTY_TUPLE_STORE = new EmptyTupleStore();
    private Map<K, NodeInfo> nodeInfos;
    private final List<N> nodes;
    private final List<K> nodeKeys;
    private final TupleStoreStatisticsCollector tupleStoreStats;
    private final GraphStatistics graphStats;
    private final NodeKeyGenerator<K, N> nodeKeyGenerator;
    private IGraphValidator<N> validator = null;
    private final KeyedHashSet<String> edgeLabels;
    private final KeyedHashSet<String> edgePropertyNames;
    private final KeyedHashSet<Object> edgePropertyValues;

    public AbstractDirectedLabeledGraph() {
        this(null, 500);
    }

    public AbstractDirectedLabeledGraph(NodeKeyGenerator<K, N> nodeKeyGenerator) {
        this(nodeKeyGenerator, 500);
    }

    public AbstractDirectedLabeledGraph(int capacity) {
        this(null, capacity);
    }

    public AbstractDirectedLabeledGraph(NodeKeyGenerator<K, N> nodeKeyGenerator, int capacity) {
        this.nodeKeyGenerator = nodeKeyGenerator == null ? new DefaultNodeKeyGenerator() : nodeKeyGenerator;
        this.nodeInfos = new HashMap<K, NodeInfo>(capacity, 0.9f);
        this.nodes = new ArrayList<N>(capacity);
        this.nodeKeys = new ArrayList<K>(capacity);
        this.edgeLabels = new KeyedHashSet(capacity);
        this.edgePropertyNames = new KeyedHashSet(capacity);
        this.edgePropertyValues = new KeyedHashSet(capacity);
        this.graphStats = new GraphStatistics();
        this.tupleStoreStats = TupleStoreFactory.getInstance().createStatisticsCollector();
    }

    public AbstractDirectedLabeledGraph(IDirectedLabeledGraph<K, N> graph) {
        this(graph.getNodeKeyGenerator());
        this.copy(graph);
        this.validator = graph.getValidator();
    }

    void copy(IDirectedLabeledGraph<K, N> graph) {
        for (Object node : graph) {
            Collection<String> edgeLabels;
            this.addNode(node);
            for (Object parentNode : graph.getParents(node)) {
                this.addNode(parentNode);
                edgeLabels = graph.getEdgeLabels(parentNode, node);
                if (edgeLabels.isEmpty()) {
                    this.addEdge(parentNode, node);
                    continue;
                }
                for (String edgeLabel : edgeLabels) {
                    this.addEdge(parentNode, node, edgeLabel);
                    for (Map.Entry<String, Object> edgeProperty : graph.getEdgeProperties(parentNode, node, edgeLabel).entrySet()) {
                        this.addEdgeProperty(parentNode, node, edgeLabel, edgeProperty.getKey(), edgeProperty.getValue());
                    }
                }
            }
            for (Object childNode : graph.getChildren(node)) {
                this.addNode(childNode);
                edgeLabels = graph.getEdgeLabels(node, childNode);
                if (edgeLabels.isEmpty()) {
                    this.addEdge(node, childNode);
                    continue;
                }
                for (String edgeLabel : edgeLabels) {
                    this.addEdge(node, childNode, edgeLabel);
                    for (Map.Entry<String, Object> edgeProperty : graph.getEdgeProperties(node, childNode, edgeLabel).entrySet()) {
                        this.addEdgeProperty(node, childNode, edgeLabel, edgeProperty.getKey(), edgeProperty.getValue());
                    }
                }
            }
        }
    }

    public AbstractDirectedLabeledGraph(IDirectedGraph<K, N> graph) {
        this(graph.getNodeKeyGenerator());
        for (Object node : graph) {
            this.addNode(node);
            for (N parentNode : graph.getParents(node)) {
                this.addNode(parentNode);
                this.addEdge(parentNode, node);
            }
            for (N childNode : graph.getChildren(node)) {
                this.addNode(childNode);
                this.addEdge(node, childNode);
            }
        }
        this.validator = graph.getValidator();
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean optimize() {
        this.graphStats.incrementOptimizeCount();
        long startTime = System.currentTimeMillis();
        try {
            boolean modified = false;
            for (K nodeKey : this.nodeKeys) {
                if (nodeKey == null || !this.optimizeByKey(nodeKey)) continue;
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.graphStats.addOptimizeTime(System.currentTimeMillis() - startTime);
        }
    }

    @Override
    public boolean optimize(N node) {
        this.graphStats.incrementOptimizeNodeCount();
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = this.optimizeByKey(this.nodeKeyGenerator.generate(node));
            return bl;
        }
        finally {
            this.graphStats.addOptimizeNodeTime(System.currentTimeMillis() - startTime);
        }
    }

    private boolean optimizeByKey(K nodeKey) {
        return this.getNodeInfo(nodeKey, true).optimize();
    }

    @Override
    public IGraphStatistics getStatistics() {
        return this.graphStats;
    }

    NodeInfo getNodeInfo(K nodeKey, boolean throwExceptionOnNotFound) {
        NodeInfo nodeInfo = this.nodeInfos.get(nodeKey);
        if (nodeInfo == null && throwExceptionOnNotFound) {
            throw new IllegalArgumentException("The node with key '" + nodeKey + "' doesn't exist in the graph.");
        }
        return nodeInfo;
    }

    NodeInfo getNodeInfo(int internalNodeKey, boolean throwExceptionOnNotFound) {
        NodeInfo nodeInfo = this.nodeInfos.get(this.nodeKeys.get(internalNodeKey));
        if (nodeInfo == null && throwExceptionOnNotFound) {
            throw new IllegalArgumentException("The node with internal key '" + internalNodeKey + "' doesn't exist in the graph.");
        }
        return nodeInfo;
    }

    @Override
    public void checkIntegrity() {
        this.graphStats.incrementCheckIntegrityCount();
        long startTime = System.currentTimeMillis();
        try {
            if (this.nodes.size() != this.nodeKeys.size()) {
                throw new IllegalStateException("this.nodes.size() != this.nodeKeys.size()");
            }
            int i = 0;
            while (i < this.nodeKeys.size()) {
                K nodeKey = this.nodeKeys.get(i);
                N node = this.nodes.get(i);
                if (nodeKey == null && node != null) {
                    throw new IllegalStateException("nodeKey == null && node != null");
                }
                if (nodeKey != null && node == null) {
                    throw new IllegalStateException("nodeKey != null && node == null");
                }
                if (nodeKey != null && node != null) {
                    NodeInfo nodeInfo = this.nodeInfos.get(nodeKey);
                    if (nodeInfo == null) {
                        throw new IllegalStateException("nodeInfo == null");
                    }
                    if (nodeInfo.getInternalNodeKey() != i) {
                        throw new IllegalStateException("nodeInfo.getInternalNodeKey()");
                    }
                } else {
                    for (NodeInfo nodeInfo : this.nodeInfos.values()) {
                        if (nodeInfo.getChildTupleStore().containsTuple(i)) {
                            throw new IllegalStateException("nodeInfo.getChildTupleStore().contains( i )");
                        }
                        if (!nodeInfo.getParentTupleStore().containsTuple(i)) continue;
                        throw new IllegalStateException("getParentTupleStore( true ).contains( i )");
                    }
                }
                ++i;
            }
        }
        finally {
            this.graphStats.addCheckIntegrityTime(System.currentTimeMillis() - startTime);
        }
    }

    @Override
    public boolean addNode(N node) {
        this.graphStats.incrementAddNodeCount();
        long startTime = System.currentTimeMillis();
        try {
            K nodeKey = this.nodeKeyGenerator.generate(node);
            NodeInfo nodeInfo = this.getNodeInfo(nodeKey, false);
            if (nodeInfo != null) {
                return true;
            }
            if (this.validator != null) {
                this.validator.validateNodeAddition(node);
            }
            nodeInfo = new NodeInfo(this.nodeKeys.size());
            this.nodeInfos.put(nodeKey, nodeInfo);
            this.nodeKeys.add(nodeKey);
            this.nodes.add(node);
            assert (this.nodes.size() == this.nodeKeys.size()) : "Nodes and NodeKeys lists are out of sync";
            return false;
        }
        finally {
            this.graphStats.addAddNodeTime(System.currentTimeMillis() - startTime);
        }
    }

    @Override
    public N getNodeByKey(K nodeKey) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeKey, false);
        return (N)(nodeInfo != null ? this.getNode((N)nodeInfo) : null);
    }

    @Override
    private N getNode(NodeInfo nodeInfo) {
        assert (nodeInfo != null);
        return this.nodes.get(nodeInfo.internalNodeKey);
    }

    @Override
    public Collection<N> getNodes() {
        return new NodeKeyProxyCollection(this, this.nodeInfos.keySet(), this.nodeKeys);
    }

    @Override
    public Collection<K> getNodeKeys() {
        return Collections.unmodifiableSet(this.nodeInfos.keySet());
    }

    @Override
    public boolean hasEdge(N sourceNode, N targetNode) {
        NodeInfo targetNodeInfo;
        NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        if (this.hasDirectedEdge(sourceNodeInfo, targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true))) {
            return true;
        }
        return this.hasDirectedEdge(targetNodeInfo, sourceNodeInfo);
    }

    @Override
    public boolean retainBranches(Collection<K> nodeKeys) {
        return this.retainBranches(nodeKeys, null);
    }

    @Override
    public boolean retainBranches(Collection<K> nodeKeys, NodeKeyRelationshipFilter<K> relationshipFilter) {
        if (nodeKeys.isEmpty()) {
            throw new IllegalArgumentException();
        }
        HashSet<K> allNodeKeysToRetain = new HashSet<K>(nodeKeys);
        for (K nodeKey : nodeKeys) {
            this.getAncestorKeys(nodeKey, allNodeKeysToRetain, null, relationshipFilter);
            this.getDescendantKeys(nodeKey, (Set<K>)allNodeKeysToRetain, (NodeFilter<N>)null);
        }
        boolean modified = false;
        for (K leafNodeKey : this.getLeafNodeKeys()) {
            List<Path<K>> paths = this.getAllPathsByKey(leafNodeKey);
            for (Path<K> path : paths) {
                for (K pathNodeKey : path.getPathNodes()) {
                    if (allNodeKeysToRetain.contains(pathNodeKey)) continue;
                    this.removeNode(pathNodeKey, this.getNodeByKey(pathNodeKey));
                    modified = true;
                }
            }
        }
        return modified;
    }

    @Override
    public boolean pruneBranches(Collection<K> nodeKeys, NodeKeyRelationshipFilter<K> relationshipFilter) {
        if (nodeKeys.isEmpty()) {
            throw new IllegalArgumentException();
        }
        HashSet<K> allNodeKeysToRetain = new HashSet<K>(nodeKeys);
        for (K nodeKey : nodeKeys) {
            this.getAncestorKeys(nodeKey, allNodeKeysToRetain, null, relationshipFilter);
        }
        LinkedHashSet nodesToRemove = new LinkedHashSet();
        for (K leafNodeKey : this.getLeafNodeKeys()) {
            LinkedHashSet<Set<K>> paths = new LinkedHashSet<Set<K>>();
            LinkedHashSet<K> processedNodeKeys = new LinkedHashSet<K>();
            processedNodeKeys.add(leafNodeKey);
            this.getAllPaths(leafNodeKey, processedNodeKeys, paths, null, null);
            for (Set set : paths) {
                for (Object pathNodeKey : set) {
                    if (allNodeKeysToRetain.contains(pathNodeKey)) continue;
                    nodesToRemove.add(pathNodeKey);
                }
            }
        }
        for (Object nodeToRemove : nodesToRemove) {
            this.removeNode(nodeToRemove, this.getNodeByKey(nodeToRemove));
        }
        return !nodesToRemove.isEmpty();
    }

    @Override
    public boolean pruneBranches(Collection<K> nodeKeys) {
        return this.pruneBranches(nodeKeys, null);
    }

    @Override
    public Collection<N> getLeafNodes() {
        return new NodeKeyProxyCollection(this, this.getLeafNodeKeys());
    }

    @Override
    public Collection<K> getLeafNodeKeys() {
        LinkedHashSet<K> leafNodeKeys = new LinkedHashSet<K>();
        for (K nodeKey : this.nodeKeys) {
            if (nodeKey == null || !this.getNodeInfo(nodeKey, true).getChildTupleStore().isEmpty()) continue;
            leafNodeKeys.add(nodeKey);
        }
        return leafNodeKeys;
    }

    @Override
    public N removeNode(N node) {
        return this.removeNode(this.nodeKeyGenerator.generate(node), node);
    }

    @Override
    public N removeNode(N node, boolean cascade) {
        K nodeKey = this.nodeKeyGenerator.generate(node);
        if (cascade) {
            HashSet<K> nodeKeysToRemove = new HashSet<K>();
            nodeKeysToRemove.add(nodeKey);
            Iterator<K> nodesToCheck = this.getDescendantKeys(nodeKey).iterator();
            while (nodesToCheck.hasNext()) {
                nodeKeysToRemove.add(nodesToCheck.next());
            }
            for (Object nodeKeyToRemove : nodeKeysToRemove) {
                NodeInfo nodeInfoToRemove;
                if (nodeKeyToRemove.equals(nodeKey) || !nodeKeysToRemove.containsAll(new InternalNodeKeyProxyCollection((nodeInfoToRemove = this.getNodeInfo(nodeKeyToRemove, true)).getParentTupleStore()))) continue;
                this.removeNode(nodeKeyToRemove, this.getNode((N)nodeInfoToRemove));
            }
        }
        return this.removeNode(nodeKey, node);
    }

    private N removeNode(K nodeKey, N node) {
        boolean removed;
        Tuple edgeTuple;
        NodeInfo adjacentNodeInfo;
        NodeInfo nodeInfo = this.getNodeInfo(nodeKey, false);
        if (nodeInfo == null) {
            return null;
        }
        if (this.validator != null) {
            this.validator.validateNodeRemoval(node);
        }
        for (Tuple tuple : nodeInfo.getChildTupleStore()) {
            adjacentNodeInfo = this.getNodeInfo(tuple.getElement(0), true);
            TupleStore parentTupleStoreToUpdate = adjacentNodeInfo.getParentTupleStore(false);
            if (parentTupleStoreToUpdate.isEmpty()) {
                throw new IllegalStateException("The parent and child adjacency lists are out of synch.");
            }
            edgeTuple = parentTupleStoreToUpdate.getTuple(nodeInfo.getInternalNodeKey(), tuple.getElement(1));
            removed = parentTupleStoreToUpdate.removeTuple(nodeInfo.getInternalNodeKey(), tuple.getElement(1));
            if (!removed || edgeTuple == null) {
                throw new IllegalStateException("The parent and child adjacency lists are out of synch.");
            }
            adjacentNodeInfo.getEdgePropertyTupleStore(false).removeTuple(edgeTuple.getElement(2));
        }
        for (Tuple tuple : nodeInfo.getParentTupleStore()) {
            adjacentNodeInfo = this.getNodeInfo(tuple.getElement(0), true);
            TupleStore childTupleStoreToUpdate = adjacentNodeInfo.getChildTupleStore(false);
            if (childTupleStoreToUpdate == null) {
                throw new IllegalStateException("The parent and child adjacency lists are out of synch.");
            }
            edgeTuple = childTupleStoreToUpdate.getTuple(nodeInfo.getInternalNodeKey(), tuple.getElement(1));
            removed = childTupleStoreToUpdate.removeTuple(nodeInfo.getInternalNodeKey(), tuple.getElement(1));
            if (!removed || edgeTuple == null) {
                throw new IllegalStateException("The parent and child adjacency lists are out of synch.");
            }
            adjacentNodeInfo.getEdgePropertyTupleStore(false).removeTuple(edgeTuple.getElement(2));
        }
        this.nodeInfos.remove(nodeKey);
        this.nodeKeys.set(nodeInfo.getInternalNodeKey(), null);
        return this.nodes.set(nodeInfo.getInternalNodeKey(), null);
    }

    @Override
    public Iterator<N> getDepthFirstIterator(N startNode) {
        K startNodeKey = this.nodeKeyGenerator.generate(startNode);
        LinkedHashSet<K> descendantNodeKeys = new LinkedHashSet<K>();
        descendantNodeKeys.add(startNodeKey);
        this.getDescendantKeys(startNodeKey, (Set<K>)descendantNodeKeys, (NodeFilter<N>)null);
        return new NodeKeyProxyCollection(this, descendantNodeKeys).iterator();
    }

    @Override
    public boolean addEdge(N sourceNode, N targetNode) {
        return this.addEdge(sourceNode, targetNode, -1);
    }

    @Override
    public boolean removeEdge(N sourceNode, N targetNode) {
        NodeInfo targetNodeInfo;
        NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        if (!this.hasDirectedEdge(sourceNodeInfo, targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true))) {
            return false;
        }
        if (this.validator != null) {
            this.validator.validateEdgeRemoval(sourceNode, targetNode);
        }
        sourceNodeInfo.getChildTupleStore(false).removeTuple(targetNodeInfo.getInternalNodeKey(), -1);
        targetNodeInfo.getParentTupleStore(false).removeTuple(sourceNodeInfo.getInternalNodeKey(), -1);
        return true;
    }

    @Override
    public boolean addEdge(N sourceNode, N targetNode, String label) {
        int internalLabelKey = this.edgeLabels.getKey(label);
        if (internalLabelKey == -1) {
            internalLabelKey = this.edgeLabels.addAndReturnKey(label);
        }
        return this.addEdge(sourceNode, targetNode, internalLabelKey);
    }

    private boolean addEdge(N sourceNode, N targetNode, int internalLabelKey) {
        boolean addedToParent;
        boolean addedToChild;
        NodeInfo targetNodeInfo;
        NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        if (this.hasDirectedEdge(sourceNodeInfo, targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true), internalLabelKey)) {
            return false;
        }
        if (this.validator != null) {
            this.validator.validateEdgeAddition(sourceNode, targetNode);
        }
        if ((addedToChild = sourceNodeInfo.getChildTupleStore(false).addTuple(targetNodeInfo.getInternalNodeKey(), internalLabelKey, sourceNodeInfo.getChildTupleStore(true).size())) != (addedToParent = targetNodeInfo.getParentTupleStore(false).addTuple(sourceNodeInfo.getInternalNodeKey(), internalLabelKey, targetNodeInfo.getParentTupleStore(true).size()))) {
            throw new IllegalStateException("The parent and child adjacency lists are out of synch.");
        }
        if (addedToChild && this.validator != null) {
            try {
                this.validator.validateEdgeAddition(sourceNode, targetNode);
            }
            catch (RuntimeException e) {
                try {
                    sourceNodeInfo.getChildTupleStore(false).removeTuple(targetNodeInfo.getInternalNodeKey(), internalLabelKey, sourceNodeInfo.getChildTupleStore(true).size());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    targetNodeInfo.getParentTupleStore(false).removeTuple(sourceNodeInfo.getInternalNodeKey(), internalLabelKey, targetNodeInfo.getParentTupleStore(true).size());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    @Override
    public boolean removeEdge(N sourceNode, N targetNode, String label) {
        NodeInfo targetNodeInfo;
        NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        if (!this.hasDirectedEdge(sourceNodeInfo, targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true))) {
            return false;
        }
        int internalLabelKey = this.edgeLabels.getKey(label);
        if (internalLabelKey == -1) {
            return false;
        }
        if (this.validator != null) {
            this.validator.validateEdgeRemoval(sourceNode, targetNode);
        }
        sourceNodeInfo.getChildTupleStore(false).removeTuple(targetNodeInfo.getInternalNodeKey(), internalLabelKey);
        targetNodeInfo.getParentTupleStore(false).removeTuple(sourceNodeInfo.getInternalNodeKey(), internalLabelKey);
        return true;
    }

    @Override
    public boolean hasEdge(N sourceNode, N targetNode, String label) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        NodeInfo targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true);
        int internalLabelKey = this.edgeLabels.getKey(label);
        if (internalLabelKey == -1) {
            return false;
        }
        if (this.hasDirectedEdge(sourceNodeInfo, targetNodeInfo, internalLabelKey)) {
            return true;
        }
        return this.hasDirectedEdge(targetNodeInfo, sourceNodeInfo, internalLabelKey);
    }

    @Override
    public Collection<String> getEdgeLabels(N sourceNode, N targetNode) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        NodeInfo targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true);
        final List<Tuple> outgoingEdgeTuples = sourceNodeInfo.getChildTupleStore().getTuples(targetNodeInfo.getInternalNodeKey());
        if (outgoingEdgeTuples.isEmpty()) {
            return Collections.emptyList();
        }
        return new AbstractCollection<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < outgoingEdgeTuples.size();
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return (String)AbstractDirectedLabeledGraph.this.edgeLabels.get(((Tuple)outgoingEdgeTuples.get(this.pos++)).getElement(1));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return outgoingEdgeTuples.size();
            }
        };
    }

    private boolean hasDirectedEdge(NodeInfo sourceNodeInfo, NodeInfo targetNodeInfo) {
        if (sourceNodeInfo.getChildTupleStore().size() < targetNodeInfo.getParentTupleStore().size()) {
            return sourceNodeInfo.getChildTupleStore().containsTuple(targetNodeInfo.getInternalNodeKey());
        }
        return targetNodeInfo.getParentTupleStore().containsTuple(sourceNodeInfo.getInternalNodeKey());
    }

    private boolean hasDirectedEdge(NodeInfo sourceNodeInfo, NodeInfo targetNodeInfo, int edgeLabelKey) {
        if (sourceNodeInfo.getChildTupleStore().size() < targetNodeInfo.getParentTupleStore().size()) {
            return sourceNodeInfo.getChildTupleStore().containsTuple(targetNodeInfo.getInternalNodeKey(), edgeLabelKey);
        }
        return targetNodeInfo.getParentTupleStore().containsTuple(sourceNodeInfo.getInternalNodeKey(), edgeLabelKey);
    }

    @Override
    public Collection<N> getConnectedNodes(N node) {
        NodeInfo nodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(node), true);
        ArrayList connectedNodeKeys = new ArrayList();
        connectedNodeKeys.addAll(new InternalNodeKeyProxyCollection(nodeInfo.getChildTupleStore()));
        connectedNodeKeys.addAll(new InternalNodeKeyProxyCollection(nodeInfo.getParentTupleStore()));
        return new NodeKeyProxyCollection(this, connectedNodeKeys);
    }

    @Override
    public Collection<N> getConnectedNodes(N node, NodeFilter<N> filter) {
        ArrayList<K> connectedNodeKeys = new ArrayList<K>();
        connectedNodeKeys.addAll(this.getOutgoingNodeKeys(this.nodeKeyGenerator.generate(node), filter, (NodeKeyRelationshipFilter<K>)null));
        connectedNodeKeys.addAll(this.getIncomingNodeKeys(this.nodeKeyGenerator.generate(node), filter, (NodeKeyRelationshipFilter<K>)null));
        return new NodeKeyProxyCollection(this, connectedNodeKeys);
    }

    @Override
    public Collection<N> getRootNodes() {
        return new NodeKeyProxyCollection(this, this.getRootNodeKeys(null));
    }

    @Override
    public Collection<N> getRootNodes(NodeKeyRelationshipFilter<K> relationshipFilter) {
        return new NodeKeyProxyCollection(this, this.getRootNodeKeys(relationshipFilter));
    }

    private Collection<K> getRootNodeKeys(NodeKeyRelationshipFilter<K> relationshipFilter) {
        LinkedHashSet<K> rootNodeKeys = new LinkedHashSet<K>();
        for (NodeInfo nodeInfo : this.nodeInfos.values()) {
            K nodeKey = this.nodeKeys.get(nodeInfo.getInternalNodeKey());
            if (nodeInfo.getParentTupleStore().isEmpty()) {
                rootNodeKeys.add(this.nodeKeys.get(nodeInfo.getInternalNodeKey()));
                continue;
            }
            if (relationshipFilter == null) continue;
            boolean addKey = true;
            for (Object adjacentParentNodeKey : new InternalNodeKeyProxyCollection(nodeInfo.getParentTupleStore())) {
                if (!relationshipFilter.evaluate(adjacentParentNodeKey, nodeKey)) continue;
                addKey = false;
                break;
            }
            if (!addKey) continue;
            rootNodeKeys.add(nodeKey);
        }
        return rootNodeKeys;
    }

    @Override
    public N getParent(N node) {
        Collection<N> parents = this.getParents(node, null);
        if (parents.isEmpty()) {
            return null;
        }
        if (parents.size() > 1) {
            throw new UnsupportedOperationException("The node with key '" + this.nodeKeyGenerator.generate(node) + "' has multiple parents.");
        }
        return parents.iterator().next();
    }

    @Override
    public Collection<N> getParents(N node) {
        return this.getParents(node, null);
    }

    @Override
    public Collection<K> getParentKeys(K nodeKey) {
        return this.getIncomingNodeKeys(nodeKey, (NodeFilter<N>)null, (NodeKeyRelationshipFilter<K>)null);
    }

    @Override
    public int getParentCount(N node) {
        NodeInfo nodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(node), true);
        return nodeInfo.getParentTupleStore().size();
    }

    @Override
    public Collection<N> getParents(N node, NodeFilter<N> filter) {
        return new NodeKeyProxyCollection(this, this.getIncomingNodeKeys(this.nodeKeyGenerator.generate(node), filter, (NodeKeyRelationshipFilter<K>)null));
    }

    @Override
    public Collection<N> getParents(N node, NodeFilter<N> filter, NodeKeyRelationshipFilter<K> relationshipFilter) {
        return new NodeKeyProxyCollection(this, this.getIncomingNodeKeys(this.nodeKeyGenerator.generate(node), filter, relationshipFilter));
    }

    @Override
    public boolean isParent(N potentialParentNode, N node) {
        NodeInfo potentialParentNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(potentialParentNode), false);
        if (potentialParentNodeInfo == null) {
            return false;
        }
        return this.getNodeInfo(this.nodeKeyGenerator.generate(node), true).getParentTupleStore().containsTuple(potentialParentNodeInfo.getInternalNodeKey());
    }

    @Override
    private Collection<K> getIncomingNodeKeys(K nodeKey, NodeFilter<N> filter, NodeKeyRelationshipFilter<K> relationshipFilter) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeKey, true);
        if (filter == null && relationshipFilter == null) {
            return new InternalNodeKeyProxyCollection(nodeInfo.getParentTupleStore());
        }
        ArrayList filteredAdjacentParentNodeKeys = null;
        for (Object adjacentParentNodeKey : new InternalNodeKeyProxyCollection(nodeInfo.getParentTupleStore())) {
            boolean add;
            boolean bl = add = !(filter != null && !filter.evaluate(this.getNode((N)this.getNodeInfo(adjacentParentNodeKey, true))) || relationshipFilter != null && !relationshipFilter.evaluate(adjacentParentNodeKey, nodeKey));
            if (!add) continue;
            if (filteredAdjacentParentNodeKeys == null) {
                filteredAdjacentParentNodeKeys = new ArrayList();
            }
            filteredAdjacentParentNodeKeys.add(adjacentParentNodeKey);
        }
        return filteredAdjacentParentNodeKeys == null ? Collections.emptySet() : Collections.unmodifiableList(filteredAdjacentParentNodeKeys);
    }

    @Override
    public Collection<K> getIncomingNodeKeys(K nodeKey, NodeFilter<N> filter, EdgeFilter<K> edgeFilter) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeKey, true);
        return this.getAdjacentNodeKeys(nodeKey, nodeInfo.getParentTupleStore(), filter, edgeFilter);
    }

    @Override
    public Collection<K> getOutgoingNodeKeys(K nodeKey, NodeFilter<N> filter, EdgeFilter<K> edgeFilter) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeKey, true);
        return this.getAdjacentNodeKeys(nodeKey, nodeInfo.getChildTupleStore(), filter, edgeFilter);
    }

    private Collection<K> getAdjacentNodeKeys(K nodeKey, TupleStore tupleStore, NodeFilter<N> nodeFilter, EdgeFilter<K> edgeFilter) {
        Iterator<Object> it;
        assert (nodeKey != null);
        assert (tupleStore != null);
        if (nodeFilter == null && edgeFilter == null) {
            return new InternalNodeKeyProxyCollection(tupleStore);
        }
        if (edgeFilter != null && !edgeFilter.getEdgeLabelsToFilterOn().isEmpty()) {
            int[] edgeLabelIds = new int[edgeFilter.getEdgeLabelsToFilterOn().size()];
            int i = 0;
            for (String edgeLabel : edgeFilter.getEdgeLabelsToFilterOn()) {
                edgeLabelIds[i] = this.edgeLabels.getKey(edgeLabel);
                ++i;
            }
            it = tupleStore.getFilteredIterator(1, edgeLabelIds);
        } else {
            it = tupleStore.iterator();
        }
        ArrayList<K> filteredAdjacentParentNodeKeys = null;
        while (it.hasNext()) {
            Tuple tuple = (Tuple)it.next();
            K adjacentParentNodeKey = this.nodeKeys.get(tuple.getElement(0));
            boolean add = true;
            if (nodeFilter != null && !nodeFilter.evaluate(this.getNode((N)this.getNodeInfo(adjacentParentNodeKey, true)))) {
                add = false;
            }
            if (edgeFilter != null && add) {
                String edgeLabel = this.edgeLabels.get(tuple.getElement(1));
                add = edgeFilter.evaluate(adjacentParentNodeKey, nodeKey, edgeLabel);
            }
            if (!add) continue;
            if (filteredAdjacentParentNodeKeys == null) {
                filteredAdjacentParentNodeKeys = new ArrayList<K>();
            }
            filteredAdjacentParentNodeKeys.add(adjacentParentNodeKey);
        }
        return filteredAdjacentParentNodeKeys == null ? Collections.emptySet() : Collections.unmodifiableList(filteredAdjacentParentNodeKeys);
    }

    @Override
    public boolean isChild(N potentialChildNode, N node) {
        NodeInfo potentialChildNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(potentialChildNode), true);
        if (potentialChildNodeInfo == null) {
            return false;
        }
        return this.getNodeInfo(this.nodeKeyGenerator.generate(node), false).getChildTupleStore().containsTuple(potentialChildNodeInfo.getInternalNodeKey());
    }

    @Override
    public Collection<N> getChildren(N node) {
        return this.getChildren(node, null);
    }

    @Override
    public Collection<N> getChildren(N node, NodeFilter<N> filter) {
        Collection<K> outgoingNodes = this.getOutgoingNodeKeys(this.nodeKeyGenerator.generate(node), filter, (NodeKeyRelationshipFilter<K>)null);
        NodeKeyProxyCollection children = new NodeKeyProxyCollection(this, outgoingNodes);
        return children;
    }

    @Override
    public Collection<N> getChildren(N node, NodeFilter<N> filter, NodeKeyRelationshipFilter<K> relationshipFilter) {
        Collection<K> outgoingNodes = this.getOutgoingNodeKeys(this.nodeKeyGenerator.generate(node), filter, relationshipFilter);
        NodeKeyProxyCollection children = new NodeKeyProxyCollection(this, outgoingNodes);
        return children;
    }

    @Override
    public Collection<K> getChildrenKeys(N node, NodeFilter<N> filter) {
        return this.getOutgoingNodeKeys(this.nodeKeyGenerator.generate(node), filter, (NodeKeyRelationshipFilter<K>)null);
    }

    @Override
    public int getChildCount(N node) {
        return this.getNodeInfo(this.nodeKeyGenerator.generate(node), true).getChildTupleStore().size();
    }

    @Override
    public int getChildCount(N node, NodeFilter<N> filter) {
        if (filter == null) {
            return this.getChildCount(node);
        }
        NodeInfo nodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(node), true);
        int childCount = 0;
        for (Object childNodeKey : new InternalNodeKeyProxyCollection(nodeInfo.getChildTupleStore())) {
            if (!filter.evaluate(this.getNode((N)this.getNodeInfo(childNodeKey, true)))) continue;
            ++childCount;
        }
        return childCount;
    }

    @Override
    public boolean hasChildren(N node, NodeFilter<N> filter) {
        if (filter == null) {
            return !this.getNodeInfo(this.nodeKeyGenerator.generate(node), true).getChildTupleStore().isEmpty();
        }
        NodeInfo nodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(node), true);
        for (Object childNodeKey : new InternalNodeKeyProxyCollection(nodeInfo.getChildTupleStore())) {
            if (!filter.evaluate(this.getNode((N)this.getNodeInfo(childNodeKey, true)))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Collection<K> getOutgoingNodeKeys(K nodeKey, NodeFilter<N> filter, NodeKeyRelationshipFilter<K> relationshipFilter) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeKey, true);
        if (filter == null) {
            return new InternalNodeKeyProxyCollection(nodeInfo.getChildTupleStore());
        }
        ArrayList filteredAdjacentChildNodeKeys = null;
        for (Object adjacentChildNodeKey : new InternalNodeKeyProxyCollection(nodeInfo.getChildTupleStore())) {
            boolean add;
            boolean bl = add = !(filter != null && !filter.evaluate(this.getNode((N)this.getNodeInfo(adjacentChildNodeKey, true))) || relationshipFilter != null && !relationshipFilter.evaluate(nodeKey, adjacentChildNodeKey));
            if (!add) continue;
            if (filteredAdjacentChildNodeKeys == null) {
                filteredAdjacentChildNodeKeys = new ArrayList();
            }
            filteredAdjacentChildNodeKeys.add(adjacentChildNodeKey);
        }
        return filteredAdjacentChildNodeKeys == null ? Collections.emptySet() : Collections.unmodifiableList(filteredAdjacentChildNodeKeys);
    }

    @Override
    public Collection<N> getDescendants(N node) {
        return this.getDescendants(node, null);
    }

    @Override
    public Collection<N> getDescendants(N node, NodeFilter<N> filter) {
        return new NodeKeyProxyCollection(this, this.getDescendantKeys(this.nodeKeyGenerator.generate(node), filter));
    }

    @Override
    public Collection<K> getDescendantKeys(K nodeKey) {
        return this.getDescendantKeys(nodeKey, null);
    }

    @Override
    public Collection<K> getDescendantKeys(K nodeKey, NodeFilter<N> filter) {
        if (this.getNodeInfo(nodeKey, true).getChildTupleStore().isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet descendantNodeKeys = new LinkedHashSet();
        this.getDescendantKeys(nodeKey, descendantNodeKeys, filter);
        return Collections.unmodifiableSet(descendantNodeKeys);
    }

    private void getDescendantKeys(K currentNodeKey, Set<K> descendantNodeKeys, NodeFilter<N> filter) {
        this.getDescendantKeys(currentNodeKey, descendantNodeKeys, (NodeKeyRelationshipFilter<K>)null);
        if (filter != null) {
            Iterator<K> it = descendantNodeKeys.iterator();
            while (it.hasNext()) {
                K descendantNodeKey = it.next();
                if (filter.evaluate(this.getNode((N)this.getNodeInfo(descendantNodeKey, true)))) continue;
                it.remove();
            }
        }
    }

    @Override
    public Collection<K> getDescendantKeys(K nodeKey, NodeFilter<N> filter, NodeKeyRelationshipFilter<K> relationshipFilter) {
        LinkedHashSet descendantNodeKeys = new LinkedHashSet();
        this.getDescendantKeys(nodeKey, descendantNodeKeys, relationshipFilter);
        if (filter != null) {
            Iterator it = descendantNodeKeys.iterator();
            while (it.hasNext()) {
                Object descendantNodeKey = it.next();
                if (filter.evaluate(this.getNode((N)this.getNodeInfo(descendantNodeKey, true)))) continue;
                it.remove();
            }
        }
        return Collections.unmodifiableSet(descendantNodeKeys);
    }

    private void getDescendantKeys(K currentNodeKey, Set<K> descendantNodeKeys, NodeKeyRelationshipFilter<K> relationshipFilter) {
        Collection<K> childNodeKeys = this.getOutgoingNodeKeys(currentNodeKey, (NodeFilter<N>)null, (NodeKeyRelationshipFilter<K>)null);
        if (childNodeKeys != null) {
            for (K childNodeKey : childNodeKeys) {
                if (descendantNodeKeys.contains(childNodeKey) || relationshipFilter != null && !relationshipFilter.evaluate(currentNodeKey, childNodeKey)) continue;
                descendantNodeKeys.add(childNodeKey);
                this.getDescendantKeys(childNodeKey, descendantNodeKeys, relationshipFilter);
            }
        }
    }

    @Override
    public int getAncestorCount(N node) {
        HashSet ancestorNodeKeys = new HashSet();
        this.getAncestorKeys(this.nodeKeyGenerator.generate(node), ancestorNodeKeys, null);
        return ancestorNodeKeys.size();
    }

    @Override
    public Collection<N> getAncestors(N node) {
        LinkedHashSet ancestorNodeKeys = new LinkedHashSet();
        this.getAncestorKeys(this.nodeKeyGenerator.generate(node), ancestorNodeKeys, null);
        return new NodeKeyProxyCollection(this, ancestorNodeKeys);
    }

    @Override
    public Collection<N> getAncestors(N node, NodeFilter<N> filter) {
        LinkedHashSet ancestorNodeKeys = new LinkedHashSet();
        this.getAncestorKeys(this.nodeKeyGenerator.generate(node), ancestorNodeKeys, filter, null);
        return new NodeKeyProxyCollection(this, ancestorNodeKeys);
    }

    @Override
    public Collection<N> getAncestors(N node, NodeFilter<N> filter, NodeKeyRelationshipFilter<K> relationshipFilter) {
        LinkedHashSet ancestorNodeKeys = new LinkedHashSet();
        this.getAncestorKeys(this.nodeKeyGenerator.generate(node), ancestorNodeKeys, filter, relationshipFilter);
        return new NodeKeyProxyCollection(this, ancestorNodeKeys);
    }

    @Override
    public Collection<K> getAncestorKeys(K nodeKey) {
        LinkedHashSet ancestorNodeKeys = new LinkedHashSet();
        this.getAncestorKeys(nodeKey, ancestorNodeKeys, null, null);
        return Collections.unmodifiableSet(ancestorNodeKeys);
    }

    private void getAncestorKeys(K currentNodeKey, Set<K> ancestorNodeKeys, NodeFilter<N> filter, NodeKeyRelationshipFilter<K> relationshipFilter) {
        this.getAncestorKeys(currentNodeKey, ancestorNodeKeys, relationshipFilter);
        if (filter != null) {
            Iterator<K> it = ancestorNodeKeys.iterator();
            while (it.hasNext()) {
                K ancestorNodeKey = it.next();
                if (filter.evaluate(this.getNode((N)this.getNodeInfo(ancestorNodeKey, true)))) continue;
                it.remove();
            }
        }
    }

    private void getAncestorKeys(K currentNodeKey, Set<K> ancestorNodeKeys, NodeKeyRelationshipFilter<K> relationshipFilter) {
        Collection<K> parentNodeKeys = this.getIncomingNodeKeys(currentNodeKey, (NodeFilter<N>)null, (NodeKeyRelationshipFilter<K>)null);
        if (parentNodeKeys != null) {
            for (K ancestorNodeKey : parentNodeKeys) {
                boolean include;
                if (ancestorNodeKeys.contains(ancestorNodeKey) || !(include = relationshipFilter == null ? true : relationshipFilter.evaluate(ancestorNodeKey, currentNodeKey))) continue;
                ancestorNodeKeys.add(ancestorNodeKey);
                this.getAncestorKeys(ancestorNodeKey, ancestorNodeKeys, relationshipFilter);
            }
        }
    }

    @Override
    public Collection<N> getSiblings(N node) {
        return new NodeKeyProxyCollection(this, this.getSiblingKeys(this.nodeKeyGenerator.generate(node)));
    }

    @Override
    public Collection<K> getSiblingKeys(K nodeKey) {
        LinkedHashSet<K> siblingNodeKeys = new LinkedHashSet<K>();
        for (K parentNodeKey : this.getIncomingNodeKeys(nodeKey, (NodeFilter<N>)null, (NodeKeyRelationshipFilter<K>)null)) {
            siblingNodeKeys.addAll(this.getOutgoingNodeKeys(parentNodeKey, (NodeFilter<N>)null, (NodeKeyRelationshipFilter<K>)null));
        }
        siblingNodeKeys.remove(nodeKey);
        return Collections.unmodifiableSet(siblingNodeKeys);
    }

    @Override
    public Iterator<N> getDepthFirstIterator() {
        LinkedHashSet<K> descendantKeys = new LinkedHashSet<K>();
        for (K rootNodeKey : this.getRootNodeKeys(null)) {
            descendantKeys.add(rootNodeKey);
            descendantKeys.addAll(this.getDescendantKeys(rootNodeKey));
        }
        return new NodeKeyProxyCollection(this, descendantKeys).iterator();
    }

    @Override
    public NodeKeyGenerator<K, N> getNodeKeyGenerator() {
        return this.nodeKeyGenerator;
    }

    @Override
    public IGraphValidator<N> getValidator() {
        return this.validator;
    }

    @Override
    public void setValidator(IGraphValidator<N> validator) {
        this.validator = validator;
    }

    @Override
    public N getNode(N node) {
        return this.getNodeByKey(this.nodeKeyGenerator.generate(node));
    }

    @Override
    public K getNodeKey(N node) {
        K nodeKey = this.nodeKeyGenerator.generate(node);
        if (this.getNodeByKey(nodeKey) == null) {
            throw new IllegalArgumentException("The node with key '" + nodeKey + "' doesn't exist in the graph.");
        }
        return nodeKey;
    }

    @Override
    public Collection<N> findNodes(NodeFilter<N> nodeFilter) {
        if (nodeFilter == null) {
            return this.getNodes();
        }
        ArrayList<N> result = new ArrayList<N>();
        for (N evalNode : this.getNodes()) {
            if (!nodeFilter.evaluate(evalNode)) continue;
            result.add(evalNode);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public boolean containsNode(N node) {
        if (node == null) {
            throw new NullPointerException();
        }
        return this.getNodeByKey(this.nodeKeyGenerator.generate(node)) != null;
    }

    @Override
    public boolean containsNodeWithKey(K nodeKey) {
        if (nodeKey == null) {
            throw new NullPointerException();
        }
        return this.getNodeByKey(nodeKey) != null;
    }

    @Override
    public List<Path<N>> getAllPaths(N node) {
        List<Path<K>> allPaths = this.getAllPathsByKey(this.nodeKeyGenerator.generate(node));
        ArrayList allPathsByNode = new ArrayList(allPaths.size());
        for (Path<K> path : allPaths) {
            allPathsByNode.add(new DefaultPath(new ArrayList(new NodeKeyProxyCollection(this, path.getPathNodes()))));
        }
        return Collections.unmodifiableList(allPathsByNode);
    }

    @Override
    public List<Path<N>> getAllPaths(N node, NodeFilter<N> nodeFilter, NodeKeyRelationshipFilter<K> relationshipFilter) {
        List<Path<K>> allPaths = this.getAllPathsByKey(this.nodeKeyGenerator.generate(node), nodeFilter, relationshipFilter);
        ArrayList allPathsByNode = new ArrayList(allPaths.size());
        for (Path<K> path : allPaths) {
            allPathsByNode.add(new DefaultPath(new ArrayList(new NodeKeyProxyCollection(this, path.getPathNodes()))));
        }
        return Collections.unmodifiableList(allPathsByNode);
    }

    @Override
    public List<Path<K>> getAllPathsByKey(K nodeKey) {
        return this.getAllPathsByKey(nodeKey, null, null);
    }

    private List<Path<K>> getAllPathsByKey(K nodeKey, NodeFilter<N> nodeFilter, NodeKeyRelationshipFilter<K> relationshipFilter) {
        if (!this.containsNodeWithKey(nodeKey)) {
            throw new IllegalArgumentException("The node with key '" + nodeKey + "' doesn't exist in the graph.");
        }
        LinkedHashSet<Set<K>> allPaths = new LinkedHashSet<Set<K>>();
        LinkedHashSet<K> processedNodeKeys = new LinkedHashSet<K>();
        processedNodeKeys.add(nodeKey);
        this.getAllPaths(nodeKey, processedNodeKeys, allPaths, nodeFilter, relationshipFilter);
        ArrayList allPathsAsList = new ArrayList();
        for (Collection collection : allPaths) {
            ArrayList list = new ArrayList(collection);
            Collections.reverse(list);
            allPathsAsList.add(new DefaultPath(list));
        }
        return Collections.unmodifiableList(allPathsAsList);
    }

    private void getAllPaths(K currentNodeKey, Set<K> processedNodeKeys, Set<Set<K>> allPaths, NodeFilter<N> nodeFilter, NodeKeyRelationshipFilter<K> relationshipFilter) {
        Collection<K> adjacentIncomingNodeKeys = this.getIncomingNodeKeys(currentNodeKey, nodeFilter, relationshipFilter);
        if (adjacentIncomingNodeKeys.isEmpty() || processedNodeKeys.containsAll(adjacentIncomingNodeKeys)) {
            allPaths.add(Collections.unmodifiableSet(new LinkedHashSet<K>(processedNodeKeys)));
            processedNodeKeys.remove(currentNodeKey);
            return;
        }
        for (K adjacentChildNodeKey : adjacentIncomingNodeKeys) {
            if (processedNodeKeys.contains(adjacentChildNodeKey)) continue;
            processedNodeKeys.add(adjacentChildNodeKey);
            this.getAllPaths(adjacentChildNodeKey, processedNodeKeys, allPaths, nodeFilter, relationshipFilter);
        }
        processedNodeKeys.remove(currentNodeKey);
    }

    @Override
    public List<Path<N>> getAllPaths(N startNode, N endNode) {
        return this.getAllPaths(startNode, endNode, Integer.MAX_VALUE);
    }

    @Override
    public List<Path<N>> getAllPaths(N startNode, N endNode, int maxDepth) {
        ArrayList allPathsAsList;
        K startNodeKey = this.nodeKeyGenerator.generate(startNode);
        if (!this.containsNodeWithKey(startNodeKey)) {
            throw new IllegalArgumentException("The node with key '" + startNodeKey + "' doesn't exist in the graph.");
        }
        K endNodeKey = this.nodeKeyGenerator.generate(endNode);
        if (!this.containsNodeWithKey(endNodeKey)) {
            throw new IllegalArgumentException("The node with key '" + endNodeKey + "' doesn't exist in the graph.");
        }
        LinkedHashSet<Set<K>> allPaths = new LinkedHashSet<Set<K>>();
        Collection<K> adjacentOutgoingNodeKeys = this.getOutgoingNodeKeys(startNodeKey, (NodeFilter<N>)null, (NodeKeyRelationshipFilter<K>)null);
        if (adjacentOutgoingNodeKeys != null) {
            for (K connectedNodeKey : adjacentOutgoingNodeKeys) {
                LinkedHashSet<K> processedNodeKeys = new LinkedHashSet<K>();
                processedNodeKeys.add(startNodeKey);
                processedNodeKeys.add(connectedNodeKey);
                this.getAllPaths(connectedNodeKey, startNodeKey, endNodeKey, processedNodeKeys, allPaths, maxDepth);
            }
        }
        if (!startNodeKey.equals(endNodeKey)) {
            allPathsAsList = new ArrayList();
            for (Set set : allPaths) {
                allPathsAsList.add(new DefaultPath(new ArrayList(new NodeKeyProxyCollection(this, set))));
            }
            return Collections.unmodifiableList(allPathsAsList);
        }
        allPathsAsList = new ArrayList();
        for (Collection collection : allPaths) {
            ArrayList<N> pathAsList = new ArrayList<N>(new NodeKeyProxyCollection(this, collection));
            if (pathAsList.size() > 1) {
                pathAsList.add(endNode);
            }
            allPathsAsList.add(new DefaultPath(pathAsList));
        }
        return Collections.unmodifiableList(allPathsAsList);
    }

    private void getAllPaths(K currentNodeKey, K startNodeKey, K endNodeKey, Set<K> processedNodeKeys, Set<Set<K>> allPaths, int maxDepth) {
        if (processedNodeKeys.size() - 1 == maxDepth) {
            processedNodeKeys.remove(currentNodeKey);
            return;
        }
        if (currentNodeKey.equals(endNodeKey)) {
            allPaths.add(Collections.unmodifiableSet(new LinkedHashSet<K>(processedNodeKeys)));
            processedNodeKeys.remove(currentNodeKey);
            return;
        }
        Collection<K> adjacentOutgoingNodeKeys = this.getOutgoingNodeKeys(currentNodeKey, (NodeFilter<N>)null, (NodeKeyRelationshipFilter<K>)null);
        if (adjacentOutgoingNodeKeys != null) {
            for (K adjacentChildNodeKey : adjacentOutgoingNodeKeys) {
                if (processedNodeKeys.contains(adjacentChildNodeKey)) {
                    if (!startNodeKey.equals(endNodeKey) || !adjacentChildNodeKey.equals(startNodeKey)) continue;
                    allPaths.add(Collections.unmodifiableSet(new LinkedHashSet<K>(processedNodeKeys)));
                    continue;
                }
                processedNodeKeys.add(adjacentChildNodeKey);
                this.getAllPaths(adjacentChildNodeKey, startNodeKey, endNodeKey, processedNodeKeys, allPaths, maxDepth);
            }
        }
        processedNodeKeys.remove(currentNodeKey);
    }

    @Override
    public Path<N> getShortestPath(N startNode, N endNode) {
        return this.getShortestPath(startNode, endNode, Integer.MAX_VALUE);
    }

    @Override
    public Path<N> getShortestPath(N startNode, N endNode, int maxDepth) {
        K startNodeKey = this.nodeKeyGenerator.generate(startNode);
        if (!this.containsNodeWithKey(startNodeKey)) {
            throw new IllegalArgumentException("The node with key '" + startNodeKey + "' doesn't exist in the graph.");
        }
        K endNodeKey = this.nodeKeyGenerator.generate(endNode);
        if (!this.containsNodeWithKey(endNodeKey)) {
            throw new IllegalArgumentException("The node with key '" + endNodeKey + "' doesn't exist in the graph.");
        }
        ArrayList shortestPath = new ArrayList();
        this.getShortestPath(startNodeKey, startNodeKey, endNodeKey, new LinkedHashSet<K>(Collections.singleton(startNodeKey)), shortestPath, maxDepth);
        return new DefaultPath(new ArrayList(new NodeKeyProxyCollection(this, shortestPath)));
    }

    private void getShortestPath(K currentNodeKey, K startNodeKey, K endNodeKey, Set<K> processedNodeKeys, List<K> currentShortestPath, int maxDepth) {
        if (processedNodeKeys.size() - 1 == maxDepth) {
            processedNodeKeys.remove(currentNodeKey);
            return;
        }
        if (currentNodeKey.equals(endNodeKey)) {
            assert (currentShortestPath.isEmpty() || processedNodeKeys.size() < currentShortestPath.size());
            currentShortestPath.clear();
            currentShortestPath.addAll(processedNodeKeys);
            processedNodeKeys.remove(currentNodeKey);
            return;
        }
        Collection<K> adjacentOutgoingNodeKeys = this.getOutgoingNodeKeys(currentNodeKey, (NodeFilter<N>)null, (NodeKeyRelationshipFilter<K>)null);
        if (adjacentOutgoingNodeKeys != null) {
            for (K adjacentChildNodeKey : adjacentOutgoingNodeKeys) {
                if (processedNodeKeys.contains(adjacentChildNodeKey)) continue;
                if (!currentShortestPath.isEmpty() && processedNodeKeys.size() == currentShortestPath.size() - 1) break;
                processedNodeKeys.add(adjacentChildNodeKey);
                this.getShortestPath(adjacentChildNodeKey, startNodeKey, endNodeKey, processedNodeKeys, currentShortestPath, maxDepth);
            }
        }
        processedNodeKeys.remove(currentNodeKey);
    }

    @Override
    public Object removeEdgeProperty(N sourceNode, N targetNode, String label, String propertyName) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        NodeInfo targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            return null;
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getChildTupleStore().getTuple(targetNodeInfo.internalNodeKey, edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            return null;
        }
        int edgePropertyNameKey = this.edgePropertyNames.getKey(propertyName);
        if (edgePropertyNameKey == -1) {
            return null;
        }
        List<Tuple> outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(2), edgePropertyNameKey);
        if (outgoingEdgePropertyTuples.isEmpty()) {
            return null;
        }
        if (outgoingEdgePropertyTuples.size() > 1) {
            throw new IllegalStateException("Multiple edge property value identifiers are mapped to the same edge.");
        }
        Object removedValue = this.edgePropertyValues.get(outgoingEdgePropertyTuples.get(0).getElement(2));
        if (this.validator instanceof ILabeledGraphValidator) {
            ((ILabeledGraphValidator)this.validator).validateEdgePropertyRemoval(sourceNode, targetNode, propertyName, removedValue);
        }
        sourceNodeInfo.getEdgePropertyTupleStore(false).removeTuple(outgoingEdgePropertyTuples.get(0));
        return removedValue;
    }

    @Override
    public boolean removeEdgeProperties(N sourceNode, N targetNode, String label) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        NodeInfo targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            return false;
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getChildTupleStore().getTuple(targetNodeInfo.internalNodeKey, edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            return false;
        }
        List<Tuple> outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(2));
        if (outgoingEdgePropertyTuples.isEmpty()) {
            return false;
        }
        for (Tuple outgoingEdgePropertyTuple : outgoingEdgePropertyTuples) {
            String propertyName = this.edgePropertyNames.get(outgoingEdgePropertyTuple.getElement(1));
            Object removedValue = this.edgePropertyValues.get(outgoingEdgePropertyTuple.getElement(2));
            if (this.validator instanceof ILabeledGraphValidator) {
                ((ILabeledGraphValidator)this.validator).validateEdgePropertyRemoval(sourceNode, targetNode, propertyName, removedValue);
            }
            sourceNodeInfo.getEdgePropertyTupleStore(false).removeTuple(outgoingEdgePropertyTuple);
        }
        return true;
    }

    @Override
    public boolean hasEdgeProperty(N sourceNode, N targetNode, String label, String propertyName) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        NodeInfo targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            return false;
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getChildTupleStore().getTuple(targetNodeInfo.internalNodeKey, edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            return false;
        }
        int edgePropertyNameIndex = this.edgePropertyNames.getKey(propertyName);
        if (edgePropertyNameIndex == -1) {
            return false;
        }
        return sourceNodeInfo.getEdgePropertyTupleStore().containsTuple(outgoingEdgeTuple.getElement(2), edgePropertyNameIndex);
    }

    @Override
    public boolean hasEdgeProperties(N sourceNode, N targetNode, String label) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        NodeInfo targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            return false;
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getChildTupleStore().getTuple(targetNodeInfo.internalNodeKey, edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            return false;
        }
        return sourceNodeInfo.getEdgePropertyTupleStore().containsTuple(outgoingEdgeTuple.getElement(2));
    }

    @Override
    public Object addEdgeProperty(N sourceNode, N targetNode, String label, String propertyName, Object propertyValue) {
        int edgePropertyValueIndex;
        NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        NodeInfo targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            throw new IllegalArgumentException("There is no edge between '" + this.nodeKeyGenerator.generate(sourceNode) + "' and '" + this.nodeKeyGenerator.generate(targetNode) + "' with the label '" + label + "'.");
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getChildTupleStore().getTuple(targetNodeInfo.internalNodeKey, edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            throw new IllegalArgumentException("There is no edge between '" + this.nodeKeyGenerator.generate(sourceNode) + "' and '" + this.nodeKeyGenerator.generate(targetNode) + "' with the label '" + label + "'.");
        }
        int edgePropertyNameIndex = this.edgePropertyNames.getKey(propertyName);
        if (edgePropertyNameIndex == -1) {
            edgePropertyNameIndex = this.edgePropertyNames.addAndReturnKey(propertyName);
        }
        Object oldPropertyValue = null;
        if (!sourceNodeInfo.getEdgePropertyTupleStore().containsTuple(outgoingEdgeTuple.getElement(2), edgePropertyNameIndex)) {
            if (this.validator instanceof ILabeledGraphValidator) {
                ((ILabeledGraphValidator)this.validator).validateEdgePropertyAddition(sourceNode, targetNode, propertyName, propertyValue);
            }
        } else {
            List<Tuple> outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(2), edgePropertyNameIndex);
            if (outgoingEdgePropertyTuples.isEmpty()) {
                return null;
            }
            if (outgoingEdgePropertyTuples.size() > 1) {
                throw new IllegalStateException("Multiple edge property value identifiers are mapped to the same edge.");
            }
            oldPropertyValue = this.edgePropertyValues.get(outgoingEdgePropertyTuples.get(0).getElement(2));
            if (oldPropertyValue.equals(propertyValue)) {
                return oldPropertyValue;
            }
            if (this.validator instanceof ILabeledGraphValidator) {
                ((ILabeledGraphValidator)this.validator).validateEdgePropertyAddition(sourceNode, targetNode, propertyName, propertyValue);
            }
            sourceNodeInfo.getEdgePropertyTupleStore(false).removeTuple(outgoingEdgePropertyTuples.get(0));
        }
        if ((edgePropertyValueIndex = this.edgePropertyValues.getKey(propertyValue)) == -1) {
            edgePropertyValueIndex = this.edgePropertyValues.addAndReturnKey(propertyValue);
        }
        sourceNodeInfo.getEdgePropertyTupleStore(false).addTuple(outgoingEdgeTuple.getElement(2), edgePropertyNameIndex, edgePropertyValueIndex);
        return oldPropertyValue;
    }

    @Override
    public Object getEdgeProperty(N sourceNode, N targetNode, String label, String propertyName) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        NodeInfo targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            return null;
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getChildTupleStore().getTuple(targetNodeInfo.internalNodeKey, edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            return null;
        }
        int edgePropertyNameIndex = this.edgePropertyNames.getKey(propertyName);
        if (edgePropertyNameIndex == -1) {
            return null;
        }
        List<Tuple> outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(2), edgePropertyNameIndex);
        if (outgoingEdgePropertyTuples.isEmpty()) {
            return null;
        }
        if (outgoingEdgePropertyTuples.size() > 1) {
            throw new IllegalStateException("Multiple edge property value identifiers are mapped to the same edge.");
        }
        return this.edgePropertyValues.get(outgoingEdgePropertyTuples.get(0).getElement(2));
    }

    @Override
    public Map<String, Object> getEdgeProperties(N sourceNode, N targetNode, String label) {
        final NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        NodeInfo targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            return Collections.emptyMap();
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getChildTupleStore().getTuple(targetNodeInfo.internalNodeKey, edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            return Collections.emptyMap();
        }
        final List<Tuple> outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(2));
        if (outgoingEdgePropertyTuples.isEmpty()) {
            return Collections.emptyMap();
        }
        return new AbstractMap<String, Object>(){
            private int size;
            {
                this.size = list.size();
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return new AbstractSet<Map.Entry<String, Object>>(){

                    @Override
                    public Iterator<Map.Entry<String, Object>> iterator() {
                        return new Iterator<Map.Entry<String, Object>>(){
                            private int pos = 0;

                            @Override
                            public boolean hasNext() {
                                return this.pos < outgoingEdgePropertyTuples.size();
                            }

                            @Override
                            public Map.Entry<String, Object> next() {
                                if (!this.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                final Tuple outgoingEdgePropertyTuple = (Tuple)outgoingEdgePropertyTuples.get(this.pos++);
                                return new Map.Entry<String, Object>(){

                                    @Override
                                    public String getKey() {
                                        return (String)AbstractDirectedLabeledGraph.this.edgePropertyNames.get(outgoingEdgePropertyTuple.getElement(1));
                                    }

                                    @Override
                                    public Object getValue() {
                                        return AbstractDirectedLabeledGraph.this.edgePropertyValues.get(outgoingEdgePropertyTuple.getElement(2));
                                    }

                                    @Override
                                    public Object setValue(Object object) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                if (this.pos == 0) {
                                    throw new IllegalStateException();
                                }
                                Tuple outgoingEdgePropertyTuple = (Tuple)outgoingEdgePropertyTuples.get(this.pos - 1);
                                sourceNodeInfo.getEdgePropertyTupleStore(false).removeTuple(outgoingEdgePropertyTuple);
                                outgoingEdgePropertyTuples.set(this.pos - 1, null);
                                2 v0 = this;
                                v0.size = v0.size - 1;
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return outgoingEdgePropertyTuples.size();
                    }
                };
            }
        };
    }

    @Override
    public Collection<String> getEdgePropertyNames(N sourceNode, N targetNode, String label) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(sourceNode), true);
        NodeInfo targetNodeInfo = this.getNodeInfo(this.nodeKeyGenerator.generate(targetNode), true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            return Collections.emptyList();
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getChildTupleStore().getTuple(targetNodeInfo.internalNodeKey, edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            return Collections.emptyList();
        }
        final List<Tuple> outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(2));
        if (outgoingEdgePropertyTuples.isEmpty()) {
            return Collections.emptyList();
        }
        return new AbstractCollection<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < outgoingEdgePropertyTuples.size();
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return (String)AbstractDirectedLabeledGraph.this.edgePropertyNames.get(((Tuple)outgoingEdgePropertyTuples.get(this.pos++)).getElement(1));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return outgoingEdgePropertyTuples.size();
            }
        };
    }

    @Override
    public int getNodeCount() {
        return this.size();
    }

    @Override
    public int getEdgeCount() {
        int edgeCount = 0;
        for (NodeInfo nodeInfo : this.nodeInfos.values()) {
            edgeCount += nodeInfo.getParentTupleStore().size();
        }
        return edgeCount;
    }

    public String toString() {
        return this.toString(true, null);
    }

    @Override
    public String toString(boolean detailed, Comparator<K> comparator) {
        StringWriter sw = new StringWriter();
        if (!detailed) {
            sw.append("[");
            Iterator<NodeInfo> it = this.nodeInfos.values().iterator();
            while (it.hasNext()) {
                sw.append(((Object)this.getNode((N)it.next())).toString());
                if (!it.hasNext()) continue;
                sw.append(", ");
            }
            sw.append("]");
            return sw.toString();
        }
        List<K> nodeKeys = null;
        if (comparator != null) {
            ArrayList<K> nodeKeysAsList = new ArrayList<K>(this.nodeInfos.keySet());
            Collections.sort(nodeKeysAsList, comparator);
            nodeKeys = nodeKeysAsList;
        } else {
            nodeKeys = this.nodeKeys;
        }
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Nodes");
        pw.println("-----");
        for (Object nodeKey : nodeKeys) {
            if (nodeKey == null) continue;
            pw.print(nodeKey.toString());
            pw.print(":");
            pw.println(((Object)this.getNode((N)this.getNodeInfo(nodeKey, true))).toString());
        }
        pw.println();
        pw.println("Edges");
        pw.println("-----");
        for (Object nodeKey : nodeKeys) {
            NodeInfo nodeInfo;
            if (nodeKey == null || (nodeInfo = this.getNodeInfo(nodeKey, true)).getChildTupleStore().isEmpty()) continue;
            Collection<Object> adjacentChildNodeKeysSorted = null;
            if (comparator != null) {
                ArrayList adjacentNodeKeysSorted = new ArrayList(new InternalNodeKeyProxyCollection(nodeInfo.getChildTupleStore()));
                Collections.sort(adjacentNodeKeysSorted, comparator);
                adjacentChildNodeKeysSorted = adjacentNodeKeysSorted;
            } else {
                adjacentChildNodeKeysSorted = new InternalNodeKeyProxyCollection(nodeInfo.getChildTupleStore());
            }
            for (Object adjacentChildNodeKey : adjacentChildNodeKeysSorted) {
                pw.print(nodeKey.toString());
                NodeInfo adjacentChildNodeInfo = this.getNodeInfo(adjacentChildNodeKey, true);
                if (adjacentChildNodeInfo.getChildTupleStore().containsTuple(nodeInfo.getInternalNodeKey())) {
                    pw.print(" <-------> ");
                } else {
                    pw.print(" --------> ");
                }
                pw.println(adjacentChildNodeKey.toString());
            }
        }
        pw.close();
        return sw.toString();
    }

    @Override
    public Iterator<N> iterator() {
        return this.getNodes().iterator();
    }

    @Override
    public boolean add(N object) {
        return this.addNode(object);
    }

    @Override
    public boolean addAll(Collection<? extends N> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.getNodeInfo(this.nodeKeyGenerator.generate(o), false) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.nodeInfos.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.nodeInfos.size();
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int i = 0;
        for (NodeInfo nodeInfo : this.nodeInfos.values()) {
            array[i++] = this.nodes.get(nodeInfo.internalNodeKey);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] contents) {
        int size = this.size();
        if (size > contents.length) {
            Class<?> ct = contents.getClass().getComponentType();
            contents = (Object[])Array.newInstance(ct, size);
        }
        int i = 0;
        for (NodeInfo nodeInfo : this.nodeInfos.values()) {
            contents[i++] = this.nodes.get(nodeInfo.internalNodeKey);
        }
        if (size < contents.length) {
            contents[size] = null;
        }
        return contents;
    }

    protected void setNodeInfoMap(Map<K, NodeInfo> nodeInfos) {
        if (!this.nodeInfos.isEmpty()) {
            throw new IllegalStateException("Map can't be changed after data has been added.");
        }
        if (!nodeInfos.isEmpty()) {
            throw new IllegalStateException("Map can't be changed after data has been added.");
        }
        this.nodeInfos = nodeInfos;
    }

    private final class GraphStatistics
    implements IGraphStatistics {
        private long optimizeCount = 0L;
        private long optimizeTime = 0L;
        private long optimizeNodeCount = 0L;
        private long optimizeNodeTime = 0L;
        private long checkIntegrityCount = 0L;
        private long checkIntegrityTime = 0L;
        private long addNodeCount = 0L;
        private long addNodeTime = 0L;

        private GraphStatistics() {
        }

        @Override
        public int getNodeCount() {
            return AbstractDirectedLabeledGraph.this.size();
        }

        @Override
        public int getEdgeCount() {
            return AbstractDirectedLabeledGraph.this.getEdgeCount();
        }

        public void incrementOptimizeCount() {
            ++this.optimizeCount;
        }

        @Override
        public long getOptimizeCount() {
            return this.optimizeCount;
        }

        @Override
        public long getOptimizeTime() {
            return this.optimizeTime;
        }

        public void addOptimizeTime(long time) {
            this.optimizeTime += time;
        }

        public void incrementOptimizeNodeCount() {
            ++this.optimizeNodeCount;
        }

        @Override
        public long getOptimizeNodeCount() {
            return this.optimizeNodeCount;
        }

        @Override
        public long getOptimizeNodeTime() {
            return this.optimizeNodeTime;
        }

        public void addOptimizeNodeTime(long time) {
            this.optimizeNodeTime += time;
        }

        public void incrementCheckIntegrityCount() {
            ++this.checkIntegrityCount;
        }

        @Override
        public long getCheckIntegrityCount() {
            return this.checkIntegrityCount;
        }

        @Override
        public long getCheckIntegrityTime() {
            return this.checkIntegrityTime;
        }

        public void addCheckIntegrityTime(long time) {
            this.checkIntegrityTime += time;
        }

        public void incrementAddNodeCount() {
            ++this.addNodeCount;
        }

        @Override
        public long getAddNodeCount() {
            return this.addNodeCount;
        }

        @Override
        public long getAddNodeTime() {
            return this.addNodeTime;
        }

        public void addAddNodeTime(long time) {
            this.addNodeTime += time;
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Graph Statistics");
            pw.println("\tPublic API Invocations");
            pw.println("\t\toptimize() invocation count: " + this.getOptimizeCount());
            pw.println("\t\toptimize() invocation time: " + this.getOptimizeTime());
            pw.println("\t\toptimize( N node ) invocation count: " + this.getOptimizeNodeCount());
            pw.println("\t\toptimize( N node ) invocation time: " + this.getOptimizeNodeTime());
            pw.println("\t\tcheckIntegrity() invocation count: " + this.getCheckIntegrityCount());
            pw.println("\t\tcheckIntegrity() invocation time: " + this.getCheckIntegrityTime());
            pw.println("\t\taddNode( N node ) invocation count: " + this.getAddNodeCount());
            pw.println("\t\taddNode( N node ) invocation time: " + this.getAddNodeTime());
            pw.println();
            pw.println(AbstractDirectedLabeledGraph.this.tupleStoreStats.toString());
            pw.close();
            return sw.toString();
        }
    }

    private final class InternalNodeKeyProxyCollection
    implements Collection<K> {
        private final TupleStore tupleStore;

        InternalNodeKeyProxyCollection(TupleStore tupleStore) {
            this.tupleStore = tupleStore;
        }

        @Override
        public boolean add(K o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            Object nodeKey = AbstractDirectedLabeledGraph.this.nodeKeyGenerator.generate(o);
            NodeInfo oNodeInfo = AbstractDirectedLabeledGraph.this.getNodeInfo(nodeKey, false);
            if (oNodeInfo == null) {
                return false;
            }
            return this.tupleStore.containsTuple(oNodeInfo.getInternalNodeKey());
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.tupleStore.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                private final TupleElementIterator m_wrappedIterator;
                private K nextNodeKey;
                {
                    this.m_wrappedIterator = InternalNodeKeyProxyCollection.this.tupleStore.getTupleElementIterator(0);
                    this.nextNodeKey = null;
                    while (this.m_wrappedIterator.hasNext()) {
                        int nextInternalNodeKey = this.m_wrappedIterator.next();
                        this.nextNodeKey = AbstractDirectedLabeledGraph.this.nodeKeys.get(nextInternalNodeKey);
                        if (this.nextNodeKey != null) break;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.nextNodeKey != null;
                }

                @Override
                public K next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object nodeKey = this.nextNodeKey;
                    this.nextNodeKey = null;
                    while (this.m_wrappedIterator.hasNext()) {
                        int nextInternalNodeKey = this.m_wrappedIterator.next();
                        this.nextNodeKey = AbstractDirectedLabeledGraph.this.nodeKeys.get(nextInternalNodeKey);
                        if (this.nextNodeKey != null) break;
                    }
                    return nodeKey;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.tupleStore.size();
        }

        @Override
        public Object[] toArray() {
            Object[] asArray = new Object[this.tupleStore.size()];
            int i = 0;
            Iterator nodeKeys = this.iterator();
            while (nodeKeys.hasNext()) {
                asArray[i++] = nodeKeys.next();
            }
            return asArray;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] asArray = a.length >= this.tupleStore.size() ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.tupleStore.size());
            int i = 0;
            Iterator nodeKeys = this.iterator();
            while (nodeKeys.hasNext()) {
                asArray[i++] = nodeKeys.next();
            }
            if (a.length > this.tupleStore.size()) {
                a[this.tupleStore.size()] = null;
            }
            return asArray;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            Iterator it = this.iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
    }

    protected final class NodeInfo {
        private final int internalNodeKey;
        private TupleStore childTupleStore = null;
        private TupleStore parentTupleStore = null;
        private TupleStore edgePropertyTupleStore = null;
        static final int RELATED_NODE_ID_POS = 0;
        static final int EDGE_LABEL_POS = 1;
        static final int EDGE_ID_POS = 2;

        NodeInfo(int internalNodeKey) {
            this.internalNodeKey = internalNodeKey;
        }

        public boolean optimize() {
            boolean modified = false;
            if (this.childTupleStore != null && this.childTupleStore.optimize()) {
                modified = true;
            }
            if (this.parentTupleStore != null && this.parentTupleStore.optimize()) {
                modified = true;
            }
            if (this.edgePropertyTupleStore != null && this.edgePropertyTupleStore.optimize()) {
                modified = true;
            }
            return modified;
        }

        public TupleStore getChildTupleStore() {
            return this.getChildTupleStore(true);
        }

        public TupleStore getChildTupleStore(boolean readOnly) {
            if (this.childTupleStore == null) {
                if (readOnly) {
                    return EMPTY_TUPLE_STORE;
                }
                this.childTupleStore = TupleStoreFactory.getInstance().create(3, 1250, 5, AbstractDirectedLabeledGraph.this.tupleStoreStats);
            }
            return this.childTupleStore;
        }

        public TupleStore getParentTupleStore() {
            return this.getParentTupleStore(true);
        }

        public TupleStore getParentTupleStore(boolean readOnly) {
            if (this.parentTupleStore == null) {
                if (readOnly) {
                    return EMPTY_TUPLE_STORE;
                }
                this.parentTupleStore = TupleStoreFactory.getInstance().create(3, 1250, 5, AbstractDirectedLabeledGraph.this.tupleStoreStats);
            }
            return this.parentTupleStore;
        }

        public TupleStore getEdgePropertyTupleStore() {
            return this.getEdgePropertyTupleStore(true);
        }

        public TupleStore getEdgePropertyTupleStore(boolean readOnly) {
            if (this.edgePropertyTupleStore == null) {
                if (readOnly) {
                    return EMPTY_TUPLE_STORE;
                }
                this.edgePropertyTupleStore = TupleStoreFactory.getInstance().create(3, 1250, 5, AbstractDirectedLabeledGraph.this.tupleStoreStats);
            }
            return this.edgePropertyTupleStore;
        }

        public int getInternalNodeKey() {
            return this.internalNodeKey;
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println(AbstractDirectedLabeledGraph.this.getNode((Object)this).toString());
            pw.print("Integer Key: ");
            pw.println(this.internalNodeKey);
            pw.print("Parents: ");
            pw.println(this.parentTupleStore != null ? new InternalNodeKeyProxyCollection(this.parentTupleStore).toString() : "[]");
            pw.print("Children: ");
            pw.println(this.childTupleStore != null ? new InternalNodeKeyProxyCollection(this.childTupleStore).toString() : "[]");
            pw.close();
            return sw.toString();
        }
    }
}

