/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.ITupleElementFilter;
import com.ibm.cognos.fpm.common.graph.Tuple;
import com.ibm.cognos.fpm.common.graph.TupleStore;
import com.ibm.cognos.fpm.common.graph.TupleStoreConfiguration;
import com.ibm.cognos.fpm.common.graph.TupleStoreStatisticsCollector;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

abstract class AbstractTupleStore
implements TupleStore {
    AbstractTupleStore() {
    }

    @Override
    public boolean containsTuple(Tuple tuple) {
        if (tuple.getElement(0) == Integer.MIN_VALUE) {
            return false;
        }
        return this.containsTuple(tuple.toArray());
    }

    static boolean containsTuple(TupleStoreImplStatisticsCollector statsCollector, int[][] tuples, int tuplesStartPos, int tuplesLastPos, int ... tuplePrefix) {
        int pos = AbstractTupleStore.indexOf(statsCollector, tuples, tuplesStartPos, tuplesLastPos, tuplePrefix);
        if (pos >= 0) {
            return true;
        }
        pos = -(pos + 1);
        while (pos < tuplesLastPos && tuples[0][pos] == Integer.MIN_VALUE) {
            ++pos;
        }
        if (pos < tuplesLastPos && tuplePrefix.length < tuples.length) {
            boolean found = true;
            int tupleElement = 0;
            while (tupleElement < tuplePrefix.length) {
                if (tuples[tupleElement][pos] != tuplePrefix[tupleElement]) {
                    found = false;
                    break;
                }
                ++tupleElement;
            }
            if (found) {
                return true;
            }
        }
        return false;
    }

    static boolean containsFilteredTuple(TupleStoreImplStatisticsCollector statsCollector, ITupleElementFilter filter, int[][] tuples, int tuplesStartPos, int tuplesLastPos, int ... tuplePrefix) {
        Tuple tuple = AbstractTupleStore.getTuple(statsCollector, filter, tuples, tuplesStartPos, tuplesLastPos, tuplePrefix);
        return tuple != null;
    }

    static int indexOf(TupleStoreImplStatisticsCollector statsCollector, int[][] tuples, int tuplesStartPos, int tuplesLastPos, int ... tuplePrefix) {
        if (tuplesStartPos >= tuplesLastPos) {
            return -(tuplesStartPos + 1);
        }
        return AbstractTupleStore.binarySearch(statsCollector, tuples, tuplesStartPos, tuplesLastPos - 1, tuplePrefix);
    }

    static void getTuples(TupleStoreImplStatisticsCollector statsCollector, int[][] tuples, int tuplesStartPos, int tuplesLastPos, List<Tuple> tupleList, int ... tuplePrefix) {
        if (tuplesStartPos >= tuplesLastPos) {
            return;
        }
        int startPos = AbstractTupleStore.binarySearch(statsCollector, tuples, tuplesStartPos, tuplesLastPos - 1, tuplePrefix);
        if (startPos < 0) {
            startPos = -(startPos + 1);
        }
        int tupleSequence = startPos;
        while (tupleSequence < tuplesLastPos) {
            if (tuples[0][tupleSequence] != Integer.MIN_VALUE) {
                int tupleElement = 0;
                while (tupleElement < tuplePrefix.length) {
                    if (tuples[tupleElement][tupleSequence] != tuplePrefix[tupleElement]) {
                        return;
                    }
                    ++tupleElement;
                }
                tupleList.add(new TupleImpl(tuples, tupleSequence));
            }
            ++tupleSequence;
        }
    }

    static Tuple getTuple(TupleStoreImplStatisticsCollector statsCollector, int[][] tuples, int tuplesStartPos, int tuplesLastPos, int ... tuplePrefix) {
        if (tuplesStartPos >= tuplesLastPos) {
            return null;
        }
        int startPos = AbstractTupleStore.binarySearch(statsCollector, tuples, tuplesStartPos, tuplesLastPos - 1, tuplePrefix);
        if (startPos < 0) {
            startPos = -(startPos + 1);
        }
        int tupleSequence = startPos;
        while (tupleSequence < tuplesLastPos) {
            if (tuples[0][tupleSequence] != Integer.MIN_VALUE) {
                int tupleElement = 0;
                while (tupleElement < tuplePrefix.length) {
                    if (tuples[tupleElement][tupleSequence] != tuplePrefix[tupleElement]) {
                        return null;
                    }
                    ++tupleElement;
                }
                return new TupleImpl(tuples, tupleSequence);
            }
            ++tupleSequence;
        }
        return null;
    }

    static Tuple getTuple(TupleStoreImplStatisticsCollector statsCollector, ITupleElementFilter filter, int[][] tuples, int tuplesStartPos, int tuplesLastPos, int ... tuplePrefix) {
        if (tuplesStartPos >= tuplesLastPos) {
            return null;
        }
        int startPos = AbstractTupleStore.binarySearch(statsCollector, tuples, tuplesStartPos, tuplesLastPos - 1, tuplePrefix);
        if (startPos < 0) {
            startPos = -(startPos + 1);
        }
        boolean atLeastOneTupleSequenceMatched = false;
        int matchedTupleSequence = startPos;
        int tupleSequence = startPos;
        while (tupleSequence < tuplesLastPos) {
            if (tuples[0][tupleSequence] != Integer.MIN_VALUE) {
                boolean isPrefixMatched = true;
                int tupleElement = 0;
                while (tupleElement < tuplePrefix.length) {
                    if (tuples[tupleElement][tupleSequence] != tuplePrefix[tupleElement]) {
                        isPrefixMatched = false;
                        break;
                    }
                    ++tupleElement;
                }
                if (!isPrefixMatched || filter.evaluate(tuples[filter.getTupleElementPosition()][tupleSequence])) break;
                atLeastOneTupleSequenceMatched = true;
                matchedTupleSequence = tupleSequence;
            }
            ++tupleSequence;
        }
        if (!atLeastOneTupleSequenceMatched) {
            return null;
        }
        return new TupleImpl(tuples, matchedTupleSequence);
    }

    static void getTuplesByPositionValue(int[][] tuples, int tuplesStartPos, int tuplesLastPos, List<Tuple> tupleList, int position, int ... values) {
        if (tuplesStartPos >= tuplesLastPos) {
            return;
        }
        Arrays.sort(values);
        int[] tuplesPos = tuples[position];
        int tupleSequence = tuplesStartPos;
        while (tupleSequence < tuplesLastPos) {
            if (tuples[0][tupleSequence] != Integer.MIN_VALUE && Arrays.binarySearch(values, tuplesPos[tupleSequence]) >= 0) {
                tupleList.add(new TupleImpl(tuples, tupleSequence));
            }
            ++tupleSequence;
        }
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof int[])) {
            throw new ClassCastException(object.getClass().getSimpleName());
        }
        return this.containsTuple((int[])object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object object : collection) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        throw new UnsupportedOperationException();
    }

    protected static int binarySearch(TupleStoreImplStatisticsCollector statisticsCollector, int[][] tuples, int startIndex, int endIndex, int[] tuple) {
        assert (startIndex <= endIndex);
        assert (startIndex >= 0);
        long startTime = 0L;
        if (statisticsCollector != null) {
            statisticsCollector.incrementBinarySearchCount();
            startTime = System.currentTimeMillis();
        }
        try {
            int[] tupleColumn0 = tuples[0];
            assert (tupleColumn0[startIndex] != Integer.MIN_VALUE);
            assert (tupleColumn0[endIndex] != Integer.MIN_VALUE);
            int compareResult = AbstractTupleStore.compare(tuple, tuples, endIndex);
            if (compareResult == 0) {
                int n = endIndex;
                return n;
            }
            if (compareResult > 0) {
                int n = -(endIndex + 2);
                return n;
            }
            compareResult = AbstractTupleStore.compare(tuple, tuples, startIndex);
            if (compareResult == 0) {
                int n = startIndex;
                return n;
            }
            if (compareResult < 0) {
                int n = -(startIndex + 1);
                return n;
            }
            int low = startIndex;
            int mid = -1;
            int high = endIndex - 1;
            while (low <= high) {
                mid = low + high >>> 1;
                if (tupleColumn0[mid] == Integer.MIN_VALUE) {
                    int tmpMid = mid;
                    while (tupleColumn0[tmpMid] == Integer.MIN_VALUE && tmpMid > low) {
                        --tmpMid;
                    }
                    if (tupleColumn0[tmpMid] == Integer.MIN_VALUE) {
                        while (tupleColumn0[tmpMid] == Integer.MIN_VALUE && tmpMid < high) {
                            ++tmpMid;
                        }
                        if (tupleColumn0[tmpMid] == Integer.MIN_VALUE) {
                            int n = -low - 1;
                            return n;
                        }
                    }
                    mid = tmpMid;
                }
                if ((compareResult = AbstractTupleStore.compare(tuple, tuples, mid)) > 0) {
                    low = mid + 1;
                    continue;
                }
                if (compareResult == 0) {
                    int n = mid;
                    return n;
                }
                high = mid - 1;
            }
            if (mid < 0) {
                int n = -startIndex - 1;
                return n;
            }
            int n = -mid - (AbstractTupleStore.compare(tuple, tuples, mid) < 0 ? 1 : 2);
            return n;
        }
        finally {
            if (statisticsCollector != null) {
                statisticsCollector.addBinarySearchTime(System.currentTimeMillis() - startTime);
            }
        }
    }

    static int compare(int[][] tuples, int srcPos, int[] tuple) {
        int i = 0;
        while (i < tuple.length) {
            int tupleA = tuples[i][srcPos];
            int tupleB = tuple[i];
            if (tupleA > tupleB) {
                return 1;
            }
            if (tupleA < tupleB) {
                return -1;
            }
            ++i;
        }
        return tuple.length == tuples.length ? 0 : -1;
    }

    public static int compare(int[][] tuplesA, int a, int[][] tuplesB, int b) {
        int tupleALength = tuplesA[0].length;
        int tupleBLength = tuplesB[0].length;
        int i = 0;
        while (i < tupleALength) {
            int tupleA = tuplesA[i][a];
            int tupleB = tuplesB[i][b];
            if (tupleA > tupleB) {
                return 1;
            }
            if (tupleA < tupleB) {
                return -1;
            }
            ++i;
        }
        return tupleALength < tupleBLength ? -1 : (tupleALength == tupleBLength ? 0 : 1);
    }

    static int compare(int[] tuple, int[][] tuples, int srcPos) {
        int tupleA = tuple[0];
        int tupleB = tuples[0][srcPos];
        if (tupleA > tupleB) {
            return 1;
        }
        if (tupleA < tupleB) {
            return -1;
        }
        int tupleLength = tuple.length;
        int i = 1;
        while (i < tupleLength) {
            tupleA = tuple[i];
            tupleB = tuples[i][srcPos];
            if (tupleA > tupleB) {
                return 1;
            }
            if (tupleA < tupleB) {
                return -1;
            }
            ++i;
        }
        return tuples.length == tupleLength ? 0 : (tuples.length > tupleLength ? -1 : -1);
    }

    static int[] fill(int[][] tuples, int srcPos, int[] destTuple) {
        int i = 0;
        while (i < destTuple.length) {
            destTuple[i] = tuples[i][srcPos];
            ++i;
        }
        return destTuple;
    }

    static void fill(int[] srcTuple, int tupleLength, int[][] tuples, int destPos) {
        int i = 0;
        while (i < tupleLength) {
            tuples[i][destPos] = srcTuple[i];
            ++i;
        }
    }

    protected static final class TupleImpl
    implements Tuple {
        private final int[][] tuples;
        private final int tupleSequence;

        TupleImpl(int[][] tuples, int tupleSequence) {
            this.tuples = tuples;
            this.tupleSequence = tupleSequence;
        }

        @Override
        public int length() {
            return this.tuples.length;
        }

        @Override
        public int getElement(int pos) {
            if (pos >= this.length()) {
                throw new IndexOutOfBoundsException();
            }
            return this.tuples[pos][this.tupleSequence];
        }

        @Override
        public int[] toArray() {
            return AbstractTupleStore.fill(this.tuples, this.tupleSequence, new int[this.length()]);
        }

        public boolean equals(Object obj) {
            if (obj instanceof int[]) {
                return AbstractTupleStore.compare(this.tuples, this.tupleSequence, (int[])obj) == 0;
            }
            if (obj instanceof Tuple) {
                Tuple castedObj = (Tuple)obj;
                if (castedObj.length() != this.length()) {
                    return false;
                }
                int i = 0;
                while (i < this.length()) {
                    if (this.tuples[i][this.tupleSequence] != castedObj.getElement(i)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.print("[");
            int j = 0;
            while (j < this.tuples.length) {
                pw.print(this.tuples[j][this.tupleSequence]);
                if (j + 1 < this.tuples.length) {
                    pw.print(", ");
                }
                ++j;
            }
            pw.println("]");
            pw.close();
            return sw.toString();
        }
    }

    public static final class TupleStoreConfigurationImpl
    implements TupleStoreConfiguration {
        static final int DEFAULT_MAX_BUCKET_SIZE = 1250;
        static final int DEFAULT_MAX_BUCKETS = 10;
        final int tupleLength;
        final TupleStoreImplStatisticsCollector statisticsCollector;
        final int maxBucketSize;
        final int maxBucketCount;

        public TupleStoreConfigurationImpl(int tupleLength, int bucketSize, int maxBuckets) {
            this.tupleLength = tupleLength;
            this.maxBucketSize = bucketSize;
            this.maxBucketCount = maxBuckets;
            this.statisticsCollector = null;
        }

        public TupleStoreConfigurationImpl(int tupleLength, int bucketSize, int maxBuckets, TupleStoreStatisticsCollector statisticsCollector) {
            if (statisticsCollector != null && !(statisticsCollector instanceof TupleStoreImplStatisticsCollector)) {
                throw new IllegalArgumentException("Unsupported class type: " + statisticsCollector.getClass().getSimpleName());
            }
            this.tupleLength = tupleLength;
            this.maxBucketSize = bucketSize;
            this.maxBucketCount = maxBuckets;
            this.statisticsCollector = statisticsCollector == null ? null : (TupleStoreImplStatisticsCollector)statisticsCollector;
        }

        public TupleStoreConfigurationImpl(int tupleLength, TupleStoreStatisticsCollector statisticsCollector) {
            this(tupleLength, 1250, 10, statisticsCollector);
        }

        public TupleStoreConfigurationImpl(int tupleLength) {
            this(tupleLength, 1250, 10);
        }

        @Override
        public int getTupleLength() {
            return this.tupleLength;
        }

        @Override
        public int getMaxBucketSize() {
            return this.maxBucketSize;
        }

        @Override
        public int getMaxBucketCount() {
            return this.maxBucketCount;
        }

        @Override
        public TupleStoreStatisticsCollector getTupleStoreStatisticsCollector() {
            return this.statisticsCollector;
        }

        public TupleStoreImplStatisticsCollector getTupleStoreImplStatisticsCollector() {
            return this.statisticsCollector;
        }

        @Override
        public boolean collectStatistics() {
            return this.statisticsCollector != null;
        }
    }

    public static final class TupleStoreImplStatisticsCollector
    implements TupleStoreStatisticsCollector {
        private long countainsTupleCount = 0L;
        private long containsTupleTime = 0L;
        private long getTuplesByPositionValueCount = 0L;
        private long getTuplesByPositionValueTime = 0L;
        private long getTuplesByPrefixCount = 0L;
        private long getTuplesByPrefixTime = 0L;
        private long addTupleCount = 0L;
        private long addTupleTime = 0L;
        private long removeTupleCount = 0L;
        private long removeTupleTime = 0L;
        private long optimizeCount = 0L;
        private long optimizeTime = 0L;
        private long binarySearchTime = 0L;
        private long binarySearchCount = 0L;
        private long mergeSortCount = 0L;
        private long mergeSortTime = 0L;
        private long mergeCount = 0L;
        private long mergeTime = 0L;
        private long mergeMoveTime = 0L;
        private long mergeMoveCount = 0L;
        private long mergeCopyCount = 0L;
        private long mergeCopyTime = 0L;
        private long mergePartitionTime = 0L;
        private long addTupleGrowArrayCount = 0L;
        private long addTupleGrowArrayTime = 0L;
        private long addTupleChooseContainerTime = 0L;

        @Override
        public void incrementContainsCount() {
            ++this.countainsTupleCount;
        }

        @Override
        public long getContainsTupleCount() {
            return this.countainsTupleCount;
        }

        @Override
        public long getContainsTupleTime() {
            return this.containsTupleTime;
        }

        @Override
        public void addContainsTupleTime(long time) {
            this.containsTupleTime += time;
        }

        @Override
        public void addGetTuplesByPrefixTime(long time) {
            this.getTuplesByPrefixTime += time;
        }

        @Override
        public void incrementGetTuplesByPrefixCount() {
            ++this.getTuplesByPrefixCount;
        }

        @Override
        public long getTuplesByPrefixCount() {
            return this.getTuplesByPrefixCount;
        }

        @Override
        public long getTuplesByPrefixTime() {
            return this.getTuplesByPrefixTime;
        }

        @Override
        public void incrementAddTupleCount() {
            ++this.addTupleCount;
        }

        @Override
        public long getAddTupleCount() {
            return this.addTupleCount;
        }

        @Override
        public long getAddTupleTime() {
            return this.addTupleTime;
        }

        public void addAddTupleTime(long time) {
            this.addTupleTime += time;
        }

        public void incrementAddTupleGrowArrayCount() {
            ++this.addTupleGrowArrayCount;
        }

        public long getAddTupleGrowArrayCount() {
            return this.addTupleGrowArrayCount;
        }

        public long getAddTupleGrowArrayTime() {
            return this.addTupleGrowArrayTime;
        }

        public void addAddTupleGrowArrayTime(long time) {
            this.addTupleGrowArrayTime += time;
        }

        @Override
        public void incrementRemoveTupleCount() {
            ++this.removeTupleCount;
        }

        @Override
        public long getRemoveTupleCount() {
            return this.removeTupleCount;
        }

        @Override
        public long getRemoveTupleTime() {
            return this.removeTupleTime;
        }

        @Override
        public void addRemoveTupleTime(long time) {
            this.removeTupleTime += time;
        }

        @Override
        public void incrementOptimizeCount() {
            ++this.optimizeCount;
        }

        @Override
        public long getOptimizeCount() {
            return this.optimizeCount;
        }

        @Override
        public long getOptimizeTime() {
            return this.optimizeTime;
        }

        @Override
        public void addOptimizeTime(long time) {
            this.optimizeTime += time;
        }

        public void incrementMergeSortCount() {
            ++this.mergeSortCount;
        }

        public long getMergeSortTime() {
            return this.mergeSortTime;
        }

        public void addMergeSortTime(long time) {
            this.mergeSortTime += time;
        }

        public long getMergeSortCount() {
            return this.mergeSortCount;
        }

        public void incrementMergeCount() {
            ++this.mergeCount;
        }

        public long getMergeTime() {
            return this.mergeTime;
        }

        public void addMergeTime(long time) {
            this.mergeTime += time;
        }

        public long getMergeCount() {
            return this.mergeCount;
        }

        public long getMergeCopyTime() {
            return this.mergeCopyTime;
        }

        public void addCopyMergeTime(long time) {
            this.mergeCopyTime += time;
        }

        public void incrementMergeCopyCount() {
            ++this.mergeCopyCount;
        }

        public long getMergeCopyCount() {
            return this.mergeCopyCount;
        }

        public long getMergeMoveTime() {
            return this.mergeMoveTime;
        }

        public void addMoveMergeTime(long time) {
            this.mergeMoveTime += time;
        }

        public void incrementMergeMoveCount() {
            ++this.mergeMoveCount;
        }

        public long getMergeMoveCount() {
            return this.mergeMoveCount;
        }

        public long getMergePartitionTime() {
            return this.mergePartitionTime;
        }

        public void addMergePartitionTime(long time) {
            this.mergePartitionTime += time;
        }

        public long getBinarySearchTime() {
            return this.binarySearchTime;
        }

        public void addBinarySearchTime(long time) {
            this.binarySearchTime += time;
        }

        public void incrementBinarySearchCount() {
            ++this.binarySearchCount;
        }

        public long getBinarySearchCount() {
            return this.binarySearchCount;
        }

        public long getAddTupleChooseContainerTime() {
            return this.addTupleChooseContainerTime;
        }

        public void addAddTupleChooseContainerTime(long time) {
            this.addTupleChooseContainerTime += time;
        }

        @Override
        public long getTuplesByPositionValueCount() {
            return this.getTuplesByPositionValueCount;
        }

        @Override
        public void incrementGetTuplesByPositionValueCount() {
            ++this.getTuplesByPrefixCount;
        }

        @Override
        public long getTuplesByPositionValueTime() {
            return this.getTuplesByPositionValueTime;
        }

        @Override
        public void addGetTuplesByPositionValueTime(long time) {
            this.addTupleChooseContainerTime += time;
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Tuple Store Statistics");
            pw.println("\tPublic API Invocations");
            pw.println("\t\taddTuple( ...tuple ) invocation count: " + this.getAddTupleCount());
            pw.println("\t\taddTuple( ...tuple ) total invocation time: " + this.getAddTupleTime() + "ms.");
            pw.println("\t\taddTuple( ...tuple ) avg invocation time: " + (this.getAddTupleCount() > 0L ? this.getAddTupleTime() / this.getAddTupleCount() : 0L) + "ms.");
            pw.println("\t\tremoveTuple( ...tuple ) invocation count: " + this.getRemoveTupleCount());
            pw.println("\t\tremoveTuple( ...tuple ) total invocation time: " + this.getRemoveTupleTime() + "ms.");
            pw.println("\t\tremoveTuple( ...tuple ) avg invocation time: " + (this.getRemoveTupleCount() > 0L ? this.getRemoveTupleTime() / this.getRemoveTupleCount() : 0L) + "ms.");
            pw.println("\t\tcontainsTuple( ...tuple ) invocation count: " + this.getContainsTupleCount());
            pw.println("\t\tcontainsTuple( ...tuple ) total invocation time: " + this.getContainsTupleTime() + "ms.");
            pw.println("\t\tcontainsTuple( ...tuple ) avg invocation time: " + (this.getContainsTupleCount() > 0L ? this.getContainsTupleTime() / this.getContainsTupleCount() : 0L) + "ms.");
            pw.println("\t\tgetTuples( ...tuple ) invocation count: " + this.getTuplesByPrefixCount());
            pw.println("\t\tgetTuples( ...tuple ) total invocation time: " + this.getTuplesByPrefixTime() + "ms.");
            pw.println("\t\tgetTuples( ...tuple ) avg invocation time: " + (this.getTuplesByPrefixCount() > 0L ? this.getTuplesByPrefixTime() / this.getTuplesByPrefixCount() : 0L) + "ms.");
            pw.println("\t\tgetTuples( int pos, int value ) invocation count: " + this.getTuplesByPositionValueCount());
            pw.println("\t\tgetTuples( int pos, int value ) total invocation time: " + this.getTuplesByPositionValueTime() + "ms.");
            pw.println("\t\tgetTuples( int pos, int value) avg invocation time: " + (this.getTuplesByPositionValueCount() > 0L ? this.getTuplesByPositionValueTime() / this.getTuplesByPositionValueCount() : 0L) + "ms.");
            pw.println("\tInternal Statistics");
            pw.println("\t\taddTuple grow array invocation count: " + this.getAddTupleGrowArrayCount());
            pw.println("\t\taddTuple grow array total invocation time: " + this.getAddTupleGrowArrayTime() + "ms.");
            pw.println("\t\taddTuple grow array avg invocation time: " + (this.getAddTupleGrowArrayCount() > 0L ? this.getAddTupleGrowArrayTime() / this.getAddTupleGrowArrayCount() : 0L) + "ms.");
            pw.println("\t\taddTuple choose container invocation time: " + this.getAddTupleChooseContainerTime());
            pw.println("\t\tmerge invocation count: " + this.getMergeCount());
            pw.println("\t\tmerge total invocation time: " + this.getMergeTime());
            pw.println("\t\tmerge avg invocation time: " + (this.getMergeCount() > 0L ? this.getMergeTime() / this.getMergeCount() : 0L) + "ms.");
            pw.println("\t\t\tmerge data sort invocation count: " + this.getMergeSortCount());
            pw.println("\t\t\tmerge data sort total invocation time: " + this.getMergeSortTime() + "ms.");
            pw.println("\t\t\tmerge data sort avg invocation time: " + (this.getMergeSortCount() > 0L ? this.getMergeSortTime() / this.getMergeSortCount() : 0L) + "ms.");
            pw.println("\t\t\tmerge data partition invocation time: " + this.getMergePartitionTime());
            pw.println("\t\t\tmerge data copy invocation count: " + this.getMergeCopyCount());
            pw.println("\t\t\tmerge data copy total invocation time: " + this.getMergeCopyTime() + "ms.");
            pw.println("\t\t\tmerge data copy avg invocation time: " + (this.getMergeCopyCount() > 0L ? this.getMergeCopyTime() / this.getMergeCopyCount() : 0L) + "ms.");
            pw.println("\t\t\tmerge data move invocation count: " + this.getMergeMoveCount());
            pw.println("\t\t\tmerge data move total invocation time: " + this.getMergeMoveTime() + "ms.");
            pw.println("\t\t\tmerge data move avg invocation time: " + (this.getMergeMoveCount() > 0L ? this.getMergeMoveTime() / this.getMergeMoveCount() : 0L) + "ms.");
            pw.println("\t\toptimize() invocation count: " + this.getOptimizeCount());
            pw.println("\t\toptimize() total invocation time: " + this.getOptimizeTime() + "ms.");
            pw.println("\t\toptimize() avg invocation time: " + (this.getOptimizeCount() > 0L ? this.getOptimizeTime() / this.getOptimizeCount() : 0L) + "ms.");
            pw.println("\t\tbinarySearch() invocation count: " + this.getBinarySearchCount());
            pw.println("\t\tbinarySearch() total invocation time: " + this.getBinarySearchTime() + "ms.");
            pw.println("\t\tbinarySearch() avg invocation time: " + (this.getBinarySearchCount() > 0L ? this.getBinarySearchTime() / this.getBinarySearchCount() : 0L) + "ms.");
            pw.close();
            return sw.toString();
        }
    }
}

