/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.ILockManager;
import com.ibm.cognos.fpm.common.graph.ITransaction;
import com.ibm.cognos.fpm.common.graph.ITransactionManager;
import com.ibm.cognos.fpm.common.graph.IVersionedPropertyGraph;
import com.ibm.cognos.fpm.common.graph.TransactionDefinition;
import com.ibm.cognos.fpm.common.graph.TransactionStatus;

abstract class BaseTransaction<K>
implements ITransaction<K> {
    protected final TransactionDefinition transactionDefinition;
    protected final IVersionedPropertyGraph<K> masterGraph;
    protected final ITransactionManager<K> transactionManager;
    protected final ILockManager lockManager;
    protected TransactionStatus status;

    public BaseTransaction(TransactionDefinition definition, IVersionedPropertyGraph<K> masterGraph, ITransactionManager<K> transactionManager, ILockManager lockManager) {
        assert (definition != null);
        assert (masterGraph != null);
        assert (transactionManager != null);
        assert (lockManager != null);
        this.transactionDefinition = definition;
        this.masterGraph = masterGraph;
        this.transactionManager = transactionManager;
        this.lockManager = lockManager;
        this.status = TransactionStatus.UNKNOWN;
    }

    @Override
    public void success() {
        if (this.status == TransactionStatus.FAILURE) {
            throw new UnsupportedOperationException("Cannot change transaction status from FAILURE to SUCCESS");
        }
        this.status = TransactionStatus.SUCCESS;
    }

    @Override
    public void failure() {
        this.status = TransactionStatus.FAILURE;
    }

    @Override
    public void finish() {
        assert (this.transactionManager.getTransaction() == this);
        if (this.status == TransactionStatus.SUCCESS) {
            this.transactionManager.commit();
        } else {
            this.transactionManager.rollback();
        }
    }

    @Override
    public TransactionDefinition getTransactionDefinition() {
        return this.transactionDefinition;
    }
}

