/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class CartesianProduct<K>
implements Iterator<K[]>,
Iterable<K[]> {
    private final List<List<K>> nodesAsArray = new ArrayList<List<K>>();
    private final CartesianProductInternal internal;
    private final K[] current;

    public CartesianProduct(List<Collection<K>> collections) {
        int[] collectionLengths = new int[collections.size()];
        int offset = 0;
        for (Collection<K> collection : collections) {
            collectionLengths[offset++] = collection.size();
            this.nodesAsArray.add(new ArrayList<K>(collection));
        }
        this.current = (Object[])Array.newInstance(this.nodesAsArray.get(0).get(0).getClass(), collections.size());
        this.internal = new CartesianProductInternal(collectionLengths);
    }

    @Override
    public boolean hasNext() {
        return this.internal.hasNext();
    }

    @Override
    public K[] next() {
        int[] next = this.internal.next();
        int i = 0;
        while (i < next.length) {
            this.current[i] = this.nodesAsArray.get(i).get(next[i]);
            ++i;
        }
        return this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<K[]> iterator() {
        return this;
    }

    private final class CartesianProductInternal
    implements Iterator<int[]> {
        private final int[] lengths;
        private final int[] indices;
        private boolean hasNext = true;
        private final int[] current;

        public CartesianProductInternal(int[] lengths) {
            this.lengths = lengths;
            this.indices = new int[lengths.length];
            this.current = new int[lengths.length];
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public int[] next() {
            System.arraycopy(this.indices, 0, this.current, 0, this.indices.length);
            int i = this.indices.length - 1;
            while (i >= 0) {
                if (this.indices[i] == this.lengths[i] - 1) {
                    this.indices[i] = 0;
                    if (i == 0) {
                        this.hasNext = false;
                    }
                } else {
                    int n = i;
                    this.indices[n] = this.indices[n] + 1;
                    break;
                }
                --i;
            }
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

