/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.ConcurrentPropertyGraphTransactionManager;
import com.ibm.cognos.fpm.common.graph.EdgeFilter;
import com.ibm.cognos.fpm.common.graph.IAPIContext;
import com.ibm.cognos.fpm.common.graph.IConcurrentPropertyGraph;
import com.ibm.cognos.fpm.common.graph.IConcurrentPropertyGraphTransaction;
import com.ibm.cognos.fpm.common.graph.IConcurrentPropertyGraphTransactionManager;
import com.ibm.cognos.fpm.common.graph.IPropertyGraph;
import com.ibm.cognos.fpm.common.graph.NodeInfo;
import com.ibm.cognos.fpm.common.graph.PropertyGraphImpl;
import com.ibm.cognos.fpm.common.graph.PropertyGraphNodeFilter;
import com.ibm.cognos.fpm.common.graph.TransactionDefinition;
import com.ibm.cognos.fpm.common.graph.TransactionType;
import com.ibm.cognos.fpm.common.graph.TupleStoreConfiguration;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

public class ConcurrentPropertyGraph<K>
implements IConcurrentPropertyGraph<K> {
    static final boolean readAPIsMustUseTransactions = false;
    private final IPropertyGraph<K> wrappedMasterGraph;
    private final IConcurrentPropertyGraphTransactionManager<K> transactionManager;

    public ConcurrentPropertyGraph() {
        this.wrappedMasterGraph = new PropertyGraphImpl();
        this.transactionManager = new ConcurrentPropertyGraphTransactionManager<K>(this.wrappedMasterGraph);
    }

    public ConcurrentPropertyGraph(int capacity) {
        this.wrappedMasterGraph = new PropertyGraphImpl(capacity);
        this.transactionManager = new ConcurrentPropertyGraphTransactionManager<K>(this.wrappedMasterGraph);
    }

    @Override
    public void destroy() {
        IConcurrentPropertyGraphTransaction<K> transaction = this.transactionManager.getTransaction();
        if (transaction != null) {
            transaction.getTransactionGraph().destroy();
        }
        this.wrappedMasterGraph.destroy();
    }

    @Override
    public int getEdgeCount(IAPIContext<K> context) {
        return this.getGraph(AccessMode.READ).getEdgeCount();
    }

    @Override
    public int getNodeCount(IAPIContext<K> context) {
        return this.getGraph(AccessMode.READ).getNodeCount();
    }

    @Override
    public Collection<K> getNodeIds(IAPIContext<K> context) {
        return this.getGraph(AccessMode.READ).getNodeIds();
    }

    @Override
    public boolean optimize() {
        if (this.transactionManager.getTransaction() != null) {
            return false;
        }
        return this.wrappedMasterGraph.optimize();
    }

    @Override
    public void checkIntegrity() {
        if (this.transactionManager.getTransaction() != null) {
            return;
        }
        this.wrappedMasterGraph.checkIntegrity();
    }

    @Override
    public boolean optimize(K nodeId) {
        if (this.transactionManager.getTransaction() != null) {
            return false;
        }
        return this.wrappedMasterGraph.optimize(nodeId);
    }

    @Override
    public boolean addNode(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.WRITE).addNode(nodeId);
    }

    @Override
    public K removeNode(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.WRITE).removeNode(nodeId);
    }

    @Override
    public boolean containsNode(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.READ).containsNode(nodeId);
    }

    @Override
    public boolean containsNode(IAPIContext<K> context, K nodeId, PropertyGraphNodeFilter<K> filter) {
        return this.getGraph(AccessMode.READ).containsNode(nodeId, filter);
    }

    @Override
    public Collection<K> findNodes(IAPIContext<K> context, PropertyGraphNodeFilter<K> filter) {
        return this.getGraph(AccessMode.READ).findNodes(filter);
    }

    @Override
    public K getIncomingNode(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.READ).getIncomingNode(nodeId);
    }

    @Override
    public Collection<K> getIncomingNodes(IAPIContext<K> context, K nodeId, int hopCount) {
        return this.getGraph(AccessMode.READ).getIncomingNodes(nodeId, hopCount);
    }

    @Override
    public Collection<K> getIncomingNodes(IAPIContext<K> context, K nodeId, int hopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getGraph(AccessMode.READ).getIncomingNodes(nodeId, hopCount, nodeFilter, edgeFilter);
    }

    @Override
    public int getIncomingNodeCount(IAPIContext<K> context, K nodeId, int hopCount) {
        return this.getGraph(AccessMode.READ).getIncomingNodeCount(nodeId, hopCount);
    }

    @Override
    public int getIncomingNodeCount(IAPIContext<K> context, K nodeId, int hopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getGraph(AccessMode.READ).getIncomingNodeCount(nodeId, hopCount, nodeFilter, edgeFilter);
    }

    @Override
    public boolean isIncomingNode(IAPIContext<K> context, K potentialIncomingNodeId, K nodeId) {
        return this.getGraph(AccessMode.READ).isIncomingNode(potentialIncomingNodeId, nodeId);
    }

    @Override
    public Collection<K> getOutgoingNodes(IAPIContext<K> context, K nodeId, int hopCount) {
        return this.getGraph(AccessMode.READ).getOutgoingNodes(nodeId, hopCount);
    }

    @Override
    public Collection<K> getOutgoingNodes(IAPIContext<K> context, K nodeId, int hopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getGraph(AccessMode.READ).getOutgoingNodes(nodeId, hopCount, nodeFilter, edgeFilter);
    }

    @Override
    public boolean isOutgoingNode(IAPIContext<K> context, K potentialOutgoingNodeId, K nodeId) {
        return this.getGraph(AccessMode.READ).isOutgoingNode(potentialOutgoingNodeId, nodeId);
    }

    @Override
    public int getOutgoingNodeCount(IAPIContext<K> context, K nodeId, int hopCount) {
        return this.getGraph(AccessMode.READ).getOutgoingNodeCount(nodeId, hopCount);
    }

    @Override
    public int getOutgoingNodeCount(IAPIContext<K> context, K nodeKey, int hopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getGraph(AccessMode.READ).getOutgoingNodeCount(nodeKey, hopCount, nodeFilter, edgeFilter);
    }

    @Override
    public boolean hasOutgoingNodes(IAPIContext<K> context, K nodeKey, PropertyGraphNodeFilter<K> filter, EdgeFilter<K> edgeFilter) {
        return this.getGraph(AccessMode.READ).hasOutgoingNodes(nodeKey, filter, edgeFilter);
    }

    @Override
    public boolean hasIncomingNodes(IAPIContext<K> context, K nodeKey, PropertyGraphNodeFilter<K> filter, EdgeFilter<K> edgeFilter) {
        return this.getGraph(AccessMode.READ).hasIncomingNodes(nodeKey, filter, edgeFilter);
    }

    @Override
    public K removeNode(IAPIContext<K> context, K nodeId, boolean cascadeToOutgoingNodes) {
        return this.getGraph(AccessMode.WRITE).removeNode(nodeId);
    }

    @Override
    public boolean addEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.WRITE).addEdge(sourceNodeId, targetNodeId, label);
    }

    @Override
    public boolean removeEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.WRITE).removeEdge(sourceNodeId, targetNodeId, label);
    }

    @Override
    public boolean hasEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.READ).hasEdge(sourceNodeId, targetNodeId, label);
    }

    @Override
    public Collection<String> getEdgeLabels(IAPIContext<K> context, K sourceNodeId, K targetNodeId) {
        return this.getGraph(AccessMode.READ).getEdgeLabels(sourceNodeId, targetNodeId);
    }

    @Override
    public Object addEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName, Object propertyValue) {
        return this.getGraph(AccessMode.WRITE).addEdgeProperty(sourceNodeId, targetNodeId, label, propertyName, propertyValue);
    }

    @Override
    public Object getEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName) {
        return this.getGraph(AccessMode.READ).getEdgeProperty(sourceNodeId, targetNodeId, label, propertyName);
    }

    @Override
    public Map<String, Object> getEdgeProperties(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.READ).getEdgeProperties(sourceNodeId, targetNodeId, label);
    }

    @Override
    public Collection<String> getEdgePropertyNames(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.READ).getEdgePropertyNames(sourceNodeId, targetNodeId, label);
    }

    @Override
    public Object removeEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName) {
        return this.getGraph(AccessMode.WRITE).removeEdgeProperty(sourceNodeId, targetNodeId, label, propertyName);
    }

    @Override
    public boolean removeEdgeProperties(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.WRITE).removeEdgeProperties(sourceNodeId, targetNodeId, label);
    }

    @Override
    public boolean hasEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName) {
        return this.getGraph(AccessMode.READ).hasEdgeProperty(sourceNodeId, targetNodeId, label, propertyName);
    }

    @Override
    public Object removeNodeProperty(IAPIContext<K> context, K sourceId, String propertyName) {
        return this.getGraph(AccessMode.WRITE).removeNodeProperty(sourceId, propertyName);
    }

    @Override
    public boolean removeNodeProperties(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.WRITE).removeNodeProperties(nodeId);
    }

    @Override
    public boolean hasNodeProperty(IAPIContext<K> context, K nodeId, String propertyName) {
        return this.getGraph(AccessMode.READ).hasNodeProperty(nodeId, propertyName);
    }

    @Override
    public boolean hasNodeProperties(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.READ).hasNodeProperties(nodeId);
    }

    @Override
    public Object addNodeProperty(IAPIContext<K> context, K nodeId, String propertyName, Object propertyValue) {
        return this.getGraph(AccessMode.WRITE).addNodeProperty(nodeId, propertyName, propertyValue);
    }

    @Override
    public Object getNodeProperty(IAPIContext<K> context, K nodeId, String propertyName) {
        return this.getGraph(AccessMode.READ).getNodeProperty(nodeId, propertyName);
    }

    @Override
    public Map<String, Object> getNodeProperties(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.READ).getNodeProperties(nodeId);
    }

    @Override
    public Collection<String> getNodePropertyNames(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.READ).getNodePropertyNames(nodeId);
    }

    @Override
    public NodeInfo getNodeInfo(K nodeId, boolean throwExceptionOnNotFound) {
        return this.getGraph(AccessMode.READ).getNodeInfo(nodeId, throwExceptionOnNotFound);
    }

    @Override
    public NodeInfo getNodeInfo(int internalNodeId, boolean throwExceptionOnNotFound) {
        return this.getGraph(AccessMode.READ).getNodeInfo(internalNodeId, throwExceptionOnNotFound);
    }

    @Override
    public String toString(boolean detailed, Comparator<K> comparator) {
        return this.getGraph(AccessMode.READ).toString(detailed, comparator);
    }

    @Override
    public IConcurrentPropertyGraphTransaction<K> beginTransaction() {
        return this.transactionManager.beginTransaction(new TransactionDefinition(TransactionType.READ_WRITE));
    }

    @Override
    public IConcurrentPropertyGraphTransaction<K> beginTransaction(TransactionDefinition definition) {
        return this.transactionManager.beginTransaction(definition);
    }

    private IPropertyGraph<K> getGraph(AccessMode mode) {
        IConcurrentPropertyGraphTransaction<K> transaction = this.transactionManager.getTransaction();
        if (transaction == null) {
            if (mode != AccessMode.WRITE) {
                if (mode == AccessMode.READ) {
                    // empty if block
                }
            } else {
                throw new IllegalStateException("There is no active transaction");
            }
            return this.wrappedMasterGraph;
        }
        if (transaction.getTransactionDefinition().getTransactionType() == TransactionType.LOAD_GRAPH) {
            return this.wrappedMasterGraph;
        }
        return transaction.getTransactionGraph();
    }

    @Override
    public TupleStoreConfiguration getNodePropertyTupleStoreConfig() {
        return this.wrappedMasterGraph.getNodePropertyTupleStoreConfig();
    }

    @Override
    public TupleStoreConfiguration getAdjacentNodesTupleStoreConfig() {
        return this.wrappedMasterGraph.getAdjacentNodesTupleStoreConfig();
    }

    @Override
    public TupleStoreConfiguration getEdgePropertyTupleStoreConfig() {
        return this.wrappedMasterGraph.getEdgePropertyTupleStoreConfig();
    }

    private static enum AccessMode {
        READ,
        WRITE;

    }
}

