/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.IConcurrentPropertyGraphTransaction;
import com.ibm.cognos.fpm.common.graph.IConcurrentPropertyGraphTransactionManager;
import com.ibm.cognos.fpm.common.graph.ILockManager;
import com.ibm.cognos.fpm.common.graph.IPropertyGraph;
import com.ibm.cognos.fpm.common.graph.TransactionDefinition;
import com.ibm.cognos.fpm.common.graph.TransactionStatus;

public abstract class ConcurrentPropertyGraphBaseTransaction<K>
implements IConcurrentPropertyGraphTransaction<K> {
    protected final TransactionDefinition transactionDefinition;
    protected final IPropertyGraph<K> masterGraph;
    protected final IConcurrentPropertyGraphTransactionManager<K> transactionManager;
    protected final ILockManager lockManager;
    protected TransactionStatus status;

    public ConcurrentPropertyGraphBaseTransaction(TransactionDefinition definition, IPropertyGraph<K> masterGraph, IConcurrentPropertyGraphTransactionManager<K> transactionManager, ILockManager lockManager) {
        assert (definition != null);
        assert (masterGraph != null);
        assert (transactionManager != null);
        assert (lockManager != null);
        this.transactionDefinition = definition;
        this.masterGraph = masterGraph;
        this.transactionManager = transactionManager;
        this.lockManager = lockManager;
        this.status = TransactionStatus.UNKNOWN;
    }

    @Override
    public void success() {
        if (this.status == TransactionStatus.FAILURE) {
            throw new UnsupportedOperationException("Cannot change transaction status from FAILURE to SUCCESS");
        }
        this.status = TransactionStatus.SUCCESS;
    }

    @Override
    public void failure() {
        this.status = TransactionStatus.FAILURE;
    }

    @Override
    public void finish() {
        assert (this.transactionManager.getTransaction() == this);
        if (this.status == TransactionStatus.SUCCESS) {
            this.transactionManager.commit();
        } else {
            this.transactionManager.rollback();
        }
    }

    @Override
    public TransactionDefinition getTransactionDefinition() {
        return this.transactionDefinition;
    }

    @Override
    public abstract IPropertyGraph<K> getTransactionGraph();
}

