/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.EdgeFilter;
import com.ibm.cognos.fpm.common.graph.EmptyTupleStore;
import com.ibm.cognos.fpm.common.graph.IConcurrentPropertyGraphTransactionGraph;
import com.ibm.cognos.fpm.common.graph.ILockManager;
import com.ibm.cognos.fpm.common.graph.IPropertyGraph;
import com.ibm.cognos.fpm.common.graph.ITransaction;
import com.ibm.cognos.fpm.common.graph.InternalNodeKeyProxyCollection;
import com.ibm.cognos.fpm.common.graph.NodeInfo;
import com.ibm.cognos.fpm.common.graph.NodePropertyFilters;
import com.ibm.cognos.fpm.common.graph.PropertyGraphNodeFilter;
import com.ibm.cognos.fpm.common.graph.Tuple;
import com.ibm.cognos.fpm.common.graph.TupleElementIterator;
import com.ibm.cognos.fpm.common.graph.TupleStore;
import com.ibm.cognos.fpm.common.graph.TupleStoreConfiguration;
import com.ibm.cognos.fpm.common.graph.TupleStoreFactory;
import com.ibm.cognos.fpm.common.graph.TupleStoreStatisticsCollector;
import com.ibm.cognos.fpm.common.utility.KeyedHashSet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConcurrentPropertyGraphTransactionGraph<K>
extends AbstractCollection<K>
implements IConcurrentPropertyGraphTransactionGraph<K> {
    private static int EDGE_RELATED_NODE_KEY_TUPLE_POSITION = 0;
    private static int EDGE_LABEL_KEY_TUPLE_POSITION = 1;
    private static int EDGE_ACTION_KEY_TUPLE_POSITION = 2;
    private static int EDGE_KEY_TUPLE_POSITION = 3;
    private static int EDGE_PROPERTY_EDGE_KEY_TUPLE_POSITION = 0;
    private static int EDGE_PROPERTY_NAME_KEY_TUPLE_POSITION = 1;
    private static int EDGE_PROPERTY_ACTION_KEY_TUPLE_POSITION = 2;
    private static int EDGE_PROPERTY_VALUE_KEY_TUPLE_POSITION = 3;
    private static int NODE_PROPERTY_NODE_KEY_TUPLE_POSITION = 0;
    private static int NODE_PROPERTY_VALUE_KEY_TUPLE_POSITION = 1;
    private static int NODE_PROPERTY_ACTION_KEY_TUPLE_POSITION = 2;
    private final IPropertyGraph<K> masterGraph;
    private final ILockManager lockManager;
    static final int DEFAULT_INITIAL_CAPACITY = 500;
    protected Map<K, NodeInfo> nodeInfos;
    protected final List<K> nodeIds;
    protected final List<K> deletedNodeIds;
    private final TupleStoreStatisticsCollector tupleStoreStats;
    protected final KeyedHashSet<String> edgeLabels;
    protected final KeyedHashSet<String> edgePropertyNames;
    protected final KeyedHashSet<Object> edgePropertyValues;
    protected final KeyedHashSet<Object> nodePropertyValues;
    protected final TupleStoreConfiguration nodePropertyTupleStoreConfig;
    protected final TupleStoreConfiguration adjacentNodesTupleStoreConfig;
    protected final TupleStoreConfiguration edgePropertyTupleStoreConfig;
    private final boolean collectTupleStoreStatistics = false;
    static final TupleStore EMPTY_TUPLE_STORE = new EmptyTupleStore();
    protected final Map<String, TupleStore> nodePropertyTupleStores;

    public TupleStoreStatisticsCollector getTupleStoreStats() {
        return this.tupleStoreStats;
    }

    public ConcurrentPropertyGraphTransactionGraph(IPropertyGraph<K> masterGraph, ILockManager lockManager) {
        this(masterGraph, lockManager, 500);
    }

    public ConcurrentPropertyGraphTransactionGraph(IPropertyGraph<K> masterGraph, ILockManager lockManager, int capacity) {
        this(masterGraph, lockManager, capacity, 3, 4, 4);
    }

    public ConcurrentPropertyGraphTransactionGraph(IPropertyGraph<K> masterGraph, ILockManager lockManager, int capacity, int nodePropertyTupleSize, int adjacentNodesTupleSize, int edgePropertyTupleSize) {
        this.masterGraph = masterGraph;
        this.lockManager = lockManager;
        this.nodeInfos = new HashMap<K, NodeInfo>(capacity, 0.9f);
        this.nodeIds = new ArrayList<K>(capacity);
        this.nodeIds.add(null);
        this.deletedNodeIds = new ArrayList<K>(capacity);
        this.edgeLabels = new KeyedHashSet(capacity);
        this.edgePropertyNames = new KeyedHashSet(capacity);
        this.edgePropertyValues = new KeyedHashSet(capacity);
        this.nodePropertyValues = new KeyedHashSet(capacity);
        this.nodePropertyTupleStores = new HashMap<String, TupleStore>(500, 0.9f);
        this.tupleStoreStats = null;
        this.nodePropertyTupleStoreConfig = TupleStoreFactory.getInstance().createConfiguration(nodePropertyTupleSize, this.tupleStoreStats);
        this.adjacentNodesTupleStoreConfig = TupleStoreFactory.getInstance().createConfiguration(adjacentNodesTupleSize, 1250, 5, this.tupleStoreStats);
        this.edgePropertyTupleStoreConfig = TupleStoreFactory.getInstance().createConfiguration(edgePropertyTupleSize, 1250, 5, this.tupleStoreStats);
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean hasChanges() {
        return !this.nodeInfos.isEmpty() || !this.deletedNodeIds.isEmpty();
    }

    @Override
    public void commit() {
        try {
            this.lockManager.acquireCommitLock();
            for (K k : this.nodeIds) {
                if (k == null || this.masterGraph.containsNode(k)) continue;
                this.masterGraph.addNode(k);
            }
            for (Map.Entry entry : this.nodeInfos.entrySet()) {
                Object nodeId = entry.getKey();
                NodeInfo nodeInfo = (NodeInfo)entry.getValue();
                for (Tuple edgeTuple : nodeInfo.getAdjacentNodesTupleStore()) {
                    Object sourceNodeId = null;
                    Object targetNodeId = null;
                    int relatedNodeKey = edgeTuple.getElement(EDGE_RELATED_NODE_KEY_TUPLE_POSITION);
                    if (relatedNodeKey >= 0) continue;
                    sourceNodeId = this.nodeIds.get(Math.abs(relatedNodeKey));
                    targetNodeId = nodeId;
                    String edgeLabel = this.edgeLabels.get(edgeTuple.getElement(EDGE_LABEL_KEY_TUPLE_POSITION));
                    int action = edgeTuple.getElement(EDGE_ACTION_KEY_TUPLE_POSITION);
                    if (action == Action.Set.getKey()) {
                        this.masterGraph.addEdge(sourceNodeId, targetNodeId, edgeLabel);
                        continue;
                    }
                    assert (action == Action.Delete.getKey());
                    if (!this.masterGraph.hasEdge(sourceNodeId, targetNodeId, edgeLabel)) continue;
                    this.masterGraph.removeEdge(sourceNodeId, targetNodeId, edgeLabel);
                }
            }
            for (Map.Entry entry : this.nodePropertyTupleStores.entrySet()) {
                String propertyName = (String)entry.getKey();
                for (Tuple nodePropertyTuple : (TupleStore)entry.getValue()) {
                    K nodeId = this.getNodeId(nodePropertyTuple.getElement(NODE_PROPERTY_NODE_KEY_TUPLE_POSITION));
                    if (!this.masterGraph.containsNode(nodeId)) continue;
                    int action = nodePropertyTuple.getElement(NODE_PROPERTY_ACTION_KEY_TUPLE_POSITION);
                    if (action == Action.Set.getKey()) {
                        Object propertyValue = this.nodePropertyValues.get(nodePropertyTuple.getElement(NODE_PROPERTY_VALUE_KEY_TUPLE_POSITION));
                        this.masterGraph.addNodeProperty(nodeId, propertyName, propertyValue);
                        continue;
                    }
                    assert (action == Action.Delete.getKey());
                    this.masterGraph.removeNodeProperty(nodeId, propertyName);
                }
            }
            for (Object object : this.deletedNodeIds) {
                if (!this.masterGraph.containsNode(object)) continue;
                this.masterGraph.removeNode(object);
            }
        }
        finally {
            this.lockManager.releaseCommitLock();
        }
    }

    @Override
    public int getEdgeCount() {
        try {
            this.lockManager.acquireReadLock();
            int edgeCount = this.masterGraph.getEdgeCount();
            block3: for (NodeInfo nodeInfo : this.nodeInfos.values()) {
                for (Tuple tuple : nodeInfo.getAdjacentNodesTupleStore()) {
                    if (tuple.getElement(EDGE_RELATED_NODE_KEY_TUPLE_POSITION) >= 0) continue block3;
                    edgeCount += tuple.getElement(EDGE_ACTION_KEY_TUPLE_POSITION) == Action.Set.getKey() ? 1 : -1;
                }
            }
            block5: for (Object nodeId : this.deletedNodeIds) {
                NodeInfo nodeInfo = this.masterGraph.getNodeInfo(nodeId, false);
                if (nodeInfo == null) continue;
                for (Tuple tuple : nodeInfo.getAdjacentNodesTupleStore()) {
                    if (tuple.getElement(0) >= 0) continue block5;
                    --edgeCount;
                }
            }
            int n = edgeCount;
            return n;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public int getNodeCount() {
        try {
            this.lockManager.acquireReadLock();
            int nodeCount = this.masterGraph.getNodeCount();
            for (K nodeId : this.nodeIds) {
                if (this.masterGraph.containsNode(nodeId)) continue;
                ++nodeCount;
            }
            for (K nodeId : this.deletedNodeIds) {
                if (!this.masterGraph.containsNode(nodeId)) continue;
                --nodeCount;
            }
            int n = nodeCount;
            return n;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Collection<K> getNodeIds() {
        ArrayList<K> nodeIds = null;
        try {
            this.lockManager.acquireReadLock();
            nodeIds = new ArrayList<K>(this.masterGraph.getNodeIds());
        }
        finally {
            this.lockManager.releaseReadLock();
        }
        nodeIds.addAll(this.nodeIds);
        nodeIds.removeAll(this.deletedNodeIds);
        return nodeIds;
    }

    @Override
    public boolean optimize() {
        boolean modified = false;
        for (K nodeId : this.nodeIds) {
            if (nodeId == null || !this.optimize(nodeId)) continue;
            modified = true;
        }
        for (TupleStore nodePropertyTupleStore : this.nodePropertyTupleStores.values()) {
            if (!nodePropertyTupleStore.optimize()) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public NodeInfo getNodeInfo(K nodeId, boolean throwExceptionOnNotFound) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public NodeInfo getNodeInfo(int internalNodeId, boolean throwExceptionOnNotFound) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void checkIntegrity() {
    }

    @Override
    public boolean optimize(K nodeId) {
        boolean modified = false;
        NodeInfo nodeInfo = this.nodeInfos.get(nodeId);
        if (nodeInfo != null) {
            modified = nodeInfo.optimize();
        }
        return modified;
    }

    @Override
    public boolean addNode(K nodeId) {
        if (this.deletedNodeIds.contains(nodeId)) {
            throw new UnsupportedOperationException("Re-adding a deleted node is not supported yet");
        }
        if (this.nodeInfos.containsKey(nodeId)) {
            return false;
        }
        NodeInfo nodeInfo = new NodeInfo(this.nodeIds.size());
        this.nodeInfos.put(nodeId, nodeInfo);
        this.nodeIds.add(nodeId);
        return true;
    }

    @Override
    public K removeNode(K nodeId) {
        if (!this.containsNode(nodeId)) {
            return null;
        }
        if (!this.nodeInfos.containsKey(nodeId)) {
            this.deletedNodeIds.add(nodeId);
            return nodeId;
        }
        NodeInfo nodeInfo = this.nodeInfos.remove(nodeId);
        this.removeNodeProperties(nodeId);
        for (Tuple tuple : nodeInfo.getAdjacentNodesTupleStore()) {
            boolean isIncoming;
            int adjacentNodeKey = tuple.getElement(EDGE_RELATED_NODE_KEY_TUPLE_POSITION);
            boolean bl = isIncoming = adjacentNodeKey < 0;
            if (isIncoming) {
                adjacentNodeKey = Math.abs(adjacentNodeKey);
            }
            K adjacentNodeId = this.nodeIds.get(adjacentNodeKey);
            assert (adjacentNodeId != null);
            NodeInfo adjacentNodeInfo = this.nodeInfos.get(adjacentNodeId);
            TupleStore childTupleStoreToUpdate = adjacentNodeInfo.getAdjacentNodesTupleStore(false, this.adjacentNodesTupleStoreConfig);
            if (childTupleStoreToUpdate == null) {
                throw new IllegalStateException("The parent and child adjacency lists are out of synch.");
            }
            Tuple edgeTuple = childTupleStoreToUpdate.getTuple(isIncoming ? nodeInfo.getInternalNodeId() : -1 * nodeInfo.getInternalNodeId(), tuple.getElement(EDGE_LABEL_KEY_TUPLE_POSITION));
            boolean removed = childTupleStoreToUpdate.removeTuple(edgeTuple);
            if (!removed || edgeTuple == null) {
                throw new IllegalStateException("The parent and child adjacency lists are out of synch.");
            }
            adjacentNodeInfo.getEdgePropertyTupleStore(false, this.edgePropertyTupleStoreConfig).removeTuple(edgeTuple.getElement(EDGE_KEY_TUPLE_POSITION));
        }
        this.nodeIds.set(nodeInfo.getInternalNodeId(), null);
        this.deletedNodeIds.add(nodeId);
        return nodeId;
    }

    @Override
    public boolean containsNode(K nodeId) {
        try {
            this.lockManager.acquireReadLock();
            boolean bl = !this.deletedNodeIds.contains(nodeId) && (this.nodeInfos.containsKey(nodeId) || this.masterGraph.containsNode(nodeId));
            return bl;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public boolean containsNode(K nodeId, PropertyGraphNodeFilter<K> filter) {
        try {
            this.lockManager.acquireReadLock();
            if (!this.deletedNodeIds.contains(nodeId) && (this.nodeInfos.containsKey(nodeId) || this.masterGraph.containsNode(nodeId))) {
                boolean bl = !this.filterNodes(Collections.singletonList(nodeId), filter).isEmpty();
                return bl;
            }
        }
        finally {
            this.lockManager.releaseReadLock();
        }
        return false;
    }

    @Override
    public K getIncomingNode(K nodeId) {
        TupleStore adjacentNodesTupleStore;
        NodeInfo nodeInfo;
        ArrayList<K> incomingNodesIds;
        block10: {
            if (this.deletedNodeIds.contains(nodeId)) {
                throw new IllegalArgumentException("The node with key '" + nodeId + "' doesn't exist in the graph.");
            }
            incomingNodesIds = new ArrayList<K>();
            try {
                this.lockManager.acquireReadLock();
                nodeInfo = this.masterGraph.getNodeInfo(nodeId, false);
                if (nodeInfo == null || (adjacentNodesTupleStore = nodeInfo.getAdjacentNodesTupleStore()).isEmpty()) break block10;
                TupleElementIterator adjacentNodeKeyIterator = adjacentNodesTupleStore.getTupleElementIterator(0);
                while (adjacentNodeKeyIterator.hasNext()) {
                    int relatedNodeKey = adjacentNodeKeyIterator.next();
                    if (relatedNodeKey > 0) {
                        break;
                    }
                    relatedNodeKey = Math.abs(relatedNodeKey);
                    incomingNodesIds.add(this.masterGraph.getNodeId(relatedNodeKey));
                }
            }
            finally {
                this.lockManager.releaseReadLock();
            }
        }
        if ((nodeInfo = this.nodeInfos.get(nodeId)) != null && !(adjacentNodesTupleStore = nodeInfo.getAdjacentNodesTupleStore()).isEmpty()) {
            for (Tuple adjacentNodeTuple : adjacentNodesTupleStore) {
                int relatedNodeKey = adjacentNodeTuple.getElement(EDGE_RELATED_NODE_KEY_TUPLE_POSITION);
                if (relatedNodeKey > 0) break;
                relatedNodeKey = Math.abs(relatedNodeKey);
                if (adjacentNodeTuple.getElement(EDGE_ACTION_KEY_TUPLE_POSITION) == Action.Set.getKey()) {
                    incomingNodesIds.add(this.nodeIds.get(relatedNodeKey));
                    continue;
                }
                incomingNodesIds.remove(this.nodeIds.get(relatedNodeKey));
            }
        }
        if (incomingNodesIds.size() > 1) {
            throw new UnsupportedOperationException("The node with key '" + nodeId + "' has multiple incoming nodes.");
        }
        return !incomingNodesIds.isEmpty() ? (K)incomingNodesIds.get(0) : null;
    }

    @Override
    public Collection<K> getIncomingNodes(K nodeId, int hopCount) {
        return this.getIncomingNodes(nodeId, hopCount, null, null);
    }

    @Override
    public Collection<K> getIncomingNodes(K nodeId, int hopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        if (hopCount > 1) {
            throw new UnsupportedOperationException("Do not support multi-hop yet.");
        }
        if (this.deletedNodeIds.contains(nodeId)) {
            throw new IllegalArgumentException("The node with key '" + nodeId + "' doesn't exist in the graph.");
        }
        Collection incomingNodes = null;
        try {
            this.lockManager.acquireReadLock();
            incomingNodes = this.masterGraph.containsNode(nodeId) ? this.masterGraph.getIncomingNodes(nodeId, hopCount, nodeFilter, edgeFilter) : Collections.emptySet();
        }
        finally {
            this.lockManager.releaseReadLock();
        }
        NodeInfo nodeInfo = this.nodeInfos.get(nodeId);
        if (nodeInfo != null) {
            Iterator<Object> it;
            incomingNodes = new HashSet(incomingNodes);
            TupleStore tupleStore = nodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig);
            if (edgeFilter != null && !edgeFilter.getEdgeLabelsToFilterOn().isEmpty()) {
                int[] edgeLabelIds = new int[edgeFilter.getEdgeLabelsToFilterOn().size()];
                int i = 0;
                for (String edgeLabel : edgeFilter.getEdgeLabelsToFilterOn()) {
                    edgeLabelIds[i] = this.edgeLabels.getKey(edgeLabel);
                    ++i;
                }
                it = tupleStore.getFilteredIterator(EDGE_LABEL_KEY_TUPLE_POSITION, edgeLabelIds);
            } else {
                it = tupleStore.iterator();
            }
            while (it.hasNext()) {
                Tuple tuple = (Tuple)it.next();
                int adjacentNodeKey = tuple.getElement(EDGE_RELATED_NODE_KEY_TUPLE_POSITION);
                if (adjacentNodeKey > 0) break;
                K adjacentNodeId = this.nodeIds.get(Math.abs(adjacentNodeKey));
                int action = tuple.getElement(EDGE_ACTION_KEY_TUPLE_POSITION);
                if (action == Action.Set.getKey()) {
                    boolean passesEdgeFilter = true;
                    if (edgeFilter != null && edgeFilter.callEvaluate()) {
                        String edgeLabel = this.edgeLabels.get(tuple.getElement(1));
                        passesEdgeFilter = edgeFilter.evaluate(adjacentNodeId, nodeId, edgeLabel);
                    }
                    if (!passesEdgeFilter) continue;
                    incomingNodes.add(adjacentNodeId);
                    continue;
                }
                assert (action == Action.Delete.getKey());
                incomingNodes.remove(adjacentNodeId);
            }
        }
        if (nodeFilter != null) {
            incomingNodes = this.filterNodes(incomingNodes, nodeFilter);
        }
        return incomingNodes != null ? Collections.unmodifiableCollection(incomingNodes) : Collections.emptySet();
    }

    @Override
    public int getIncomingNodeCount(K nodeId, int hopCount) {
        return this.getIncomingNodes(nodeId, hopCount).size();
    }

    @Override
    public int getIncomingNodeCount(K nodeId, int hopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getIncomingNodes(nodeId, hopCount, nodeFilter, edgeFilter).size();
    }

    @Override
    public boolean isIncomingNode(K potentialIncomingNodeId, K nodeId) {
        Set incomingEdgeLabels = null;
        try {
            this.lockManager.acquireReadLock();
            incomingEdgeLabels = this.masterGraph.containsNode(nodeId) ? this.masterGraph.getEdgeLabels(potentialIncomingNodeId, nodeId) : Collections.emptySet();
        }
        finally {
            this.lockManager.releaseReadLock();
        }
        NodeInfo nodeInfo = this.nodeInfos.get(nodeId);
        NodeInfo potentialIncomingNodeInfo = this.nodeInfos.get(potentialIncomingNodeId);
        if (nodeInfo != null && potentialIncomingNodeInfo != null) {
            incomingEdgeLabels = new HashSet(incomingEdgeLabels);
            TupleStore tupleStore = nodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig);
            Iterator<Tuple> it = tupleStore.getFilteredIterator(EDGE_RELATED_NODE_KEY_TUPLE_POSITION, -1 * potentialIncomingNodeInfo.getInternalNodeId());
            while (it.hasNext()) {
                Tuple tuple = it.next();
                int action = tuple.getElement(EDGE_ACTION_KEY_TUPLE_POSITION);
                if (action == Action.Set.getKey()) {
                    incomingEdgeLabels.add(this.edgeLabels.get(tuple.getElement(EDGE_LABEL_KEY_TUPLE_POSITION)));
                    continue;
                }
                assert (action == Action.Delete.getKey());
                incomingEdgeLabels.remove(this.edgeLabels.get(tuple.getElement(EDGE_LABEL_KEY_TUPLE_POSITION)));
            }
        }
        return !incomingEdgeLabels.isEmpty();
    }

    @Override
    public Collection<K> getOutgoingNodes(K nodeId, int hopCount) {
        return this.getOutgoingNodes(nodeId, hopCount, null, null);
    }

    @Override
    public Collection<K> getOutgoingNodes(K nodeId, int hopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        if (hopCount > 1) {
            throw new UnsupportedOperationException("Do not support multi-hop yet.");
        }
        if (this.deletedNodeIds.contains(nodeId)) {
            throw new IllegalArgumentException("The node with key '" + nodeId + "' doesn't exist in the graph.");
        }
        Collection outgoingNodes = null;
        try {
            this.lockManager.acquireReadLock();
            outgoingNodes = this.masterGraph.containsNode(nodeId) ? this.masterGraph.getOutgoingNodes(nodeId, hopCount, nodeFilter, edgeFilter) : Collections.emptySet();
        }
        finally {
            this.lockManager.releaseReadLock();
        }
        NodeInfo nodeInfo = this.nodeInfos.get(nodeId);
        if (nodeInfo != null) {
            Iterator<Object> it;
            outgoingNodes = new HashSet(outgoingNodes);
            TupleStore tupleStore = nodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig);
            if (edgeFilter != null && !edgeFilter.getEdgeLabelsToFilterOn().isEmpty()) {
                int[] edgeLabelIds = new int[edgeFilter.getEdgeLabelsToFilterOn().size()];
                int i = 0;
                for (String edgeLabel : edgeFilter.getEdgeLabelsToFilterOn()) {
                    edgeLabelIds[i] = this.edgeLabels.getKey(edgeLabel);
                    ++i;
                }
                it = tupleStore.getFilteredIterator(EDGE_LABEL_KEY_TUPLE_POSITION, edgeLabelIds);
            } else {
                it = tupleStore.iterator();
            }
            while (it.hasNext()) {
                Tuple tuple = (Tuple)it.next();
                int adjacentNodeKey = tuple.getElement(EDGE_RELATED_NODE_KEY_TUPLE_POSITION);
                if (adjacentNodeKey < 0) continue;
                K adjacentNodeId = this.nodeIds.get(Math.abs(adjacentNodeKey));
                int action = tuple.getElement(EDGE_ACTION_KEY_TUPLE_POSITION);
                if (action == Action.Set.getKey()) {
                    boolean passesEdgeFilter = true;
                    if (edgeFilter != null && edgeFilter.callEvaluate()) {
                        String edgeLabel = this.edgeLabels.get(tuple.getElement(1));
                        passesEdgeFilter = edgeFilter.evaluate(adjacentNodeId, nodeId, edgeLabel);
                    }
                    if (!passesEdgeFilter) continue;
                    outgoingNodes.add(adjacentNodeId);
                    continue;
                }
                assert (action == Action.Delete.getKey());
                outgoingNodes.remove(adjacentNodeId);
            }
        }
        if (nodeFilter != null) {
            outgoingNodes = this.filterNodes(outgoingNodes, nodeFilter);
        }
        return outgoingNodes != null ? Collections.unmodifiableCollection(outgoingNodes) : Collections.emptySet();
    }

    @Override
    public boolean isOutgoingNode(K potentialOutgoingNodeId, K nodeId) {
        Set outgoingEdgeLabels = null;
        try {
            this.lockManager.acquireReadLock();
            outgoingEdgeLabels = this.masterGraph.containsNode(nodeId) ? this.masterGraph.getEdgeLabels(nodeId, potentialOutgoingNodeId) : Collections.emptySet();
        }
        finally {
            this.lockManager.releaseReadLock();
        }
        NodeInfo nodeInfo = this.nodeInfos.get(nodeId);
        NodeInfo potentialOutgoingNodeInfo = this.nodeInfos.get(potentialOutgoingNodeId);
        if (nodeInfo != null && potentialOutgoingNodeInfo != null) {
            outgoingEdgeLabels = new HashSet(outgoingEdgeLabels);
            TupleStore tupleStore = nodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig);
            Iterator<Tuple> it = tupleStore.getFilteredIterator(EDGE_RELATED_NODE_KEY_TUPLE_POSITION, potentialOutgoingNodeInfo.getInternalNodeId());
            while (it.hasNext()) {
                Tuple tuple = it.next();
                int action = tuple.getElement(EDGE_ACTION_KEY_TUPLE_POSITION);
                if (action == Action.Set.getKey()) {
                    outgoingEdgeLabels.add(this.edgeLabels.get(tuple.getElement(EDGE_LABEL_KEY_TUPLE_POSITION)));
                    continue;
                }
                assert (action == Action.Delete.getKey());
                outgoingEdgeLabels.remove(this.edgeLabels.get(tuple.getElement(EDGE_LABEL_KEY_TUPLE_POSITION)));
            }
        }
        return !outgoingEdgeLabels.isEmpty();
    }

    @Override
    public int getOutgoingNodeCount(K nodeId, int hopCount) {
        return this.getOutgoingNodes(nodeId, hopCount).size();
    }

    @Override
    public int getOutgoingNodeCount(K nodeId, int hopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getOutgoingNodes(nodeId, hopCount, nodeFilter, edgeFilter).size();
    }

    @Override
    public boolean hasOutgoingNodes(K nodeId, PropertyGraphNodeFilter<K> filter, EdgeFilter<K> edgeFilter) {
        return !this.getOutgoingNodes(nodeId, 1, filter, edgeFilter).isEmpty();
    }

    @Override
    public boolean hasIncomingNodes(K nodeId, PropertyGraphNodeFilter<K> filter, EdgeFilter<K> edgeFilter) {
        return !this.getIncomingNodes(nodeId, 1, filter, edgeFilter).isEmpty();
    }

    @Override
    public K removeNode(K nodeId, boolean cascadeToOutgoingNodes) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean addEdge(K sourceNodeId, K targetNodeId, String label) {
        try {
            this.lockManager.acquireReadLock();
            if (this.masterGraph.containsNode(sourceNodeId) && this.masterGraph.containsNode(targetNodeId) && this.masterGraph.hasEdge(sourceNodeId, targetNodeId, label)) {
                return false;
            }
        }
        finally {
            this.lockManager.releaseReadLock();
        }
        int internalLabelKey = this.edgeLabels.getKey(label);
        if (internalLabelKey == -1) {
            internalLabelKey = this.edgeLabels.addAndReturnKey(label);
        }
        return this.addEdge(sourceNodeId, targetNodeId, internalLabelKey);
    }

    private boolean addEdge(K sourceNodeId, K targetNodeId, int internalLabelKey) {
        this.addNode(sourceNodeId);
        this.addNode(targetNodeId);
        NodeInfo sourceNodeInfo = this.nodeInfos.get(sourceNodeId);
        NodeInfo targetNodeInfo = this.nodeInfos.get(targetNodeId);
        Tuple existingEdgeTuple = this.getEdgeTuple(sourceNodeInfo, targetNodeInfo, internalLabelKey);
        if (existingEdgeTuple != null) {
            if (existingEdgeTuple.getElement(EDGE_ACTION_KEY_TUPLE_POSITION) == Action.Delete.getKey()) {
                throw new UnsupportedOperationException("Re-adding a deleted edge is not supported yet");
            }
            return false;
        }
        boolean addedToOutgoing = sourceNodeInfo.getAdjacentNodesTupleStore(false, this.adjacentNodesTupleStoreConfig).addTuple(targetNodeInfo.getInternalNodeId(), internalLabelKey, Action.Set.getKey(), sourceNodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig).size());
        boolean addedToIncoming = targetNodeInfo.getAdjacentNodesTupleStore(false, this.adjacentNodesTupleStoreConfig).addTuple(-1 * sourceNodeInfo.getInternalNodeId(), internalLabelKey, Action.Set.getKey(), targetNodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig).size());
        if (addedToOutgoing != addedToIncoming) {
            throw new IllegalStateException("The outgoing and incoming node adjacency lists are out of synch.");
        }
        return addedToOutgoing;
    }

    private Tuple getEdgeTuple(NodeInfo sourceNodeInfo, NodeInfo targetNodeInfo, int edgeLabelKey) {
        if (sourceNodeInfo.getAdjacentNodesTupleStore().size() < targetNodeInfo.getAdjacentNodesTupleStore().size()) {
            return sourceNodeInfo.getAdjacentNodesTupleStore().getTuple(targetNodeInfo.getInternalNodeId(), edgeLabelKey);
        }
        return targetNodeInfo.getAdjacentNodesTupleStore().getTuple(-1 * sourceNodeInfo.getInternalNodeId(), edgeLabelKey);
    }

    @Override
    public boolean removeEdge(K sourceNodeId, K targetNodeId, String label) {
        if (!this.hasEdge(sourceNodeId, targetNodeId, label)) {
            return false;
        }
        int internalLabelKey = this.edgeLabels.getKey(label);
        if (internalLabelKey == -1) {
            internalLabelKey = this.edgeLabels.addAndReturnKey(label);
        }
        return this.removeEdge(sourceNodeId, targetNodeId, internalLabelKey);
    }

    private boolean removeEdge(K sourceNodeId, K targetNodeId, int internalLabelKey) {
        this.addNode(sourceNodeId);
        this.addNode(targetNodeId);
        NodeInfo sourceNodeInfo = this.nodeInfos.get(sourceNodeId);
        NodeInfo targetNodeInfo = this.nodeInfos.get(targetNodeId);
        Tuple existingEdgeTuple = this.getEdgeTuple(sourceNodeInfo, targetNodeInfo, internalLabelKey);
        if (existingEdgeTuple != null) {
            if (existingEdgeTuple.getElement(EDGE_ACTION_KEY_TUPLE_POSITION) == Action.Set.getKey()) {
                throw new UnsupportedOperationException("Removing an added edge is not supported yet");
            }
            return false;
        }
        boolean addedToOutgoing = sourceNodeInfo.getAdjacentNodesTupleStore(false, this.adjacentNodesTupleStoreConfig).addTuple(targetNodeInfo.getInternalNodeId(), internalLabelKey, Action.Delete.getKey(), sourceNodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig).size());
        boolean addedToIncoming = targetNodeInfo.getAdjacentNodesTupleStore(false, this.adjacentNodesTupleStoreConfig).addTuple(-1 * sourceNodeInfo.getInternalNodeId(), internalLabelKey, Action.Delete.getKey(), targetNodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig).size());
        if (addedToOutgoing != addedToIncoming) {
            throw new IllegalStateException("The outgoing and incoming node adjacency lists are out of synch.");
        }
        return addedToOutgoing;
    }

    @Override
    public boolean hasEdge(K sourceNodeId, K targetNodeId, String label) {
        boolean hasEdge = false;
        try {
            this.lockManager.acquireReadLock();
            hasEdge = this.masterGraph.containsNode(sourceNodeId) && this.masterGraph.containsNode(targetNodeId) ? this.masterGraph.hasEdge(sourceNodeId, targetNodeId, label) : false;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
        int internalLabelKey = this.edgeLabels.getKey(label);
        if (internalLabelKey != -1) {
            Tuple existingEdgeTuple;
            NodeInfo sourceNodeInfo = this.nodeInfos.get(sourceNodeId);
            NodeInfo targetNodeInfo = this.nodeInfos.get(targetNodeId);
            if (sourceNodeInfo != null && targetNodeInfo != null && (existingEdgeTuple = this.getEdgeTuple(sourceNodeInfo, targetNodeInfo, internalLabelKey)) != null) {
                int action = existingEdgeTuple.getElement(EDGE_ACTION_KEY_TUPLE_POSITION);
                if (action == Action.Set.getKey()) {
                    hasEdge = true;
                } else {
                    assert (action == Action.Delete.getKey());
                    hasEdge = false;
                }
            }
        }
        return hasEdge;
    }

    @Override
    public Collection<String> getEdgeLabels(K sourceNodeId, K targetNodeId) {
        Set<String> edgeLabels = null;
        try {
            this.lockManager.acquireReadLock();
            edgeLabels = this.masterGraph.containsNode(sourceNodeId) && this.masterGraph.containsNode(targetNodeId) ? this.masterGraph.getEdgeLabels(sourceNodeId, targetNodeId) : Collections.emptySet();
        }
        finally {
            this.lockManager.releaseReadLock();
        }
        NodeInfo sourceNodeInfo = this.nodeInfos.get(sourceNodeId);
        NodeInfo targetNodeInfo = this.nodeInfos.get(targetNodeId);
        if (sourceNodeInfo != null && targetNodeInfo != null) {
            edgeLabels = new HashSet<String>(edgeLabels);
            TupleStore tupleStore = sourceNodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig);
            Iterator<Tuple> it = tupleStore.getFilteredIterator(EDGE_RELATED_NODE_KEY_TUPLE_POSITION, targetNodeInfo.getInternalNodeId());
            while (it.hasNext()) {
                Tuple tuple = it.next();
                int action = tuple.getElement(EDGE_ACTION_KEY_TUPLE_POSITION);
                String edgeLabel = this.edgeLabels.get(tuple.getElement(EDGE_LABEL_KEY_TUPLE_POSITION));
                if (action == Action.Set.getKey()) {
                    edgeLabels.add(edgeLabel);
                    continue;
                }
                assert (action == Action.Delete.getKey());
                edgeLabels.remove(edgeLabel);
            }
        }
        return edgeLabels;
    }

    @Override
    public Object addEdgeProperty(K sourceNode, K targetNode, String label, String propertyName, Object propertyValue) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Object getEdgeProperty(K sourceNodeId, K targetNodeId, String label, String propertyName) {
        Object edgeProperty = null;
        try {
            this.lockManager.acquireReadLock();
            edgeProperty = this.masterGraph.containsNode(sourceNodeId) && this.masterGraph.containsNode(targetNodeId) ? this.masterGraph.getEdgeProperty(sourceNodeId, targetNodeId, label, propertyName) : null;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
        int internalLabelKey = this.edgeLabels.getKey(label);
        int edgePropertyNameIndex = this.edgePropertyNames.getKey(propertyName);
        if (internalLabelKey == -1 || edgePropertyNameIndex == -1) {
            return edgeProperty;
        }
        NodeInfo sourceNodeInfo = this.nodeInfos.get(sourceNodeId);
        NodeInfo targetNodeInfo = this.nodeInfos.get(targetNodeId);
        if (sourceNodeInfo == null || targetNodeInfo == null) {
            return edgeProperty;
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getAdjacentNodesTupleStore().getTuple(targetNodeInfo.getInternalNodeId(), internalLabelKey);
        if (outgoingEdgeTuple != null) {
            List<Tuple> outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(EDGE_KEY_TUPLE_POSITION), edgePropertyNameIndex);
            if (outgoingEdgePropertyTuples.size() > 1) {
                throw new IllegalStateException("Multiple edge property value identifiers are mapped to the same edge.");
            }
            if (!outgoingEdgePropertyTuples.isEmpty()) {
                Tuple edgePropertyTuple = outgoingEdgePropertyTuples.get(0);
                int action = edgePropertyTuple.getElement(EDGE_PROPERTY_ACTION_KEY_TUPLE_POSITION);
                if (action == Action.Set.getKey()) {
                    edgeProperty = this.edgePropertyValues.get(edgePropertyTuple.getElement(EDGE_PROPERTY_VALUE_KEY_TUPLE_POSITION));
                } else {
                    assert (action == Action.Delete.getKey());
                    edgeProperty = null;
                }
            }
        }
        return edgeProperty;
    }

    @Override
    public Map<String, Object> getEdgeProperties(K sourceNodeId, K targetNodeId, String label) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Collection<String> getEdgePropertyNames(K sourceNodeId, K targetNodeId, String label) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Object removeEdgeProperty(K sourceNodeId, K targetNodeId, String label, String propertyName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean removeEdgeProperties(K sourceNodeId, K targetNodeId, String label) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean hasEdgeProperty(K sourceNodeId, K targetNodeId, String label, String propertyName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Object removeNodeProperty(K nodeId, String propertyName) {
        Object existingPropertyValue = this.getNodeProperty(nodeId, propertyName);
        if (existingPropertyValue != null) {
            this.addNode(nodeId);
            NodeInfo nodeInfo = this.nodeInfos.get(nodeId);
            TupleStore nodePropertyTupleStore = this.getNodePropertyTupleStore(propertyName, false);
            Tuple nodePropertyTuple = nodePropertyTupleStore.getTuple(nodeInfo.getInternalNodeId());
            if (nodePropertyTuple != null) {
                int action = nodePropertyTuple.getElement(NODE_PROPERTY_ACTION_KEY_TUPLE_POSITION);
                if (action == Action.Set.getKey()) {
                    throw new UnsupportedOperationException("Removing an added node property is not supported yet");
                }
                assert (action == Action.Delete.getKey());
                return null;
            }
            nodePropertyTupleStore.addTuple(nodeInfo.getInternalNodeId(), -1, Action.Delete.getKey());
        }
        return existingPropertyValue;
    }

    @Override
    public boolean removeNodeProperties(K nodeId) {
        boolean modified = false;
        for (String propertyName : this.getNodePropertyNames(nodeId)) {
            if (this.removeNodeProperty(nodeId, propertyName) == null) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean hasNodeProperty(K nodeId, String propertyName) {
        return this.getNodeProperty(nodeId, propertyName) != null;
    }

    @Override
    public boolean hasNodeProperties(K nodeId) {
        return !this.getNodePropertyNames(nodeId).isEmpty();
    }

    @Override
    public Object addNodeProperty(K nodeId, String propertyName, Object propertyValue) {
        TupleStore nodePropertyTupleStore;
        Tuple nodePropertyTuple;
        Object existingPropertyValue = this.getNodeProperty(nodeId, propertyName);
        this.addNode(nodeId);
        NodeInfo nodeInfo = this.nodeInfos.get(nodeId);
        int nodePropertyValueKey = this.nodePropertyValues.getKey(propertyValue);
        if (nodePropertyValueKey == -1) {
            nodePropertyValueKey = this.nodePropertyValues.addAndReturnKey(propertyValue);
        }
        if ((nodePropertyTuple = (nodePropertyTupleStore = this.getNodePropertyTupleStore(propertyName, false)).getTuple(nodeInfo.getInternalNodeId())) != null) {
            int action = nodePropertyTuple.getElement(NODE_PROPERTY_ACTION_KEY_TUPLE_POSITION);
            if (action == Action.Delete.getKey()) {
                throw new UnsupportedOperationException("Adding a removed node property is not supported yet");
            }
            assert (action == Action.Set.getKey());
            if (nodePropertyTuple.getElement(NODE_PROPERTY_VALUE_KEY_TUPLE_POSITION) == nodePropertyValueKey) {
                return propertyValue;
            }
        }
        nodePropertyTupleStore.addTuple(nodeInfo.getInternalNodeId(), nodePropertyValueKey, Action.Set.getKey());
        return existingPropertyValue;
    }

    @Override
    public Object getNodeProperty(K nodeId, String propertyName) {
        Tuple nodePropertyTuple;
        Object nodeProperty = null;
        try {
            this.lockManager.acquireReadLock();
            nodeProperty = this.masterGraph.containsNode(nodeId) ? this.masterGraph.getNodeProperty(nodeId, propertyName) : null;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
        NodeInfo nodeInfo = this.nodeInfos.get(nodeId);
        if (nodeInfo != null && (nodePropertyTuple = this.getNodePropertyTupleStore(propertyName).getTuple(nodeInfo.getInternalNodeId())) != null) {
            int action = nodePropertyTuple.getElement(NODE_PROPERTY_ACTION_KEY_TUPLE_POSITION);
            if (action == Action.Set.getKey()) {
                nodeProperty = this.nodePropertyValues.get(nodePropertyTuple.getElement(NODE_PROPERTY_VALUE_KEY_TUPLE_POSITION));
            } else {
                assert (action == Action.Delete.getKey());
                nodeProperty = null;
            }
        }
        return nodeProperty;
    }

    @Override
    public Map<String, Object> getNodeProperties(K nodeId) {
        Map<String, Object> nodeProperties = null;
        try {
            this.lockManager.acquireReadLock();
            nodeProperties = this.masterGraph.containsNode(nodeId) ? this.masterGraph.getNodeProperties(nodeId) : Collections.emptyMap();
        }
        finally {
            this.lockManager.releaseReadLock();
        }
        NodeInfo nodeInfo = this.nodeInfos.get(nodeId);
        if (nodeInfo != null) {
            nodeProperties = new HashMap<String, Object>(nodeProperties);
            for (Map.Entry<String, TupleStore> nodePropertyTupleStoreEntry : this.nodePropertyTupleStores.entrySet()) {
                String propertyName = nodePropertyTupleStoreEntry.getKey();
                TupleStore nodePropertyTupleStore = nodePropertyTupleStoreEntry.getValue();
                Tuple nodePropertyTuple = nodePropertyTupleStore.getTuple(nodeInfo.getInternalNodeId());
                int action = nodePropertyTuple.getElement(NODE_PROPERTY_ACTION_KEY_TUPLE_POSITION);
                if (action == Action.Set.getKey()) {
                    nodeProperties.put(propertyName, this.nodePropertyValues.get(nodePropertyTuple.getElement(NODE_PROPERTY_VALUE_KEY_TUPLE_POSITION)));
                    continue;
                }
                assert (action == Action.Delete.getKey());
                nodeProperties.remove(propertyName);
            }
        }
        return nodeProperties;
    }

    @Override
    public Collection<String> getNodePropertyNames(K nodeId) {
        Set<String> nodePropertyNames = null;
        try {
            this.lockManager.acquireReadLock();
            nodePropertyNames = this.masterGraph.containsNode(nodeId) ? this.masterGraph.getNodePropertyNames(nodeId) : Collections.emptySet();
        }
        finally {
            this.lockManager.releaseReadLock();
        }
        NodeInfo nodeInfo = this.nodeInfos.get(nodeId);
        if (nodeInfo != null) {
            nodePropertyNames = new HashSet<String>(nodePropertyNames);
            for (Map.Entry<String, TupleStore> nodePropertyTupleStoreEntry : this.nodePropertyTupleStores.entrySet()) {
                String propertyName = nodePropertyTupleStoreEntry.getKey();
                TupleStore nodePropertyTupleStore = nodePropertyTupleStoreEntry.getValue();
                Tuple nodePropertyTuple = nodePropertyTupleStore.getTuple(nodeInfo.getInternalNodeId());
                int action = nodePropertyTuple.getElement(NODE_PROPERTY_ACTION_KEY_TUPLE_POSITION);
                if (action == Action.Set.getKey()) {
                    nodePropertyNames.add(propertyName);
                    continue;
                }
                assert (action == Action.Delete.getKey());
                nodePropertyNames.remove(propertyName);
            }
        }
        return nodePropertyNames;
    }

    @Override
    public Collection<K> findNodes(PropertyGraphNodeFilter<K> filter) {
        try {
            this.lockManager.acquireReadLock();
            HashSet<K> nodesToFilter = new HashSet<K>(this.masterGraph.getNodeIds());
            nodesToFilter.addAll(this.nodeIds);
            Collection<K> collection = this.filterNodes(nodesToFilter, filter);
            return collection;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public K getNodeId(int internalNodeId) {
        try {
            return this.nodeIds.get(internalNodeId);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private Collection<K> filterNodes(Collection<K> nodesToFilter, PropertyGraphNodeFilter<K> filter) {
        assert (nodesToFilter != null);
        assert (filter != null);
        NodePropertyFilters propFilters = filter.getNodePropertyFilters();
        Collection<K> filteredNodes = nodesToFilter;
        if (propFilters != null) {
            Map<String, List<Object>> filters = propFilters.getFilters();
            for (Map.Entry<String, List<Object>> entry : filters.entrySet()) {
                ArrayList<K> newFilteredNodeIds = new ArrayList<K>();
                for (K nodeId : filteredNodes) {
                    if (nodeId == null || !entry.getValue().contains(this.getNodeProperty(nodeId, entry.getKey()))) continue;
                    newFilteredNodeIds.add(nodeId);
                }
                filteredNodes = newFilteredNodeIds;
            }
        }
        if (filter.callEvaluate()) {
            ArrayList<Object> newFilteredNodeKeys = new ArrayList<Object>();
            for (Object nodeId : filteredNodes) {
                if (nodeId == null || !filter.evaluate(nodeId)) continue;
                newFilteredNodeKeys.add(nodeId);
            }
            return newFilteredNodeKeys;
        }
        return filteredNodes;
    }

    public TupleStore getNodePropertyTupleStore(String propertyName) {
        return this.getNodePropertyTupleStore(propertyName, true);
    }

    public TupleStore getNodePropertyTupleStore(String propertyName, boolean readOnly) {
        if (!this.nodePropertyTupleStores.containsKey(propertyName)) {
            if (readOnly) {
                return EMPTY_TUPLE_STORE;
            }
            this.nodePropertyTupleStores.put(propertyName, TupleStoreFactory.getInstance().create(this.nodePropertyTupleStoreConfig));
        }
        TupleStore nodePropertyTupleStore = this.nodePropertyTupleStores.get(propertyName);
        if (!readOnly) {
            nodePropertyTupleStore = TupleStoreFactory.getInstance().createWritableTupleStore(nodePropertyTupleStore);
            this.nodePropertyTupleStores.put(propertyName, nodePropertyTupleStore);
        }
        return nodePropertyTupleStore;
    }

    @Override
    public String toString() {
        return this.toString(true, null);
    }

    @Override
    public String toString(boolean detailed, Comparator<K> comparator) {
        StringWriter sw = new StringWriter();
        if (!detailed) {
            sw.append("[");
            Iterator<NodeInfo> it = this.nodeInfos.values().iterator();
            while (it.hasNext()) {
                sw.append(it.next().toString());
                if (!it.hasNext()) continue;
                sw.append(", ");
            }
            sw.append("]");
            return sw.toString();
        }
        List<K> nodeKeys = null;
        if (comparator != null) {
            ArrayList<K> nodeKeysAsList = new ArrayList<K>(this.nodeIds);
            Collections.sort(nodeKeysAsList, comparator);
            nodeKeys = nodeKeysAsList;
        } else {
            nodeKeys = this.nodeIds;
        }
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Nodes");
        pw.println("-----");
        for (Object nodeKey : nodeKeys) {
            if (nodeKey == null) continue;
            pw.print(nodeKey.toString());
            pw.print(":");
            pw.println(this.getNodeInfo(nodeKey, true).toString());
        }
        pw.println();
        pw.println("Edges");
        pw.println("-----");
        for (Object nodeKey : nodeKeys) {
            if (nodeKey == null) continue;
            NodeInfo nodeInfo = this.getNodeInfo(nodeKey, true);
            Collection adjacentChildNodeKeysSorted = null;
            if (comparator != null) {
                ArrayList adjacentNodeKeysSorted = new ArrayList(new InternalNodeKeyProxyCollection(this, nodeInfo.getAdjacentNodesTupleStore(), InternalNodeKeyProxyCollection.NODE_KEY_SIGN.POSITIVE));
                Collections.sort(adjacentNodeKeysSorted, comparator);
                adjacentChildNodeKeysSorted = adjacentNodeKeysSorted;
            } else {
                adjacentChildNodeKeysSorted = new InternalNodeKeyProxyCollection(this, nodeInfo.getAdjacentNodesTupleStore(), InternalNodeKeyProxyCollection.NODE_KEY_SIGN.POSITIVE);
            }
            for (Object adjacentChildNodeKey : adjacentChildNodeKeysSorted) {
                pw.print(nodeKey.toString());
                NodeInfo adjacentChildNodeInfo = this.getNodeInfo(adjacentChildNodeKey, true);
                if (adjacentChildNodeInfo.getAdjacentNodesTupleStore().containsTuple(nodeInfo.getInternalNodeId())) {
                    pw.print(" <-------> ");
                } else {
                    pw.print(" --------> ");
                }
                pw.println(adjacentChildNodeKey.toString());
            }
        }
        pw.close();
        return sw.toString();
    }

    @Override
    public ITransaction<K> beginTransaction() {
        return null;
    }

    @Override
    public TupleStoreConfiguration getNodePropertyTupleStoreConfig() {
        return this.nodePropertyTupleStoreConfig;
    }

    @Override
    public TupleStoreConfiguration getAdjacentNodesTupleStoreConfig() {
        return this.adjacentNodesTupleStoreConfig;
    }

    @Override
    public TupleStoreConfiguration getEdgePropertyTupleStoreConfig() {
        return this.edgePropertyTupleStoreConfig;
    }

    @Override
    public boolean add(K object) {
        return this.addNode(object);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        return this.containsNode(object);
    }

    @Override
    public boolean isEmpty() {
        return this.getNodeCount() == 0;
    }

    @Override
    public Iterator<K> iterator() {
        return new Iterator<K>(){
            int pos = 0;
            K current = null;
            K next;
            {
                Object localNext = null;
                while (localNext == null && this.pos < ConcurrentPropertyGraphTransactionGraph.this.nodeIds.size()) {
                    localNext = ConcurrentPropertyGraphTransactionGraph.this.nodeIds.get(this.pos++);
                }
                this.next = localNext;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public K next() {
                this.current = this.next;
                Object localNext = null;
                while (localNext == null && this.pos < ConcurrentPropertyGraphTransactionGraph.this.nodeIds.size()) {
                    localNext = ConcurrentPropertyGraphTransactionGraph.this.nodeIds.get(this.pos++);
                }
                this.next = localNext;
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                ConcurrentPropertyGraphTransactionGraph.this.removeNode(this.current);
                this.current = null;
            }
        };
    }

    @Override
    public boolean remove(Object object) {
        return this.removeNode(object) != null;
    }

    @Override
    public int size() {
        return this.getNodeCount();
    }

    @Override
    public /* synthetic */ Collection getRootNodes() {
        throw new Error("Unresolved compilation problem: \n\tThe type ConcurrentPropertyGraphTransactionGraph<K> must implement the inherited abstract method IPropertyGraph<K>.getRootNodes()\n");
    }

    @Override
    public /* synthetic */ int getInternalNodeId(Object object) {
        throw new Error("Unresolved compilation problem: \n\tThe type ConcurrentPropertyGraphTransactionGraph<K> must implement the inherited abstract method IPropertyGraph<K>.getInternalNodeId(K)\n");
    }

    @Override
    public /* synthetic */ Object getNode(Object object) {
        throw new Error("Unresolved compilation problem: \n\tThe type ConcurrentPropertyGraphTransactionGraph<K> must implement the inherited abstract method IPropertyGraph<K>.getNode(Object)\n");
    }

    @Override
    public /* synthetic */ Iterator getDepthFirstPreOrderIterator(Object object) {
        throw new Error("Unresolved compilation problem: \n\tThe type ConcurrentPropertyGraphTransactionGraph<K> must implement the inherited abstract method IPropertyGraph<K>.getDepthFirstPreOrderIterator(K)\n");
    }

    @Override
    public /* synthetic */ Iterator getDepthFirstPostOrderIterator(Object object) {
        throw new Error("Unresolved compilation problem: \n\tThe type ConcurrentPropertyGraphTransactionGraph<K> must implement the inherited abstract method IPropertyGraph<K>.getDepthFirstPostOrderIterator(K)\n");
    }

    private static enum Action {
        Delete(0),
        Set(1);

        private final int key;

        private Action(int key) {
            this.key = key;
        }

        int getKey() {
            return this.key;
        }
    }
}

