/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.ConcurrentPropertyGraphLoadTransaction;
import com.ibm.cognos.fpm.common.graph.ConcurrentPropertyGraphLockManagerFactory;
import com.ibm.cognos.fpm.common.graph.ConcurrentPropertyGraphReadWriteTransaction;
import com.ibm.cognos.fpm.common.graph.ConcurrentPropertyGraphTransactionGraph;
import com.ibm.cognos.fpm.common.graph.IConcurrentPropertyGraphTransaction;
import com.ibm.cognos.fpm.common.graph.IConcurrentPropertyGraphTransactionGraph;
import com.ibm.cognos.fpm.common.graph.IConcurrentPropertyGraphTransactionManager;
import com.ibm.cognos.fpm.common.graph.ILockManager;
import com.ibm.cognos.fpm.common.graph.IPropertyGraph;
import com.ibm.cognos.fpm.common.graph.TransactionDefinition;
import java.util.concurrent.ConcurrentHashMap;

final class ConcurrentPropertyGraphTransactionManager<K>
implements IConcurrentPropertyGraphTransactionManager<K> {
    private final IPropertyGraph<K> masterGraph;
    private final ILockManager lockManager;
    private ConcurrentHashMap<Thread, IConcurrentPropertyGraphTransaction<K>> transactionMap = new ConcurrentHashMap();

    public ConcurrentPropertyGraphTransactionManager(IPropertyGraph<K> masterGraph) {
        assert (masterGraph != null);
        this.masterGraph = masterGraph;
        this.lockManager = ConcurrentPropertyGraphLockManagerFactory.getInstance().create(masterGraph);
    }

    @Override
    public IConcurrentPropertyGraphTransaction<K> beginTransaction(TransactionDefinition definition) {
        Thread thread = Thread.currentThread();
        IConcurrentPropertyGraphTransaction<K> transaction = this.transactionMap.get(thread);
        if (transaction != null) {
            throw new UnsupportedOperationException("Nested transactions are not supported");
        }
        switch (definition.getTransactionType()) {
            case LOAD_GRAPH: {
                transaction = new ConcurrentPropertyGraphLoadTransaction<K>(definition, this.masterGraph, this, this.lockManager);
                break;
            }
            case READ_ONLY: {
                throw new UnsupportedOperationException("Read-only transactions not implemented");
            }
            case READ_WRITE: {
                transaction = new ConcurrentPropertyGraphReadWriteTransaction<K>(definition, this.masterGraph, this, this.lockManager);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown transaction type" + definition.getTransactionType().toString());
            }
        }
        this.transactionMap.put(thread, transaction);
        return transaction;
    }

    @Override
    public void commit() {
        try {
            IPropertyGraph<K> transactionGraph = this.getTransaction().getTransactionGraph();
            if (transactionGraph != null && transactionGraph instanceof IConcurrentPropertyGraphTransactionGraph && ((ConcurrentPropertyGraphTransactionGraph)transactionGraph).hasChanges()) {
                ((IConcurrentPropertyGraphTransactionGraph)transactionGraph).commit();
            }
        }
        finally {
            this.transactionMap.remove(Thread.currentThread());
            this.lockManager.releaseAllLocks();
        }
    }

    @Override
    public void rollback() {
        this.transactionMap.remove(Thread.currentThread());
        this.lockManager.releaseAllLocks();
    }

    @Override
    public IConcurrentPropertyGraphTransaction<K> getTransaction() {
        return this.transactionMap.get(Thread.currentThread());
    }
}

