/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.EdgeFilter;
import com.ibm.cognos.fpm.common.graph.IAPIContext;
import com.ibm.cognos.fpm.common.graph.ITransaction;
import com.ibm.cognos.fpm.common.graph.ITransactionManager;
import com.ibm.cognos.fpm.common.graph.ITupleElementFilter;
import com.ibm.cognos.fpm.common.graph.IVersionedPropertyGraph;
import com.ibm.cognos.fpm.common.graph.NodeHistory;
import com.ibm.cognos.fpm.common.graph.NodeInfo;
import com.ibm.cognos.fpm.common.graph.TransactionDefinition;
import com.ibm.cognos.fpm.common.graph.TransactionManager;
import com.ibm.cognos.fpm.common.graph.TransactionType;
import com.ibm.cognos.fpm.common.graph.TupleStoreConfiguration;
import com.ibm.cognos.fpm.common.graph.VersionedNodeInfo;
import com.ibm.cognos.fpm.common.graph.VersionedPropertyGraph;
import com.ibm.cognos.fpm.common.graph.VersionedPropertyGraphNodeFilter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ConcurrentVersionedPropertyGraph<K>
implements IVersionedPropertyGraph<K> {
    static final boolean readAPIsMustUseTransactions = false;
    private final IVersionedPropertyGraph<K> wrappedMasterGraph = new VersionedPropertyGraph();
    private final ITransactionManager<K> transactionManager = new TransactionManager<K>(this.wrappedMasterGraph);

    @Override
    public void destroy() {
        ITransaction<K> transaction = this.transactionManager.getTransaction();
        if (transaction != null) {
            transaction.getTransactionData().destroy();
        }
        this.wrappedMasterGraph.destroy();
    }

    @Override
    public int getEdgeCount(IAPIContext<K> context) {
        return this.getGraph(AccessMode.READ).getEdgeCount(context);
    }

    @Override
    public int getNodeCount(IAPIContext<K> context) {
        return this.getGraph(AccessMode.READ).getNodeCount(context);
    }

    @Override
    public Collection<K> getNodeIds(IAPIContext<K> context) {
        return this.getGraph(AccessMode.READ).getNodeIds(context);
    }

    @Override
    public boolean optimize() {
        if (this.transactionManager.getTransaction() != null) {
            return false;
        }
        return this.wrappedMasterGraph.optimize();
    }

    @Override
    public void checkIntegrity() {
        if (this.transactionManager.getTransaction() != null) {
            return;
        }
        this.wrappedMasterGraph.checkIntegrity();
    }

    @Override
    public boolean optimize(K nodeId) {
        if (this.transactionManager.getTransaction() != null) {
            return false;
        }
        return this.wrappedMasterGraph.optimize(nodeId);
    }

    @Override
    public boolean addNode(IAPIContext<K> context, K nodeId, Long classId) {
        return this.getGraph(AccessMode.WRITE).addNode(context, nodeId, classId);
    }

    @Override
    public K removeNode(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.WRITE).removeNode(context, nodeId);
    }

    @Override
    public boolean deleteNode(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.WRITE).deleteNode(context, nodeId);
    }

    @Override
    public boolean restoreNode(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.WRITE).restoreNode(context, nodeId);
    }

    @Override
    public boolean containsNode(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.READ).containsNode(context, nodeId);
    }

    @Override
    public Collection<K> findNodes(IAPIContext<K> context, VersionedPropertyGraphNodeFilter<K> filter) {
        return this.getGraph(AccessMode.READ).findNodes(context, filter);
    }

    @Override
    public K getIncomingNode(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.READ).getIncomingNode(context, nodeId);
    }

    @Override
    public Collection<K> getIncomingNodes(IAPIContext<K> context, K nodeId, int hopCount) {
        return this.getGraph(AccessMode.READ).getIncomingNodes(context, nodeId, hopCount);
    }

    @Override
    public Collection<K> getIncomingNodes(IAPIContext<K> context, K nodeId, int hopCount, VersionedPropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getGraph(AccessMode.READ).getIncomingNodes(context, nodeId, hopCount, nodeFilter, edgeFilter);
    }

    @Override
    public int getIncomingNodeCount(IAPIContext<K> context, K nodeId, int hopCount) {
        return this.getGraph(AccessMode.READ).getIncomingNodeCount(context, nodeId, hopCount);
    }

    @Override
    public int getIncomingNodeCount(IAPIContext<K> context, K nodeId, int hopCount, VersionedPropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getGraph(AccessMode.READ).getIncomingNodeCount(context, nodeId, hopCount, nodeFilter, edgeFilter);
    }

    @Override
    public boolean isIncomingNode(IAPIContext<K> context, K potentialIncomingNodeId, K nodeId) {
        return this.getGraph(AccessMode.READ).isIncomingNode(context, potentialIncomingNodeId, nodeId);
    }

    @Override
    public Collection<K> getOutgoingNodes(IAPIContext<K> context, K nodeId, int hopCount) {
        return this.getGraph(AccessMode.READ).getOutgoingNodes(context, nodeId, hopCount);
    }

    @Override
    public Collection<K> getOutgoingNodes(IAPIContext<K> context, K nodeId, int hopCount, VersionedPropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getGraph(AccessMode.READ).getOutgoingNodes(context, nodeId, hopCount, nodeFilter, edgeFilter);
    }

    @Override
    public boolean isOutgoingNode(IAPIContext<K> context, K potentialOutgoingNodeId, K nodeId) {
        return this.getGraph(AccessMode.READ).isOutgoingNode(context, potentialOutgoingNodeId, nodeId);
    }

    @Override
    public int getOutgoingNodeCount(IAPIContext<K> context, K nodeId, int hopCount) {
        return this.getGraph(AccessMode.READ).getOutgoingNodeCount(context, nodeId, hopCount);
    }

    @Override
    public int getOutgoingNodeCount(IAPIContext<K> context, K nodeKey, int hopCount, VersionedPropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getGraph(AccessMode.READ).getOutgoingNodeCount(context, nodeKey, hopCount, nodeFilter, edgeFilter);
    }

    @Override
    public boolean hasOutgoingNodes(IAPIContext<K> context, K nodeKey, VersionedPropertyGraphNodeFilter<K> filter, EdgeFilter<K> edgeFilter) {
        return this.getGraph(AccessMode.READ).hasOutgoingNodes(context, nodeKey, filter, edgeFilter);
    }

    @Override
    public boolean hasIncomingNodes(IAPIContext<K> context, K nodeKey, VersionedPropertyGraphNodeFilter<K> filter, EdgeFilter<K> edgeFilter) {
        return this.getGraph(AccessMode.READ).hasIncomingNodes(context, nodeKey, filter, edgeFilter);
    }

    @Override
    public K removeNode(IAPIContext<K> context, K nodeId, boolean cascadeToOutgoingNodes) {
        return this.getGraph(AccessMode.WRITE).removeNode(context, nodeId);
    }

    @Override
    public boolean addEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.WRITE).addEdge(context, sourceNodeId, targetNodeId, label);
    }

    @Override
    public boolean removeEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.WRITE).removeEdge(context, sourceNodeId, targetNodeId, label);
    }

    @Override
    public boolean deleteEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.WRITE).deleteEdge(context, sourceNodeId, targetNodeId, label);
    }

    @Override
    public boolean hasEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.READ).hasEdge(context, sourceNodeId, targetNodeId, label);
    }

    @Override
    public boolean restoreEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.WRITE).restoreEdge(context, sourceNodeId, targetNodeId, label);
    }

    @Override
    public Collection<String> getEdgeLabels(IAPIContext<K> context, K sourceNodeId, K targetNodeId) {
        return this.getGraph(AccessMode.READ).getEdgeLabels(context, sourceNodeId, targetNodeId);
    }

    @Override
    public Object addEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName, Object propertyValue) {
        return this.getGraph(AccessMode.WRITE).addEdgeProperty(context, sourceNodeId, targetNodeId, label, propertyName, propertyValue);
    }

    @Override
    public Object getEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName) {
        return this.getGraph(AccessMode.READ).getEdgeProperty(context, sourceNodeId, targetNodeId, label, propertyName);
    }

    @Override
    public Map<String, Object> getEdgeProperties(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.READ).getEdgeProperties(context, sourceNodeId, targetNodeId, label);
    }

    @Override
    public Collection<String> getEdgePropertyNames(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.READ).getEdgePropertyNames(context, sourceNodeId, targetNodeId, label);
    }

    @Override
    public Object removeEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName) {
        return this.getGraph(AccessMode.WRITE).removeEdgeProperty(context, sourceNodeId, targetNodeId, label, propertyName);
    }

    @Override
    public boolean removeEdgeProperties(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return this.getGraph(AccessMode.WRITE).removeEdgeProperties(context, sourceNodeId, targetNodeId, label);
    }

    @Override
    public boolean hasEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName) {
        return this.getGraph(AccessMode.READ).hasEdgeProperty(context, sourceNodeId, targetNodeId, label, propertyName);
    }

    @Override
    public Object removeNodeProperty(IAPIContext<K> context, K sourceId, String propertyName) {
        return this.getGraph(AccessMode.WRITE).removeNodeProperty(context, sourceId, propertyName);
    }

    @Override
    public boolean removeNodeProperties(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.WRITE).removeNodeProperties(context, nodeId);
    }

    @Override
    public boolean hasNodeProperty(IAPIContext<K> context, K nodeId, String propertyName) {
        return this.getGraph(AccessMode.READ).hasNodeProperty(context, nodeId, propertyName);
    }

    @Override
    public boolean hasNodeProperties(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.READ).hasNodeProperties(context, nodeId);
    }

    @Override
    public Object addNodeProperty(IAPIContext<K> context, K nodeId, String propertyName, Object propertyValue) {
        return this.getGraph(AccessMode.WRITE).addNodeProperty(context, nodeId, propertyName, propertyValue);
    }

    @Override
    public Object getNodeProperty(IAPIContext<K> context, K nodeId, String propertyName) {
        return this.getGraph(AccessMode.READ).getNodeProperty(context, nodeId, propertyName);
    }

    @Override
    public Map<String, Object> getNodeProperties(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.READ).getNodeProperties(context, nodeId);
    }

    @Override
    public Collection<String> getNodePropertyNames(IAPIContext<K> context, K nodeId) {
        return this.getGraph(AccessMode.READ).getNodePropertyNames(context, nodeId);
    }

    @Override
    public VersionedNodeInfo getNodeInfo(K nodeId, boolean throwExceptionOnNotFound) {
        return this.getGraph(AccessMode.READ).getNodeInfo(nodeId, throwExceptionOnNotFound);
    }

    @Override
    public NodeInfo getNodeInfo(int internalNodeId, boolean throwExceptionOnNotFound) {
        return this.getGraph(AccessMode.READ).getNodeInfo(internalNodeId, throwExceptionOnNotFound);
    }

    @Override
    public List<NodeHistory<K>> getNodeHistory(K nodeId) {
        return this.getGraph(AccessMode.READ).getNodeHistory(nodeId);
    }

    @Override
    public Long getNodeClass(K nodeId) {
        return this.getGraph(AccessMode.READ).getNodeClass(nodeId);
    }

    @Override
    public Long getEventTime(int internalEventId) {
        return this.getGraph(AccessMode.READ).getEventTime(internalEventId);
    }

    @Override
    public String toString(boolean detailed, Comparator<K> comparator) {
        return null;
    }

    @Override
    public ITransaction<K> beginTransaction() {
        return this.transactionManager.beginTransaction(new TransactionDefinition(TransactionType.READ_WRITE));
    }

    @Override
    public ITransaction<K> beginTransaction(TransactionDefinition definition) {
        return this.transactionManager.beginTransaction(definition);
    }

    private IVersionedPropertyGraph<K> getGraph(AccessMode mode) {
        ITransaction<K> transaction = this.transactionManager.getTransaction();
        if (transaction == null) {
            if (mode != AccessMode.WRITE) {
                if (mode == AccessMode.READ) {
                    // empty if block
                }
            } else {
                throw new IllegalStateException("There is no active transaction");
            }
            return this.wrappedMasterGraph;
        }
        if (transaction.getTransactionDefinition().getTransactionType() == TransactionType.LOAD_GRAPH) {
            return this.wrappedMasterGraph;
        }
        return transaction.getTransactionData();
    }

    @Override
    public TupleStoreConfiguration getNodePropertyTupleStoreConfig() {
        return this.wrappedMasterGraph.getNodePropertyTupleStoreConfig();
    }

    @Override
    public TupleStoreConfiguration getAdjacentNodesTupleStoreConfig() {
        return this.wrappedMasterGraph.getAdjacentNodesTupleStoreConfig();
    }

    @Override
    public TupleStoreConfiguration getEdgePropertyTupleStoreConfig() {
        return this.wrappedMasterGraph.getEdgePropertyTupleStoreConfig();
    }

    @Override
    public ITupleElementFilter<K> getTimeTupleFilter(IAPIContext<K> context, int timeElementPosition) {
        return this.getGraph(AccessMode.READ).getTimeTupleFilter(context, timeElementPosition);
    }

    private static enum AccessMode {
        READ,
        WRITE;

    }
}

