/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.IDirectedGraph;
import com.ibm.cognos.fpm.common.graph.IGraph;
import com.ibm.cognos.fpm.common.graph.IGraphDeltaProcessor;
import com.ibm.cognos.fpm.common.graph.IGraphDeltaResult;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class DirectedGraphDeltaProcessor<K, N>
implements IGraphDeltaProcessor<K, N> {
    protected final IDirectedGraph<K, N> sourceGraph;
    protected final IDirectedGraph<K, N> targetGraph;
    private final Collection<N> nodesInGraph1AddedForReferences;

    public DirectedGraphDeltaProcessor(IDirectedGraph<K, N> graph1, Collection<N> nodesInGraph1AddedForReferences, IDirectedGraph<K, N> graph2) {
        assert (graph1 != null);
        assert (graph2 != null);
        this.sourceGraph = graph1;
        this.targetGraph = graph2;
        this.nodesInGraph1AddedForReferences = nodesInGraph1AddedForReferences;
    }

    @Override
    public IGraphDeltaResult<K, N> process() {
        if (this.targetGraph.isEmpty()) {
            return new GraphDeltaResultImpl(this.sourceGraph, Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), this.nodesInGraph1AddedForReferences);
        }
        if (this.sourceGraph.isEmpty()) {
            return new GraphDeltaResultImpl(Collections.emptyList(), this.targetGraph, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), this.nodesInGraph1AddedForReferences);
        }
        LinkedHashSet<N> objectsToAdd = new LinkedHashSet<N>();
        LinkedHashSet objectsToDelete = new LinkedHashSet();
        LinkedHashSet<N> objectsToModify = new LinkedHashSet<N>();
        LinkedHashMap parentToAddToObject = new LinkedHashMap();
        LinkedHashMap parentToRemoveFromObject = new LinkedHashMap();
        Iterator<N> it = this.sourceGraph.getDepthFirstIterator();
        while (it.hasNext()) {
            N sourceNode = it.next();
            Object sourceNodeKey = this.sourceGraph.getNodeKeyGenerator().generate(sourceNode);
            Object targetNode = this.targetGraph.getNodeByKey(sourceNodeKey);
            if (targetNode == null) {
                objectsToAdd.add(sourceNode);
                continue;
            }
            if (!sourceNode.equals(targetNode)) {
                objectsToModify.add(sourceNode);
            }
            this.searchForParentsToAdd(sourceNode, parentToAddToObject);
            this.searchForParentsToDelete(targetNode, parentToRemoveFromObject);
        }
        this.searchForNodesToDelete(objectsToDelete);
        return new GraphDeltaResultImpl(objectsToAdd, objectsToDelete, objectsToModify, parentToAddToObject, parentToRemoveFromObject, this.nodesInGraph1AddedForReferences);
    }

    private void searchForNodesToDelete(Set<N> objectsToDelete) {
        Iterator<N> it = this.targetGraph.getDepthFirstIterator();
        while (it.hasNext()) {
            N targetNode = it.next();
            if (this.sourceGraph.containsNode(targetNode)) continue;
            objectsToDelete.add(targetNode);
        }
    }

    private void searchForParentsToDelete(N targetNode, Map<N, Collection<N>> parentToRemoveFromObject) {
        for (N targetNodeParent : this.targetGraph.getParents(targetNode)) {
            if (this.sourceGraph.isParent(targetNodeParent, targetNode) || !this.sourceGraph.containsNode(targetNodeParent)) continue;
            Collection<N> existingParents = parentToRemoveFromObject.get(targetNode);
            if (existingParents == null) {
                existingParents = Collections.singleton(targetNodeParent);
                parentToRemoveFromObject.put(targetNode, existingParents);
                continue;
            }
            if (existingParents.size() == 1) {
                existingParents = new LinkedHashSet<N>(existingParents);
                parentToRemoveFromObject.put(targetNode, existingParents);
            }
            existingParents.add(targetNodeParent);
        }
    }

    private void searchForParentsToAdd(N sourceNode, Map<N, Collection<N>> parentToAddToObject) {
        for (N sourceNodeParent : this.sourceGraph.getParents(sourceNode)) {
            if (this.targetGraph.isParent(sourceNodeParent, sourceNode)) continue;
            Collection<N> existingParents = parentToAddToObject.get(sourceNode);
            if (existingParents == null) {
                existingParents = Collections.singleton(sourceNodeParent);
                parentToAddToObject.put(sourceNode, existingParents);
                continue;
            }
            if (existingParents.size() == 1) {
                existingParents = new LinkedHashSet<N>(existingParents);
                parentToAddToObject.put(sourceNode, existingParents);
            }
            existingParents.add(sourceNodeParent);
        }
    }

    private final class GraphDeltaResultImpl
    implements IGraphDeltaResult<K, N> {
        private final Collection<N> objectsToAdd;
        private final Collection<N> objectsToDelete;
        private final Collection<N> objectsToModify;
        final Map<N, Collection<N>> parentToAddToObject;
        final Map<N, Collection<N>> parentToRemoveFromObject;
        private final Collection<N> nodesIncludedForReferencesOnly;

        GraphDeltaResultImpl(Collection<N> objectsToAdd, Collection<N> objectsToDelete, Collection<N> objectsToModify, Map<N, Collection<N>> parentToAddToObject, Map<N, Collection<N>> parentToRemoveFromObject, Collection<N> nodesIncludedForReferencesOnly) {
            this.nodesIncludedForReferencesOnly = nodesIncludedForReferencesOnly;
            this.objectsToAdd = Collections.unmodifiableCollection(objectsToAdd);
            this.objectsToDelete = Collections.unmodifiableCollection(objectsToDelete);
            this.objectsToModify = Collections.unmodifiableCollection(objectsToModify);
            this.parentToAddToObject = Collections.unmodifiableMap(parentToAddToObject);
            this.parentToRemoveFromObject = Collections.unmodifiableMap(parentToRemoveFromObject);
        }

        @Override
        public boolean isTargetDifferent() {
            return !this.objectsToAdd.isEmpty() || !this.objectsToDelete.isEmpty() || !this.objectsToModify.isEmpty() || !this.parentToAddToObject.isEmpty() || !this.parentToRemoveFromObject.isEmpty();
        }

        @Override
        public IGraph<K, N> getSourceGraph() {
            return DirectedGraphDeltaProcessor.this.sourceGraph;
        }

        @Override
        public IGraph<K, N> getTargetGraph() {
            return DirectedGraphDeltaProcessor.this.targetGraph;
        }

        @Override
        public Collection<N> getNodesToCreate() {
            return this.objectsToAdd;
        }

        @Override
        public Collection<N> getNodesToDelete() {
            return this.objectsToDelete;
        }

        @Override
        public Collection<N> getNodesToModify() {
            return this.objectsToModify;
        }

        @Override
        public Collection<N> getNodesToMove() {
            LinkedHashSet allObjects = new LinkedHashSet();
            allObjects.addAll(this.parentToAddToObject.keySet());
            allObjects.addAll(this.parentToRemoveFromObject.keySet());
            return Collections.unmodifiableSet(allObjects);
        }

        @Override
        public Collection<N> getNodesToConnectToForMovedNode(N node) {
            Collection result = this.parentToAddToObject.get(node);
            return result == null ? Collections.emptyList() : Collections.unmodifiableCollection(result);
        }

        @Override
        public Collection<N> getNodesToDisconnectFromForMovedNode(N node) {
            Collection result = this.parentToRemoveFromObject.get(node);
            return result == null ? Collections.emptyList() : Collections.unmodifiableCollection(result);
        }

        @Override
        public Collection<N> getNodesIncludedForReferencesOnly() {
            return this.nodesIncludedForReferencesOnly;
        }
    }
}

