/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class GraphPrimitiveUtils {
    private GraphPrimitiveUtils() {
    }

    public static int getBinarySearchCost(int size) {
        int log = 0;
        if ((size & 0xFFFF0000) != 0) {
            size >>>= 16;
            log = 16;
        }
        if (size >= 256) {
            size >>>= 8;
            log += 8;
        }
        if (size >= 16) {
            size >>>= 4;
            log += 4;
        }
        if (size >= 4) {
            size >>>= 2;
            log += 2;
        }
        return log + (size >>> 1);
    }

    public static long combine(int value1, int value2) {
        return (long)value1 << 32 | (long)value2 << 32 >>> 32;
    }

    public static int extractUpperInt(long value) {
        return (int)(value >> 32);
    }

    public static int extractLowerInt(long value) {
        return (int)value;
    }

    public static int jre16_binarySearch(long[] array, int startIndex, int endIndex, long value) {
        int low = startIndex;
        int mid = -1;
        int high = endIndex - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            if (value > array[mid]) {
                low = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static int jre16_binarySearch(int[] array, int startIndex, int endIndex, int value) {
        int low = startIndex;
        int mid = -1;
        int high = endIndex - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            if (value > array[mid]) {
                low = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static void writeToOutputStream(byte value, OutputStream out) {
        try {
            out.write(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte readByteFromInputStream(InputStream in) {
        try {
            return (byte)in.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int readIntFromInputStream(InputStream in) {
        try {
            return (in.read() & 0xFF) << 24 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 8 | (in.read() & 0xFF) << 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int[] readIntArrayFromInputStream(InputStream in) {
        int arrayLen = GraphPrimitiveUtils.readIntFromInputStream(in);
        if (arrayLen < 0) {
            return null;
        }
        int[] array = new int[arrayLen];
        int j = 0;
        while (j < arrayLen) {
            array[j] = GraphPrimitiveUtils.readIntFromInputStream(in);
            if (array[j] < 0) {
                throw new IllegalStateException();
            }
            ++j;
        }
        return array;
    }

    public static long[] readLongArrayFromInputStream(InputStream in) {
        int arrayLen = GraphPrimitiveUtils.readIntFromInputStream(in);
        if (arrayLen < 0) {
            return null;
        }
        long[] array = new long[arrayLen];
        int j = 0;
        while (j < arrayLen) {
            array[j] = GraphPrimitiveUtils.readLongFromInputStream(in);
            ++j;
        }
        return array;
    }

    public static long readLongFromInputStream(InputStream in) {
        try {
            return ((long)in.read() & 0xFFL) << 56 | ((long)in.read() & 0xFFL) << 48 | ((long)in.read() & 0xFFL) << 40 | ((long)in.read() & 0xFFL) << 32 | ((long)in.read() & 0xFFL) << 24 | ((long)in.read() & 0xFFL) << 16 | ((long)in.read() & 0xFFL) << 8 | ((long)in.read() & 0xFFL) << 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToOutputStream(int value, OutputStream out) {
        try {
            out.write((byte)(value >> 24));
            out.write((byte)(value >> 16));
            out.write((byte)(value >> 8));
            out.write((byte)(value >> 0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToOutputStream(int[] value, int len, OutputStream out) {
        if (value == null) {
            GraphPrimitiveUtils.writeToOutputStream(-1, out);
            return;
        }
        GraphPrimitiveUtils.writeToOutputStream(len, out);
        int i = 0;
        while (i < len) {
            GraphPrimitiveUtils.writeToOutputStream(value[i], out);
            ++i;
        }
    }

    public static void writeToOutputStream(long value, OutputStream out) {
        try {
            out.write((byte)(value >> 56));
            out.write((byte)(value >> 48));
            out.write((byte)(value >> 40));
            out.write((byte)(value >> 32));
            out.write((byte)(value >> 24));
            out.write((byte)(value >> 16));
            out.write((byte)(value >> 8));
            out.write((byte)(value >> 0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToOutputStream(long[] value, int len, OutputStream out) {
        if (value == null) {
            GraphPrimitiveUtils.writeToOutputStream(-1, out);
            return;
        }
        GraphPrimitiveUtils.writeToOutputStream(len, out);
        int i = 0;
        while (i < len) {
            GraphPrimitiveUtils.writeToOutputStream(value[i], out);
            ++i;
        }
    }
}

