/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.IPropertyGraph;
import com.ibm.cognos.fpm.common.graph.NodeInfo;
import com.ibm.cognos.fpm.common.graph.TupleElementIterator;
import com.ibm.cognos.fpm.common.graph.TupleStore;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CollectionUtils;

final class InternalNodeKeyProxyCollection<K>
implements Collection<K> {
    private final IPropertyGraph<K> propertyGraph;
    private final TupleStore tupleStore;
    private final NODE_KEY_SIGN nodeKeySign;

    InternalNodeKeyProxyCollection(IPropertyGraph<K> propertyGraph, TupleStore tupleStore, NODE_KEY_SIGN nodeKeySign) {
        this.propertyGraph = propertyGraph;
        this.tupleStore = tupleStore;
        this.nodeKeySign = nodeKeySign;
    }

    @Override
    public boolean add(K o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        NodeInfo oNodeInfo = this.propertyGraph.getNodeInfo(o, false);
        if (oNodeInfo == null) {
            return false;
        }
        int internalNodeId = oNodeInfo.getInternalNodeId();
        if (this.nodeKeySign == NODE_KEY_SIGN.NEGATIVE) {
            internalNodeId = -1 * oNodeInfo.getInternalNodeId();
        }
        return this.tupleStore.containsTuple(internalNodeId);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.tupleStore.isEmpty();
    }

    @Override
    public Iterator<K> iterator() {
        return new Iterator<K>(){
            private final TupleElementIterator m_wrappedIterator;
            private K nextNodeKey;
            {
                this.m_wrappedIterator = InternalNodeKeyProxyCollection.this.tupleStore.getTupleElementIterator(0);
                this.nextNodeKey = null;
                while (this.m_wrappedIterator.hasNext()) {
                    int nextInternalNodeKey = this.m_wrappedIterator.next();
                    if (InternalNodeKeyProxyCollection.this.nodeKeySign == NODE_KEY_SIGN.POSITIVE) {
                        if (nextInternalNodeKey < 0) {
                            continue;
                        }
                    } else {
                        if (!$assertionsDisabled && InternalNodeKeyProxyCollection.this.nodeKeySign != NODE_KEY_SIGN.NEGATIVE) {
                            throw new AssertionError();
                        }
                        if (nextInternalNodeKey > 0) break;
                        nextInternalNodeKey *= -1;
                    }
                    this.nextNodeKey = CollectionUtils.get(InternalNodeKeyProxyCollection.this.propertyGraph.getNodeIds(), (int)nextInternalNodeKey);
                    if (this.nextNodeKey != null) break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextNodeKey != null;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object nodeKey = this.nextNodeKey;
                this.nextNodeKey = null;
                while (this.m_wrappedIterator.hasNext()) {
                    int nextInternalNodeKey = this.m_wrappedIterator.next();
                    if (InternalNodeKeyProxyCollection.this.nodeKeySign == NODE_KEY_SIGN.POSITIVE) {
                        if (nextInternalNodeKey < 0) {
                            continue;
                        }
                    } else {
                        if (!$assertionsDisabled && InternalNodeKeyProxyCollection.this.nodeKeySign != NODE_KEY_SIGN.NEGATIVE) {
                            throw new AssertionError();
                        }
                        if (nextInternalNodeKey > 0) break;
                        nextInternalNodeKey *= -1;
                    }
                    this.nextNodeKey = CollectionUtils.get(InternalNodeKeyProxyCollection.this.propertyGraph.getNodeIds(), (int)nextInternalNodeKey);
                    if (this.nextNodeKey != null) break;
                }
                return nodeKey;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int negativeKeyCount = 0;
        TupleElementIterator it = this.tupleStore.getTupleElementIterator(0);
        while (it.hasNext()) {
            if (it.next() >= 0) break;
            ++negativeKeyCount;
        }
        return this.nodeKeySign == NODE_KEY_SIGN.POSITIVE ? this.tupleStore.size() - negativeKeyCount : negativeKeyCount;
    }

    @Override
    public Object[] toArray() {
        Object[] asArray = new Object[this.size()];
        int i = 0;
        Iterator<K> nodeKeys = this.iterator();
        while (nodeKeys.hasNext()) {
            asArray[i++] = nodeKeys.next();
        }
        return asArray;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        T[] asArray = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        int i = 0;
        Iterator<K> nodeKeys = this.iterator();
        while (nodeKeys.hasNext()) {
            asArray[i++] = nodeKeys.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return asArray;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator<K> it = this.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum NODE_KEY_SIGN {
        POSITIVE,
        NEGATIVE;

    }
}

