/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.IDirectedGraph;
import com.ibm.cognos.fpm.common.graph.IGraph;
import com.ibm.cognos.fpm.common.graph.IJSGraphVisualizerNodeInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public final class JSGraphVisualizerGenerator {
    private JSGraphVisualizerGenerator() {
    }

    public static <K, N> String toJson(IGraph<K, N> graph, N startNode, IJSGraphVisualizerNodeInfo<N> nodeInfo) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        JSGraphVisualizerGenerator.addNonGraphSpecificVariables(pw, graph, startNode, nodeInfo);
        pw.println("var GraphConnections = [");
        boolean firstConnectedNode = true;
        Iterator<N> nodes = graph.getDepthFirstIterator(startNode);
        while (nodes.hasNext()) {
            N node;
            Iterator<N> connectedNodes;
            if (!firstConnectedNode) {
                pw.print(", ");
            }
            if ((connectedNodes = graph.getConnectedNodes(node = nodes.next()).iterator()).hasNext() && !firstConnectedNode) {
                pw.print(", ");
            }
            while (connectedNodes.hasNext()) {
                firstConnectedNode = false;
                N connectedNode = connectedNodes.next();
                pw.println("{left:'" + node.hashCode() + "', right:'" + connectedNode.hashCode() + "'}");
                if (!connectedNodes.hasNext()) continue;
                pw.print(", ");
            }
        }
        pw.println("];");
        pw.close();
        return sw.toString();
    }

    public static <K, N> String toJson(IDirectedGraph<K, N> graph, N startNode, IJSGraphVisualizerNodeInfo<N> nodeInfo) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        JSGraphVisualizerGenerator.addNonGraphSpecificVariables(pw, graph, startNode, nodeInfo);
        pw.println("var GraphConnections = [");
        boolean firstEdge = true;
        Iterator<N> nodes = graph.getDepthFirstIterator(startNode);
        while (nodes.hasNext()) {
            N node = nodes.next();
            Iterator<N> childNodes = graph.getChildren(node).iterator();
            if (childNodes.hasNext() && !firstEdge) {
                pw.print(", ");
            }
            while (childNodes.hasNext()) {
                firstEdge = false;
                N childNode = childNodes.next();
                pw.print("{left:'");
                pw.print(node.hashCode());
                pw.print("', right:'");
                pw.print(childNode.hashCode());
                pw.println("', leftArrow:false, rightArrow:true}");
                if (!childNodes.hasNext()) continue;
                pw.print(", ");
            }
        }
        pw.println("];");
        pw.close();
        return sw.toString();
    }

    private static <K, N> void addNonGraphSpecificVariables(PrintWriter pw, IGraph<K, N> graph, N startNode, IJSGraphVisualizerNodeInfo<N> nodeInfo) {
        pw.println(" var GraphName = '" + nodeInfo.getGraphName() + "';");
        pw.println(" var expandItems = " + (nodeInfo.expandPropertiesByDefault() ? "true" : "false") + ";");
        pw.println(" var nodeWidth = 200;");
        pw.println("var GraphNodes = [");
        HashSet<N> nodesToInclude = new HashSet<N>();
        Iterator<N> nodes = graph.getDepthFirstIterator(startNode);
        while (nodes.hasNext()) {
            N node = nodes.next();
            nodesToInclude.add(node);
            pw.println("{");
            pw.println("name:'" + nodeInfo.getCaption(node) + "', icon:'todo_add_icon', id:'" + node.hashCode() + "'");
            Map<String, String> nodeProps = nodeInfo.getNodeProperties(node);
            if (!nodeProps.isEmpty()) {
                pw.println(", items:[");
                Iterator<Map.Entry<String, String>> nodePropEntries = nodeProps.entrySet().iterator();
                while (nodePropEntries.hasNext()) {
                    Map.Entry<String, String> nodePropEntry = nodePropEntries.next();
                    pw.println("{name: '" + nodePropEntry.getKey() + ": " + nodePropEntry.getValue() + "'}");
                    if (!nodePropEntries.hasNext()) continue;
                    pw.print(", ");
                }
                pw.println("]");
            }
            pw.println("}");
            if (!nodes.hasNext()) continue;
            pw.print(", ");
        }
        pw.println("];");
        pw.println(" var GraphDetails = [];");
    }
}

