/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.ILockManager;
import com.ibm.cognos.fpm.common.graph.IVersionedPropertyGraph;
import com.ibm.cognos.fpm.common.graph.ReadWriteCommitLock;

class LockManager<K>
implements ILockManager {
    private final ReadWriteCommitLock graphLock;

    public LockManager(IVersionedPropertyGraph<K> masterGraph) {
        this.graphLock = new ReadWriteCommitLock(masterGraph);
    }

    @Override
    public void acquireReadLock() {
        this.graphLock.acquireReadLock();
    }

    @Override
    public void releaseReadLock() {
        this.graphLock.releaseReadLock();
    }

    @Override
    public void acquireWriteLock() {
        if (this.graphLock.getWriteLockCount() == 0) {
            this.graphLock.acquireWriteLock();
        }
    }

    @Override
    public void releaseWriteLock() {
        this.graphLock.releaseWriteLock();
    }

    @Override
    public void acquireCommitLock() {
        this.graphLock.acquireCommitLock();
    }

    @Override
    public void releaseCommitLock() {
        this.graphLock.releaseCommitLock();
    }

    @Override
    public void releaseAllLocks() {
        this.graphLock.releaseAllLocks();
    }

    @Override
    public int getReadLockCount() {
        return this.graphLock.getReadLockCount();
    }

    @Override
    public int getWriteLockCount() {
        return this.graphLock.getWriteLockCount();
    }

    @Override
    public int getCommitLockCount() {
        return this.graphLock.getCommitLockCount();
    }

    @Override
    public int getTotalLockCount() {
        return this.graphLock.getTotalLockCount();
    }
}

