/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.EmptyTupleStore;
import com.ibm.cognos.fpm.common.graph.INodeInfo;
import com.ibm.cognos.fpm.common.graph.IPropertyGraph;
import com.ibm.cognos.fpm.common.graph.InternalNodeKeyProxyCollection;
import com.ibm.cognos.fpm.common.graph.TupleStore;
import com.ibm.cognos.fpm.common.graph.TupleStoreConfiguration;
import com.ibm.cognos.fpm.common.graph.TupleStoreFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

class NodeInfo
implements INodeInfo {
    static final TupleStore EMPTY_TUPLE_STORE = new EmptyTupleStore();
    private final int internalNodeId;
    private TupleStore getAdjacentNodesTupleStore = null;
    private TupleStore edgePropertyTupleStore = null;
    static final int RELATED_NODE_ID_POS = 0;
    static final int RELATED_NODE_EDGE_LABEL_POS = 1;
    static final int RELATED_NODE_EDGE_ID_POS = 2;
    static final int NODE_PROPERTY_VALUE_ID_POS = 1;

    public NodeInfo(int internalNodeKey) {
        this.internalNodeId = internalNodeKey;
    }

    @Override
    public boolean optimize() {
        boolean modified = false;
        if (this.getAdjacentNodesTupleStore != null) {
            if (this.getAdjacentNodesTupleStore.optimize()) {
                modified = true;
            }
            this.getAdjacentNodesTupleStore = TupleStoreFactory.getInstance().createReadOnlyTupleStore(this.getAdjacentNodesTupleStore);
        }
        if (this.edgePropertyTupleStore != null) {
            if (this.edgePropertyTupleStore.optimize()) {
                modified = true;
            }
            this.edgePropertyTupleStore = TupleStoreFactory.getInstance().createReadOnlyTupleStore(this.edgePropertyTupleStore);
        }
        return modified;
    }

    @Override
    public TupleStore getAdjacentNodesTupleStore() {
        return this.getAdjacentNodesTupleStore(true, null);
    }

    @Override
    public TupleStore getAdjacentNodesTupleStore(boolean readOnly, TupleStoreConfiguration adjacentNodesTupleStoreConfig) {
        if (this.getAdjacentNodesTupleStore == null) {
            if (readOnly) {
                return EMPTY_TUPLE_STORE;
            }
            this.getAdjacentNodesTupleStore = TupleStoreFactory.getInstance().create(adjacentNodesTupleStoreConfig);
        }
        if (!readOnly) {
            this.getAdjacentNodesTupleStore = TupleStoreFactory.getInstance().createWritableTupleStore(this.getAdjacentNodesTupleStore);
        }
        return this.getAdjacentNodesTupleStore;
    }

    @Override
    public TupleStore getEdgePropertyTupleStore() {
        return this.getEdgePropertyTupleStore(true, null);
    }

    @Override
    public TupleStore getEdgePropertyTupleStore(boolean readOnly, TupleStoreConfiguration edgePropertyTupleStoreConfig) {
        if (this.edgePropertyTupleStore == null) {
            if (readOnly) {
                return EMPTY_TUPLE_STORE;
            }
            this.edgePropertyTupleStore = TupleStoreFactory.getInstance().create(edgePropertyTupleStoreConfig);
        }
        if (!readOnly) {
            this.edgePropertyTupleStore = TupleStoreFactory.getInstance().createWritableTupleStore(this.edgePropertyTupleStore);
        }
        return this.edgePropertyTupleStore;
    }

    @Override
    public int getInternalNodeId() {
        return this.internalNodeId;
    }

    public <K> String toString(IPropertyGraph<K> parentGraph) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(CollectionUtils.get(parentGraph.getNodeIds(), (int)this.internalNodeId).toString());
        pw.print("Internal Key: ");
        pw.println(this.internalNodeId);
        pw.println("Properties: ");
        Map<String, Object> props = parentGraph.getNodeProperties(CollectionUtils.get(parentGraph.getNodeIds(), (int)this.internalNodeId));
        for (Map.Entry<String, Object> e : props.entrySet()) {
            pw.print(e.getKey());
            pw.print(": ");
            pw.println(e.getValue());
        }
        pw.print("Adjacent Nodes: ");
        pw.println(this.getAdjacentNodesTupleStore != null ? new InternalNodeKeyProxyCollection<K>(parentGraph, this.getAdjacentNodesTupleStore, InternalNodeKeyProxyCollection.NODE_KEY_SIGN.POSITIVE).toString() : "[]");
        pw.close();
        return sw.toString();
    }
}

