/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.IGraph;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

final class NodeKeyProxyCollection<K, N>
implements Collection<N> {
    private final IGraph<K, N> m_graph;
    private final Collection<K> m_nodeKeys;
    private final List<K> m_orderNodeKeys;

    NodeKeyProxyCollection(IGraph<K, N> graph, Collection<K> nodeKeys) {
        this(graph, nodeKeys, null);
    }

    NodeKeyProxyCollection(IGraph<K, N> graph, Collection<K> nodeKeys, List<K> orderedNodeKeys) {
        assert (graph != null);
        assert (nodeKeys != null);
        this.m_graph = graph;
        this.m_nodeKeys = nodeKeys;
        this.m_orderNodeKeys = orderedNodeKeys;
    }

    @Override
    public boolean add(N o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends N> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        return this.m_nodeKeys.contains(this.m_graph.getNodeKeyGenerator().generate(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.m_nodeKeys.isEmpty();
    }

    @Override
    public Iterator<N> iterator() {
        return new Iterator<N>(){
            private final Iterator<K> m_wrappedIterator;
            private K nextNodeKey;
            {
                this.m_wrappedIterator = NodeKeyProxyCollection.this.m_orderNodeKeys != null ? NodeKeyProxyCollection.this.m_orderNodeKeys.iterator() : NodeKeyProxyCollection.this.m_nodeKeys.iterator();
                this.nextNodeKey = null;
                while (this.m_wrappedIterator.hasNext()) {
                    this.nextNodeKey = this.m_wrappedIterator.next();
                    if (this.nextNodeKey != null) break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextNodeKey != null;
            }

            @Override
            public N next() {
                Object node = NodeKeyProxyCollection.this.m_graph.getNodeByKey(this.nextNodeKey);
                if (node == null) {
                    throw new IllegalArgumentException("The node with key '" + this.nextNodeKey + "' doesn't exist in the graph.");
                }
                this.nextNodeKey = null;
                while (this.m_wrappedIterator.hasNext()) {
                    this.nextNodeKey = this.m_wrappedIterator.next();
                    if (this.nextNodeKey != null) break;
                }
                return node;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.m_nodeKeys.size();
    }

    @Override
    public Object[] toArray() {
        Object[] asArray = new Object[this.m_nodeKeys.size()];
        int i = 0;
        for (K nodeKey : this.m_nodeKeys) {
            asArray[i++] = this.m_graph.getNodeByKey(nodeKey);
        }
        return asArray;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] asArray = a.length >= this.m_nodeKeys.size() ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.m_nodeKeys.size());
        int i = 0;
        for (K nodeKey : this.m_nodeKeys) {
            asArray[i++] = this.m_graph.getNodeByKey(nodeKey);
        }
        if (a.length > this.m_nodeKeys.size()) {
            a[this.m_nodeKeys.size()] = null;
        }
        return asArray;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Collection)) {
            return false;
        }
        if (((Collection)obj).size() != this.m_nodeKeys.size()) {
            return false;
        }
        Iterator it = ((Collection)obj).iterator();
        for (K nodeKey : this.m_nodeKeys) {
            N node = this.m_graph.getNodeByKey(nodeKey);
            if (node == null) {
                throw new IllegalStateException("No node exists with the key '" + nodeKey + "'.");
            }
            if (node.equals(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.m_nodeKeys.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator<N> it = this.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

