/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NodePropertyFilters {
    private final Map<String, List<Object>> filters = new TreeMap<String, List<Object>>();

    public NodePropertyFilters() {
    }

    public NodePropertyFilters(String propertyName, Object propertyValue) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(propertyValue);
        this.filters.put(propertyName, values);
    }

    public Collection<Object> addPropertyFilter(String propertyName, Object propertyValue) {
        List<Object> values;
        ArrayList<Object> oldValues = null;
        if (!this.filters.containsKey(propertyName)) {
            this.filters.put(propertyName, new ArrayList());
        }
        if (!(values = this.filters.get(propertyName)).isEmpty()) {
            oldValues = new ArrayList<Object>(values);
        }
        this.filters.get(propertyName).add(propertyValue);
        return oldValues;
    }

    public Collection<Object> addPropertyFilters(String propertyName, Collection<? extends Object> propertyValues) {
        Collection<Object> oldValues = null;
        boolean first = true;
        for (Object object : propertyValues) {
            Collection<Object> currOldValues = this.addPropertyFilter(propertyName, object);
            if (!first) continue;
            oldValues = currOldValues;
            first = false;
        }
        return oldValues;
    }

    public Map<String, List<Object>> getFilters() {
        return Collections.unmodifiableMap(this.filters);
    }
}

