/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.IParameterizedDirectedMultigraph;
import com.ibm.cognos.fpm.common.graph.IParameterizedEdge;
import com.ibm.cognos.fpm.common.graph.IParameterizedEdgeFactory;
import com.ibm.cognos.fpm.common.graph.ParameterizedMultigraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class ParameterizedDirectedMultigraph<N, E>
extends ParameterizedMultigraph<N, E>
implements IParameterizedDirectedMultigraph<N, E> {
    public ParameterizedDirectedMultigraph() {
    }

    public ParameterizedDirectedMultigraph(IParameterizedEdgeFactory<N, E> edgeFactory) {
        super(edgeFactory);
    }

    public ParameterizedDirectedMultigraph(IParameterizedDirectedMultigraph<N, E> graph, IParameterizedEdgeFactory<N, E> edgeFactory) {
        super(graph, edgeFactory);
    }

    @Override
    public IParameterizedEdge<N, E> addEdge(N sourceNode, N targetNode, IParameterizedEdge<N, E> edge) {
        LinkedHashMap<E, IParameterizedEdge<N, E>> existingSourceTargetEdges;
        if (edge == null) {
            throw new IllegalArgumentException();
        }
        if (!edge.getSourceNode().equals(sourceNode)) {
            throw new IllegalArgumentException("The given source node isn't assigned as the source node in the given edge.");
        }
        if (!edge.getTargetNode().equals(targetNode)) {
            throw new IllegalArgumentException("The given target node isn't assigned as the target node in the given edge.");
        }
        LinkedHashMap existingSourceEdges = (LinkedHashMap)this.m_nodesToEdgesByTargetByType.get(sourceNode);
        if (existingSourceEdges == null) {
            throw new IllegalArgumentException("The source node doesn't exist in the graph.");
        }
        if (!this.containsNode(targetNode)) {
            throw new IllegalArgumentException("The target node doesn't exist in the graph.");
        }
        if (existingSourceEdges.isEmpty()) {
            existingSourceEdges = new LinkedHashMap();
            this.m_nodesToEdgesByTargetByType.put(sourceNode, existingSourceEdges);
        }
        if ((existingSourceTargetEdges = (LinkedHashMap<E, IParameterizedEdge<N, E>>)existingSourceEdges.get(targetNode)) == null) {
            existingSourceTargetEdges = new LinkedHashMap<E, IParameterizedEdge<N, E>>();
            existingSourceEdges.put(targetNode, existingSourceTargetEdges);
        }
        if (existingSourceTargetEdges.containsKey(edge.getType())) {
            return (IParameterizedEdge)existingSourceTargetEdges.get(edge.getType());
        }
        existingSourceTargetEdges.put(edge.getType(), edge);
        ArrayList<IParameterizedEdge<N, E>> sourceNodeEdges = (ArrayList<IParameterizedEdge<N, E>>)this.m_nodesToEdges.get(sourceNode);
        if (sourceNodeEdges.isEmpty()) {
            sourceNodeEdges = new ArrayList<IParameterizedEdge<N, E>>();
            this.m_nodesToEdges.put(sourceNode, sourceNodeEdges);
        }
        sourceNodeEdges.add(edge);
        return edge;
    }

    @Override
    public Collection<IParameterizedEdge<N, E>> getIncomingEdges(N node) {
        return this.getIncomingEdges(node, null);
    }

    @Override
    public Collection<IParameterizedEdge<N, E>> getIncomingEdges(N node, E edgeType) {
        if (!this.containsNode(node)) {
            throw new IllegalArgumentException("The given node does not exist in the graph.");
        }
        HashSet<IParameterizedEdge> incomingEdges = null;
        for (Map.Entry nodeEdges : this.m_nodesToEdgesByTargetByType.entrySet()) {
            if (!((Map)nodeEdges.getValue()).containsKey(node)) continue;
            for (IParameterizedEdge edge : ((Map)((Map)nodeEdges.getValue()).get(node)).values()) {
                if (edgeType != null && !edgeType.equals(edge.getType())) continue;
                if (incomingEdges == null) {
                    incomingEdges = new HashSet<IParameterizedEdge>();
                }
                incomingEdges.add(edge);
            }
        }
        return incomingEdges != null ? Collections.unmodifiableCollection(incomingEdges) : Collections.emptySet();
    }

    @Override
    public Collection<IParameterizedEdge<N, E>> getOutgoingEdges(N node) {
        return this.getEdges(node);
    }

    @Override
    public Collection<IParameterizedEdge<N, E>> getOutgoingEdges(N node, E edgeType) {
        return this.getEdges(node, edgeType);
    }
}

