/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.DefaultParameterizedPath;
import com.ibm.cognos.fpm.common.graph.IParameterizedEdge;
import com.ibm.cognos.fpm.common.graph.IParameterizedEdgeFactory;
import com.ibm.cognos.fpm.common.graph.IParameterizedMultigraph;
import com.ibm.cognos.fpm.common.graph.IParameterizedPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ParameterizedMultigraph<N, E>
implements IParameterizedMultigraph<N, E> {
    protected final IParameterizedEdgeFactory<N, E> m_edgeFactory;
    protected final Map<N, Map<N, Map<E, IParameterizedEdge<N, E>>>> m_nodesToEdgesByTargetByType = new LinkedHashMap<N, Map<N, Map<E, IParameterizedEdge<N, E>>>>();
    protected final Map<N, Collection<IParameterizedEdge<N, E>>> m_nodesToEdges = new LinkedHashMap<N, Collection<IParameterizedEdge<N, E>>>();

    public ParameterizedMultigraph() {
        this.m_edgeFactory = null;
    }

    public ParameterizedMultigraph(IParameterizedEdgeFactory<N, E> edgeFactory) {
        if (edgeFactory == null) {
            throw new IllegalArgumentException();
        }
        this.m_edgeFactory = edgeFactory;
    }

    public ParameterizedMultigraph(IParameterizedMultigraph<N, E> graph, IParameterizedEdgeFactory<N, E> edgeFactory) {
        assert (graph != null);
        assert (edgeFactory != null) : "Copy constructor requires an EdgeFactory";
        this.m_edgeFactory = edgeFactory;
        Iterator<N> it = graph.iterator();
        while (it.hasNext()) {
            for (IParameterizedEdge<N, E> edge : graph.getEdges(it.next())) {
                this.addNode(edge.getSourceNode());
                this.addNode(edge.getTargetNode());
                this.addEdge(edge.getSourceNode(), edge.getTargetNode(), edge);
            }
        }
    }

    @Override
    public boolean addNode(N node) {
        if (this.m_nodesToEdgesByTargetByType.containsKey(node)) {
            return false;
        }
        this.m_nodesToEdgesByTargetByType.put(node, Collections.emptyMap());
        this.m_nodesToEdges.put(node, Collections.emptyList());
        return true;
    }

    @Override
    public boolean containsNode(N node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        return this.m_nodesToEdgesByTargetByType.containsKey(node);
    }

    @Override
    public IParameterizedEdge<N, E> addEdge(N sourceNode, N targetNode, E edgeType) {
        if (this.m_edgeFactory == null) {
            throw new UnsupportedOperationException("No EdgeFactory was supplied during construction, the caller must supply the edge.");
        }
        return this.addEdge(sourceNode, targetNode, this.m_edgeFactory.create(sourceNode, targetNode, edgeType));
    }

    @Override
    public abstract IParameterizedEdge<N, E> addEdge(N var1, N var2, IParameterizedEdge<N, E> var3);

    @Override
    public Collection<IParameterizedEdge<N, E>> getEdges(N node) {
        Collection<IParameterizedEdge<N, E>> edges = this.m_nodesToEdges.get(node);
        if (edges == null) {
            throw new IllegalArgumentException("The given node does not exist in the graph.");
        }
        return Collections.unmodifiableCollection(edges);
    }

    @Override
    public Collection<IParameterizedEdge<N, E>> getEdges(N node, E edgeType) {
        ArrayList<IParameterizedEdge<N, E>> edges = new ArrayList<IParameterizedEdge<N, E>>();
        for (IParameterizedEdge<N, E> edge : this.getEdges(node)) {
            if (!edge.getType().equals(edgeType)) continue;
            edges.add(edge);
        }
        return Collections.unmodifiableCollection(edges);
    }

    @Override
    public List<IParameterizedPath<N, E>> getAllPaths(N startNode, N endNode) {
        return this.getAllPaths(startNode, endNode, null);
    }

    @Override
    public List<IParameterizedPath<N, E>> getAllPaths(N startNode, N endNode, E edgeType) {
        if (!this.m_nodesToEdgesByTargetByType.containsKey(startNode)) {
            throw new IllegalArgumentException("The given start node does not exist in the graph.");
        }
        if (!this.m_nodesToEdgesByTargetByType.containsKey(endNode)) {
            throw new IllegalArgumentException("The given end node does not exist in the graph.");
        }
        ArrayList<List<IParameterizedEdge<N, E>>> allPaths = new ArrayList<List<IParameterizedEdge<N, E>>>();
        for (IParameterizedEdge<N, E> edge : this.getEdges(startNode)) {
            if (edgeType != null && !edgeType.equals(edge.getType())) continue;
            LinkedHashSet processedNodes = new LinkedHashSet();
            processedNodes.add(startNode);
            processedNodes.add(edge.getTargetNode());
            ArrayList<IParameterizedEdge<N, IParameterizedEdge<N, E>>> processedEdges = new ArrayList<IParameterizedEdge<N, IParameterizedEdge<N, E>>>();
            processedEdges.add(edge);
            this.getAllPaths(edge, startNode, endNode, processedNodes, processedEdges, allPaths, edgeType);
        }
        ArrayList<IParameterizedPath<N, E>> allPathsAsList = new ArrayList<IParameterizedPath<N, E>>();
        for (List list : allPaths) {
            allPathsAsList.add(this.convertToPath(list));
        }
        return Collections.unmodifiableList(allPathsAsList);
    }

    private void getAllPaths(IParameterizedEdge<N, E> currentEdge, N startNode, N endNode, Set<N> processedNodes, List<IParameterizedEdge<N, E>> processedEdges, List<List<IParameterizedEdge<N, E>>> allPaths, E edgeType) {
        if (currentEdge.getTargetNode().equals(endNode)) {
            allPaths.add(Collections.unmodifiableList(new ArrayList<IParameterizedEdge<N, E>>(processedEdges)));
            processedNodes.remove(currentEdge.getTargetNode());
            processedEdges.remove(currentEdge);
            return;
        }
        for (IParameterizedEdge edge : this.getEdges(currentEdge.getTargetNode())) {
            if (edgeType != null && !edgeType.equals(edge.getType())) continue;
            if (processedNodes.contains(edge.getTargetNode())) {
                if (!startNode.equals(endNode) || !startNode.equals(edge.getTargetNode())) continue;
                allPaths.add(Collections.unmodifiableList(new ArrayList<IParameterizedEdge<N, E>>(processedEdges)));
                continue;
            }
            processedNodes.add(edge.getTargetNode());
            processedEdges.add(edge);
            this.getAllPaths(edge, startNode, endNode, processedNodes, processedEdges, allPaths, edgeType);
        }
        processedNodes.remove(currentEdge.getTargetNode());
    }

    @Override
    public Collection<IParameterizedPath<N, E>> getShortestPaths(N startNode, N endNode) {
        return this.getShortestPaths(startNode, endNode, null);
    }

    @Override
    public Collection<IParameterizedPath<N, E>> getShortestPaths(N startNode, N endNode, E edgeType) {
        if (!this.m_nodesToEdges.containsKey(startNode)) {
            throw new IllegalArgumentException("The given start node does not exist in the graph.");
        }
        if (!this.m_nodesToEdges.containsKey(endNode)) {
            throw new IllegalArgumentException("The given end node does not exist in the graph.");
        }
        ArrayList<List<IParameterizedEdge<N, E>>> currentShortestPaths = new ArrayList<List<IParameterizedEdge<N, E>>>();
        for (IParameterizedEdge<N, E> edge : this.getEdges(startNode)) {
            if (edgeType != null && !edgeType.equals(edge.getType())) continue;
            LinkedHashSet processedNodes = new LinkedHashSet();
            processedNodes.add(startNode);
            processedNodes.add(edge.getTargetNode());
            ArrayList<IParameterizedEdge<N, IParameterizedEdge<N, E>>> processedEdges = new ArrayList<IParameterizedEdge<N, IParameterizedEdge<N, E>>>();
            processedEdges.add(edge);
            this.getShortestPaths(edge, startNode, endNode, new LinkedHashSet<N>(Collections.singleton(startNode)), processedEdges, currentShortestPaths, edgeType);
        }
        ArrayList<IParameterizedPath<N, E>> shortestPaths = new ArrayList<IParameterizedPath<N, E>>(currentShortestPaths.size());
        for (List list : currentShortestPaths) {
            shortestPaths.add(this.convertToPath(list));
        }
        return Collections.unmodifiableList(shortestPaths);
    }

    private void getShortestPaths(IParameterizedEdge<N, E> currentEdge, N startNode, N endNode, Set<N> processedNodes, List<IParameterizedEdge<N, E>> processedEdges, List<List<IParameterizedEdge<N, E>>> currentShortestPaths, E edgeType) {
        if (currentEdge.getTargetNode().equals(endNode)) {
            assert (currentShortestPaths.isEmpty() || processedNodes.size() <= currentShortestPaths.get(0).size());
            if (!currentShortestPaths.isEmpty() && processedNodes.size() < currentShortestPaths.get(0).size()) {
                currentShortestPaths.clear();
            }
            currentShortestPaths.add(Collections.unmodifiableList(new ArrayList<IParameterizedEdge<N, E>>(processedEdges)));
            processedNodes.remove(currentEdge.getTargetNode());
            processedEdges.remove(currentEdge);
            return;
        }
        for (IParameterizedEdge edge : this.getEdges(currentEdge.getTargetNode())) {
            if (edgeType != null && !edgeType.equals(edge.getType()) || processedNodes.contains(edge.getTargetNode())) continue;
            if (!currentShortestPaths.isEmpty() && processedNodes.size() == currentShortestPaths.get(0).size()) break;
            processedNodes.add(edge.getTargetNode());
            processedEdges.add(edge);
            this.getShortestPaths(edge, startNode, endNode, processedNodes, processedEdges, currentShortestPaths, edgeType);
        }
        processedNodes.remove(currentEdge.getTargetNode());
    }

    private IParameterizedPath<N, E> convertToPath(List<IParameterizedEdge<N, E>> path) {
        ArrayList pathNodes = new ArrayList(path.size() + 1);
        ArrayList<E> pathEdgeTypes = new ArrayList<E>(path.size());
        for (IParameterizedEdge<N, E> edge : path) {
            if (pathNodes.isEmpty()) {
                pathNodes.add(edge.getSourceNode());
            }
            pathNodes.add(edge.getTargetNode());
            pathEdgeTypes.add(edge.getType());
        }
        return new DefaultParameterizedPath(pathNodes, pathEdgeTypes);
    }

    @Override
    public Iterator<N> getDepthFirstIterator(N startNode) {
        return this.getDepthFirstIterator(startNode, null);
    }

    @Override
    public Iterator<N> getDepthFirstIterator(N startNode, E edgeType) {
        return new DepthFirstIterator<N, E>(this, startNode, edgeType);
    }

    @Override
    public Iterator<N> iterator() {
        return this.m_nodesToEdgesByTargetByType.keySet().iterator();
    }

    private static class DepthFirstIterator<N, E>
    implements Iterator<N> {
        private final Iterator<N> m_iterator;

        DepthFirstIterator(IParameterizedMultigraph<N, E> graph, N startNode, E edgeType) {
            if (graph == null) {
                throw new IllegalArgumentException();
            }
            LinkedHashSet processedNodes = new LinkedHashSet();
            this.populate(startNode, graph, processedNodes, edgeType);
            this.m_iterator = processedNodes.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        @Override
        public N next() {
            return this.m_iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void populate(N node, IParameterizedMultigraph<N, E> graph, Set<N> processedNodes, E edgeType) {
            if (processedNodes.add(node)) {
                for (IParameterizedEdge<N, E> edge : graph.getEdges(node)) {
                    if (edgeType != null && !edgeType.equals(edge.getType())) continue;
                    this.populate(edge.getTargetNode(), graph, processedNodes, edgeType);
                    this.populate(edge.getSourceNode(), graph, processedNodes, edgeType);
                }
            }
        }
    }
}

