/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.EdgeFilter;
import com.ibm.cognos.fpm.common.graph.EmptyTupleStore;
import com.ibm.cognos.fpm.common.graph.IPropertyGraph;
import com.ibm.cognos.fpm.common.graph.ITransaction;
import com.ibm.cognos.fpm.common.graph.InternalNodeKeyProxyCollection;
import com.ibm.cognos.fpm.common.graph.NodeInfo;
import com.ibm.cognos.fpm.common.graph.NodePropertyFilters;
import com.ibm.cognos.fpm.common.graph.PropertyGraphNodeFilter;
import com.ibm.cognos.fpm.common.graph.Tuple;
import com.ibm.cognos.fpm.common.graph.TupleElementIterator;
import com.ibm.cognos.fpm.common.graph.TupleStore;
import com.ibm.cognos.fpm.common.graph.TupleStoreConfiguration;
import com.ibm.cognos.fpm.common.graph.TupleStoreFactory;
import com.ibm.cognos.fpm.common.graph.TupleStoreStatisticsCollector;
import com.ibm.cognos.fpm.common.utility.KeyedHashSet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class PropertyGraphImpl<K>
extends AbstractCollection<K>
implements IPropertyGraph<K> {
    static final int DEFAULT_INITIAL_CAPACITY = 500;
    protected Map<K, NodeInfo> nodeInfos;
    protected final List<K> nodeIds;
    private final TupleStoreStatisticsCollector tupleStoreStats;
    protected final KeyedHashSet<String> edgeLabels;
    protected final KeyedHashSet<String> edgePropertyNames;
    protected final KeyedHashSet<Object> edgePropertyValues;
    protected final KeyedHashSet<Object> nodePropertyValues;
    protected final TupleStoreConfiguration nodePropertyTupleStoreConfig;
    protected final TupleStoreConfiguration adjacentNodesTupleStoreConfig;
    protected final TupleStoreConfiguration edgePropertyTupleStoreConfig;
    private final boolean collectTupleStoreStatistics = false;
    static final TupleStore EMPTY_TUPLE_STORE = new EmptyTupleStore();
    protected final Map<String, TupleStore> nodePropertyTupleStores;

    public String getStatistics() {
        return this.tupleStoreStats == null ? "" : this.tupleStoreStats.toString();
    }

    public TupleStoreStatisticsCollector getTupleStoreStats() {
        return this.tupleStoreStats;
    }

    public PropertyGraphImpl() {
        this(500);
    }

    public PropertyGraphImpl(int capacity) {
        this(capacity, 2, 3, 3);
    }

    public PropertyGraphImpl(int capacity, int nodePropertyTupleSize, int adjacentNodesTupleSize, int edgePropertyTupleSize) {
        this.nodeInfos = new HashMap<K, NodeInfo>(capacity, 0.9f);
        this.nodeIds = new ArrayList<K>(capacity);
        this.nodeIds.add(null);
        this.edgeLabels = new KeyedHashSet(capacity);
        this.edgePropertyNames = new KeyedHashSet(capacity);
        this.edgePropertyValues = new KeyedHashSet(capacity);
        this.nodePropertyValues = new KeyedHashSet(capacity);
        this.nodePropertyTupleStores = new HashMap<String, TupleStore>(500, 0.9f);
        this.tupleStoreStats = null;
        this.nodePropertyTupleStoreConfig = TupleStoreFactory.getInstance().createConfiguration(nodePropertyTupleSize, this.tupleStoreStats);
        this.adjacentNodesTupleStoreConfig = TupleStoreFactory.getInstance().createConfiguration(adjacentNodesTupleSize, 1250, 5, this.tupleStoreStats);
        this.edgePropertyTupleStoreConfig = TupleStoreFactory.getInstance().createConfiguration(edgePropertyTupleSize, 1250, 5, this.tupleStoreStats);
    }

    public PropertyGraphImpl(IPropertyGraph<K> graph) {
        this(graph.getNodeCount());
        for (Object node : graph) {
            this.addNode(node);
            for (String propertyName : graph.getNodePropertyNames(node)) {
                this.addNodeProperty(node, propertyName, graph.getNodeProperty(node, propertyName));
            }
            for (Object parentNode : graph.getIncomingNodes(node, 1)) {
                this.addNode(parentNode);
                for (String edgeLabel : graph.getEdgeLabels(parentNode, node)) {
                    this.addEdge(parentNode, node, edgeLabel);
                    for (Map.Entry<String, Object> edgeProperty : graph.getEdgeProperties(parentNode, node, edgeLabel).entrySet()) {
                        this.addEdgeProperty(parentNode, node, edgeLabel, edgeProperty.getKey(), edgeProperty.getValue());
                    }
                }
            }
            for (Object childNode : graph.getOutgoingNodes(node, 1)) {
                this.addNode(childNode);
                for (String edgeLabel : graph.getEdgeLabels(node, childNode)) {
                    this.addEdge(node, childNode, edgeLabel);
                    for (Map.Entry<String, Object> edgeProperty : graph.getEdgeProperties(node, childNode, edgeLabel).entrySet()) {
                        this.addEdgeProperty(node, childNode, edgeLabel, edgeProperty.getKey(), edgeProperty.getValue());
                    }
                }
            }
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getEdgeCount() {
        int edgeCount = 0;
        for (NodeInfo nodeInfo : this.nodeInfos.values()) {
            int incomingNodeCount = 0;
            for (Tuple tuple : nodeInfo.getAdjacentNodesTupleStore()) {
                if (tuple.getElement(0) >= 0) break;
                ++incomingNodeCount;
            }
            edgeCount += incomingNodeCount;
        }
        return edgeCount;
    }

    @Override
    public int getNodeCount() {
        return this.nodeInfos.size();
    }

    @Override
    public int getNodeCount(PropertyGraphNodeFilter<K> filter) {
        return this.findNodes(filter).size();
    }

    @Override
    public Collection<K> getNodeIds() {
        return Collections.unmodifiableList(this.nodeIds);
    }

    @Override
    public K getNodeId(int internalNodeId) {
        try {
            return this.nodeIds.get(internalNodeId);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public int getInternalNodeId(K nodeId) {
        return this.getNodeInfo(nodeId, true).getInternalNodeId();
    }

    @Override
    public boolean optimize() {
        boolean modified = false;
        for (K nodeKey : this.nodeIds) {
            if (nodeKey == null || !this.optimize(nodeKey)) continue;
            modified = true;
        }
        for (TupleStore nodePropertyTupleStore : this.nodePropertyTupleStores.values()) {
            if (!nodePropertyTupleStore.optimize()) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public NodeInfo getNodeInfo(K nodeId, boolean throwExceptionOnNotFound) {
        NodeInfo nodeInfo = this.nodeInfos.get(nodeId);
        if (nodeInfo == null && throwExceptionOnNotFound) {
            throw new IllegalArgumentException("The node with key '" + nodeId + "' doesn't exist in the graph.");
        }
        return nodeInfo;
    }

    @Override
    public K getNode(Object nodeId) {
        NodeInfo nodeInfo = this.nodeInfos.get(nodeId);
        if (nodeInfo == null) {
            return null;
        }
        return this.nodeIds.get(nodeInfo.getInternalNodeId());
    }

    @Override
    public NodeInfo getNodeInfo(int internalNodeId, boolean throwExceptionOnNotFound) {
        NodeInfo nodeInfo = this.nodeInfos.get(this.nodeIds.get(internalNodeId));
        if (nodeInfo == null && throwExceptionOnNotFound) {
            throw new IllegalArgumentException("The node with internal ID '" + internalNodeId + "' doesn't exist in the graph.");
        }
        return nodeInfo;
    }

    @Override
    public void checkIntegrity() {
        int i = 0;
        while (i < this.nodeIds.size()) {
            K nodeKey = this.nodeIds.get(i);
            if (nodeKey != null) {
                NodeInfo nodeInfo = this.nodeInfos.get(nodeKey);
                if (nodeInfo == null) {
                    throw new IllegalStateException("nodeInfo == null");
                }
                if (nodeInfo.getInternalNodeId() != i) {
                    throw new IllegalStateException("nodeInfo.getInternalNodeKey()");
                }
            } else {
                for (NodeInfo nodeInfo : this.nodeInfos.values()) {
                    if (!nodeInfo.getAdjacentNodesTupleStore().containsTuple(i)) continue;
                    throw new IllegalStateException("getParentTupleStore( true ).contains( i )");
                }
            }
            ++i;
        }
    }

    @Override
    public boolean optimize(K nodeId) {
        return this.getNodeInfo(nodeId, true).optimize();
    }

    @Override
    public boolean addNode(K nodeId) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, false);
        if (nodeInfo != null) {
            return false;
        }
        nodeInfo = new NodeInfo(this.nodeIds.size());
        this.nodeInfos.put(nodeId, nodeInfo);
        this.nodeIds.add(nodeId);
        return true;
    }

    @Override
    public K removeNode(K nodeId) {
        if (!this.nodeInfos.containsKey(nodeId)) {
            return null;
        }
        this.removeNodeProperties(nodeId);
        NodeInfo nodeInfo = this.nodeInfos.remove(nodeId);
        for (Tuple tuple : nodeInfo.getAdjacentNodesTupleStore()) {
            NodeInfo adjacentNodeInfo;
            TupleStore childTupleStoreToUpdate;
            boolean isIncoming;
            int adjacentNodeKey = tuple.getElement(0);
            boolean bl = isIncoming = adjacentNodeKey < 0;
            if (isIncoming) {
                adjacentNodeKey = Math.abs(adjacentNodeKey);
            }
            if ((childTupleStoreToUpdate = (adjacentNodeInfo = this.getNodeInfo(adjacentNodeKey, true)).getAdjacentNodesTupleStore(false, this.adjacentNodesTupleStoreConfig)) == null) {
                throw new IllegalStateException("The parent and child adjacency lists are out of synch.");
            }
            Tuple edgeTuple = childTupleStoreToUpdate.getTuple(isIncoming ? nodeInfo.getInternalNodeId() : -1 * nodeInfo.getInternalNodeId(), tuple.getElement(1));
            boolean removed = childTupleStoreToUpdate.removeTuple(edgeTuple);
            if (!removed || edgeTuple == null) {
                throw new IllegalStateException("The parent and child adjacency lists are out of synch.");
            }
            adjacentNodeInfo.getEdgePropertyTupleStore(false, this.edgePropertyTupleStoreConfig).removeTuple(edgeTuple.getElement(2));
        }
        this.nodeIds.set(nodeInfo.getInternalNodeId(), null);
        return nodeId;
    }

    @Override
    public boolean containsNode(K nodeId) {
        return this.getNodeInfo(nodeId, false) != null;
    }

    @Override
    public boolean containsNode(K nodeId, PropertyGraphNodeFilter<K> filter) {
        return this.getNodeInfo(nodeId, false) != null && !this.filterNodes(Collections.singletonList(nodeId), filter).isEmpty();
    }

    @Override
    public K getIncomingNode(K nodeId) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
        TupleStore incomingNodesTupleStore = nodeInfo.getAdjacentNodesTupleStore();
        if (incomingNodesTupleStore.size() == 0) {
            return null;
        }
        TupleElementIterator incomingNodeKeyIterator = incomingNodesTupleStore.getTupleElementIterator(0);
        int incomingNodeKey = incomingNodeKeyIterator.next();
        if (incomingNodeKey > 0) {
            return null;
        }
        if (incomingNodeKeyIterator.hasNext() && incomingNodeKeyIterator.next() < 0) {
            throw new UnsupportedOperationException("The node with key '" + nodeId + "' has multiple incoming nodes.");
        }
        return this.nodeIds.get(Math.abs(incomingNodeKey));
    }

    @Override
    public Collection<K> getIncomingNodes(K nodeId, int hopCount) {
        return this.getIncomingNodes(nodeId, hopCount, null, null);
    }

    @Override
    public Collection<K> getIncomingNodes(K nodeId, int hopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        if (hopCount <= 1) {
            return Collections.unmodifiableCollection(this.getIncomingNodes(nodeId, nodeFilter, edgeFilter));
        }
        Collection<K> incomingNodes = this.getIncomingNodes(nodeId, null, edgeFilter);
        Collection<K> allIncomingNodes = new LinkedHashSet<K>(incomingNodes);
        for (K incomingNode : incomingNodes) {
            this.getIncomingNodes(incomingNode, hopCount, 2, null, edgeFilter, allIncomingNodes);
        }
        if (nodeFilter != null) {
            allIncomingNodes = this.filterNodes(allIncomingNodes, nodeFilter);
        }
        return Collections.unmodifiableCollection(allIncomingNodes);
    }

    private void getIncomingNodes(K nodeId, int maxHopCount, int currentHopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter, Collection<K> allIncomingNodes) {
        Collection<K> incomingNodes = this.getIncomingNodes(nodeId, nodeFilter, edgeFilter);
        allIncomingNodes.addAll(incomingNodes);
        if (currentHopCount + 1 <= maxHopCount) {
            for (K incomingNode : incomingNodes) {
                this.getIncomingNodes(incomingNode, maxHopCount, currentHopCount + 1, nodeFilter, edgeFilter, allIncomingNodes);
            }
        }
    }

    private Collection<K> getIncomingNodes(K nodeId, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        Iterator<Object> it;
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
        TupleStore tupleStore = nodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig);
        if (nodeFilter == null && edgeFilter == null) {
            return new InternalNodeKeyProxyCollection(this, tupleStore, InternalNodeKeyProxyCollection.NODE_KEY_SIGN.NEGATIVE);
        }
        if (edgeFilter != null && !edgeFilter.getEdgeLabelsToFilterOn().isEmpty()) {
            int[] edgeLabelIds = new int[edgeFilter.getEdgeLabelsToFilterOn().size()];
            int i = 0;
            for (String edgeLabel : edgeFilter.getEdgeLabelsToFilterOn()) {
                edgeLabelIds[i] = this.edgeLabels.getKey(edgeLabel);
                ++i;
            }
            it = tupleStore.getFilteredIterator(1, edgeLabelIds);
        } else {
            it = tupleStore.iterator();
        }
        Collection<K> filteredAdjacentParentNodeKeys = null;
        while (it.hasNext()) {
            Tuple tuple = (Tuple)it.next();
            int adjacentNodeKey = tuple.getElement(0);
            if (adjacentNodeKey > 0) break;
            adjacentNodeKey = Math.abs(adjacentNodeKey);
            K adjacentNodeId = this.nodeIds.get(adjacentNodeKey);
            boolean add = true;
            if (edgeFilter != null && edgeFilter.callEvaluate()) {
                String edgeLabel = this.edgeLabels.get(tuple.getElement(1));
                add = edgeFilter.evaluate(adjacentNodeId, nodeId, edgeLabel);
            }
            if (!add) continue;
            if (filteredAdjacentParentNodeKeys == null) {
                filteredAdjacentParentNodeKeys = new ArrayList<K>();
            }
            filteredAdjacentParentNodeKeys.add(adjacentNodeId);
        }
        Collection<K> toReturn = filteredAdjacentParentNodeKeys;
        if (toReturn != null && nodeFilter != null) {
            toReturn = this.filterNodes(filteredAdjacentParentNodeKeys, nodeFilter);
        }
        return toReturn == null ? Collections.emptySet() : Collections.unmodifiableCollection(toReturn);
    }

    @Override
    public int getIncomingNodeCount(K nodeId, int hopCount) {
        return this.getIncomingNodeCount(nodeId, hopCount, null, null);
    }

    @Override
    public int getIncomingNodeCount(K nodeId, int hopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        Iterator<Object> it;
        if (hopCount > 1) {
            return this.getIncomingNodes(nodeId, hopCount, nodeFilter, edgeFilter).size();
        }
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
        TupleStore tupleStore = nodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig);
        if (edgeFilter != null && !edgeFilter.getEdgeLabelsToFilterOn().isEmpty()) {
            int[] edgeLabelIds = new int[edgeFilter.getEdgeLabelsToFilterOn().size()];
            int i = 0;
            for (String edgeLabel : edgeFilter.getEdgeLabelsToFilterOn()) {
                edgeLabelIds[i] = this.edgeLabels.getKey(edgeLabel);
                ++i;
            }
            it = tupleStore.getFilteredIterator(1, edgeLabelIds);
        } else {
            it = tupleStore.iterator();
        }
        Map<String, List<Integer>> internalNodePropertyFilters = null;
        if (nodeFilter != null && nodeFilter.getNodePropertyFilters() != null) {
            internalNodePropertyFilters = this.getInternalRepresentation(nodeFilter.getNodePropertyFilters());
        }
        int incomingNodeCount = 0;
        while (it.hasNext()) {
            Tuple tuple = (Tuple)it.next();
            int adjacentNodeKey = tuple.getElement(0);
            if (adjacentNodeKey > 0) continue;
            adjacentNodeKey = Math.abs(adjacentNodeKey);
            K adjacentNodeId = this.nodeIds.get(adjacentNodeKey);
            boolean add = true;
            if (edgeFilter != null && edgeFilter.callEvaluate()) {
                String edgeLabel = this.edgeLabels.get(tuple.getElement(1));
                add = edgeFilter.evaluate(adjacentNodeId, nodeId, edgeLabel);
            }
            if (add && nodeFilter != null) {
                if (internalNodePropertyFilters != null) {
                    boolean passesNodePropertyFilter = false;
                    for (Map.Entry<String, List<Integer>> nodePropertyFilter : internalNodePropertyFilters.entrySet()) {
                        TupleStore nodePropTupleStore = this.getNodePropertyTupleStore(nodePropertyFilter.getKey(), true);
                        for (Integer propertyValueKey : nodePropertyFilter.getValue()) {
                            if (!nodePropTupleStore.containsTuple(adjacentNodeKey, propertyValueKey)) continue;
                            passesNodePropertyFilter = true;
                            break;
                        }
                        if (!passesNodePropertyFilter) break;
                    }
                    add = passesNodePropertyFilter;
                }
                if (add && nodeFilter.callEvaluate()) {
                    add = nodeFilter.evaluate(adjacentNodeId);
                }
            }
            if (!add) continue;
            ++incomingNodeCount;
        }
        return incomingNodeCount;
    }

    @Override
    public boolean isIncomingNode(K potentialIncomingNodeId, K nodeId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Collection<K> getRootNodes() {
        ArrayList<K> rootNodes = new ArrayList<K>();
        for (K nodeId : this) {
            if (this.getIncomingNodeCount(nodeId, 1) != 0) continue;
            rootNodes.add(nodeId);
        }
        return Collections.unmodifiableCollection(rootNodes);
    }

    @Override
    public Collection<K> getRootNodes(PropertyGraphNodeFilter<K> nodeFilter) {
        Collection<K> rootNodes = new ArrayList();
        for (K nodeId : this) {
            if (this.getIncomingNodeCount(nodeId, 1) != 0) continue;
            rootNodes.add(nodeId);
        }
        if (nodeFilter != null) {
            rootNodes = this.filterNodes(rootNodes, nodeFilter);
        }
        return Collections.unmodifiableCollection(rootNodes);
    }

    @Override
    public Collection<K> getOutgoingNodes(K nodeId, int hopCount) {
        return this.getOutgoingNodes(nodeId, hopCount, null, null);
    }

    @Override
    public Collection<K> getOutgoingNodes(K nodeId, int hopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        if (hopCount <= 1) {
            return Collections.unmodifiableCollection(this.getOutgoingNodes(nodeId, nodeFilter, edgeFilter));
        }
        Collection<K> outgoingNodes = this.getOutgoingNodes(nodeId, null, edgeFilter);
        Collection<K> allOutgoingNodes = new LinkedHashSet<K>(outgoingNodes);
        for (K outgoingNode : outgoingNodes) {
            this.getOutgoingNodes(outgoingNode, hopCount, 2, null, edgeFilter, allOutgoingNodes);
        }
        if (nodeFilter != null) {
            allOutgoingNodes = this.filterNodes(allOutgoingNodes, nodeFilter);
        }
        return Collections.unmodifiableCollection(allOutgoingNodes);
    }

    private void getOutgoingNodes(K nodeId, int maxHopCount, int currentHopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter, Collection<K> allOutgoingNodes) {
        Collection<K> outgoingNodes = this.getOutgoingNodes(nodeId, nodeFilter, edgeFilter);
        allOutgoingNodes.addAll(outgoingNodes);
        if (currentHopCount + 1 <= maxHopCount) {
            for (K outgoingNode : outgoingNodes) {
                this.getOutgoingNodes(outgoingNode, maxHopCount, currentHopCount + 1, nodeFilter, edgeFilter, allOutgoingNodes);
            }
        }
    }

    private Collection<K> getOutgoingNodes(K nodeId, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        Iterator<Object> it;
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
        TupleStore tupleStore = nodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig);
        if (nodeFilter == null && edgeFilter == null) {
            return new InternalNodeKeyProxyCollection(this, tupleStore, InternalNodeKeyProxyCollection.NODE_KEY_SIGN.POSITIVE);
        }
        if (edgeFilter != null && !edgeFilter.getEdgeLabelsToFilterOn().isEmpty()) {
            int[] edgeLabelIds = new int[edgeFilter.getEdgeLabelsToFilterOn().size()];
            int i = 0;
            for (String edgeLabel : edgeFilter.getEdgeLabelsToFilterOn()) {
                edgeLabelIds[i] = this.edgeLabels.getKey(edgeLabel);
                ++i;
            }
            it = tupleStore.getFilteredIterator(1, edgeLabelIds);
        } else {
            it = tupleStore.iterator();
        }
        Collection<K> filteredAdjacentParentNodeKeys = null;
        while (it.hasNext()) {
            Tuple tuple = (Tuple)it.next();
            int adjacentNodeKey = tuple.getElement(0);
            if (adjacentNodeKey < 0) continue;
            K adjacentNodeId = this.nodeIds.get(adjacentNodeKey);
            boolean add = true;
            if (edgeFilter != null && edgeFilter.callEvaluate()) {
                String edgeLabel = this.edgeLabels.get(tuple.getElement(1));
                add = edgeFilter.evaluate(nodeId, adjacentNodeId, edgeLabel);
            }
            if (!add) continue;
            if (filteredAdjacentParentNodeKeys == null) {
                filteredAdjacentParentNodeKeys = new ArrayList<K>();
            }
            filteredAdjacentParentNodeKeys.add(adjacentNodeId);
        }
        Collection<K> toReturn = filteredAdjacentParentNodeKeys;
        if (toReturn != null && nodeFilter != null) {
            toReturn = this.filterNodes(filteredAdjacentParentNodeKeys, nodeFilter);
        }
        return toReturn == null ? Collections.emptySet() : Collections.unmodifiableCollection(toReturn);
    }

    @Override
    public boolean isOutgoingNode(K potentialOutgoingNodeId, K nodeId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public int getOutgoingNodeCount(K nodeId, int hopCount) {
        return this.getOutgoingNodeCount(nodeId, hopCount, null, null);
    }

    @Override
    public int getOutgoingNodeCount(K nodeId, int hopCount, PropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        Iterator<Object> it;
        if (hopCount > 1) {
            throw new UnsupportedOperationException("Do not support multi-hop yet.");
        }
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
        TupleStore tupleStore = nodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig);
        if (edgeFilter != null && !edgeFilter.getEdgeLabelsToFilterOn().isEmpty()) {
            int[] edgeLabelIds = new int[edgeFilter.getEdgeLabelsToFilterOn().size()];
            int i = 0;
            for (String edgeLabel : edgeFilter.getEdgeLabelsToFilterOn()) {
                edgeLabelIds[i] = this.edgeLabels.getKey(edgeLabel);
                ++i;
            }
            it = tupleStore.getFilteredIterator(1, edgeLabelIds);
        } else {
            it = tupleStore.iterator();
        }
        Map<String, List<Integer>> internalNodePropertyFilters = null;
        if (nodeFilter != null && nodeFilter.getNodePropertyFilters() != null) {
            internalNodePropertyFilters = this.getInternalRepresentation(nodeFilter.getNodePropertyFilters());
        }
        int outgoingNodeCount = 0;
        while (it.hasNext()) {
            Tuple tuple = (Tuple)it.next();
            int adjacentNodeKey = tuple.getElement(0);
            if (adjacentNodeKey < 0) continue;
            K adjacentNodeId = this.nodeIds.get(adjacentNodeKey);
            boolean add = true;
            if (edgeFilter != null && edgeFilter.callEvaluate()) {
                String edgeLabel = this.edgeLabels.get(tuple.getElement(1));
                add = edgeFilter.evaluate(nodeId, adjacentNodeId, edgeLabel);
            }
            if (add && nodeFilter != null) {
                if (internalNodePropertyFilters != null) {
                    boolean passesNodePropertyFilter = false;
                    for (Map.Entry<String, List<Integer>> internalNodePropertyFilter : internalNodePropertyFilters.entrySet()) {
                        TupleStore nodePropTupleStore = this.getNodePropertyTupleStore(internalNodePropertyFilter.getKey(), true);
                        for (Integer propertyValueKey : internalNodePropertyFilter.getValue()) {
                            if (!nodePropTupleStore.containsTuple(adjacentNodeKey, propertyValueKey)) continue;
                            passesNodePropertyFilter = true;
                            break;
                        }
                        if (!passesNodePropertyFilter) break;
                    }
                    add = passesNodePropertyFilter;
                }
                if (add && nodeFilter.callEvaluate()) {
                    add = nodeFilter.evaluate(adjacentNodeId);
                }
            }
            if (!add) continue;
            ++outgoingNodeCount;
        }
        return outgoingNodeCount;
    }

    private Map<String, List<Integer>> getInternalRepresentation(NodePropertyFilters nodePropertyFilters) {
        assert (nodePropertyFilters != null);
        HashMap<String, List<Integer>> internalNodePropertyFilters = new HashMap<String, List<Integer>>();
        Map<String, List<Object>> filters = nodePropertyFilters.getFilters();
        for (Map.Entry<String, List<Object>> entry : filters.entrySet()) {
            if (!this.nodePropertyTupleStores.containsKey(entry.getKey())) continue;
            ArrayList<Integer> propertyValueKeys = new ArrayList<Integer>(entry.getValue().size());
            for (Object propertyValue : entry.getValue()) {
                propertyValueKeys.add(this.nodePropertyValues.getKey(propertyValue));
            }
        }
        return internalNodePropertyFilters;
    }

    @Override
    public boolean hasOutgoingNodes(K nodeKey, PropertyGraphNodeFilter<K> filter, EdgeFilter<K> edgeFilter) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean hasIncomingNodes(K nodeKey, PropertyGraphNodeFilter<K> filter, EdgeFilter<K> edgeFilter) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public K removeNode(K nodeId, boolean cascadeToOutgoingNodes) {
        if (cascadeToOutgoingNodes) {
            Iterator<K> nodesToRemove = this.getDepthFirstPostOrderIterator(nodeId);
            while (nodesToRemove.hasNext()) {
                nodesToRemove.next();
                nodesToRemove.remove();
            }
        }
        return this.removeNode(nodeId);
    }

    @Override
    public boolean addEdge(K sourceNodeId, K targetNodeId, String label) {
        int internalLabelKey = this.edgeLabels.getKey(label);
        if (internalLabelKey == -1) {
            internalLabelKey = this.edgeLabels.addAndReturnKey(label);
        }
        return this.addEdge(sourceNodeId, targetNodeId, internalLabelKey);
    }

    private boolean addEdge(K sourceNodeId, K targetNodeId, int internalLabelKey) {
        NodeInfo targetNodeInfo;
        NodeInfo sourceNodeInfo = this.getNodeInfo(sourceNodeId, true);
        if (this.hasDirectedEdge(sourceNodeInfo, targetNodeInfo = this.getNodeInfo(targetNodeId, true), internalLabelKey)) {
            return false;
        }
        boolean addedToOutgoing = sourceNodeInfo.getAdjacentNodesTupleStore(false, this.adjacentNodesTupleStoreConfig).addTuple(targetNodeInfo.getInternalNodeId(), internalLabelKey, sourceNodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig).size());
        boolean addedToIncoming = targetNodeInfo.getAdjacentNodesTupleStore(false, this.adjacentNodesTupleStoreConfig).addTuple(-1 * sourceNodeInfo.getInternalNodeId(), internalLabelKey, targetNodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig).size());
        if (addedToOutgoing != addedToIncoming) {
            throw new IllegalStateException("The outgoing and incoming node adjacency lists are out of synch.");
        }
        return addedToOutgoing;
    }

    private boolean hasDirectedEdge(NodeInfo sourceNodeInfo, NodeInfo targetNodeInfo, int edgeLabelKey) {
        if (sourceNodeInfo.getAdjacentNodesTupleStore().size() < targetNodeInfo.getAdjacentNodesTupleStore().size()) {
            return sourceNodeInfo.getAdjacentNodesTupleStore().containsTuple(targetNodeInfo.getInternalNodeId(), edgeLabelKey);
        }
        return targetNodeInfo.getAdjacentNodesTupleStore().containsTuple(-1 * sourceNodeInfo.getInternalNodeId(), edgeLabelKey);
    }

    @Override
    public boolean removeEdge(K sourceNodeId, K targetNodeId, String label) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(sourceNodeId, true);
        NodeInfo targetNodeInfo = this.getNodeInfo(targetNodeId, true);
        int internalLabelKey = this.edgeLabels.getKey(label);
        if (internalLabelKey == -1) {
            return false;
        }
        this.removeEdgeProperties(sourceNodeInfo, targetNodeInfo, internalLabelKey);
        boolean removedFromOutgoing = sourceNodeInfo.getAdjacentNodesTupleStore(false, this.adjacentNodesTupleStoreConfig).removeTuple(targetNodeInfo.getInternalNodeId(), internalLabelKey);
        boolean removedFromIncoming = targetNodeInfo.getAdjacentNodesTupleStore(false, this.adjacentNodesTupleStoreConfig).removeTuple(-1 * sourceNodeInfo.getInternalNodeId(), internalLabelKey);
        if (removedFromOutgoing != removedFromIncoming) {
            throw new IllegalStateException("The outgoing and incoming node adjacency lists are out of synch.");
        }
        return removedFromOutgoing;
    }

    @Override
    public boolean hasEdge(K sourceNodeId, K targetNodeId, String label) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(sourceNodeId, true);
        NodeInfo targetNodeInfo = this.getNodeInfo(targetNodeId, true);
        int internalLabelKey = this.edgeLabels.getKey(label);
        if (internalLabelKey == -1) {
            return false;
        }
        if (this.hasDirectedEdge(sourceNodeInfo, targetNodeInfo, internalLabelKey)) {
            return true;
        }
        return this.hasDirectedEdge(targetNodeInfo, sourceNodeInfo, internalLabelKey);
    }

    @Override
    public Collection<String> getEdgeLabels(K sourceNodeId, K targetNodeId) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(sourceNodeId, true);
        NodeInfo targetNodeInfo = this.getNodeInfo(targetNodeId, true);
        final List<Tuple> outgoingEdgeTuples = sourceNodeInfo.getAdjacentNodesTupleStore().getTuples(targetNodeInfo.getInternalNodeId());
        if (outgoingEdgeTuples.isEmpty()) {
            return Collections.emptyList();
        }
        return new AbstractCollection<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < outgoingEdgeTuples.size();
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return (this).PropertyGraphImpl.this.edgeLabels.get(((Tuple)outgoingEdgeTuples.get(this.pos++)).getElement(1));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return outgoingEdgeTuples.size();
            }
        };
    }

    @Override
    public Object addEdgeProperty(K sourceNode, K targetNode, String label, String propertyName, Object propertyValue) {
        int edgePropertyValueIndex;
        NodeInfo sourceNodeInfo = this.getNodeInfo(sourceNode, true);
        NodeInfo targetNodeInfo = this.getNodeInfo(targetNode, true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            throw new IllegalArgumentException("There is no edge between '" + sourceNode + "' and '" + targetNode + "' with the label '" + label + "'.");
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getAdjacentNodesTupleStore().getTuple(targetNodeInfo.getInternalNodeId(), edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            throw new IllegalArgumentException("There is no edge between '" + sourceNode + "' and '" + targetNode + "' with the label '" + label + "'.");
        }
        int edgePropertyNameIndex = this.edgePropertyNames.getKey(propertyName);
        if (edgePropertyNameIndex == -1) {
            edgePropertyNameIndex = this.edgePropertyNames.addAndReturnKey(propertyName);
        }
        Object oldPropertyValue = null;
        List<Tuple> outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(2), edgePropertyNameIndex);
        if (outgoingEdgePropertyTuples.size() > 1) {
            throw new IllegalStateException("Multiple edge property value identifiers are mapped to the same edge.");
        }
        if (!outgoingEdgePropertyTuples.isEmpty()) {
            oldPropertyValue = this.edgePropertyValues.get(outgoingEdgePropertyTuples.get(0).getElement(2));
            if (oldPropertyValue.equals(propertyValue)) {
                return oldPropertyValue;
            }
            sourceNodeInfo.getEdgePropertyTupleStore(false, this.edgePropertyTupleStoreConfig).removeTuple(outgoingEdgePropertyTuples.get(0));
        }
        if ((edgePropertyValueIndex = this.edgePropertyValues.getKey(propertyValue)) == -1) {
            edgePropertyValueIndex = this.edgePropertyValues.addAndReturnKey(propertyValue);
        }
        sourceNodeInfo.getEdgePropertyTupleStore(false, this.edgePropertyTupleStoreConfig).addTuple(outgoingEdgeTuple.getElement(2), edgePropertyNameIndex, edgePropertyValueIndex);
        return oldPropertyValue;
    }

    @Override
    public Object getEdgeProperty(K sourceNodeId, K targetNodeId, String label, String propertyName) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(sourceNodeId, true);
        NodeInfo targetNodeInfo = this.getNodeInfo(targetNodeId, true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            return null;
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getAdjacentNodesTupleStore().getTuple(targetNodeInfo.getInternalNodeId(), edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            return null;
        }
        int edgePropertyNameIndex = this.edgePropertyNames.getKey(propertyName);
        if (edgePropertyNameIndex == -1) {
            return null;
        }
        List<Tuple> outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(2), edgePropertyNameIndex);
        if (outgoingEdgePropertyTuples.isEmpty()) {
            return null;
        }
        if (outgoingEdgePropertyTuples.size() > 1) {
            throw new IllegalStateException("Multiple edge property value identifiers are mapped to the same edge.");
        }
        return this.edgePropertyValues.get(outgoingEdgePropertyTuples.get(0).getElement(2));
    }

    @Override
    public Map<String, Object> getEdgeProperties(K sourceNodeId, K targetNodeId, String label) {
        final NodeInfo sourceNodeInfo = this.getNodeInfo(sourceNodeId, true);
        NodeInfo targetNodeInfo = this.getNodeInfo(targetNodeId, true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            return Collections.emptyMap();
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getAdjacentNodesTupleStore().getTuple(targetNodeInfo.getInternalNodeId(), edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            return Collections.emptyMap();
        }
        final List<Tuple> outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(2));
        if (outgoingEdgePropertyTuples.isEmpty()) {
            return Collections.emptyMap();
        }
        return new AbstractMap<String, Object>(){
            private int size;
            {
                this.size = list.size();
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return new AbstractSet<Map.Entry<String, Object>>(){

                    @Override
                    public Iterator<Map.Entry<String, Object>> iterator() {
                        return new Iterator<Map.Entry<String, Object>>(){
                            private int pos = 0;

                            @Override
                            public boolean hasNext() {
                                return this.pos < outgoingEdgePropertyTuples.size();
                            }

                            @Override
                            public Map.Entry<String, Object> next() {
                                if (!this.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                final Tuple outgoingEdgePropertyTuple = (Tuple)outgoingEdgePropertyTuples.get(this.pos++);
                                return new Map.Entry<String, Object>(){

                                    @Override
                                    public String getKey() {
                                        return (((this).this).this).PropertyGraphImpl.this.edgePropertyNames.get(outgoingEdgePropertyTuple.getElement(1));
                                    }

                                    @Override
                                    public Object getValue() {
                                        return (((this).this).this).PropertyGraphImpl.this.edgePropertyValues.get(outgoingEdgePropertyTuple.getElement(2));
                                    }

                                    @Override
                                    public Object setValue(Object object) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                if (this.pos == 0) {
                                    throw new IllegalStateException();
                                }
                                Tuple outgoingEdgePropertyTuple = (Tuple)outgoingEdgePropertyTuples.get(this.pos - 1);
                                sourceNodeInfo.getEdgePropertyTupleStore(false, ((this).this).PropertyGraphImpl.this.edgePropertyTupleStoreConfig).removeTuple(outgoingEdgePropertyTuple);
                                outgoingEdgePropertyTuples.set(this.pos - 1, null);
                                2 v0 = this;
                                v0.size = v0.size - 1;
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return outgoingEdgePropertyTuples.size();
                    }
                };
            }
        };
    }

    @Override
    public Collection<String> getEdgePropertyNames(K sourceNodeId, K targetNodeId, String label) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(sourceNodeId, true);
        NodeInfo targetNodeInfo = this.getNodeInfo(targetNodeId, true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            return Collections.emptyList();
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getAdjacentNodesTupleStore().getTuple(targetNodeInfo.getInternalNodeId(), edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            return Collections.emptyList();
        }
        final List<Tuple> outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(2));
        if (outgoingEdgePropertyTuples.isEmpty()) {
            return Collections.emptyList();
        }
        return new AbstractCollection<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < outgoingEdgePropertyTuples.size();
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return (this).PropertyGraphImpl.this.edgePropertyNames.get(((Tuple)outgoingEdgePropertyTuples.get(this.pos++)).getElement(1));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return outgoingEdgePropertyTuples.size();
            }
        };
    }

    @Override
    public Object removeEdgeProperty(K sourceNodeId, K targetNodeId, String label, String propertyName) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(sourceNodeId, true);
        NodeInfo targetNodeInfo = this.getNodeInfo(targetNodeId, true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            return null;
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getAdjacentNodesTupleStore().getTuple(targetNodeInfo.getInternalNodeId(), edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            return null;
        }
        int edgePropertyNameKey = this.edgePropertyNames.getKey(propertyName);
        if (edgePropertyNameKey == -1) {
            return null;
        }
        List<Tuple> outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(2), edgePropertyNameKey);
        if (outgoingEdgePropertyTuples.isEmpty()) {
            return null;
        }
        if (outgoingEdgePropertyTuples.size() > 1) {
            throw new IllegalStateException("Multiple edge property value identifiers are mapped to the same edge.");
        }
        Object removedValue = this.edgePropertyValues.get(outgoingEdgePropertyTuples.get(0).getElement(2));
        sourceNodeInfo.getEdgePropertyTupleStore(false, this.edgePropertyTupleStoreConfig).removeTuple(outgoingEdgePropertyTuples.get(0));
        return removedValue;
    }

    @Override
    public boolean removeEdgeProperties(K sourceNodeId, K targetNodeId, String label) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(sourceNodeId, true);
        NodeInfo targetNodeInfo = this.getNodeInfo(targetNodeId, true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            return false;
        }
        return this.removeEdgeProperties(sourceNodeInfo, targetNodeInfo, edgeLabelKey);
    }

    private boolean removeEdgeProperties(NodeInfo sourceNodeInfo, NodeInfo targetNodeInfo, int edgeLabelKey) {
        Tuple outgoingEdgeTuple = sourceNodeInfo.getAdjacentNodesTupleStore().getTuple(targetNodeInfo.getInternalNodeId(), edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            return false;
        }
        TupleStore edgePropertyTupleStore = sourceNodeInfo.getEdgePropertyTupleStore();
        List<Tuple> outgoingEdgePropertyTuples = edgePropertyTupleStore.getTuples(outgoingEdgeTuple.getElement(2));
        if (outgoingEdgePropertyTuples.isEmpty()) {
            return false;
        }
        for (Tuple outgoingEdgePropertyTuple : outgoingEdgePropertyTuples) {
            edgePropertyTupleStore.removeTuple(outgoingEdgePropertyTuple);
        }
        return true;
    }

    @Override
    public boolean hasEdgeProperty(K sourceNodeId, K targetNodeId, String label, String propertyName) {
        NodeInfo sourceNodeInfo = this.getNodeInfo(sourceNodeId, true);
        NodeInfo targetNodeInfo = this.getNodeInfo(targetNodeId, true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            return false;
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getAdjacentNodesTupleStore().getTuple(targetNodeInfo.getInternalNodeId(), edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            return false;
        }
        int edgePropertyNameIndex = this.edgePropertyNames.getKey(propertyName);
        if (edgePropertyNameIndex == -1) {
            return false;
        }
        return sourceNodeInfo.getEdgePropertyTupleStore().containsTuple(outgoingEdgeTuple.getElement(2), edgePropertyNameIndex);
    }

    @Override
    public Object removeNodeProperty(K nodeId, String propertyName) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
        if (!this.nodePropertyTupleStores.containsKey(propertyName)) {
            return null;
        }
        Tuple propTuple = this.getNodePropertyTupleStore(propertyName, true).getTuple(nodeInfo.getInternalNodeId());
        if (propTuple == null) {
            return null;
        }
        int propertyValueKey = propTuple.getElement(1);
        Object oldPropertyValue = this.nodePropertyValues.get(propertyValueKey);
        assert (oldPropertyValue != null);
        boolean removed = this.getNodePropertyTupleStore(propertyName, false).removeTuple(propTuple);
        assert (removed);
        return oldPropertyValue;
    }

    @Override
    public boolean removeNodeProperties(K nodeId) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
        boolean removed = false;
        for (Map.Entry<String, TupleStore> nodePropertyTupleStore : this.nodePropertyTupleStores.entrySet()) {
            if (!nodePropertyTupleStore.getValue().containsTuple(nodeInfo.getInternalNodeId())) continue;
            nodePropertyTupleStore.getValue().removeTuple(nodeInfo.getInternalNodeId());
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean hasNodeProperty(K nodeId, String propertyName) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
        if (!this.nodePropertyTupleStores.containsKey(propertyName)) {
            return false;
        }
        return this.getNodePropertyTupleStore(propertyName).containsTuple(nodeInfo.getInternalNodeId());
    }

    @Override
    public boolean hasNodeProperties(K nodeId) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
        for (Map.Entry<String, TupleStore> nodePropertyTupleStore : this.nodePropertyTupleStores.entrySet()) {
            if (!nodePropertyTupleStore.getValue().containsTuple(nodeInfo.getInternalNodeId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object addNodeProperty(K nodeId, String propertyName, Object propertyValue) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
        int propertyValueKey = this.nodePropertyValues.getKey(propertyValue);
        if (propertyValueKey == -1) {
            propertyValueKey = this.nodePropertyValues.addAndReturnKey(propertyValue);
        }
        Object oldPropertyValue = null;
        Tuple propTuple = this.getNodePropertyTupleStore(propertyName, true).getTuple(nodeInfo.getInternalNodeId());
        if (propTuple != null) {
            int oldPropValueKey = propTuple.getElement(1);
            if (oldPropValueKey == propertyValueKey) {
                return propertyValue;
            }
            oldPropertyValue = this.nodePropertyValues.get(oldPropValueKey);
            boolean removed = this.getNodePropertyTupleStore(propertyName, false).removeTuple(propTuple);
            assert (removed);
        }
        boolean added = this.getNodePropertyTupleStore(propertyName, false).addTuple(nodeInfo.getInternalNodeId(), propertyValueKey);
        assert (added);
        return oldPropertyValue;
    }

    @Override
    public Object getNodeProperty(K nodeId, String propertyName) {
        if (!this.nodePropertyTupleStores.containsKey(propertyName)) {
            return null;
        }
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
        Tuple propTuple = this.getNodePropertyTupleStore(propertyName, true).getTuple(nodeInfo.getInternalNodeId());
        if (propTuple == null) {
            return null;
        }
        int propValueKey = propTuple.getElement(1);
        return this.nodePropertyValues.get(propValueKey);
    }

    @Override
    public Map<String, Object> getNodeProperties(K nodeId) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
        HashMap<String, Object> nodeProps = new HashMap<String, Object>();
        for (Map.Entry<String, TupleStore> nodePropertyTupleStore : this.nodePropertyTupleStores.entrySet()) {
            for (Tuple tuple : nodePropertyTupleStore.getValue().getTuples(nodeInfo.getInternalNodeId())) {
                Object propertyValue = this.nodePropertyValues.get(tuple.getElement(1));
                assert (propertyValue != null);
                nodeProps.put(nodePropertyTupleStore.getKey(), propertyValue);
            }
        }
        return nodeProps;
    }

    @Override
    public Collection<String> getNodePropertyNames(K nodeId) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
        HashSet<String> nodePropNames = new HashSet<String>();
        for (Map.Entry<String, TupleStore> nodePropertyTupleStore : this.nodePropertyTupleStores.entrySet()) {
            if (nodePropertyTupleStore.getValue().getTuple(nodeInfo.getInternalNodeId()) == null) continue;
            nodePropNames.add(nodePropertyTupleStore.getKey());
        }
        return nodePropNames;
    }

    @Override
    public Collection<K> findNodes(PropertyGraphNodeFilter<K> filter) {
        return this.filterNodes(this.nodeIds, filter);
    }

    private Collection<K> filterNodes(Collection<K> nodesToFilter, PropertyGraphNodeFilter<K> filter) {
        assert (nodesToFilter != null);
        assert (filter != null);
        NodePropertyFilters propFilters = filter.getNodePropertyFilters();
        Collection<K> filteredNodes = nodesToFilter;
        if (propFilters != null) {
            Map<String, List<Object>> filters = propFilters.getFilters();
            for (Map.Entry<String, List<Object>> entry : filters.entrySet()) {
                String propertyName = entry.getKey();
                if (!this.nodePropertyTupleStores.containsKey(propertyName)) continue;
                List<Object> propertyValues = entry.getValue();
                int[] propertyValueKeys = new int[propertyValues.size()];
                int i = 0;
                while (i < propertyValues.size()) {
                    propertyValueKeys[i] = this.nodePropertyValues.getKey(propertyValues.get(i));
                    ++i;
                }
                ArrayList<K> newFilteredNodeKeys = new ArrayList<K>();
                block2: for (K nodeId : filteredNodes) {
                    if (nodeId == null) continue;
                    NodeInfo nodeInfo = this.getNodeInfo(nodeId, true);
                    TupleStore nodePropTupleStore = this.getNodePropertyTupleStore(propertyName, true);
                    int i2 = 0;
                    while (i2 < propertyValueKeys.length) {
                        if (nodePropTupleStore.containsTuple(nodeInfo.getInternalNodeId(), propertyValueKeys[i2])) {
                            newFilteredNodeKeys.add(nodeId);
                            continue block2;
                        }
                        ++i2;
                    }
                }
                filteredNodes = newFilteredNodeKeys;
            }
        }
        if (filter.callEvaluate()) {
            ArrayList<Object> newFilteredNodeKeys = new ArrayList<Object>();
            for (Object nodeId : filteredNodes) {
                if (nodeId == null || !filter.evaluate(nodeId)) continue;
                newFilteredNodeKeys.add(nodeId);
            }
            return newFilteredNodeKeys;
        }
        return filteredNodes;
    }

    public TupleStore getNodePropertyTupleStore(String propertyName) {
        return this.getNodePropertyTupleStore(propertyName, true);
    }

    public TupleStore getNodePropertyTupleStore(String propertyName, boolean readOnly) {
        if (!this.nodePropertyTupleStores.containsKey(propertyName)) {
            if (readOnly) {
                return EMPTY_TUPLE_STORE;
            }
            this.nodePropertyTupleStores.put(propertyName, TupleStoreFactory.getInstance().create(this.nodePropertyTupleStoreConfig));
        }
        TupleStore nodePropertyTupleStore = this.nodePropertyTupleStores.get(propertyName);
        if (!readOnly) {
            nodePropertyTupleStore = TupleStoreFactory.getInstance().createWritableTupleStore(nodePropertyTupleStore);
            this.nodePropertyTupleStores.put(propertyName, nodePropertyTupleStore);
        }
        return nodePropertyTupleStore;
    }

    @Override
    public String toString() {
        return this.toString(true, null);
    }

    @Override
    public String toString(boolean detailed, Comparator<K> comparator) {
        StringWriter sw = new StringWriter();
        if (!detailed) {
            sw.append("[");
            Iterator<NodeInfo> it = this.nodeInfos.values().iterator();
            while (it.hasNext()) {
                sw.append(it.next().toString(this));
                if (!it.hasNext()) continue;
                sw.append(", ");
            }
            sw.append("]");
            return sw.toString();
        }
        List<K> nodeKeys = null;
        if (comparator != null) {
            ArrayList<K> nodeKeysAsList = new ArrayList<K>(this.nodeIds);
            Collections.sort(nodeKeysAsList, comparator);
            nodeKeys = nodeKeysAsList;
        } else {
            nodeKeys = this.nodeIds;
        }
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Nodes");
        pw.println("-----");
        for (Object nodeKey : nodeKeys) {
            if (nodeKey == null) continue;
            pw.print(nodeKey.toString());
            pw.print(":");
            pw.println(this.getNodeInfo(nodeKey, true).toString(this));
        }
        pw.println();
        pw.println("Edges");
        pw.println("-----");
        for (Object nodeKey : nodeKeys) {
            if (nodeKey == null) continue;
            NodeInfo nodeInfo = this.getNodeInfo(nodeKey, true);
            Collection adjacentChildNodeKeysSorted = null;
            if (comparator != null) {
                ArrayList adjacentNodeKeysSorted = new ArrayList(new InternalNodeKeyProxyCollection(this, nodeInfo.getAdjacentNodesTupleStore(), InternalNodeKeyProxyCollection.NODE_KEY_SIGN.POSITIVE));
                Collections.sort(adjacentNodeKeysSorted, comparator);
                adjacentChildNodeKeysSorted = adjacentNodeKeysSorted;
            } else {
                adjacentChildNodeKeysSorted = new InternalNodeKeyProxyCollection(this, nodeInfo.getAdjacentNodesTupleStore(), InternalNodeKeyProxyCollection.NODE_KEY_SIGN.POSITIVE);
            }
            for (Object adjacentChildNodeKey : adjacentChildNodeKeysSorted) {
                for (String edgeLabel : this.getEdgeLabels(nodeKey, adjacentChildNodeKey)) {
                    pw.print(nodeKey.toString());
                    NodeInfo adjacentChildNodeInfo = this.getNodeInfo(adjacentChildNodeKey, true);
                    if (adjacentChildNodeInfo.getAdjacentNodesTupleStore().containsTuple(nodeInfo.getInternalNodeId())) {
                        pw.print(" <---[");
                        pw.print(edgeLabel);
                        pw.print("]---> ");
                    } else {
                        pw.print(" ---[");
                        pw.print(edgeLabel);
                        pw.print("]---> ");
                    }
                    pw.println(adjacentChildNodeKey.toString());
                }
            }
        }
        pw.close();
        return sw.toString();
    }

    @Override
    public ITransaction<K> beginTransaction() {
        return null;
    }

    @Override
    public TupleStoreConfiguration getNodePropertyTupleStoreConfig() {
        return this.nodePropertyTupleStoreConfig;
    }

    @Override
    public TupleStoreConfiguration getAdjacentNodesTupleStoreConfig() {
        return this.adjacentNodesTupleStoreConfig;
    }

    @Override
    public TupleStoreConfiguration getEdgePropertyTupleStoreConfig() {
        return this.edgePropertyTupleStoreConfig;
    }

    @Override
    public boolean add(K object) {
        return this.addNode(object);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        return this.containsNode(object);
    }

    @Override
    public boolean isEmpty() {
        return this.getNodeCount() == 0;
    }

    @Override
    public Iterator<K> iterator() {
        return new Iterator<K>(){
            int pos = 0;
            K current = null;
            K next;
            {
                Object localNext = null;
                while (localNext == null && this.pos < PropertyGraphImpl.this.nodeIds.size()) {
                    localNext = PropertyGraphImpl.this.nodeIds.get(this.pos++);
                }
                this.next = localNext;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public K next() {
                this.current = this.next;
                Object localNext = null;
                while (localNext == null && this.pos < PropertyGraphImpl.this.nodeIds.size()) {
                    localNext = PropertyGraphImpl.this.nodeIds.get(this.pos++);
                }
                this.next = localNext;
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                PropertyGraphImpl.this.removeNode(this.current);
                this.current = null;
            }
        };
    }

    @Override
    public boolean remove(Object object) {
        return this.removeNode(object) != null;
    }

    @Override
    public int size() {
        return this.getNodeCount();
    }

    @Override
    public Iterator<K> getDepthFirstPostOrderIterator(K startNode) {
        return new Iterator<K>(startNode){
            private K last = null;
            private final LinkedList<K> stack = new LinkedList();
            {
                this.traverseDepthFirstPostOrder(object);
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.stack.removeFirst();
                return this.last;
            }

            private void traverseDepthFirstPostOrder(K node) {
                for (Object outgoingNode : PropertyGraphImpl.this.getOutgoingNodes(node, 1)) {
                    this.traverseDepthFirstPostOrder(outgoingNode);
                }
                this.stack.addLast(node);
            }

            @Override
            public void remove() {
                if (this.last == null) {
                    throw new NoSuchElementException();
                }
                PropertyGraphImpl.this.removeNode(this.last);
                this.last = null;
            }
        };
    }

    @Override
    public Iterator<K> getDepthFirstPreOrderIterator(K startNode) {
        return new Iterator<K>(startNode){
            private K last = null;
            private final LinkedList<K> stack = new LinkedList();
            {
                this.traverseDepthFirstPreOrder(object);
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.stack.removeFirst();
                return this.last;
            }

            private void traverseDepthFirstPreOrder(K node) {
                this.stack.addLast(node);
                for (Object outgoingNode : PropertyGraphImpl.this.getOutgoingNodes(node, 1)) {
                    this.traverseDepthFirstPreOrder(outgoingNode);
                }
            }

            @Override
            public void remove() {
                if (this.last == null) {
                    throw new NoSuchElementException();
                }
                PropertyGraphImpl.this.removeNode(this.last);
                this.last = null;
            }
        };
    }
}

