/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.AbstractTupleStore;
import com.ibm.cognos.fpm.common.graph.ITupleElementFilter;
import com.ibm.cognos.fpm.common.graph.Tuple;
import com.ibm.cognos.fpm.common.graph.TupleElementIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

final class ReadOnlyTupleStoreImpl
extends AbstractTupleStore {
    private final AbstractTupleStore.TupleStoreConfigurationImpl config;
    private int[][] tuples;

    @Override
    public int size() {
        return this.tuples[0].length;
    }

    ReadOnlyTupleStoreImpl(AbstractTupleStore.TupleStoreConfigurationImpl config, int[][] tuples) {
        this.config = config;
        this.tuples = tuples;
    }

    int[][] getBackingArrays() {
        return this.tuples;
    }

    AbstractTupleStore.TupleStoreConfigurationImpl getTupleStoreConfigurationImpl() {
        return this.config;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new Iterator<Tuple>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < ReadOnlyTupleStoreImpl.this.size();
            }

            @Override
            public Tuple next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new AbstractTupleStore.TupleImpl(ReadOnlyTupleStoreImpl.this.tuples, this.pos++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean containsTuple(int ... tuple) {
        if (tuple[0] == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use can cannot be stored.");
        }
        long startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementContainsCount();
            startTime = System.currentTimeMillis();
        }
        try {
            if (this.size() == 0) {
                return false;
            }
            boolean bl = ReadOnlyTupleStoreImpl.containsTuple(this.config.statisticsCollector, this.tuples, 0, this.size(), tuple);
            return bl;
        }
        finally {
            if (this.config.collectStatistics()) {
                this.config.statisticsCollector.addContainsTupleTime(System.currentTimeMillis() - startTime);
            }
        }
    }

    @Override
    public boolean containsTuple(ITupleElementFilter filter, int ... tuple) {
        if (tuple[0] == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use can cannot be stored.");
        }
        long startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementContainsCount();
            startTime = System.currentTimeMillis();
        }
        try {
            if (this.size() == 0) {
                return false;
            }
            boolean bl = ReadOnlyTupleStoreImpl.containsFilteredTuple(this.config.statisticsCollector, filter, this.tuples, 0, this.size(), tuple);
            return bl;
        }
        finally {
            if (this.config.collectStatistics()) {
                this.config.statisticsCollector.addContainsTupleTime(System.currentTimeMillis() - startTime);
            }
        }
    }

    @Override
    public List<Tuple> getTuples(int ... tuplePrefix) {
        if (tuplePrefix.length > this.config.tupleLength) {
            throw new IllegalArgumentException("Tuple suffix must contain '" + this.config.tupleLength + "' or fewer elements.");
        }
        if (tuplePrefix[0] == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use can cannot be stored.");
        }
        long startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementGetTuplesByPrefixCount();
            startTime = System.currentTimeMillis();
        }
        try {
            ArrayList<Tuple> tuples = new ArrayList<Tuple>();
            AbstractTupleStore.getTuples(this.config.statisticsCollector, this.tuples, 0, this.size(), tuples, tuplePrefix);
            List<Tuple> list = Collections.unmodifiableList(tuples);
            return list;
        }
        finally {
            if (this.config.collectStatistics()) {
                this.config.statisticsCollector.addGetTuplesByPrefixTime(System.currentTimeMillis() - startTime);
            }
        }
    }

    @Override
    public Tuple getTuple(int ... tuplePrefix) {
        if (tuplePrefix.length > this.config.tupleLength) {
            throw new IllegalArgumentException("Tuple prefix must contain '" + this.config.tupleLength + "' or fewer elements.");
        }
        if (tuplePrefix[0] == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use and cannot be stored.");
        }
        long startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementGetTuplesByPrefixCount();
            startTime = System.currentTimeMillis();
        }
        try {
            Tuple tuple = AbstractTupleStore.getTuple(this.config.statisticsCollector, this.tuples, 0, this.size(), tuplePrefix);
            return tuple;
        }
        finally {
            if (this.config.collectStatistics()) {
                this.config.statisticsCollector.addGetTuplesByPrefixTime(System.currentTimeMillis() - startTime);
            }
        }
    }

    @Override
    public Tuple getTuple(ITupleElementFilter filter, int ... tuplePrefix) {
        if (tuplePrefix.length > this.config.tupleLength) {
            throw new IllegalArgumentException("Tuple prefix must contain '" + this.config.tupleLength + "' or fewer elements.");
        }
        if (tuplePrefix[0] == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use and cannot be stored.");
        }
        long startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementGetTuplesByPrefixCount();
            startTime = System.currentTimeMillis();
        }
        try {
            Tuple tuple = AbstractTupleStore.getTuple(this.config.statisticsCollector, filter, this.tuples, 0, this.size(), tuplePrefix);
            return tuple;
        }
        finally {
            if (this.config.collectStatistics()) {
                this.config.statisticsCollector.addGetTuplesByPrefixTime(System.currentTimeMillis() - startTime);
            }
        }
    }

    @Override
    public List<Tuple> getTuplesByPositionValue(int position, int ... values) {
        if (position >= this.config.tupleLength) {
            throw new IllegalArgumentException("The position must be between 0 and " + (this.config.tupleLength - 1));
        }
        if (position == 0 && values.length == 1) {
            return this.getTuples(values[0]);
        }
        long startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementGetTuplesByPositionValueCount();
            startTime = System.currentTimeMillis();
        }
        try {
            ArrayList<Tuple> tuples = new ArrayList<Tuple>();
            AbstractTupleStore.getTuplesByPositionValue(this.tuples, 0, this.size(), tuples, position, values);
            List<Tuple> list = Collections.unmodifiableList(tuples);
            return list;
        }
        finally {
            if (this.config.collectStatistics()) {
                this.config.statisticsCollector.addGetTuplesByPositionValueTime(System.currentTimeMillis() - startTime);
            }
        }
    }

    @Override
    public TupleElementIterator getTupleElementIterator(final int elementPos) {
        return new TupleElementIterator(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < ReadOnlyTupleStoreImpl.this.size();
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ReadOnlyTupleStoreImpl.this.tuples[elementPos][this.pos++];
            }
        };
    }

    @Override
    public TupleElementIterator getTupleElementFilteredIterator(final int elementPosToReturn, final int elementPosToFilter, final int ... valuesToFilterBy) {
        return new TupleElementIterator(){
            private int pos = 0;
            private boolean movedToNext = true;
            {
                Arrays.sort(nArray);
            }

            private int getNextTupleSequence() {
                if (this.movedToNext) {
                    return this.pos;
                }
                int nextPos = this.pos + 1;
                while (nextPos < ReadOnlyTupleStoreImpl.this.size()) {
                    if (Arrays.binarySearch(valuesToFilterBy, ReadOnlyTupleStoreImpl.this.tuples[elementPosToFilter][nextPos]) >= 0) {
                        this.movedToNext = true;
                        this.pos = nextPos;
                        return this.pos;
                    }
                    ++nextPos;
                }
                return ReadOnlyTupleStoreImpl.this.size();
            }

            @Override
            public boolean hasNext() {
                if (this.movedToNext) {
                    return true;
                }
                return this.getNextTupleSequence() < ReadOnlyTupleStoreImpl.this.size();
            }

            @Override
            public int next() {
                int nextPos;
                int n = nextPos = this.movedToNext ? this.pos : this.getNextTupleSequence();
                if (nextPos == ReadOnlyTupleStoreImpl.this.size()) {
                    throw new NoSuchElementException();
                }
                this.movedToNext = false;
                return ReadOnlyTupleStoreImpl.this.tuples[elementPosToReturn][nextPos];
            }
        };
    }

    @Override
    public Iterator<Tuple> getFilteredIterator(int elementPosToFilter, int ... valuesToFilterBy) {
        return new Iterator<Tuple>(elementPosToFilter, valuesToFilterBy){
            private final Iterator<Tuple> wrappedIterator;
            {
                List<Tuple> filteredTuples = ReadOnlyTupleStoreImpl.this.getTuplesByPositionValue(n, nArray);
                this.wrappedIterator = filteredTuples.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.wrappedIterator.hasNext();
            }

            @Override
            public Tuple next() {
                return this.wrappedIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean optimize() {
        return false;
    }

    @Override
    public boolean add(Tuple o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Tuple> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addTuple(int ... tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeTuple(int ... tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addTuple(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeTuple(Tuple tuple) {
        throw new UnsupportedOperationException();
    }
}

