/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;

public class ReadWriteCommitLock {
    private final Object lockedObject;
    private int readCount = 0;
    private int writeCount = 0;
    private int commitCount = 0;
    private final ArrayDeque<BlockedThreadInfo> blockedThreads = new ArrayDeque();
    private final HashMap<Thread, ThreadLockCounts> threadLockCounts = new HashMap();

    ReadWriteCommitLock(Object lockedObject) {
        this.lockedObject = lockedObject;
    }

    synchronized void acquireReadLock() {
        Thread th = Thread.currentThread();
        ThreadLockCounts tlc = this.threadLockCounts.get(th);
        if (tlc == null) {
            tlc = new ThreadLockCounts(th);
        }
        while (this.commitCount > tlc.commitCount) {
            BlockedThreadInfo blockedThread = new BlockedThreadInfo(LockType.READ, tlc);
            this.blockedThreads.addFirst(blockedThread);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        ++this.readCount;
        ++tlc.readCount;
        this.threadLockCounts.put(th, tlc);
    }

    synchronized void releaseReadLock() {
        Thread th = Thread.currentThread();
        ThreadLockCounts tlc = this.threadLockCounts.get(th);
        if (tlc == null) {
            throw new IllegalStateException("Failed to find ThreadLockCounts object for thread: " + th);
        }
        if (tlc.readCount == 0) {
            throw new IllegalStateException("Current thread does not have any read locks");
        }
        --this.readCount;
        --tlc.readCount;
        if (tlc.getTotalLockCount() == 0) {
            this.threadLockCounts.remove(th);
            if (this.blockedThreads.size() > 0) {
                BlockedThreadInfo blockedThread = this.blockedThreads.removeLast();
                blockedThread.th.interrupt();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    synchronized void acquireWriteLock() {
        th = Thread.currentThread();
        tlc = this.threadLockCounts.get(th);
        if (tlc == null) {
            tlc = new ThreadLockCounts(th);
        }
        if (this.readCount <= 0 || this.readCount != tlc.readCount) ** GOTO lbl15
        throw new UnsupportedOperationException("Cannot upgrade the lock from read to write");
lbl-1000:
        // 1 sources

        {
            blockedThread = new BlockedThreadInfo(LockType.WRITE, tlc);
            this.blockedThreads.addFirst(blockedThread);
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
lbl15:
            // 3 sources

            ** while (this.commitCount > tlc.commitCount || this.writeCount > tlc.writeCount)
        }
lbl16:
        // 1 sources

        ++this.writeCount;
        ++tlc.writeCount;
        this.threadLockCounts.put(th, tlc);
    }

    synchronized void releaseWriteLock() {
        Thread th = Thread.currentThread();
        ThreadLockCounts tlc = this.threadLockCounts.get(th);
        if (tlc == null) {
            throw new IllegalStateException("Failed to find ThreadLockCounts object for thread: " + th);
        }
        if (tlc.writeCount == 0) {
            throw new IllegalStateException("Current thread does not have any write locks");
        }
        --this.writeCount;
        --tlc.writeCount;
        if (tlc.getTotalLockCount() == 0) {
            this.threadLockCounts.remove(th);
            if (this.blockedThreads.size() > 0) {
                BlockedThreadInfo blockedThread = this.blockedThreads.removeLast();
                blockedThread.th.interrupt();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    synchronized void acquireCommitLock() {
        th = Thread.currentThread();
        tlc = this.threadLockCounts.get(th);
        if (tlc == null) {
            tlc = new ThreadLockCounts(th);
        }
        if (this.readCount <= 0 || this.readCount != tlc.readCount) ** GOTO lbl15
        throw new UnsupportedOperationException("Cannot upgrade the lock from read to commit");
lbl-1000:
        // 1 sources

        {
            blockedThread = new BlockedThreadInfo(LockType.COMMIT, tlc);
            this.blockedThreads.addFirst(blockedThread);
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
lbl15:
            // 3 sources

            ** while (this.commitCount > tlc.commitCount || this.writeCount > tlc.writeCount || this.readCount > tlc.readCount)
        }
lbl16:
        // 1 sources

        ++this.commitCount;
        ++tlc.commitCount;
        this.threadLockCounts.put(th, tlc);
    }

    synchronized void releaseCommitLock() {
        Thread th = Thread.currentThread();
        ThreadLockCounts tlc = this.threadLockCounts.get(th);
        if (tlc == null) {
            throw new IllegalStateException("Failed to find ThreadLockCounts object for thread: " + th);
        }
        if (tlc.commitCount == 0) {
            throw new IllegalStateException("Current transaction does not have any commit locks");
        }
        --this.commitCount;
        --tlc.commitCount;
        if (tlc.getTotalLockCount() == 0) {
            this.threadLockCounts.remove(th);
            if (this.blockedThreads.size() > 0) {
                BlockedThreadInfo blockedThread = this.blockedThreads.removeLast();
                blockedThread.th.interrupt();
            }
        }
    }

    public void releaseAllLocks() {
        Thread th = Thread.currentThread();
        ThreadLockCounts tlc = this.threadLockCounts.get(th);
        if (tlc == null) {
            return;
        }
        this.readCount -= tlc.readCount;
        this.writeCount -= tlc.writeCount;
        this.commitCount -= tlc.commitCount;
        tlc.readCount = 0;
        tlc.writeCount = 0;
        tlc.commitCount = 0;
        this.threadLockCounts.remove(th);
        if (this.blockedThreads.size() > 0) {
            BlockedThreadInfo blockedThread = this.blockedThreads.removeLast();
            blockedThread.th.interrupt();
        }
    }

    public synchronized int getReadLockCount() {
        ThreadLockCounts tlc = this.threadLockCounts.get(Thread.currentThread());
        return tlc != null ? tlc.readCount : 0;
    }

    public synchronized int getWriteLockCount() {
        ThreadLockCounts tlc = this.threadLockCounts.get(Thread.currentThread());
        return tlc != null ? tlc.writeCount : 0;
    }

    public synchronized int getCommitLockCount() {
        ThreadLockCounts tlc = this.threadLockCounts.get(Thread.currentThread());
        return tlc != null ? tlc.commitCount : 0;
    }

    public synchronized int getTotalLockCount() {
        ThreadLockCounts tlc = this.threadLockCounts.get(Thread.currentThread());
        return tlc != null ? tlc.getTotalLockCount() : 0;
    }

    public synchronized void dumpState() {
        System.out.println(this.toString());
        System.out.println("Total lock count:");
        System.out.println("\t readCount=" + this.readCount);
        System.out.println("\t writeCount=" + this.writeCount);
        System.out.println("\t commitCount=" + this.commitCount);
        System.out.println("Blocked threads:");
        Iterator<BlockedThreadInfo> iter1 = this.blockedThreads.iterator();
        while (iter1.hasNext()) {
            BlockedThreadInfo blockedThread = iter1.next();
            System.out.print("\t " + blockedThread.th + "(r=" + blockedThread.lockCounts.readCount + " w=" + blockedThread.lockCounts.writeCount + " c=" + blockedThread.lockCounts.commitCount + ") waits for " + (Object)((Object)blockedThread.lockType) + " since " + blockedThread.blockedSince);
            if (iter1.hasNext()) {
                System.out.print(",");
                continue;
            }
            System.out.println();
        }
        System.out.println("Locking threads:");
        for (ThreadLockCounts lockingThread : this.threadLockCounts.values()) {
            System.out.println("\t " + lockingThread.th + "(r=" + lockingThread.readCount + " w=" + lockingThread.writeCount + " c=" + lockingThread.commitCount + ")");
        }
    }

    public String toString() {
        return "ReadWriteCommitLock for: " + this.lockedObject.toString();
    }

    private static class BlockedThreadInfo {
        final Thread th = Thread.currentThread();
        final LockType lockType;
        final ThreadLockCounts lockCounts;
        final long blockedSince;

        BlockedThreadInfo(LockType lockType, ThreadLockCounts lockCounts) {
            assert (this.th == lockCounts.th);
            this.lockType = lockType;
            this.lockCounts = lockCounts;
            this.blockedSince = System.currentTimeMillis();
        }
    }

    private static enum LockType {
        READ,
        WRITE,
        COMMIT;

    }

    private static class ThreadLockCounts {
        final Thread th;
        int readCount = 0;
        int writeCount = 0;
        int commitCount = 0;

        ThreadLockCounts(Thread th) {
            this.th = th;
        }

        int getTotalLockCount() {
            return this.readCount + this.writeCount + this.commitCount;
        }
    }
}

