/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.EdgeFilter;
import com.ibm.cognos.fpm.common.graph.IAPIContext;
import com.ibm.cognos.fpm.common.graph.ILockManager;
import com.ibm.cognos.fpm.common.graph.ITransaction;
import com.ibm.cognos.fpm.common.graph.ITransactionData;
import com.ibm.cognos.fpm.common.graph.ITransactionLog;
import com.ibm.cognos.fpm.common.graph.ITupleElementFilter;
import com.ibm.cognos.fpm.common.graph.IVersionedPropertyGraph;
import com.ibm.cognos.fpm.common.graph.NodeHistory;
import com.ibm.cognos.fpm.common.graph.NodeInfo;
import com.ibm.cognos.fpm.common.graph.TransactionCallAddEdge;
import com.ibm.cognos.fpm.common.graph.TransactionCallAddEdgeProperty;
import com.ibm.cognos.fpm.common.graph.TransactionCallAddNode;
import com.ibm.cognos.fpm.common.graph.TransactionCallAddNodeProperty;
import com.ibm.cognos.fpm.common.graph.TransactionCallDeleteEdge;
import com.ibm.cognos.fpm.common.graph.TransactionCallDeleteNode;
import com.ibm.cognos.fpm.common.graph.TransactionCallRemoveEdge;
import com.ibm.cognos.fpm.common.graph.TransactionCallRemoveEdgeProperties;
import com.ibm.cognos.fpm.common.graph.TransactionCallRemoveEdgeProperty;
import com.ibm.cognos.fpm.common.graph.TransactionCallRemoveNode;
import com.ibm.cognos.fpm.common.graph.TransactionCallRemoveNodeProperties;
import com.ibm.cognos.fpm.common.graph.TransactionCallRemoveNodeProperty;
import com.ibm.cognos.fpm.common.graph.TransactionDefinition;
import com.ibm.cognos.fpm.common.graph.TransactionLog;
import com.ibm.cognos.fpm.common.graph.TupleStoreConfiguration;
import com.ibm.cognos.fpm.common.graph.VersionedNodeInfo;
import com.ibm.cognos.fpm.common.graph.VersionedPropertyGraphNodeFilter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ReadWriteTransactionData<K>
implements ITransactionData<K> {
    static final int DEFAULT_INITIAL_CAPACITY = 100;
    private final IVersionedPropertyGraph<K> masterGraph;
    private final ILockManager lockManager;
    private final ITransactionLog<K> transactionLog;
    private final Map<K, ElementState> nodeStates;
    private final Map<K, Map<String, Object>> nodeProperties;
    private final Map<EdgeKey, ElementState> edgeStates;
    private final Map<EdgeKey, Map<String, Object>> edgeProperties;
    private final Map<K, Long> classIds;

    public ReadWriteTransactionData(IVersionedPropertyGraph<K> masterGraph, ILockManager lockManager) {
        this(100, masterGraph, lockManager);
    }

    public ReadWriteTransactionData(int capacity, IVersionedPropertyGraph<K> masterGraph, ILockManager lockManager) {
        assert (masterGraph != null);
        assert (lockManager != null);
        this.masterGraph = masterGraph;
        this.lockManager = lockManager;
        this.transactionLog = new TransactionLog<K>(masterGraph);
        this.nodeStates = new HashMap<K, ElementState>(capacity, 0.9f);
        this.nodeProperties = new HashMap<K, Map<String, Object>>(capacity, 0.9f);
        this.edgeStates = new HashMap<EdgeKey, ElementState>(capacity, 0.9f);
        this.edgeProperties = new HashMap<EdgeKey, Map<String, Object>>(capacity, 0.9f);
        this.classIds = new HashMap<K, Long>(capacity, 0.9f);
    }

    @Override
    public void commit() {
        this.transactionLog.commit();
    }

    @Override
    public boolean addNode(IAPIContext<K> context, K nodeId, Long classId) {
        this.lockManager.acquireWriteLock();
        this.transactionLog.addCall(new TransactionCallAddNode<K>(context, nodeId, classId));
        boolean nodeAdded = false;
        ElementState state = this.nodeStates.get(nodeId);
        if (state == null) {
            if (!this.masterGraph.containsNode(context, nodeId)) {
                this.nodeStates.put(nodeId, ElementState.ADDED);
                nodeAdded = true;
            }
        } else if (state == ElementState.REMOVED || state == ElementState.DELETED) {
            this.nodeStates.put(nodeId, ElementState.RESTORED);
            nodeAdded = true;
        }
        if (nodeAdded) {
            this.classIds.put(nodeId, classId);
        }
        return nodeAdded;
    }

    @Override
    public void destroy() {
        this.masterGraph.destroy();
    }

    @Override
    public int getEdgeCount(IAPIContext<K> context) {
        try {
            this.lockManager.acquireReadLock();
            int n = this.masterGraph.getEdgeCount(context);
            return n;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public int getNodeCount(IAPIContext<K> context) {
        try {
            this.lockManager.acquireReadLock();
            int n = this.masterGraph.getNodeCount(context);
            return n;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Collection<K> getNodeIds(IAPIContext<K> context) {
        try {
            this.lockManager.acquireReadLock();
            Collection<K> collection = this.masterGraph.getNodeIds(context);
            return collection;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public boolean optimize() {
        try {
            this.lockManager.acquireCommitLock();
            boolean bl = this.masterGraph.optimize();
            return bl;
        }
        finally {
            this.lockManager.releaseCommitLock();
        }
    }

    @Override
    public void checkIntegrity() {
        try {
            this.lockManager.acquireWriteLock();
            this.masterGraph.checkIntegrity();
        }
        finally {
            this.lockManager.releaseCommitLock();
        }
    }

    @Override
    public boolean optimize(K nodeId) {
        try {
            this.lockManager.acquireCommitLock();
            boolean bl = this.masterGraph.optimize(nodeId);
            return bl;
        }
        finally {
            this.lockManager.releaseCommitLock();
        }
    }

    @Override
    public K removeNode(IAPIContext<K> context, K nodeId) {
        this.lockManager.acquireWriteLock();
        this.transactionLog.addCall(new TransactionCallRemoveNode<K>(context, nodeId));
        ElementState state = this.nodeStates.get(nodeId);
        assert (state != ElementState.UNKNOWN);
        if (state == null) {
            assert (!this.nodeProperties.containsKey(nodeId));
            if (this.masterGraph.containsNode(context, nodeId)) {
                this.nodeStates.put(nodeId, ElementState.REMOVED);
                return nodeId;
            }
            return null;
        }
        if (state == ElementState.REMOVED) {
            return null;
        }
        this.nodeStates.put(nodeId, ElementState.REMOVED);
        this.nodeProperties.remove(nodeId);
        return nodeId;
    }

    @Override
    public boolean deleteNode(IAPIContext<K> context, K nodeId) {
        this.lockManager.acquireWriteLock();
        this.transactionLog.addCall(new TransactionCallDeleteNode<K>(context, nodeId));
        ElementState state = this.nodeStates.get(nodeId);
        assert (state != ElementState.UNKNOWN);
        if (state == null) {
            assert (!this.nodeProperties.containsKey(nodeId));
            if (this.masterGraph.containsNode(context, nodeId)) {
                this.nodeStates.put(nodeId, ElementState.DELETED);
                return true;
            }
            return false;
        }
        if (state == ElementState.REMOVED || state == ElementState.DELETED) {
            return false;
        }
        this.nodeStates.put(nodeId, ElementState.DELETED);
        this.nodeProperties.remove(nodeId);
        return true;
    }

    @Override
    public boolean restoreNode(IAPIContext<K> context, K nodeId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean containsNode(IAPIContext<K> context, K nodeId) {
        ElementState nodeState = this.nodeStates.get(nodeId);
        if (nodeState != null) {
            assert (nodeState != ElementState.UNKNOWN);
            return nodeState != ElementState.REMOVED && nodeState != ElementState.DELETED;
        }
        try {
            this.lockManager.acquireReadLock();
            boolean bl = this.masterGraph.containsNode(context, nodeId);
            return bl;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Collection<K> findNodes(IAPIContext<K> context, VersionedPropertyGraphNodeFilter<K> filter) {
        try {
            this.lockManager.acquireReadLock();
            Collection<K> collection = this.masterGraph.findNodes(context, filter);
            return collection;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public K getIncomingNode(IAPIContext<K> context, K nodeId) {
        try {
            this.lockManager.acquireReadLock();
            K k = this.masterGraph.getIncomingNode(context, nodeId);
            return k;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Collection<K> getIncomingNodes(IAPIContext<K> context, K nodeId, int hopCount) {
        try {
            this.lockManager.acquireReadLock();
            Collection<K> collection = this.masterGraph.getIncomingNodes(context, nodeId, hopCount);
            return collection;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Collection<K> getIncomingNodes(IAPIContext<K> context, K nodeId, int hopCount, VersionedPropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        try {
            this.lockManager.acquireReadLock();
            Collection<K> collection = this.masterGraph.getIncomingNodes(context, nodeId, hopCount, nodeFilter, edgeFilter);
            return collection;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public int getIncomingNodeCount(IAPIContext<K> context, K nodeId, int hopCount) {
        try {
            this.lockManager.acquireReadLock();
            int n = this.masterGraph.getIncomingNodeCount(context, nodeId, hopCount);
            return n;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public int getIncomingNodeCount(IAPIContext<K> context, K nodeId, int hopCount, VersionedPropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        try {
            this.lockManager.acquireReadLock();
            int n = this.masterGraph.getIncomingNodeCount(context, nodeId, hopCount, nodeFilter, edgeFilter);
            return n;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public boolean isIncomingNode(IAPIContext<K> context, K potentialIncomingNodeId, K nodeId) {
        try {
            this.lockManager.acquireReadLock();
            boolean bl = this.masterGraph.isIncomingNode(context, potentialIncomingNodeId, nodeId);
            return bl;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Collection<K> getOutgoingNodes(IAPIContext<K> context, K nodeId, int hopCount) {
        try {
            this.lockManager.acquireReadLock();
            Collection<K> collection = this.masterGraph.getOutgoingNodes(context, nodeId, hopCount);
            return collection;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Collection<K> getOutgoingNodes(IAPIContext<K> context, K nodeId, int hopCount, VersionedPropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        try {
            this.lockManager.acquireReadLock();
            Collection<K> collection = this.masterGraph.getOutgoingNodes(context, nodeId, hopCount, nodeFilter, edgeFilter);
            return collection;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public boolean isOutgoingNode(IAPIContext<K> context, K potentialOutgoingNodeId, K nodeId) {
        try {
            this.lockManager.acquireReadLock();
            boolean bl = this.masterGraph.isOutgoingNode(context, potentialOutgoingNodeId, nodeId);
            return bl;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public int getOutgoingNodeCount(IAPIContext<K> context, K nodeId, int hopCount) {
        try {
            this.lockManager.acquireReadLock();
            int n = this.masterGraph.getOutgoingNodeCount(context, nodeId, hopCount);
            return n;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public int getOutgoingNodeCount(IAPIContext<K> context, K nodeKey, int hopCount, VersionedPropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        try {
            this.lockManager.acquireReadLock();
            int n = this.masterGraph.getOutgoingNodeCount(context, nodeKey, hopCount, nodeFilter, edgeFilter);
            return n;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public boolean hasOutgoingNodes(IAPIContext<K> context, K nodeKey, VersionedPropertyGraphNodeFilter<K> filter, EdgeFilter<K> edgeFilter) {
        try {
            this.lockManager.acquireReadLock();
            boolean bl = this.masterGraph.hasOutgoingNodes(context, nodeKey, filter, edgeFilter);
            return bl;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public boolean hasIncomingNodes(IAPIContext<K> context, K nodeKey, VersionedPropertyGraphNodeFilter<K> filter, EdgeFilter<K> edgeFilter) {
        try {
            this.lockManager.acquireReadLock();
            boolean bl = this.masterGraph.hasIncomingNodes(context, nodeKey, filter, edgeFilter);
            return bl;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public K removeNode(IAPIContext<K> context, K nodeId, boolean cascadeToOutgoingNodes) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean addEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        this.lockManager.acquireWriteLock();
        this.checkNodeExists(context, sourceNodeId);
        this.checkNodeExists(context, targetNodeId);
        this.transactionLog.addCall(new TransactionCallAddEdge<K>(context, sourceNodeId, targetNodeId, label));
        ElementState sourceNodeState = this.nodeStates.get(sourceNodeId);
        ElementState targetNodeState = this.nodeStates.get(targetNodeId);
        EdgeKey edgeKey = new EdgeKey(sourceNodeId, targetNodeId, label);
        ElementState edgeState = this.edgeStates.get(edgeKey);
        boolean edgeAdded = false;
        if (edgeState == null) {
            if (!(this.masterGraph.containsNode(context, sourceNodeId) && this.masterGraph.containsNode(context, targetNodeId) && this.masterGraph.hasEdge(context, sourceNodeId, targetNodeId, label))) {
                this.edgeStates.put(edgeKey, ElementState.ADDED);
                edgeAdded = true;
            }
        } else if (edgeState != ElementState.ADDED) {
            if (edgeState == ElementState.MODIFIED) {
                throw new UnsupportedOperationException("Not implemented yet");
            }
            if (edgeState == ElementState.REMOVED || edgeState == ElementState.DELETED) {
                this.edgeStates.put(edgeKey, ElementState.RESTORED);
                edgeAdded = true;
            } else {
                if (edgeState == ElementState.RESTORED) {
                    throw new UnsupportedOperationException("Not implemented yet");
                }
                throw new IllegalStateException("Unexpected edge state. Source nodeId='" + sourceNodeId + "', Target nodeId='" + targetNodeId + "', Edge state='" + (Object)((Object)edgeState) + "'");
            }
        }
        if (edgeAdded) {
            if (sourceNodeState == null) {
                this.nodeStates.put(sourceNodeId, ElementState.MODIFIED);
            }
            if (targetNodeState == null) {
                this.nodeStates.put(targetNodeId, ElementState.MODIFIED);
            }
        }
        return edgeAdded;
    }

    @Override
    public boolean removeEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        this.lockManager.acquireWriteLock();
        this.checkNodeExists(context, sourceNodeId);
        this.checkNodeExists(context, targetNodeId);
        this.transactionLog.addCall(new TransactionCallRemoveEdge<K>(context, sourceNodeId, targetNodeId, label));
        ElementState sourceNodeState = this.nodeStates.get(sourceNodeId);
        ElementState targetNodeState = this.nodeStates.get(targetNodeId);
        EdgeKey edgeKey = new EdgeKey(sourceNodeId, targetNodeId, label);
        ElementState edgeState = this.edgeStates.get(edgeKey);
        boolean edgeRemoved = false;
        if (sourceNodeState == null || targetNodeState == null) {
            if (edgeState != null) {
                throw new IllegalStateException();
            }
            if (this.masterGraph.containsNode(context, sourceNodeId) && this.masterGraph.containsNode(context, targetNodeId) && this.masterGraph.hasEdge(context, sourceNodeId, targetNodeId, label)) {
                edgeRemoved = true;
            }
        } else if (sourceNodeState == ElementState.MODIFIED) {
            if (edgeState == null) {
                if (this.masterGraph.hasEdge(context, sourceNodeId, targetNodeId, label)) {
                    edgeRemoved = true;
                }
            } else if (edgeState != ElementState.REMOVED && edgeState != ElementState.DELETED) {
                edgeRemoved = true;
            }
        } else if (sourceNodeState == ElementState.ADDED || sourceNodeState == ElementState.RESTORED) {
            if (edgeState != null && edgeState != ElementState.REMOVED && edgeState != ElementState.DELETED) {
                edgeRemoved = true;
            }
        } else {
            throw new IllegalStateException("Unexpected node state. NodeId='" + sourceNodeId + "', State='" + (Object)((Object)sourceNodeState) + "'");
        }
        if (edgeRemoved) {
            this.edgeStates.put(edgeKey, ElementState.REMOVED);
            if (sourceNodeState == null) {
                this.nodeStates.put(sourceNodeId, ElementState.MODIFIED);
            }
            if (targetNodeState == null) {
                this.nodeStates.put(targetNodeId, ElementState.MODIFIED);
            }
        }
        return edgeRemoved;
    }

    @Override
    public boolean deleteEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        this.lockManager.acquireWriteLock();
        this.checkNodeExists(context, sourceNodeId);
        this.checkNodeExists(context, targetNodeId);
        this.transactionLog.addCall(new TransactionCallDeleteEdge<K>(context, sourceNodeId, targetNodeId, label));
        ElementState sourceNodeState = this.nodeStates.get(sourceNodeId);
        ElementState targetNodeState = this.nodeStates.get(targetNodeId);
        EdgeKey edgeKey = new EdgeKey(sourceNodeId, targetNodeId, label);
        ElementState edgeState = this.edgeStates.get(edgeKey);
        boolean edgeDeleted = false;
        if (sourceNodeState == null || targetNodeState == null) {
            if (edgeState != null) {
                throw new IllegalStateException();
            }
            if (this.masterGraph.containsNode(context, sourceNodeId) && this.masterGraph.containsNode(context, targetNodeId) && this.masterGraph.hasEdge(context, sourceNodeId, targetNodeId, label)) {
                edgeDeleted = true;
            }
        } else if (sourceNodeState == ElementState.MODIFIED) {
            if (edgeState == null) {
                if (this.masterGraph.hasEdge(context, sourceNodeId, targetNodeId, label)) {
                    edgeDeleted = true;
                }
            } else if (edgeState != ElementState.REMOVED && edgeState != ElementState.DELETED) {
                edgeDeleted = true;
            }
        } else if (sourceNodeState == ElementState.ADDED || sourceNodeState == ElementState.RESTORED) {
            if (edgeState != null && edgeState != ElementState.REMOVED && edgeState != ElementState.DELETED) {
                edgeDeleted = true;
            }
        } else {
            throw new IllegalStateException("Unexpected node state. NodeId='" + sourceNodeId + "', State='" + (Object)((Object)sourceNodeState) + "'");
        }
        if (edgeDeleted) {
            this.edgeStates.put(edgeKey, ElementState.DELETED);
            if (sourceNodeState == null) {
                this.nodeStates.put(sourceNodeId, ElementState.MODIFIED);
            }
            if (targetNodeState == null) {
                this.nodeStates.put(targetNodeId, ElementState.MODIFIED);
            }
        }
        return edgeDeleted;
    }

    @Override
    public boolean hasEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        try {
            this.lockManager.acquireReadLock();
            boolean bl = this.hasEdgeInternal(context, sourceNodeId, targetNodeId, label);
            return bl;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    private boolean hasEdgeInternal(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        this.checkNodeExists(context, sourceNodeId);
        this.checkNodeExists(context, targetNodeId);
        ElementState sourceNodeState = this.nodeStates.get(sourceNodeId);
        ElementState targetNodeState = this.nodeStates.get(targetNodeId);
        EdgeKey edgeKey = new EdgeKey(sourceNodeId, targetNodeId, label);
        ElementState edgeState = this.edgeStates.get(edgeKey);
        boolean edgeExists = false;
        if (sourceNodeState == null || targetNodeState == null) {
            if (edgeState != null) {
                throw new IllegalStateException();
            }
            if (this.masterGraph.containsNode(context, sourceNodeId) && this.masterGraph.containsNode(context, targetNodeId)) {
                edgeExists = this.masterGraph.hasEdge(context, sourceNodeId, targetNodeId, label);
            }
        } else if (sourceNodeState == ElementState.MODIFIED) {
            edgeExists = edgeState == null ? this.masterGraph.hasEdge(context, sourceNodeId, targetNodeId, label) : edgeState != ElementState.REMOVED && edgeState != ElementState.DELETED;
        } else if (sourceNodeState == ElementState.ADDED || sourceNodeState == ElementState.RESTORED) {
            edgeExists = edgeState != null && edgeState != ElementState.REMOVED && edgeState != ElementState.DELETED;
        } else {
            throw new IllegalStateException("Unexpected node state. NodeId='" + sourceNodeId + "', State='" + (Object)((Object)sourceNodeState) + "'");
        }
        return edgeExists;
    }

    @Override
    public boolean restoreEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Collection<String> getEdgeLabels(IAPIContext<K> context, K sourceNodeId, K targetNodeId) {
        try {
            this.lockManager.acquireReadLock();
            Collection<String> collection = this.masterGraph.getEdgeLabels(context, sourceNodeId, targetNodeId);
            return collection;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Object addEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName, Object propertyValue) {
        this.lockManager.acquireWriteLock();
        this.checkNodeExists(context, sourceNodeId);
        this.checkNodeExists(context, targetNodeId);
        this.checkEdgeExists(context, sourceNodeId, targetNodeId, label);
        this.transactionLog.addCall(new TransactionCallAddEdgeProperty<K>(context, sourceNodeId, targetNodeId, label, propertyName, propertyValue));
        EdgeKey edgeKey = new EdgeKey(sourceNodeId, targetNodeId, label);
        ElementState edgeState = this.edgeStates.get(edgeKey);
        Map<String, Object> edgePropertyValues = this.edgeProperties.get(edgeKey);
        Object oldPropertyValue = ElementState.UNKNOWN;
        if (edgeState == null) {
            assert (edgePropertyValues == null);
            if (this.masterGraph.containsNode(context, sourceNodeId) && this.masterGraph.containsNode(context, targetNodeId) && this.masterGraph.hasEdge(context, sourceNodeId, targetNodeId, label)) {
                oldPropertyValue = this.masterGraph.getEdgeProperty(context, sourceNodeId, targetNodeId, label, propertyName);
            }
            this.edgeStates.put(edgeKey, ElementState.MODIFIED);
        } else if (edgeState == ElementState.MODIFIED) {
            oldPropertyValue = edgePropertyValues != null && edgePropertyValues.containsKey(propertyName) ? edgePropertyValues.get(propertyName) : this.masterGraph.getEdgeProperty(context, sourceNodeId, targetNodeId, label, propertyName);
        } else if (edgeState == ElementState.ADDED || edgeState == ElementState.RESTORED) {
            if (edgePropertyValues != null && edgePropertyValues.containsKey(propertyName)) {
                oldPropertyValue = edgePropertyValues.get(propertyName);
            }
        } else {
            throw new IllegalStateException("Unexpected edge state. sourceNodeId='" + sourceNodeId + "', targetNodeId='" + targetNodeId + "', label='" + label + "', State='" + (Object)((Object)edgeState) + "'");
        }
        if (edgePropertyValues == null) {
            edgePropertyValues = new HashMap<String, Object>();
            this.edgeProperties.put(edgeKey, edgePropertyValues);
        }
        edgePropertyValues.put(propertyName, propertyValue);
        if (!this.nodeStates.containsKey(sourceNodeId)) {
            this.nodeStates.put(sourceNodeId, ElementState.MODIFIED);
        }
        if (!this.nodeStates.containsKey(targetNodeId)) {
            this.nodeStates.put(targetNodeId, ElementState.MODIFIED);
        }
        if (oldPropertyValue == ElementState.UNKNOWN || oldPropertyValue == ElementState.REMOVED) {
            return null;
        }
        return oldPropertyValue;
    }

    @Override
    public Object getEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName) {
        try {
            this.lockManager.acquireReadLock();
            Object object = this.masterGraph.getEdgeProperty(context, sourceNodeId, targetNodeId, label, propertyName);
            return object;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Map<String, Object> getEdgeProperties(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        try {
            this.lockManager.acquireReadLock();
            Map<String, Object> map = this.masterGraph.getEdgeProperties(context, sourceNodeId, targetNodeId, label);
            return map;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Collection<String> getEdgePropertyNames(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        try {
            this.lockManager.acquireReadLock();
            Collection<String> collection = this.masterGraph.getEdgePropertyNames(context, sourceNodeId, targetNodeId, label);
            return collection;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Object removeEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName) {
        this.lockManager.acquireWriteLock();
        this.checkNodeExists(context, sourceNodeId);
        this.checkNodeExists(context, targetNodeId);
        this.transactionLog.addCall(new TransactionCallRemoveEdgeProperty<K>(context, sourceNodeId, targetNodeId, label, propertyName));
        EdgeKey edgeKey = new EdgeKey(sourceNodeId, targetNodeId, label);
        ElementState edgeState = this.edgeStates.get(edgeKey);
        Map<String, Object> edgePropertyValues = this.edgeProperties.get(edgeKey);
        Object removedObject = ElementState.UNKNOWN;
        if (edgePropertyValues != null && edgePropertyValues.containsKey(propertyName)) {
            ElementState sourceNodeState = this.nodeStates.get(sourceNodeId);
            ElementState targetNodeState = this.nodeStates.get(targetNodeId);
            assert (sourceNodeState != null && sourceNodeState != ElementState.REMOVED && sourceNodeState != ElementState.DELETED);
            assert (targetNodeState != null && targetNodeState != ElementState.REMOVED && targetNodeState != ElementState.DELETED);
            assert (edgeState != null && edgeState != ElementState.REMOVED && edgeState != ElementState.DELETED);
            removedObject = edgePropertyValues.get(propertyName);
        } else if (this.masterGraph.hasEdgeProperty(context, sourceNodeId, targetNodeId, label, propertyName)) {
            removedObject = this.masterGraph.getEdgeProperty(context, sourceNodeId, targetNodeId, label, propertyName);
        }
        if (removedObject == ElementState.UNKNOWN || removedObject == ElementState.REMOVED || removedObject == ElementState.DELETED) {
            return null;
        }
        if (edgePropertyValues == null) {
            edgePropertyValues = new HashMap<String, Object>();
            this.edgeProperties.put(edgeKey, edgePropertyValues);
        }
        edgePropertyValues.put(propertyName, (Object)ElementState.REMOVED);
        if (!this.edgeStates.containsKey(edgeKey)) {
            this.edgeStates.put(edgeKey, ElementState.MODIFIED);
        }
        if (!this.nodeStates.containsKey(sourceNodeId)) {
            this.nodeStates.put(sourceNodeId, ElementState.MODIFIED);
        }
        if (!this.nodeStates.containsKey(targetNodeId)) {
            this.nodeStates.put(targetNodeId, ElementState.MODIFIED);
        }
        return removedObject;
    }

    @Override
    public boolean removeEdgeProperties(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        Collection<String> masterPropertyNames;
        this.lockManager.acquireWriteLock();
        this.checkNodeExists(context, sourceNodeId);
        this.checkNodeExists(context, targetNodeId);
        this.transactionLog.addCall(new TransactionCallRemoveEdgeProperties<K>(context, sourceNodeId, targetNodeId, label));
        EdgeKey edgeKey = new EdgeKey(sourceNodeId, targetNodeId, label);
        Map<String, Object> edgePropertyValues = this.edgeProperties.get(edgeKey);
        boolean propertiesRemoved = false;
        if (edgePropertyValues != null) {
            assert (!edgePropertyValues.isEmpty());
            propertiesRemoved = true;
            for (Map.Entry<String, Object> entry : edgePropertyValues.entrySet()) {
                entry.setValue((Object)ElementState.REMOVED);
            }
        }
        if (!(masterPropertyNames = this.masterGraph.getEdgePropertyNames(context, sourceNodeId, targetNodeId, label)).isEmpty()) {
            propertiesRemoved = true;
            if (edgePropertyValues == null) {
                edgePropertyValues = new HashMap<String, Object>();
                this.edgeProperties.put(edgeKey, edgePropertyValues);
            }
            for (String propertyName : masterPropertyNames) {
                edgePropertyValues.put(propertyName, (Object)ElementState.REMOVED);
            }
        }
        if (!this.edgeStates.containsKey(edgeKey)) {
            this.edgeStates.put(edgeKey, ElementState.MODIFIED);
        }
        if (!this.nodeStates.containsKey(sourceNodeId)) {
            this.nodeStates.put(sourceNodeId, ElementState.MODIFIED);
        }
        if (!this.nodeStates.containsKey(targetNodeId)) {
            this.nodeStates.put(targetNodeId, ElementState.MODIFIED);
        }
        return propertiesRemoved;
    }

    @Override
    public boolean hasEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName) {
        try {
            this.lockManager.acquireReadLock();
            boolean bl = this.masterGraph.hasEdgeProperty(context, sourceNodeId, targetNodeId, label, propertyName);
            return bl;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Object removeNodeProperty(IAPIContext<K> context, K nodeId, String propertyName) {
        this.lockManager.acquireWriteLock();
        this.checkNodeExists(context, nodeId);
        this.transactionLog.addCall(new TransactionCallRemoveNodeProperty<K>(context, nodeId, propertyName));
        Object removedObject = ElementState.UNKNOWN;
        Map<String, Object> nodePropertyValues = this.nodeProperties.get(nodeId);
        if (nodePropertyValues != null && nodePropertyValues.containsKey(propertyName)) {
            ElementState nodeState = this.nodeStates.get(nodeId);
            assert (nodeState != null && nodeState != ElementState.REMOVED && nodeState != ElementState.DELETED);
            removedObject = nodePropertyValues.get(propertyName);
        } else if (this.masterGraph.hasNodeProperty(context, nodeId, propertyName)) {
            removedObject = this.masterGraph.getNodeProperty(context, nodeId, propertyName);
        }
        if (removedObject == ElementState.UNKNOWN || removedObject == ElementState.REMOVED || removedObject == ElementState.DELETED) {
            return null;
        }
        if (nodePropertyValues == null) {
            nodePropertyValues = new HashMap<String, Object>();
            this.nodeProperties.put(nodeId, nodePropertyValues);
        }
        nodePropertyValues.put(propertyName, (Object)ElementState.REMOVED);
        if (!this.nodeStates.containsKey(nodeId)) {
            this.nodeStates.put(nodeId, ElementState.MODIFIED);
        }
        return removedObject;
    }

    @Override
    public boolean removeNodeProperties(IAPIContext<K> context, K nodeId) {
        this.lockManager.acquireWriteLock();
        this.checkNodeExists(context, nodeId);
        this.transactionLog.addCall(new TransactionCallRemoveNodeProperties<K>(context, nodeId));
        boolean propertiesRemoved = false;
        Map<String, Object> nodePropertyValues = this.nodeProperties.get(nodeId);
        if (nodePropertyValues != null) {
            assert (!nodePropertyValues.isEmpty());
            propertiesRemoved = true;
            for (Map.Entry<String, Object> entry : nodePropertyValues.entrySet()) {
                entry.setValue((Object)ElementState.REMOVED);
            }
        }
        if (this.masterGraph.hasNodeProperties(context, nodeId)) {
            propertiesRemoved = true;
            if (nodePropertyValues == null) {
                nodePropertyValues = new HashMap<String, Object>();
                this.nodeProperties.put(nodeId, nodePropertyValues);
            }
            for (String propertyName : this.masterGraph.getNodePropertyNames(context, nodeId)) {
                nodePropertyValues.put(propertyName, (Object)ElementState.REMOVED);
            }
        }
        return propertiesRemoved;
    }

    @Override
    public boolean hasNodeProperty(IAPIContext<K> context, K nodeId, String propertyName) {
        ElementState nodeState = this.nodeStates.get(nodeId);
        if (nodeState != null) {
            assert (nodeState != ElementState.UNKNOWN);
            if (nodeState == ElementState.REMOVED || nodeState == ElementState.DELETED) {
                return false;
            }
            Map<String, Object> nodePropertyValues = this.nodeProperties.get(nodeId);
            if (nodePropertyValues != null && nodePropertyValues.containsKey(propertyName)) {
                return true;
            }
            if (nodeState == ElementState.ADDED || nodeState == ElementState.RESTORED) {
                return false;
            }
        }
        try {
            this.lockManager.acquireReadLock();
            boolean bl = this.masterGraph.hasNodeProperty(context, nodeId, propertyName);
            return bl;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public boolean hasNodeProperties(IAPIContext<K> context, K nodeId) {
        ElementState nodeState = this.nodeStates.get(nodeId);
        if (nodeState != null) {
            assert (nodeState != ElementState.UNKNOWN);
            if (nodeState == ElementState.REMOVED || nodeState == ElementState.DELETED) {
                return false;
            }
            Map<String, Object> nodePropertyValues = this.nodeProperties.get(nodeId);
            if (nodePropertyValues != null) {
                return true;
            }
            if (nodeState == ElementState.ADDED || nodeState == ElementState.RESTORED) {
                return false;
            }
        }
        try {
            this.lockManager.acquireReadLock();
            boolean bl = this.masterGraph.hasNodeProperties(context, nodeId);
            return bl;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Object addNodeProperty(IAPIContext<K> context, K nodeId, String propertyName, Object propertyValue) {
        this.lockManager.acquireWriteLock();
        this.checkNodeExists(context, nodeId);
        this.transactionLog.addCall(new TransactionCallAddNodeProperty<K>(context, nodeId, propertyName, propertyValue));
        Object oldPropertyValue = ElementState.UNKNOWN;
        ElementState nodeState = this.nodeStates.get(nodeId);
        Map<String, Object> nodePropertyValues = this.nodeProperties.get(nodeId);
        if (nodeState == null) {
            assert (nodePropertyValues == null);
            oldPropertyValue = this.masterGraph.getNodeProperty(context, nodeId, propertyName);
            this.nodeStates.put(nodeId, ElementState.MODIFIED);
        } else if (nodeState == ElementState.MODIFIED) {
            if (nodePropertyValues != null && nodePropertyValues.containsKey(propertyName)) {
                oldPropertyValue = nodePropertyValues.get(propertyName);
            } else if (this.masterGraph.containsNode(context, nodeId)) {
                oldPropertyValue = this.masterGraph.getNodeProperty(context, nodeId, propertyName);
            }
        } else if (nodeState == ElementState.ADDED || nodeState == ElementState.RESTORED) {
            if (nodePropertyValues != null && nodePropertyValues.containsKey(propertyName)) {
                oldPropertyValue = nodePropertyValues.get(propertyName);
            }
        } else {
            throw new IllegalStateException("Unexpected node state. NodeId='" + nodeId + "', State='" + (Object)((Object)nodeState) + "'");
        }
        if (nodePropertyValues == null) {
            nodePropertyValues = new HashMap<String, Object>();
            this.nodeProperties.put(nodeId, nodePropertyValues);
        }
        nodePropertyValues.put(propertyName, propertyValue);
        if (oldPropertyValue == ElementState.UNKNOWN || oldPropertyValue == ElementState.REMOVED || oldPropertyValue == ElementState.DELETED) {
            return null;
        }
        return oldPropertyValue;
    }

    @Override
    public Object getNodeProperty(IAPIContext<K> context, K nodeId, String propertyName) {
        try {
            this.lockManager.acquireReadLock();
            Object object = this.getNodePropertyInternal(context, nodeId, propertyName);
            return object;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    private Object getNodePropertyInternal(IAPIContext<K> context, K nodeId, String propertyName) {
        this.checkNodeExists(context, nodeId);
        ElementState nodeState = this.nodeStates.get(nodeId);
        if (nodeState == null) {
            assert (!this.nodeProperties.containsKey(nodeId));
            return this.masterGraph.getNodeProperty(context, nodeId, propertyName);
        }
        Object propertyValue = ElementState.UNKNOWN;
        Map<String, Object> nodePropertyValues = this.nodeProperties.get(nodeId);
        if (nodeState == ElementState.MODIFIED) {
            if (nodePropertyValues != null && nodePropertyValues.containsKey(propertyName)) {
                propertyValue = nodePropertyValues.get(propertyName);
            } else if (this.masterGraph.containsNode(context, nodeId)) {
                propertyValue = this.masterGraph.getNodeProperty(context, nodeId, propertyName);
            }
        } else if (nodeState == ElementState.ADDED || nodeState == ElementState.RESTORED) {
            if (nodePropertyValues != null && nodePropertyValues.containsKey(propertyName)) {
                propertyValue = nodePropertyValues.get(propertyName);
            }
        } else {
            throw new IllegalStateException("Unexpected node state. NodeId='" + nodeId + "', State='" + (Object)((Object)nodeState) + "'");
        }
        if (propertyValue == ElementState.UNKNOWN || propertyValue == ElementState.REMOVED || propertyValue == ElementState.DELETED) {
            return null;
        }
        return propertyValue;
    }

    @Override
    public Map<String, Object> getNodeProperties(IAPIContext<K> context, K nodeId) {
        try {
            this.lockManager.acquireReadLock();
            Map<String, Object> map = this.masterGraph.getNodeProperties(context, nodeId);
            return map;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Collection<String> getNodePropertyNames(IAPIContext<K> context, K nodeId) {
        try {
            this.lockManager.acquireReadLock();
            Collection<String> collection = this.masterGraph.getNodePropertyNames(context, nodeId);
            return collection;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public VersionedNodeInfo getNodeInfo(K nodeId, boolean throwExceptionOnNotFound) {
        try {
            this.lockManager.acquireReadLock();
            VersionedNodeInfo versionedNodeInfo = this.masterGraph.getNodeInfo(nodeId, throwExceptionOnNotFound);
            return versionedNodeInfo;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public NodeInfo getNodeInfo(int internalNodeId, boolean throwExceptionOnNotFound) {
        try {
            this.lockManager.acquireReadLock();
            NodeInfo nodeInfo = this.getNodeInfo(internalNodeId, throwExceptionOnNotFound);
            return nodeInfo;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public List<NodeHistory<K>> getNodeHistory(K nodeId) {
        try {
            this.lockManager.acquireReadLock();
            List<NodeHistory<K>> list = this.masterGraph.getNodeHistory(nodeId);
            return list;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Long getNodeClass(K nodeId) {
        if (this.classIds.containsKey(nodeId)) {
            return this.classIds.get(nodeId);
        }
        try {
            this.lockManager.acquireReadLock();
            Long l = this.masterGraph.getNodeClass(nodeId);
            return l;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public Long getEventTime(int internalEventId) {
        try {
            this.lockManager.acquireReadLock();
            Long l = this.masterGraph.getEventTime(internalEventId);
            return l;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public ITupleElementFilter<K> getTimeTupleFilter(IAPIContext<K> context, int timeElementPosition) {
        try {
            this.lockManager.acquireReadLock();
            ITupleElementFilter<K> iTupleElementFilter = this.masterGraph.getTimeTupleFilter(context, timeElementPosition);
            return iTupleElementFilter;
        }
        finally {
            this.lockManager.releaseReadLock();
        }
    }

    @Override
    public String toString(boolean detailed, Comparator<K> comparator) {
        return null;
    }

    @Override
    public ITransaction<K> beginTransaction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITransaction<K> beginTransaction(TransactionDefinition definition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TupleStoreConfiguration getNodePropertyTupleStoreConfig() {
        return this.masterGraph.getNodePropertyTupleStoreConfig();
    }

    @Override
    public TupleStoreConfiguration getAdjacentNodesTupleStoreConfig() {
        return this.masterGraph.getAdjacentNodesTupleStoreConfig();
    }

    @Override
    public TupleStoreConfiguration getEdgePropertyTupleStoreConfig() {
        return this.masterGraph.getEdgePropertyTupleStoreConfig();
    }

    private void checkNodeExists(IAPIContext<K> context, K nodeId) {
        boolean exists = false;
        ElementState state = this.nodeStates.get(nodeId);
        if (state == null) {
            exists = this.masterGraph.containsNode(context, nodeId);
        } else {
            boolean bl = exists = state != ElementState.REMOVED && state != ElementState.DELETED;
        }
        if (!exists) {
            throw new IllegalArgumentException("The node with key '" + nodeId + "' doesn't exist in the graph.");
        }
    }

    private void checkEdgeExists(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        boolean exists = false;
        EdgeKey key = new EdgeKey(sourceNodeId, targetNodeId, label);
        ElementState state = this.edgeStates.get(key);
        if (state == null) {
            if (this.masterGraph.containsNode(context, sourceNodeId) && this.masterGraph.containsNode(context, targetNodeId)) {
                exists = this.masterGraph.hasEdge(context, sourceNodeId, targetNodeId, label);
            }
        } else {
            boolean bl = exists = state != ElementState.REMOVED && state != ElementState.DELETED;
        }
        if (!exists) {
            throw new IllegalArgumentException("There is no edge between '" + sourceNodeId + "' and '" + targetNodeId + "' with the label '" + label + "'.");
        }
    }

    private class EdgeKey {
        private final K sourceNodeId;
        private final K targetNodeId;
        private final String label;

        public EdgeKey(K sourceNodeId, K targetNodeId, String label) {
            assert (sourceNodeId != null);
            assert (targetNodeId != null);
            assert (label != null);
            this.sourceNodeId = sourceNodeId;
            this.targetNodeId = targetNodeId;
            this.label = label;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            EdgeKey key = (EdgeKey)o;
            return this.sourceNodeId == key.sourceNodeId && this.targetNodeId == key.targetNodeId && this.label.equals(key.label);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.sourceNodeId.hashCode();
            result = 31 * result + this.targetNodeId.hashCode();
            result = 31 * result + this.label.hashCode();
            return result;
        }
    }

    private static enum ElementState {
        UNKNOWN,
        ADDED,
        MODIFIED,
        REMOVED,
        DELETED,
        RESTORED;

    }
}

