/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.ITupleElementFilter;
import com.ibm.cognos.fpm.common.graph.Tuple;
import com.ibm.cognos.fpm.common.graph.TupleElementIterator;
import com.ibm.cognos.fpm.common.graph.TupleStore;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class SingleElementTupleStore
extends AbstractCollection<Tuple>
implements TupleStore {
    private static final List<Tuple> EMPTY_TUPLE_LIST = Collections.unmodifiableList(new ArrayList(0));
    private static final TupleElementIterator EMPTY_TUPLE_ELEMENT_ITERATOR = new EmptyTupleElementIterator();
    protected int[] tuple = null;

    public SingleElementTupleStore(int tupleLength) {
        this.tuple = new int[tupleLength];
        this.tuple[0] = Integer.MIN_VALUE;
    }

    public int[] getBackingArray() {
        return this.tuple;
    }

    @Override
    public boolean addTuple(int ... tuple) {
        if (this.tuple[0] != Integer.MIN_VALUE) {
            throw new UnsupportedOperationException();
        }
        if (tuple.length != this.tuple.length) {
            throw new IllegalArgumentException("Tuple must contain '" + this.tuple.length + "' elements.");
        }
        if (tuple[0] == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use can cannot be stored.");
        }
        if (this.containsTuple(tuple)) {
            return false;
        }
        System.arraycopy(tuple, 0, this.tuple, 0, tuple.length);
        return true;
    }

    @Override
    public boolean addTuple(Tuple tuple) {
        return this.addTuple(tuple.toArray());
    }

    @Override
    public boolean containsTuple(int ... tuple) {
        if (tuple[0] == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use can cannot be stored.");
        }
        if (this.tuple[0] == Integer.MIN_VALUE) {
            return false;
        }
        int i = 0;
        while (i < tuple.length) {
            if (tuple[i] != this.tuple[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean containsTuple(ITupleElementFilter filter, int ... tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsTuple(Tuple tuple) {
        return this.containsTuple(tuple.toArray());
    }

    @Override
    public List<Tuple> getTuples(int ... tupleSuffix) {
        if (this.tuple[0] == Integer.MIN_VALUE) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Tuple(){

            @Override
            public int length() {
                return SingleElementTupleStore.this.tuple.length;
            }

            @Override
            public int getElement(int pos) {
                return SingleElementTupleStore.this.tuple[pos];
            }

            @Override
            public int[] toArray() {
                return SingleElementTupleStore.this.tuple;
            }
        });
    }

    @Override
    public boolean removeTuple(int ... tuple) {
        if (!this.containsTuple(tuple)) {
            return false;
        }
        this.tuple[0] = Integer.MIN_VALUE;
        return true;
    }

    @Override
    public boolean removeTuple(Tuple tuple) {
        return this.removeTuple(tuple.toArray());
    }

    @Override
    public int size() {
        return this.tuple[0] == Integer.MIN_VALUE ? 0 : 1;
    }

    @Override
    public boolean optimize() {
        return false;
    }

    @Override
    public TupleElementIterator getTupleElementIterator(final int elementPos) {
        if (this.tuple[0] == Integer.MIN_VALUE) {
            return EMPTY_TUPLE_ELEMENT_ITERATOR;
        }
        return new TupleElementIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public int next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return SingleElementTupleStore.this.tuple[elementPos];
            }
        };
    }

    @Override
    public TupleElementIterator getTupleElementFilteredIterator(int elementPosToReturn, int elementPosToFilter, int ... valuesToFilterBy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Tuple tuple) {
        return this.addTuple(tuple);
    }

    @Override
    public void clear() {
        this.tuple[0] = Integer.MIN_VALUE;
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof Tuple) {
            return this.containsTuple((Tuple)object);
        }
        if (object instanceof int[]) {
            return this.containsTuple((int[])object);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.tuple[0] == Integer.MIN_VALUE;
    }

    @Override
    public Iterator<Tuple> iterator() {
        if (this.tuple[0] == Integer.MIN_VALUE) {
            return EMPTY_TUPLE_LIST.iterator();
        }
        return new Iterator<Tuple>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Tuple next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return new Tuple(){

                    @Override
                    public int length() {
                        return (this).SingleElementTupleStore.this.tuple.length;
                    }

                    @Override
                    public int getElement(int pos) {
                        return (this).SingleElementTupleStore.this.tuple[pos];
                    }

                    @Override
                    public int[] toArray() {
                        return (this).SingleElementTupleStore.this.tuple;
                    }
                };
            }

            @Override
            public void remove() {
                SingleElementTupleStore.this.tuple[0] = Integer.MIN_VALUE;
            }
        };
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof Tuple) {
            return this.removeTuple((Tuple)object);
        }
        if (object instanceof int[]) {
            return this.removeTuple((int[])object);
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tuple getTuple(int ... tuplePrefix) {
        return null;
    }

    @Override
    public Tuple getTuple(ITupleElementFilter filter, int ... tuplePrefix) {
        return null;
    }

    @Override
    public List<Tuple> getTuplesByPositionValue(int position, int ... values) {
        return null;
    }

    @Override
    public Iterator<Tuple> getFilteredIterator(int elementPosToFilter, int ... valuesToFilterBy) {
        return EMPTY_TUPLE_LIST.iterator();
    }

    private static final class EmptyTupleElementIterator
    implements TupleElementIterator {
        private EmptyTupleElementIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int next() {
            throw new NoSuchElementException();
        }
    }
}

