/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.ILockManager;
import com.ibm.cognos.fpm.common.graph.ITransaction;
import com.ibm.cognos.fpm.common.graph.ITransactionData;
import com.ibm.cognos.fpm.common.graph.ITransactionManager;
import com.ibm.cognos.fpm.common.graph.IVersionedPropertyGraph;
import com.ibm.cognos.fpm.common.graph.LoadGraphTransaction;
import com.ibm.cognos.fpm.common.graph.LockManagerFactory;
import com.ibm.cognos.fpm.common.graph.ReadWriteTransaction;
import com.ibm.cognos.fpm.common.graph.TransactionDefinition;
import java.util.concurrent.ConcurrentHashMap;

final class TransactionManager<K>
implements ITransactionManager<K> {
    private final IVersionedPropertyGraph<K> masterGraph;
    private final ILockManager lockManager;
    private ConcurrentHashMap<Thread, ITransaction<K>> transactionMap = new ConcurrentHashMap();

    public TransactionManager(IVersionedPropertyGraph<K> masterGraph) {
        assert (masterGraph != null);
        this.masterGraph = masterGraph;
        this.lockManager = LockManagerFactory.getInstance().create(masterGraph);
    }

    @Override
    public ITransaction<K> beginTransaction(TransactionDefinition definition) {
        Thread thread = Thread.currentThread();
        ITransaction<K> trans = this.transactionMap.get(thread);
        if (trans != null) {
            throw new UnsupportedOperationException("Nested transactions are not supported");
        }
        switch (definition.getTransactionType()) {
            case LOAD_GRAPH: {
                trans = new LoadGraphTransaction<K>(definition, this.masterGraph, this, this.lockManager);
                break;
            }
            case READ_ONLY: {
                throw new UnsupportedOperationException("Read-only transactions not implemented");
            }
            case READ_WRITE: {
                trans = new ReadWriteTransaction<K>(definition, this.masterGraph, this, this.lockManager);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown transaction type" + definition.getTransactionType().toString());
            }
        }
        this.transactionMap.put(thread, trans);
        return trans;
    }

    @Override
    public void commit() {
        try {
            ITransactionData<K> transactionData = this.getTransaction().getTransactionData();
            if (transactionData != null) {
                this.lockManager.acquireCommitLock();
                transactionData.commit();
            }
        }
        finally {
            this.transactionMap.remove(Thread.currentThread());
            this.lockManager.releaseAllLocks();
        }
    }

    @Override
    public void rollback() {
        this.transactionMap.remove(Thread.currentThread());
        this.lockManager.releaseAllLocks();
    }

    @Override
    public ITransaction<K> getTransaction() {
        return this.transactionMap.get(Thread.currentThread());
    }
}

