/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.AbstractTupleStore;
import com.ibm.cognos.fpm.common.graph.ReadOnlyTupleStoreImpl;
import com.ibm.cognos.fpm.common.graph.TupleStore;
import com.ibm.cognos.fpm.common.graph.TupleStoreConfiguration;
import com.ibm.cognos.fpm.common.graph.TupleStoreImpl;
import com.ibm.cognos.fpm.common.graph.TupleStoreStatisticsCollector;

public final class TupleStoreFactory {
    private static final TupleStoreFactory instance = new TupleStoreFactory();

    private TupleStoreFactory() {
    }

    public static TupleStoreFactory getInstance() {
        return instance;
    }

    public TupleStore create(TupleStoreConfiguration tupleStoreConfig) {
        return new TupleStoreImpl(tupleStoreConfig);
    }

    public TupleStore create(int tupleLength) {
        return new TupleStoreImpl(tupleLength);
    }

    public TupleStore create(int tupleLength, int bucketSize, int maxBuckets) {
        return new TupleStoreImpl(tupleLength, bucketSize, maxBuckets);
    }

    public TupleStore create(int tupleLength, int bucketSize, int maxBuckets, TupleStoreStatisticsCollector tupleStoreStats) {
        return new TupleStoreImpl(tupleLength, bucketSize, maxBuckets, tupleStoreStats);
    }

    public TupleStoreStatisticsCollector createStatisticsCollector() {
        return new AbstractTupleStore.TupleStoreImplStatisticsCollector();
    }

    public TupleStoreConfiguration createConfiguration(int tupleLength, int bucketSize, int maxBuckets, TupleStoreStatisticsCollector tupleStoreStats) {
        return new AbstractTupleStore.TupleStoreConfigurationImpl(tupleLength, bucketSize, maxBuckets, tupleStoreStats);
    }

    public TupleStoreConfiguration createConfiguration(int tupleLength, TupleStoreStatisticsCollector tupleStoreStats) {
        return new AbstractTupleStore.TupleStoreConfigurationImpl(tupleLength, tupleStoreStats);
    }

    public TupleStore createReadOnlyTupleStore(TupleStore tupleStore) {
        if (tupleStore instanceof ReadOnlyTupleStoreImpl) {
            return tupleStore;
        }
        assert (tupleStore instanceof TupleStoreImpl);
        TupleStoreImpl writableTupleStore = (TupleStoreImpl)tupleStore;
        return new ReadOnlyTupleStoreImpl(writableTupleStore.getTupleStoreConfigurationImpl(), writableTupleStore.getOptimizedBackingArrays());
    }

    public TupleStore createWritableTupleStore(TupleStore tupleStore) {
        if (tupleStore instanceof TupleStoreImpl) {
            return tupleStore;
        }
        assert (tupleStore instanceof ReadOnlyTupleStoreImpl);
        ReadOnlyTupleStoreImpl readOnlyTupleStore = (ReadOnlyTupleStoreImpl)tupleStore;
        return new TupleStoreImpl(readOnlyTupleStore.getTupleStoreConfigurationImpl(), readOnlyTupleStore.getBackingArrays());
    }
}

