/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.AbstractTupleStore;
import com.ibm.cognos.fpm.common.graph.ITupleElementFilter;
import com.ibm.cognos.fpm.common.graph.Tuple;
import com.ibm.cognos.fpm.common.graph.TupleElementIterator;
import com.ibm.cognos.fpm.common.graph.TupleStoreConfiguration;
import com.ibm.cognos.fpm.common.graph.TupleStoreStatisticsCollector;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

final class TupleStoreImpl
extends AbstractTupleStore {
    private final AbstractTupleStore.TupleStoreConfigurationImpl config;
    static final boolean VALIDATE_BUCKET_MERGE = false;
    private TupleBucket[] tupleBuckets;
    private int modCount = 1;

    TupleStoreImpl(int tupleLength, int bucketSize, int maxBuckets) {
        this.config = new AbstractTupleStore.TupleStoreConfigurationImpl(tupleLength, bucketSize, maxBuckets, new AbstractTupleStore.TupleStoreImplStatisticsCollector());
        this.createNewTupleBuckets();
    }

    TupleStoreImpl(int tupleLength, int bucketSize, int maxBuckets, TupleStoreStatisticsCollector statisticsCollector) {
        if (statisticsCollector != null && !(statisticsCollector instanceof AbstractTupleStore.TupleStoreImplStatisticsCollector)) {
            throw new IllegalArgumentException("Unsupported class type: " + statisticsCollector.getClass().getSimpleName());
        }
        this.config = new AbstractTupleStore.TupleStoreConfigurationImpl(tupleLength, bucketSize, maxBuckets, statisticsCollector);
        this.createNewTupleBuckets();
    }

    TupleStoreImpl(int tupleLength) {
        this.config = new AbstractTupleStore.TupleStoreConfigurationImpl(tupleLength);
        this.createNewTupleBuckets();
    }

    TupleStoreImpl(TupleStoreConfiguration config) {
        if (!(config instanceof AbstractTupleStore.TupleStoreConfigurationImpl)) {
            throw new IllegalArgumentException("Unsupported class type: " + config.getClass().getSimpleName());
        }
        this.config = (AbstractTupleStore.TupleStoreConfigurationImpl)config;
        this.createNewTupleBuckets();
    }

    TupleStoreImpl(AbstractTupleStore.TupleStoreConfigurationImpl config, int[][] tuples) {
        this.config = config;
        this.tupleBuckets = new TupleBucket[1];
        this.tupleBuckets[0] = new TupleBucket(tuples, 0, tuples[0].length);
    }

    private void createNewTupleBuckets() {
        this.tupleBuckets = new TupleBucket[1];
        this.tupleBuckets[0] = new TupleBucket(new int[this.config.tupleLength][0], 0, 0);
    }

    int[][] getOptimizedBackingArrays() {
        this.optimize();
        assert (this.getDirtyEntryCount() == 0);
        assert (this.tupleBuckets.length == 1);
        return this.tupleBuckets[0].tuples;
    }

    AbstractTupleStore.TupleStoreConfigurationImpl getTupleStoreConfigurationImpl() {
        return this.config;
    }

    @Override
    public boolean addTuple(int ... tuple) {
        if (tuple.length != this.config.tupleLength) {
            throw new IllegalArgumentException("Tuple must contain '" + this.config.tupleLength + "' elements.");
        }
        if (tuple[0] == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use can cannot be stored.");
        }
        assert (this.tupleBuckets.length <= this.config.maxBucketCount);
        long startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementAddTupleCount();
            startTime = System.currentTimeMillis();
        }
        try {
            long addTupleChooseTargetCollectionStartTime = 0L;
            if (this.config.collectStatistics()) {
                addTupleChooseTargetCollectionStartTime = System.currentTimeMillis();
            }
            TupleBucket targetCollection = null;
            int insertPos = Integer.MIN_VALUE;
            int bestCost = Integer.MAX_VALUE;
            TupleBucket emptyCollection = null;
            int i = this.tupleBuckets.length - 1;
            while (i >= 0) {
                TupleBucket tupleCollection = this.tupleBuckets[i];
                int potentialInsertPos = tupleCollection.indexOf(this.config.statisticsCollector, tuple);
                if (potentialInsertPos >= 0) {
                    return false;
                }
                if (tupleCollection.size() == 0) {
                    emptyCollection = tupleCollection;
                } else {
                    int currentCost = Integer.MAX_VALUE;
                    if (-(potentialInsertPos + 1) == tupleCollection.tuplesLastPos) {
                        currentCost = 1;
                    } else if (-(potentialInsertPos + 1) == tupleCollection.tuplesStartPos) {
                        currentCost = 1;
                    } else {
                        int relativeInsertPos = -(potentialInsertPos + 1) - tupleCollection.tuplesStartPos;
                        if (tupleCollection.tuples[0][-(potentialInsertPos + 1)] == Integer.MIN_VALUE) {
                            currentCost = 0;
                        } else {
                            int n = currentCost = relativeInsertPos < tupleCollection.size() >>> 1 ? relativeInsertPos : tupleCollection.size() - relativeInsertPos;
                        }
                    }
                    assert (currentCost >= 0);
                    if (currentCost > 0 && tupleCollection.capacity() == 0) {
                        currentCost = tupleCollection.size();
                    }
                    if (currentCost < bestCost) {
                        targetCollection = tupleCollection;
                        insertPos = potentialInsertPos;
                        bestCost = currentCost;
                    }
                }
                --i;
            }
            if (this.config.collectStatistics()) {
                this.config.statisticsCollector.addAddTupleChooseContainerTime(System.currentTimeMillis() - addTupleChooseTargetCollectionStartTime);
            }
            if (bestCost > this.config.maxBucketSize) {
                if (emptyCollection != null) {
                    targetCollection = emptyCollection;
                    insertPos = -targetCollection.tuplesStartPos - 1;
                } else if (this.tupleBuckets.length >= this.config.maxBucketCount) {
                    this.consolidate(true);
                    targetCollection = this.tupleBuckets[1];
                    insertPos = -targetCollection.tuplesStartPos - 1;
                } else {
                    targetCollection = new TupleBucket(new int[this.config.tupleLength][0], 0, 0);
                    TupleBucket[] tmpTupleBuckets = new TupleBucket[this.tupleBuckets.length + 1];
                    System.arraycopy(this.tupleBuckets, 0, tmpTupleBuckets, 0, this.tupleBuckets.length);
                    this.tupleBuckets = tmpTupleBuckets;
                    this.tupleBuckets[this.tupleBuckets.length - 1] = targetCollection;
                    insertPos = -1;
                }
            }
            targetCollection.addTuple(this.config.statisticsCollector, -(insertPos + 1), tuple);
            ++this.modCount;
            return true;
        }
        finally {
            if (this.config.collectStatistics()) {
                this.config.statisticsCollector.addAddTupleTime(System.currentTimeMillis() - startTime);
            }
        }
    }

    @Override
    public boolean addTuple(Tuple tuple) {
        return this.addTuple(tuple.toArray());
    }

    @Override
    public boolean removeTuple(int ... tuple) {
        if (tuple[0] == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use can cannot be stored.");
        }
        assert (this.tupleBuckets.length <= this.config.maxBucketCount);
        long startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementRemoveTupleCount();
            startTime = System.currentTimeMillis();
        }
        try {
            boolean removed = false;
            int i = this.tupleBuckets.length - 1;
            while (i >= 0) {
                TupleBucket tupleCollection = this.tupleBuckets[i];
                int pos = tupleCollection.indexOf(this.config.statisticsCollector, tuple);
                if (pos >= 0) {
                    tupleCollection.removeTuple(pos);
                    ++this.modCount;
                    removed = true;
                    break;
                }
                if (tuple.length < this.config.tupleLength) {
                    int tupleSequence = pos = -(pos + 1);
                    while (tupleSequence < tupleCollection.tuplesLastPos) {
                        if (tupleCollection.tuples[0][tupleSequence] != Integer.MIN_VALUE) {
                            boolean matched = true;
                            int tupleElement = 0;
                            while (tupleElement < tuple.length) {
                                if (tupleCollection.tuples[tupleElement][tupleSequence] != tuple[tupleElement]) {
                                    matched = false;
                                    break;
                                }
                                ++tupleElement;
                            }
                            if (!matched) break;
                            tupleCollection.removeTuple(tupleSequence);
                            ++this.modCount;
                            removed = true;
                        }
                        ++tupleSequence;
                    }
                }
                --i;
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            if (this.config.collectStatistics()) {
                this.config.statisticsCollector.addRemoveTupleTime(System.currentTimeMillis() - startTime);
            }
        }
    }

    @Override
    public boolean removeTuple(Tuple tuple) {
        return this.removeTuple(tuple.toArray());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean containsTuple(int ... tuple) {
        if (tuple[0] == -2147483648) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use can cannot be stored.");
        }
        startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementContainsCount();
            startTime = System.currentTimeMillis();
        }
        i = this.tupleBuckets.length - 1;
        while (true) {
            tupleCollection = this.tupleBuckets[i];
            found = TupleStoreImpl.containsTuple(this.config.statisticsCollector, TupleBucket.access$2(tupleCollection), TupleBucket.access$0(tupleCollection), TupleBucket.access$1(tupleCollection), tuple);
            if (found) {
                return true;
            }
            --i;
            return (boolean)i;
        }
lbl17:
        // 1 sources

        return false;
        finally {
            if (i >= 0) ** continue;
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean containsTuple(ITupleElementFilter filter, int ... tuple) {
        if (tuple[0] == -2147483648) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use can cannot be stored.");
        }
        startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementContainsCount();
            startTime = System.currentTimeMillis();
        }
        i = this.tupleBuckets.length - 1;
        while (true) {
            tupleCollection = this.tupleBuckets[i];
            found = TupleStoreImpl.containsFilteredTuple(this.config.statisticsCollector, filter, TupleBucket.access$2(tupleCollection), TupleBucket.access$0(tupleCollection), TupleBucket.access$1(tupleCollection), tuple);
            if (found) {
                return true;
            }
            --i;
            return (boolean)i;
        }
lbl17:
        // 1 sources

        return false;
        finally {
            if (i >= 0) ** continue;
            ** continue;
        }
    }

    @Override
    public List<Tuple> getTuples(int ... tupleSuffix) {
        if (tupleSuffix.length > this.config.tupleLength) {
            throw new IllegalArgumentException("Tuple suffix must contain '" + this.config.tupleLength + "' or fewer elements.");
        }
        if (tupleSuffix[0] == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use can cannot be stored.");
        }
        long startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementGetTuplesByPrefixCount();
            startTime = System.currentTimeMillis();
        }
        try {
            ArrayList<Tuple> tuples = new ArrayList<Tuple>();
            int i = 0;
            while (i < this.tupleBuckets.length) {
                this.tupleBuckets[i].getTuples(this.config.statisticsCollector, tuples, tupleSuffix);
                ++i;
            }
            List<Tuple> list = Collections.unmodifiableList(tuples);
            return list;
        }
        finally {
            if (this.config.collectStatistics()) {
                this.config.statisticsCollector.addGetTuplesByPrefixTime(System.currentTimeMillis() - startTime);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Tuple getTuple(int ... tuplePrefix) {
        if (tuplePrefix.length > this.config.tupleLength) {
            throw new IllegalArgumentException("Tuple prefix must contain '" + this.config.tupleLength + "' or fewer elements.");
        }
        if (tuplePrefix[0] == -2147483648) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use and cannot be stored.");
        }
        startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementGetTuplesByPrefixCount();
            startTime = System.currentTimeMillis();
        }
        i = 0;
        while (true) {
            tuple = this.tupleBuckets[i].getTuple(this.config.statisticsCollector, tuplePrefix);
            if (tuple != null) {
                var7_5 = tuple;
                return var7_5;
            }
            ++i;
            return i;
        }
lbl19:
        // 1 sources

        return null;
        finally {
            if (i < this.tupleBuckets.length) ** continue;
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Tuple getTuple(ITupleElementFilter filter, int ... tuplePrefix) {
        if (tuplePrefix.length > this.config.tupleLength) {
            throw new IllegalArgumentException("Tuple prefix must contain '" + this.config.tupleLength + "' or fewer elements.");
        }
        if (tuplePrefix[0] == -2147483648) {
            throw new IllegalArgumentException("The integer value Integer.MIN_VALUE is reserved for internal use and cannot be stored.");
        }
        startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementGetTuplesByPrefixCount();
            startTime = System.currentTimeMillis();
        }
        i = 0;
        while (true) {
            tuple = this.tupleBuckets[i].getTuple(this.config.statisticsCollector, filter, tuplePrefix);
            if (tuple != null) {
                var8_6 = tuple;
                return var8_6;
            }
            ++i;
            return i;
        }
lbl19:
        // 1 sources

        return null;
        finally {
            if (i < this.tupleBuckets.length) ** continue;
            ** continue;
        }
    }

    @Override
    public List<Tuple> getTuplesByPositionValue(int position, int ... values) {
        if (position >= this.config.tupleLength) {
            throw new IllegalArgumentException("The position must be between 0 and " + (this.config.tupleLength - 1));
        }
        if (position == 0 && values.length == 1) {
            return this.getTuples(values[0]);
        }
        long startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementGetTuplesByPositionValueCount();
            startTime = System.currentTimeMillis();
        }
        try {
            ArrayList<Tuple> tuples = new ArrayList<Tuple>();
            int i = 0;
            while (i < this.tupleBuckets.length) {
                this.tupleBuckets[i].getTuplesByPositionValue(tuples, position, values);
                ++i;
            }
            List<Tuple> list = Collections.unmodifiableList(tuples);
            return list;
        }
        finally {
            if (this.config.collectStatistics()) {
                this.config.statisticsCollector.addGetTuplesByPositionValueTime(System.currentTimeMillis() - startTime);
            }
        }
    }

    @Override
    public int size() {
        if (this.tupleBuckets == null) {
            return 0;
        }
        int size = 0;
        int i = 0;
        while (i < this.tupleBuckets.length) {
            size += this.tupleBuckets[i].tuplesLastPos - this.tupleBuckets[i].tuplesStartPos - this.tupleBuckets[i].dirtyEntryCount;
            ++i;
        }
        return size;
    }

    @Override
    public boolean optimize() {
        boolean modified = this.consolidate(false);
        if (modified) {
            ++this.modCount;
        }
        return modified;
    }

    @Override
    public TupleElementIterator getTupleElementIterator(int elementPos) {
        this.optimize();
        assert (this.tupleBuckets.length == 1);
        return this.tupleBuckets[0].getTupleElementIterator(this, elementPos);
    }

    @Override
    public TupleElementIterator getTupleElementFilteredIterator(int elementPosToReturn, int elementPosToFilter, int ... valuesToFilterBy) {
        this.optimize();
        assert (this.tupleBuckets.length == 1);
        return this.tupleBuckets[0].getTupleElementFilteredIterator(this, elementPosToReturn, elementPosToFilter, valuesToFilterBy);
    }

    public String toString() {
        return this.config.statisticsCollector.toString();
    }

    private boolean consolidate(boolean addRoomToGrow) {
        if (this.tupleBuckets.length <= 1) {
            if (!addRoomToGrow) {
                return this.tupleBuckets[0].optimize();
            }
            return false;
        }
        long startTime = 0L;
        if (this.config.collectStatistics()) {
            this.config.statisticsCollector.incrementOptimizeCount();
            startTime = System.currentTimeMillis();
        }
        try {
            TupleBucket mergeTarget = null;
            int largestCollectionSize = 0;
            int mergeTargetIndex = -1;
            int i = 0;
            while (i < this.tupleBuckets.length) {
                TupleBucket mergeTargetCandidate = this.tupleBuckets[i];
                if (mergeTargetCandidate.size() > largestCollectionSize) {
                    mergeTarget = mergeTargetCandidate;
                    largestCollectionSize = mergeTargetCandidate.size();
                    mergeTargetIndex = i;
                }
                ++i;
            }
            if (mergeTarget == null) {
                return false;
            }
            this.tupleBuckets[mergeTargetIndex] = null;
            mergeTarget.merge(this.config, this.tupleBuckets, addRoomToGrow);
            if (addRoomToGrow) {
                this.tupleBuckets = new TupleBucket[2];
                this.tupleBuckets[1] = new TupleBucket(new int[this.config.tupleLength][0], 0, 0);
            } else {
                this.tupleBuckets = new TupleBucket[1];
            }
            this.tupleBuckets[0] = mergeTarget;
            return true;
        }
        finally {
            if (this.config.collectStatistics()) {
                this.config.statisticsCollector.addOptimizeTime(System.currentTimeMillis() - startTime);
            }
        }
    }

    int getDirtyEntryCount() {
        int dirtyEntryCount = 0;
        int i = 0;
        while (i < this.tupleBuckets.length) {
            dirtyEntryCount += this.tupleBuckets[i].dirtyEntryCount;
            ++i;
        }
        return dirtyEntryCount;
    }

    @Override
    public boolean add(Tuple object) {
        return this.addTuple(object.toArray());
    }

    @Override
    public boolean addAll(Collection<? extends Tuple> tuples) {
        boolean modified = false;
        for (Tuple tuple : tuples) {
            if (!this.add(tuple)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.createNewTupleBuckets();
        ++this.modCount;
    }

    @Override
    public Iterator<Tuple> iterator() {
        this.optimize();
        assert (this.tupleBuckets.length == 1);
        return this.tupleBuckets[0].iterator(this);
    }

    @Override
    public Iterator<Tuple> getFilteredIterator(int elementPosToFilter, int ... valuesToFilterBy) {
        this.optimize();
        assert (this.tupleBuckets.length == 1);
        return this.tupleBuckets[0].getFilteredIterator(this, elementPosToFilter, valuesToFilterBy);
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof int[])) {
            throw new ClassCastException(object.getClass().getSimpleName());
        }
        return this.removeTuple((int[])object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean modified = false;
        for (Object object : collection) {
            if (!this.remove(object)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    private static void move(int[][] tuples, int tupleLength, int srcPos, int destPos, int count) {
        int j = 0;
        while (j < count) {
            int i = 0;
            while (i < tupleLength) {
                tuples[i][destPos + j] = tuples[i][srcPos + j];
                ++i;
            }
            ++j;
        }
    }

    private static final class SmoothSort {
        static final int[] LP = new int[]{1, 1, 3, 5, 9, 15, 25, 41, 67, 109, 177, 287, 465, 753, 1219, 1973, 3193, 5167, 8361, 13529, 21891, 35421, 57313, 92735, 150049, 242785, 392835, 635621, 1028457, 1664079, 2692537, 4356617, 7049155, 11405773, 0x1199991, 29860703, 48315633, 78176337, 126491971, 204668309, 331160281, 535828591, 866988873};

        private SmoothSort() {
        }

        public static void sort(int lo, int hi, int[][] m, int tupleLength) {
            int head = lo;
            int p = 1;
            int pshift = 1;
            while (head < hi) {
                if ((p & 3) == 3) {
                    SmoothSort.sift(m, tupleLength, pshift, head);
                    p >>>= 2;
                    pshift += 2;
                } else {
                    if (LP[pshift - 1] >= hi - head) {
                        SmoothSort.trinkle(m, tupleLength, p, pshift, head, false);
                    } else {
                        SmoothSort.sift(m, tupleLength, pshift, head);
                    }
                    if (pshift == 1) {
                        p <<= 1;
                        --pshift;
                    } else {
                        p <<= pshift - 1;
                        pshift = 1;
                    }
                }
                p |= 1;
                ++head;
            }
            SmoothSort.trinkle(m, tupleLength, p, pshift, head, false);
            while (pshift != 1 || p != 1) {
                if (pshift <= 1) {
                    int trail = Integer.numberOfTrailingZeros(p & 0xFFFFFFFE);
                    p >>>= trail;
                    pshift += trail;
                } else {
                    p <<= 2;
                    SmoothSort.trinkle(m, tupleLength, (p ^= 7) >>> 1, (pshift -= 2) + 1, head - LP[pshift] - 1, true);
                    SmoothSort.trinkle(m, tupleLength, p, pshift, head - 1, true);
                }
                --head;
            }
        }

        private static void sift(int[][] m, int tupleLength, int pshift, int head) {
            int[] val = TupleStoreImpl.fill(m, head, new int[tupleLength]);
            while (pshift > 1) {
                int rt = head - 1;
                int lf = head - 1 - LP[pshift - 2];
                if (TupleStoreImpl.compare(val, m, lf) >= 0 && TupleStoreImpl.compare(val, m, rt) >= 0) break;
                if (TupleStoreImpl.compare(m, lf, m, rt) >= 0) {
                    TupleStoreImpl.move(m, tupleLength, lf, head, 1);
                    head = lf;
                    --pshift;
                    continue;
                }
                TupleStoreImpl.move(m, tupleLength, rt, head, 1);
                head = rt;
                pshift -= 2;
            }
            TupleStoreImpl.fill(val, tupleLength, m, head);
        }

        private static void trinkle(int[][] m, int tupleLength, int p, int pshift, int head, boolean isTrusty) {
            int[] val = new int[tupleLength];
            TupleStoreImpl.fill(m, head, val);
            while (p != 1) {
                int stepson = head - LP[pshift];
                if (TupleStoreImpl.compare(m, stepson, val) <= 0) break;
                if (!isTrusty && pshift > 1) {
                    int rt = head - 1;
                    int lf = head - 1 - LP[pshift - 2];
                    if (TupleStoreImpl.compare(m, rt, m, stepson) >= 0 || TupleStoreImpl.compare(m, lf, m, stepson) >= 0) break;
                }
                TupleStoreImpl.move(m, tupleLength, stepson, head, 1);
                head = stepson;
                int trail = Integer.numberOfTrailingZeros(p & 0xFFFFFFFE);
                p >>>= trail;
                pshift += trail;
                isTrusty = false;
            }
            if (!isTrusty) {
                TupleStoreImpl.fill(val, tupleLength, m, head);
                SmoothSort.sift(m, tupleLength, pshift, head);
            }
        }
    }

    public static final class TupleBucket {
        private int[][] tuples;
        private int tuplesStartPos;
        private int tuplesLastPos;
        private int dirtyEntryCount = 0;

        TupleBucket(int[][] tuples, int tuplesStartPos, int tuplesLastPos) {
            this.tuplesLastPos = tuplesLastPos;
            this.tuplesStartPos = tuplesStartPos;
            this.tuples = tuples;
        }

        public boolean optimize() {
            if (this.tuples[0].length == this.tuplesLastPos && this.tuplesStartPos == 0) {
                return false;
            }
            int newTuplesSize = this.size();
            int tupleColumn = 0;
            while (tupleColumn < this.tuples.length) {
                int[] tmpColumn = new int[newTuplesSize];
                System.arraycopy(this.tuples[tupleColumn], this.tuplesStartPos, tmpColumn, 0, this.tuplesLastPos - this.tuplesStartPos);
                this.tuples[tupleColumn] = tmpColumn;
                ++tupleColumn;
            }
            this.tuplesStartPos = 0;
            this.tuplesLastPos = newTuplesSize;
            return true;
        }

        public void addTuple(AbstractTupleStore.TupleStoreImplStatisticsCollector statisticsCollector, int insertPos, int ... tuple) {
            if (this.tuples[0].length == this.tuplesLastPos || this.tuplesStartPos == 0 && this.tuplesLastPos != 0) {
                if (statisticsCollector != null) {
                    statisticsCollector.incrementAddTupleGrowArrayCount();
                }
                long startTime = System.currentTimeMillis();
                int extraBuffer = this.tuples[0].length > 12 ? this.tuples[0].length >>> 3 : 12;
                int newTuplesSize = this.tuples[0].length + extraBuffer;
                int newTuplesStartPos = extraBuffer >>> 1;
                int newTuplesLastPos = this.tuplesLastPos + newTuplesStartPos - this.tuplesStartPos;
                insertPos += newTuplesStartPos - this.tuplesStartPos;
                int tupleColumn = 0;
                while (tupleColumn < this.tuples.length) {
                    int[] tmpColumn = new int[newTuplesSize];
                    System.arraycopy(this.tuples[tupleColumn], this.tuplesStartPos, tmpColumn, newTuplesStartPos, this.tuplesLastPos - this.tuplesStartPos);
                    this.tuples[tupleColumn] = tmpColumn;
                    ++tupleColumn;
                }
                this.tuplesStartPos = newTuplesStartPos;
                this.tuplesLastPos = newTuplesLastPos;
                if (statisticsCollector != null) {
                    statisticsCollector.addAddTupleGrowArrayTime(System.currentTimeMillis() - startTime);
                }
            }
            if (insertPos == this.tuplesLastPos) {
                int tupleColumn = 0;
                while (tupleColumn < tuple.length) {
                    this.tuples[tupleColumn][insertPos] = tuple[tupleColumn];
                    ++tupleColumn;
                }
                ++this.tuplesLastPos;
            } else if (insertPos == this.tuplesStartPos && this.tuplesStartPos != 0) {
                --this.tuplesStartPos;
                int tupleColumn = 0;
                while (tupleColumn < tuple.length) {
                    this.tuples[tupleColumn][this.tuplesStartPos] = tuple[tupleColumn];
                    ++tupleColumn;
                }
            } else if (this.tuples[0][insertPos] == Integer.MIN_VALUE) {
                int tupleColumn = 0;
                while (tupleColumn < tuple.length) {
                    this.tuples[tupleColumn][insertPos] = tuple[tupleColumn];
                    ++tupleColumn;
                }
                --this.dirtyEntryCount;
                assert (this.dirtyEntryCount >= 0);
            } else {
                int i;
                int tuplesMidPos = this.tuplesLastPos - this.tuplesStartPos >>> 1;
                if (insertPos < tuplesMidPos && this.tuplesStartPos != 0) {
                    int tupleColumn = 0;
                    while (tupleColumn < tuple.length) {
                        i = this.tuplesStartPos;
                        while (i < insertPos) {
                            this.tuples[tupleColumn][i - 1] = this.tuples[tupleColumn][i];
                            ++i;
                        }
                        this.tuples[tupleColumn][insertPos - 1] = tuple[tupleColumn];
                        ++tupleColumn;
                    }
                    --this.tuplesStartPos;
                } else {
                    assert (this.tuplesLastPos != this.tuples[0].length);
                    int tupleColumn = 0;
                    while (tupleColumn < tuple.length) {
                        i = this.tuplesLastPos;
                        while (i > insertPos) {
                            this.tuples[tupleColumn][i] = this.tuples[tupleColumn][i - 1];
                            --i;
                        }
                        this.tuples[tupleColumn][insertPos] = tuple[tupleColumn];
                        ++tupleColumn;
                    }
                    ++this.tuplesLastPos;
                }
            }
        }

        public void removeTuple(int removePos) {
            if (removePos == this.tuplesStartPos) {
                ++this.tuplesStartPos;
                while (this.tuplesStartPos < this.tuplesLastPos && this.tuples[0][this.tuplesStartPos] == Integer.MIN_VALUE) {
                    ++this.tuplesStartPos;
                    --this.dirtyEntryCount;
                    assert (this.dirtyEntryCount >= 0);
                }
            } else if (removePos == this.tuplesLastPos - 1) {
                --this.tuplesLastPos;
                while (this.tuplesStartPos < this.tuplesLastPos && this.tuples[0][this.tuplesLastPos - 1] == Integer.MIN_VALUE) {
                    --this.tuplesLastPos;
                    --this.dirtyEntryCount;
                    assert (this.dirtyEntryCount >= 0);
                }
            } else {
                this.tuples[0][removePos] = Integer.MIN_VALUE;
                ++this.dirtyEntryCount;
            }
        }

        public int indexOf(AbstractTupleStore.TupleStoreImplStatisticsCollector statsCollector, int ... tuple) {
            if (this.size() == 0) {
                return -(this.tuplesStartPos + 1);
            }
            return TupleStoreImpl.binarySearch(statsCollector, this.tuples, this.tuplesStartPos, this.tuplesLastPos - 1, tuple);
        }

        public void getTuples(AbstractTupleStore.TupleStoreImplStatisticsCollector statsCollector, List<Tuple> tuples, int ... tuplePrefix) {
            if (this.size() == 0) {
                return;
            }
            AbstractTupleStore.getTuples(statsCollector, this.tuples, this.tuplesStartPos, this.tuplesLastPos, tuples, tuplePrefix);
        }

        public void getTuplesByPositionValue(List<Tuple> tuples, int position, int ... values) {
            if (this.size() == 0) {
                return;
            }
            AbstractTupleStore.getTuplesByPositionValue(this.tuples, this.tuplesStartPos, this.tuplesLastPos, tuples, position, values);
        }

        public Tuple getTuple(AbstractTupleStore.TupleStoreImplStatisticsCollector statsCollector, int ... tuplePrefix) {
            if (this.size() == 0) {
                return null;
            }
            return AbstractTupleStore.getTuple(statsCollector, this.tuples, this.tuplesStartPos, this.tuplesLastPos, tuplePrefix);
        }

        public Tuple getTuple(AbstractTupleStore.TupleStoreImplStatisticsCollector statsCollector, ITupleElementFilter filter, int ... tuplePrefix) {
            if (this.size() == 0) {
                return null;
            }
            return AbstractTupleStore.getTuple(statsCollector, filter, this.tuples, this.tuplesStartPos, this.tuplesLastPos, tuplePrefix);
        }

        public TupleElementIterator getTupleElementIterator(final TupleStoreImpl tupleStoreImpl, final int elementPos) {
            return new TupleElementIterator(){
                private final int modCount;
                private int pos;
                {
                    this.modCount = tupleStoreImpl2.modCount;
                    this.pos = TupleBucket.this.tuplesStartPos;
                }

                @Override
                public boolean hasNext() {
                    if (this.modCount != tupleStoreImpl.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    int nextPos = this.pos;
                    while (nextPos < TupleBucket.this.tuplesLastPos) {
                        if (TupleBucket.this.tuples[0][nextPos] != Integer.MIN_VALUE) break;
                        ++nextPos;
                    }
                    return nextPos < TupleBucket.this.tuplesLastPos;
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public int next() {
                    if (this.modCount == TupleStoreImpl.access$1(tupleStoreImpl)) ** GOTO lbl5
                    throw new ConcurrentModificationException();
                    while (TupleBucket.access$2(TupleBucket.this)[0][this.pos] == -2147483648) {
                        ++this.pos;
lbl5:
                        // 2 sources

                        if (this.pos < TupleBucket.access$1(TupleBucket.this)) continue;
                    }
                    if (this.pos == TupleBucket.access$1(TupleBucket.this)) {
                        throw new NoSuchElementException();
                    }
                    return TupleBucket.access$2(TupleBucket.this)[elementPos][this.pos++];
                }
            };
        }

        public TupleElementIterator getTupleElementFilteredIterator(final TupleStoreImpl tupleStoreImpl, final int elementPosToReturn, final int elementPosToFilter, final int ... valuesToFilterBy) {
            return new TupleElementIterator(){
                private final int modCount;
                private int pos;
                private boolean movedToNext;
                {
                    this.modCount = tupleStoreImpl2.modCount;
                    this.pos = TupleBucket.this.tuplesStartPos;
                    this.movedToNext = true;
                    Arrays.sort(nArray);
                }

                private int getNextTupleSequence() {
                    if (this.movedToNext) {
                        return this.pos;
                    }
                    int nextPos = this.pos + 1;
                    while (nextPos < TupleBucket.this.tuplesLastPos) {
                        if (TupleBucket.this.tuples[0][nextPos] != Integer.MIN_VALUE && Arrays.binarySearch(valuesToFilterBy, TupleBucket.this.tuples[elementPosToFilter][nextPos]) >= 0) {
                            this.movedToNext = true;
                            this.pos = nextPos;
                            return this.pos;
                        }
                        ++nextPos;
                    }
                    return TupleBucket.this.tuplesLastPos;
                }

                @Override
                public boolean hasNext() {
                    if (this.modCount != tupleStoreImpl.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    if (this.movedToNext) {
                        return true;
                    }
                    return this.getNextTupleSequence() < TupleBucket.this.tuplesLastPos;
                }

                @Override
                public int next() {
                    int nextPos;
                    if (this.modCount != tupleStoreImpl.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    int n = nextPos = this.movedToNext ? this.pos : this.getNextTupleSequence();
                    if (nextPos == TupleBucket.this.tuplesLastPos) {
                        throw new NoSuchElementException();
                    }
                    this.movedToNext = false;
                    return TupleBucket.this.tuples[elementPosToReturn][nextPos];
                }
            };
        }

        public Iterator<Tuple> iterator(final TupleStoreImpl tupleStoreImpl) {
            return new Iterator<Tuple>(){
                private final int modCount;
                private int pos;
                {
                    this.modCount = tupleStoreImpl2.modCount;
                    this.pos = TupleBucket.this.tuplesStartPos;
                }

                @Override
                public boolean hasNext() {
                    if (this.modCount != tupleStoreImpl.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    int nextPos = this.pos;
                    while (nextPos < TupleBucket.this.tuplesLastPos) {
                        if (TupleBucket.this.tuples[0][nextPos] != Integer.MIN_VALUE) break;
                        ++nextPos;
                    }
                    return nextPos < TupleBucket.this.tuplesLastPos;
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public Tuple next() {
                    if (this.modCount == TupleStoreImpl.access$1(tupleStoreImpl)) ** GOTO lbl5
                    throw new ConcurrentModificationException();
                    while (TupleBucket.access$2(TupleBucket.this)[0][this.pos] == -2147483648) {
                        ++this.pos;
lbl5:
                        // 2 sources

                        if (this.pos < TupleBucket.access$1(TupleBucket.this)) continue;
                    }
                    if (this.pos == TupleBucket.access$1(TupleBucket.this)) {
                        throw new NoSuchElementException();
                    }
                    return new AbstractTupleStore.TupleImpl(TupleBucket.access$2(TupleBucket.this), this.pos++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public Iterator<Tuple> getFilteredIterator(final TupleStoreImpl tupleStoreImpl, int elementPosToFilter, int ... valuesToFilterBy) {
            return new Iterator<Tuple>(elementPosToFilter, valuesToFilterBy){
                private final Iterator<Tuple> wrappedIterator;
                private final int modCount;
                {
                    this.modCount = tupleStoreImpl2.modCount;
                    ArrayList<Tuple> filteredTuples = new ArrayList<Tuple>();
                    TupleBucket.this.getTuplesByPositionValue(filteredTuples, n, nArray);
                    this.wrappedIterator = filteredTuples.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.modCount != tupleStoreImpl.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    return this.wrappedIterator.hasNext();
                }

                @Override
                public Tuple next() {
                    if (this.modCount != tupleStoreImpl.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    return this.wrappedIterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int size() {
            return this.tuplesLastPos - this.tuplesStartPos;
        }

        public int capacity() {
            return this.tuples[0].length - this.size();
        }

        public void clear() {
            this.tuplesLastPos = this.tuplesStartPos = this.tuples[0].length >>> 1;
            this.dirtyEntryCount = 0;
        }

        public void merge(AbstractTupleStore.TupleStoreConfigurationImpl config, TupleBucket[] tupleCollections, boolean addRoomToGrow) {
            long mergeStartTime = 0L;
            if (config.collectStatistics()) {
                config.statisticsCollector.incrementMergeCount();
                mergeStartTime = System.currentTimeMillis();
            }
            try {
                int[][] tuplesToMerge = null;
                int tuplesToMergeStartPos = -1;
                int tuplesToMergeEndPos = -1;
                if (tupleCollections.length > 1) {
                    long sortStartTime = System.currentTimeMillis();
                    int newSize = 0;
                    int i = 0;
                    while (i < tupleCollections.length) {
                        if (tupleCollections[i] != null) {
                            newSize += tupleCollections[i].size();
                        }
                        ++i;
                    }
                    tuplesToMerge = new int[config.tupleLength][newSize];
                    int tupleColumn = 0;
                    while (tupleColumn < config.tupleLength) {
                        int tmpTuplesOffset = 0;
                        int i2 = 0;
                        while (i2 < tupleCollections.length) {
                            if (tupleCollections[i2] != null) {
                                TupleBucket tupleCollectionToMerge = tupleCollections[i2];
                                System.arraycopy(tupleCollectionToMerge.tuples[tupleColumn], tupleCollectionToMerge.tuplesStartPos, tuplesToMerge[tupleColumn], tmpTuplesOffset, tupleCollectionToMerge.size());
                                tmpTuplesOffset += tupleCollectionToMerge.size();
                            }
                            ++i2;
                        }
                        ++tupleColumn;
                    }
                    SmoothSort.sort(0, newSize - 1, tuplesToMerge, config.tupleLength);
                    tuplesToMergeStartPos = 0;
                    tuplesToMergeEndPos = newSize;
                    while (tuplesToMerge[0][tuplesToMergeStartPos] == Integer.MIN_VALUE) {
                        ++tuplesToMergeStartPos;
                    }
                    if (config.collectStatistics()) {
                        config.statisticsCollector.incrementMergeSortCount();
                        config.statisticsCollector.addMergeSortTime(System.currentTimeMillis() - sortStartTime);
                    }
                } else {
                    tuplesToMerge = tupleCollections[0].tuples;
                    tuplesToMergeStartPos = tupleCollections[0].tuplesStartPos;
                    tuplesToMergeEndPos = tupleCollections[0].tuplesLastPos;
                }
                this.merge(config, tuplesToMerge, tuplesToMergeStartPos, tuplesToMergeEndPos, addRoomToGrow);
            }
            finally {
                if (config.collectStatistics()) {
                    config.statisticsCollector.addMergeTime(System.currentTimeMillis() - mergeStartTime);
                }
            }
        }

        private void merge(AbstractTupleStore.TupleStoreConfigurationImpl config, int[][] tuplesToMerge, int tuplesToMergeStartPos, int tuplesToMergeLastPos, boolean addRoomToGrow) {
            List<TupleBucket> mergePoints = this.partitionSortedTuples(config, tuplesToMerge, tuplesToMergeStartPos, tuplesToMergeLastPos);
            if (this.tuples[0].length - this.tuplesLastPos >= tuplesToMergeLastPos - tuplesToMergeStartPos) {
                long startTime = 0L;
                if (config.collectStatistics()) {
                    startTime = System.currentTimeMillis();
                    config.statisticsCollector.incrementMergeMoveCount();
                }
                int[][] originalTuples = null;
                int originalTuplesStartPos = this.tuplesStartPos;
                int originalTuplesLastPos = this.tuplesLastPos;
                int tupleColumn = 0;
                while (tupleColumn < config.tupleLength) {
                    int tuplesOffset = this.tuplesLastPos + tuplesToMergeLastPos - tuplesToMergeStartPos;
                    int i = mergePoints.size() - 1;
                    while (i >= 0) {
                        TupleBucket tupleCollection = mergePoints.get(i);
                        int length = tupleCollection.tuplesLastPos - tupleCollection.tuplesStartPos;
                        tuplesOffset -= length;
                        if (tupleCollection.tuples == this.tuples) {
                            if (i == 0) break;
                            int j = length - 1;
                            while (j >= 0) {
                                this.tuples[tupleColumn][tuplesOffset + j] = this.tuples[tupleColumn][tupleCollection.tuplesStartPos + j];
                                --j;
                            }
                        } else if (length > 1) {
                            System.arraycopy(tupleCollection.tuples[tupleColumn], tupleCollection.tuplesStartPos, this.tuples[tupleColumn], tuplesOffset, length);
                        } else {
                            this.tuples[tupleColumn][tuplesOffset] = tupleCollection.tuples[tupleColumn][tupleCollection.tuplesStartPos];
                        }
                        --i;
                    }
                    ++tupleColumn;
                }
                this.tuplesLastPos += tuplesToMergeLastPos - tuplesToMergeStartPos;
                if (config.collectStatistics()) {
                    config.statisticsCollector.addMoveMergeTime(System.currentTimeMillis() - startTime);
                }
            } else {
                long startTime = 0L;
                if (config.collectStatistics()) {
                    startTime = System.currentTimeMillis();
                    config.statisticsCollector.incrementMergeCopyCount();
                }
                int tmpTuplesStartPos = 0;
                int tmpTuplesSize = this.tuplesLastPos - this.tuplesStartPos + tuplesToMergeLastPos - tuplesToMergeStartPos;
                int tmpTuplesExtraBuffer = addRoomToGrow ? tmpTuplesSize >>> 3 : 0;
                int[][] tmpTuples = new int[config.tupleLength][tmpTuplesSize + tmpTuplesExtraBuffer];
                int tupleColumn = 0;
                while (tupleColumn < config.tupleLength) {
                    int tmpTuplesOffset = tmpTuplesStartPos;
                    int i = 0;
                    while (i < mergePoints.size()) {
                        assert (mergePoints.get((int)i).tuplesStartPos <= mergePoints.get((int)i).tuplesLastPos);
                        System.arraycopy(mergePoints.get((int)i).tuples[tupleColumn], mergePoints.get((int)i).tuplesStartPos, tmpTuples[tupleColumn], tmpTuplesOffset, mergePoints.get((int)i).tuplesLastPos - mergePoints.get((int)i).tuplesStartPos);
                        tmpTuplesOffset += mergePoints.get((int)i).tuplesLastPos - mergePoints.get((int)i).tuplesStartPos;
                        ++i;
                    }
                    ++tupleColumn;
                }
                this.tuples = tmpTuples;
                this.tuplesStartPos = tmpTuplesStartPos;
                this.tuplesLastPos = tmpTuplesStartPos + tmpTuplesSize;
                if (config.collectStatistics()) {
                    config.statisticsCollector.addCopyMergeTime(System.currentTimeMillis() - startTime);
                }
            }
        }

        private List<TupleBucket> partitionSortedTuples(AbstractTupleStore.TupleStoreConfigurationImpl config, int[][] tuplesToMerge, int tuplesToMergeStartPos, int tuplesToMergeLastPos) {
            long startTime = System.currentTimeMillis();
            ArrayList<TupleBucket> mergePoints = new ArrayList<TupleBucket>();
            int tuplesOffset = this.tuplesStartPos;
            int tuplesLastPos = TupleStoreImpl.binarySearch(config.statisticsCollector, this.tuples, this.tuplesStartPos, this.tuplesLastPos - 1, TupleStoreImpl.fill(tuplesToMerge, tuplesToMergeLastPos - 1, new int[config.tupleLength]));
            if (tuplesLastPos >= 0) {
                throw new IllegalStateException("Duplicate entry in tuple store: " + this.toString(tuplesToMerge, tuplesToMergeLastPos));
            }
            if ((tuplesLastPos = -(tuplesLastPos + 1) - 1) < this.tuplesStartPos) {
                tuplesLastPos = this.tuplesStartPos;
            }
            int tuplesToMergeOffset = tuplesToMergeStartPos;
            int[] tuple = new int[config.tupleLength];
            while (tuplesToMergeOffset < tuplesToMergeLastPos) {
                int tuplesNextOffset = this.getMergePosition(config, tuplesOffset, tuplesLastPos, tuplesToMerge, tuplesToMergeOffset, tuplesToMergeLastPos - 1);
                if (tuplesNextOffset >= 0) {
                    throw new IllegalStateException("Duplicate entry in tuple store: " + this.toString(this.tuples, tuplesOffset));
                }
                tuplesNextOffset = -(tuplesNextOffset + 1);
                int length = 0;
                if (tuplesNextOffset == this.tuplesLastPos) {
                    length = tuplesToMergeLastPos - tuplesToMergeOffset;
                    assert (length > 0);
                } else if (TupleStoreImpl.compare(tuplesToMerge, tuplesToMergeLastPos - 1, TupleStoreImpl.fill(this.tuples, tuplesNextOffset, tuple)) < 0) {
                    length = tuplesToMergeLastPos - tuplesToMergeOffset;
                    assert (length > 0);
                } else {
                    int pos = TupleStoreImpl.binarySearch(config.statisticsCollector, tuplesToMerge, tuplesToMergeOffset, tuplesToMergeLastPos - 1, TupleStoreImpl.fill(this.tuples, tuplesNextOffset, tuple));
                    assert (pos < 0);
                    length = -(pos + 1) - tuplesToMergeOffset;
                    assert (length > 0);
                }
                assert (length > 0);
                mergePoints.add(new TupleBucket(this.tuples, tuplesOffset, tuplesOffset + tuplesNextOffset - tuplesOffset));
                mergePoints.add(new TupleBucket(tuplesToMerge, tuplesToMergeOffset, tuplesToMergeOffset + length));
                tuplesToMergeOffset += length;
                tuplesOffset = tuplesNextOffset;
            }
            if (tuplesOffset < this.tuplesLastPos) {
                mergePoints.add(new TupleBucket(this.tuples, tuplesOffset, this.tuplesLastPos));
            }
            if (config.collectStatistics()) {
                config.statisticsCollector.addMergePartitionTime(System.currentTimeMillis() - startTime);
            }
            return mergePoints;
        }

        private void validateMerge(AbstractTupleStore.TupleStoreConfigurationImpl config, int[][] tuples, int tuplesStartPos, int tuplesLastPos, int[][] tuplesToMerge, int tuplesToMergeStartPos, int tuplesToMergeLastPos, int[][] mergedTuples, int mergedTuplesStartPos, int mergedTuplesLastPos) {
            int count = 0;
            final class TupleWrapper {
                int[][] tuples;
                final int tupleIndex;

                TupleWrapper(int[][] tuples, int tupleIndex) {
                    this.tuples = tuples;
                    this.tupleIndex = tupleIndex;
                }
            }
            TupleWrapper[] wrappedTuples = new TupleWrapper[tuplesLastPos - tuplesStartPos + tuplesToMergeLastPos - tuplesToMergeStartPos];
            int i = tuplesStartPos;
            while (i < tuplesLastPos) {
                wrappedTuples[count++] = new TupleWrapper(tuples, i);
                ++i;
            }
            i = tuplesToMergeStartPos;
            while (i < tuplesToMergeLastPos) {
                wrappedTuples[count++] = new TupleWrapper(tuplesToMerge, i);
                ++i;
            }
            Arrays.sort(wrappedTuples, new Comparator<TupleWrapper>(){

                @Override
                public int compare(TupleWrapper object1, TupleWrapper object2) {
                    return TupleStoreImpl.compare(object1.tuples, object1.tupleIndex, object2.tuples, object2.tupleIndex);
                }
            });
            int tupleColumn = 0;
            while (tupleColumn < config.tupleLength) {
                int i2 = 0;
                while (i2 < wrappedTuples.length) {
                    if (mergedTuples[tupleColumn][mergedTuplesStartPos + i2] != wrappedTuples[i2].tuples[tupleColumn][wrappedTuples[i2].tupleIndex]) {
                        throw new IllegalStateException("Bucket merge failed.");
                    }
                    ++i2;
                }
                ++tupleColumn;
            }
        }

        public int getMergePosition(AbstractTupleStore.TupleStoreConfigurationImpl config, int startPos, int endPos, int[][] tuplesToMerge, int tuplesToMergeStartPos, int tuplesToMergeLastPos) {
            if (this.size() == 0) {
                return -(this.tuplesStartPos + 1);
            }
            int result = TupleStoreImpl.binarySearch(config.statisticsCollector, this.tuples, startPos, endPos, TupleStoreImpl.fill(tuplesToMerge, tuplesToMergeStartPos, new int[config.tupleLength]));
            if (result >= 0) {
                throw new IllegalStateException("Duplicate entry in tuple store: " + this.toString(tuplesToMerge, tuplesToMergeLastPos));
            }
            return result;
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            int tupleLength = this.tuples.length;
            int i = this.tuplesStartPos;
            while (i < this.tuplesLastPos) {
                pw.print("[");
                int j = 0;
                while (j < tupleLength) {
                    pw.print(this.tuples[j][i]);
                    if (j + 1 < tupleLength) {
                        pw.print(", ");
                    }
                    ++j;
                }
                pw.println("]");
                ++i;
            }
            pw.close();
            return sw.toString();
        }

        public String toString(int[][] tuples, int pos) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.print("[");
            int j = 0;
            while (j < tuples.length) {
                pw.print(this.tuples[j][pos]);
                if (j + 1 < tuples.length) {
                    pw.print(", ");
                }
                ++j;
            }
            pw.println("]");
            pw.close();
            return sw.toString();
        }
    }
}

