/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.DirectedLabeledGraph;
import com.ibm.cognos.fpm.common.graph.IDirectedLabeledGraph;
import com.ibm.cognos.fpm.common.graph.IGraphStatistics;
import com.ibm.cognos.fpm.common.graph.IGraphValidator;
import com.ibm.cognos.fpm.common.graph.IUndirectedGraph;
import com.ibm.cognos.fpm.common.graph.IUndirectedLabeledGraph;
import com.ibm.cognos.fpm.common.graph.NodeFilter;
import com.ibm.cognos.fpm.common.graph.NodeKeyGenerator;
import com.ibm.cognos.fpm.common.graph.NodeKeyRelationshipFilter;
import com.ibm.cognos.fpm.common.graph.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class UndirectedLabeledGraph<K, N>
implements IUndirectedLabeledGraph<K, N> {
    private final IDirectedLabeledGraph<K, N> directedLabeledGraph;

    public UndirectedLabeledGraph() {
        this.directedLabeledGraph = new DirectedLabeledGraph();
    }

    public UndirectedLabeledGraph(NodeKeyGenerator<K, N> nodeKeyGenerator) {
        this.directedLabeledGraph = new DirectedLabeledGraph<K, N>(nodeKeyGenerator);
    }

    public UndirectedLabeledGraph(int adjacencyListsMaxBucketSize) {
        this.directedLabeledGraph = new DirectedLabeledGraph(adjacencyListsMaxBucketSize);
    }

    public UndirectedLabeledGraph(NodeKeyGenerator<K, N> nodeKeyGenerator, int adjacencyListsMaxBucketSize) {
        this.directedLabeledGraph = new DirectedLabeledGraph(adjacencyListsMaxBucketSize);
    }

    public UndirectedLabeledGraph(IUndirectedLabeledGraph<K, N> graph) {
        this(graph.getNodeKeyGenerator());
        for (Object node : graph) {
            this.addNode(node);
            for (Object connectedNode : graph.getConnectedNodes(node)) {
                this.addNode(connectedNode);
                Collection<String> edgeLabels = graph.getEdgeLabels(node, connectedNode);
                if (edgeLabels.isEmpty()) {
                    this.addEdge(node, connectedNode);
                    continue;
                }
                for (String edgeLabel : edgeLabels) {
                    this.addEdge(node, connectedNode, edgeLabel);
                    for (Map.Entry<String, Object> edgeProperty : graph.getEdgeProperties(node, connectedNode, edgeLabel).entrySet()) {
                        this.addEdgeProperty(node, connectedNode, edgeLabel, edgeProperty.getKey(), edgeProperty.getValue());
                    }
                }
            }
        }
    }

    public UndirectedLabeledGraph(IUndirectedGraph<K, N> graph) {
        this(graph.getNodeKeyGenerator());
        for (Object node : graph) {
            this.addNode(node);
            for (Object connectedNode : graph.getConnectedNodes(node)) {
                this.addNode(connectedNode);
                this.addEdge(node, connectedNode);
            }
        }
    }

    @Override
    public void destroy() {
        this.directedLabeledGraph.destroy();
    }

    @Override
    public Object removeEdgeProperty(N sourceNode, N targetNode, String label, String propertyName) {
        return this.directedLabeledGraph.removeEdgeProperty(sourceNode, targetNode, label, propertyName);
    }

    @Override
    public boolean removeEdgeProperties(N sourceNode, N targetNode, String label) {
        return this.directedLabeledGraph.removeEdgeProperties(sourceNode, targetNode, label);
    }

    @Override
    public boolean hasEdgeProperty(N sourceNode, N targetNode, String label, String propertyName) {
        return this.directedLabeledGraph.hasEdgeProperty(sourceNode, targetNode, label, propertyName);
    }

    @Override
    public boolean hasEdgeProperties(N sourceNode, N targetNode, String label) {
        return this.directedLabeledGraph.hasEdgeProperties(sourceNode, targetNode, label);
    }

    @Override
    public Object addEdgeProperty(N sourceNode, N targetNode, String label, String propertyName, Object propertyValue) {
        return this.directedLabeledGraph.addEdgeProperty(sourceNode, targetNode, label, propertyName, propertyValue);
    }

    @Override
    public Object getEdgeProperty(N sourceNode, N targetNode, String label, String propertyName) {
        return this.directedLabeledGraph.getEdgeProperty(sourceNode, targetNode, label, propertyName);
    }

    @Override
    public Map<String, Object> getEdgeProperties(N sourceNode, N targetNode, String label) {
        return this.directedLabeledGraph.getEdgeProperties(sourceNode, targetNode, label);
    }

    @Override
    public Collection<String> getEdgePropertyNames(N sourceNode, N targetNode, String label) {
        return this.directedLabeledGraph.getEdgePropertyNames(sourceNode, targetNode, label);
    }

    @Override
    public int getEdgeCount() {
        return this.directedLabeledGraph.getEdgeCount();
    }

    @Override
    public boolean addEdge(N sourceNode, N targetNode, String label) {
        return this.directedLabeledGraph.addEdge(sourceNode, targetNode, label);
    }

    @Override
    public boolean removeEdge(N sourceNode, N targetNode, String label) {
        return this.directedLabeledGraph.removeEdge(sourceNode, targetNode, label);
    }

    @Override
    public boolean hasEdge(N sourceNode, N targetNode, String label) {
        return this.directedLabeledGraph.hasEdge(sourceNode, targetNode, label);
    }

    @Override
    public Collection<String> getEdgeLabels(N sourceNode, N targetNode) {
        return this.directedLabeledGraph.getEdgeLabels(sourceNode, targetNode);
    }

    @Override
    public int getNodeCount() {
        return this.directedLabeledGraph.getNodeCount();
    }

    @Override
    public void checkIntegrity() {
        this.directedLabeledGraph.checkIntegrity();
    }

    @Override
    public boolean optimize() {
        return this.directedLabeledGraph.optimize();
    }

    @Override
    public boolean optimize(N node) {
        return this.directedLabeledGraph.optimize(node);
    }

    @Override
    public IGraphStatistics getStatistics() {
        return this.directedLabeledGraph.getStatistics();
    }

    @Override
    public N getNodeByKey(K nodeKey) {
        return this.directedLabeledGraph.getNodeByKey(nodeKey);
    }

    @Override
    public N getNode(N node) {
        return this.directedLabeledGraph.getNode(node);
    }

    @Override
    public K getNodeKey(N node) {
        return this.directedLabeledGraph.getNodeKey(node);
    }

    @Override
    public NodeKeyGenerator<K, N> getNodeKeyGenerator() {
        return this.directedLabeledGraph.getNodeKeyGenerator();
    }

    @Override
    public IGraphValidator<N> getValidator() {
        return this.directedLabeledGraph.getValidator();
    }

    @Override
    public void setValidator(IGraphValidator<N> validator) {
        this.directedLabeledGraph.setValidator(validator);
    }

    @Override
    public boolean addNode(N node) {
        return this.directedLabeledGraph.addNode(node);
    }

    @Override
    public N removeNode(N node) {
        return this.directedLabeledGraph.removeNode(node);
    }

    @Override
    public Collection<N> findNodes(NodeFilter<N> nodeFilter) {
        return this.directedLabeledGraph.findNodes(nodeFilter);
    }

    @Override
    public boolean addEdge(N sourceNode, N targetNode) {
        boolean sourceToTargetEdge = this.directedLabeledGraph.addEdge(sourceNode, targetNode);
        boolean targetToSourceEdge = this.directedLabeledGraph.addEdge(targetNode, sourceNode);
        return sourceToTargetEdge || targetToSourceEdge;
    }

    @Override
    public boolean removeEdge(N sourceNode, N targetNode) {
        return this.directedLabeledGraph.removeEdge(sourceNode, targetNode);
    }

    @Override
    public boolean hasEdge(N sourceNode, N targetNode) {
        return this.directedLabeledGraph.hasEdge(sourceNode, targetNode);
    }

    @Override
    public boolean containsNode(N node) {
        return this.directedLabeledGraph.containsNode(node);
    }

    @Override
    public boolean containsNodeWithKey(K nodeKey) {
        return this.directedLabeledGraph.containsNodeWithKey(nodeKey);
    }

    @Override
    public Iterator<N> getDepthFirstIterator(N startNode) {
        return this.directedLabeledGraph.getDepthFirstIterator(startNode);
    }

    @Override
    public Path<N> getShortestPath(N startNode, N endNode) {
        return this.directedLabeledGraph.getShortestPath(startNode, endNode);
    }

    @Override
    public Path<N> getShortestPath(N startNode, N endNode, int maxDepth) {
        return this.directedLabeledGraph.getShortestPath(startNode, endNode, maxDepth);
    }

    @Override
    public List<Path<N>> getAllPaths(N startNode, N endNode) {
        return this.directedLabeledGraph.getAllPaths(startNode, endNode);
    }

    @Override
    public List<Path<N>> getAllPaths(N startNode, N endNode, int maxDepth) {
        return this.directedLabeledGraph.getAllPaths(startNode, endNode, maxDepth);
    }

    @Override
    public List<Path<N>> getAllPaths(N node) {
        return this.directedLabeledGraph.getAllPaths(node);
    }

    @Override
    public List<Path<K>> getAllPathsByKey(K nodeKey) {
        return this.directedLabeledGraph.getAllPathsByKey(nodeKey);
    }

    @Override
    public Iterator<N> iterator() {
        return this.directedLabeledGraph.iterator();
    }

    @Override
    public Collection<N> getConnectedNodes(N node) {
        return this.directedLabeledGraph.getConnectedNodes(node);
    }

    @Override
    public Collection<N> getNodes() {
        return this.directedLabeledGraph.getNodes();
    }

    @Override
    public Collection<K> getNodeKeys() {
        return this.directedLabeledGraph.getNodeKeys();
    }

    @Override
    public String toString(boolean detailed, Comparator<K> comparator) {
        return this.directedLabeledGraph.toString(detailed, comparator);
    }

    @Override
    public boolean add(N object) {
        return this.directedLabeledGraph.add(object);
    }

    @Override
    public boolean addAll(Collection<? extends N> collection) {
        return this.directedLabeledGraph.addAll(collection);
    }

    @Override
    public void clear() {
        this.directedLabeledGraph.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.directedLabeledGraph.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.directedLabeledGraph.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.directedLabeledGraph.isEmpty();
    }

    @Override
    public boolean remove(Object object) {
        return this.directedLabeledGraph.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.directedLabeledGraph.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.directedLabeledGraph.retainAll(collection);
    }

    @Override
    public int size() {
        return this.directedLabeledGraph.size();
    }

    @Override
    public Object[] toArray() {
        return this.directedLabeledGraph.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.directedLabeledGraph.toArray(array);
    }

    public String toString() {
        return this.directedLabeledGraph.toString();
    }

    @Override
    public List<Path<N>> getAllPaths(N node, NodeFilter<N> nodeFilter, NodeKeyRelationshipFilter<K> relationshipFilter) {
        return this.directedLabeledGraph.getAllPaths(node, nodeFilter, relationshipFilter);
    }

    @Override
    public Collection<N> getConnectedNodes(N node, NodeFilter<N> filter) {
        return this.directedLabeledGraph.getConnectedNodes(node, filter);
    }
}

