/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.IPropertyGraph;
import com.ibm.cognos.fpm.common.graph.InternalNodeKeyProxyCollection;
import com.ibm.cognos.fpm.common.graph.NodeInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

class VersionedNodeInfo
extends NodeInfo {
    private int[] nodeEventHistory = new int[1];
    private final int nodeClass;
    static final int NODE_HISTORY_EVENT_ID_POS = 0;
    static final int RELATED_NODE_EVENT_ID_POS = 3;
    static final int NODE_PROPERTIES_EVENT_ID_POS = 2;
    static final int ELEMENT_STATE_CREATED = 0;
    static final int ELEMENT_STATE_DELETED = 1;
    static final int ELEMENT_STATE_RESTORED = 2;

    public int[] getNodeEventHistory() {
        return this.nodeEventHistory;
    }

    VersionedNodeInfo(int internalNodeKey, int internalEventId, int internalNodeType) {
        super(internalNodeKey);
        this.nodeClass = internalNodeType;
        this.nodeEventHistory[0] = internalEventId;
    }

    public boolean delete(int internalEventId) {
        boolean isDeleted = false;
        if (internalEventId != -1) {
            this.addNodeEvent(internalEventId);
            isDeleted = true;
        }
        return isDeleted;
    }

    public boolean restore(int internalEventId) {
        boolean isRestored = false;
        if (internalEventId != -1) {
            this.addNodeEvent(internalEventId);
            isRestored = true;
        }
        return isRestored;
    }

    public int getNodeClass() {
        return this.nodeClass;
    }

    private void addNodeEvent(int internalEventId) {
        int[] newNodeEventHistory = new int[this.nodeEventHistory.length + 1];
        System.arraycopy(this.nodeEventHistory, 0, newNodeEventHistory, 0, this.nodeEventHistory.length);
        newNodeEventHistory[this.nodeEventHistory.length] = internalEventId;
        this.nodeEventHistory = newNodeEventHistory;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("nodeId=" + this.getInternalNodeId());
        sb.append(":classId=" + this.getNodeClass());
        sb.append(":" + this.historyToString());
        return sb.toString();
    }

    @Override
    public <K> String toString(IPropertyGraph<K> parentGraph) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(CollectionUtils.get(parentGraph.getNodeIds(), (int)this.getInternalNodeId()).toString());
        pw.print("Internal Key: ");
        pw.print(this.getInternalNodeId());
        pw.print(", Class: ");
        pw.println(this.getNodeClass());
        pw.println("Properties: ");
        Map<String, Object> props = parentGraph.getNodeProperties(CollectionUtils.get(parentGraph.getNodeIds(), (int)this.getInternalNodeId()));
        for (Map.Entry<String, Object> e : props.entrySet()) {
            pw.print(e.getKey());
            pw.print(": ");
            pw.println(e.getValue());
        }
        pw.print("Adjacent Nodes: ");
        pw.println(this.getAdjacentNodesTupleStore() != null ? new InternalNodeKeyProxyCollection<K>(parentGraph, this.getAdjacentNodesTupleStore(), InternalNodeKeyProxyCollection.NODE_KEY_SIGN.POSITIVE).toString() : "[]");
        pw.print("History: ");
        pw.println(this.historyToString());
        pw.close();
        return sw.toString();
    }

    private String historyToString() {
        StringBuffer sb = new StringBuffer("creationId=");
        sb.append(this.nodeEventHistory[0]);
        int i = 1;
        while (i < this.nodeEventHistory.length) {
            sb.append(":");
            sb.append(i % 2 != 0 ? "deletionId=" : "restorationId=");
            sb.append(this.nodeEventHistory[i]);
            ++i;
        }
        return sb.toString();
    }
}

