/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.graph;

import com.ibm.cognos.fpm.common.graph.EdgeFilter;
import com.ibm.cognos.fpm.common.graph.IAPIContext;
import com.ibm.cognos.fpm.common.graph.ITransaction;
import com.ibm.cognos.fpm.common.graph.IVersionedPropertyGraph;
import com.ibm.cognos.fpm.common.graph.InternalNodeKeyProxyCollection;
import com.ibm.cognos.fpm.common.graph.NodeHistory;
import com.ibm.cognos.fpm.common.graph.NodeInfo;
import com.ibm.cognos.fpm.common.graph.NodePropertyFilters;
import com.ibm.cognos.fpm.common.graph.PropertyGraphImpl;
import com.ibm.cognos.fpm.common.graph.TransactionDefinition;
import com.ibm.cognos.fpm.common.graph.Tuple;
import com.ibm.cognos.fpm.common.graph.TupleElementFilterGreaterThan;
import com.ibm.cognos.fpm.common.graph.TupleStore;
import com.ibm.cognos.fpm.common.graph.VersionedNodeInfo;
import com.ibm.cognos.fpm.common.graph.VersionedPropertyGraphNodeFilter;
import com.ibm.cognos.fpm.common.utility.KeyedHashSet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VersionedPropertyGraph<K>
extends PropertyGraphImpl<K>
implements IVersionedPropertyGraph<K> {
    private final KeyedHashSet<EventId> eventIds;
    private final KeyedHashSet<Long> nodeClasses;

    public VersionedPropertyGraph() {
        this(500);
    }

    public VersionedPropertyGraph(int capacity) {
        super(capacity, 3, 4, 4);
        this.eventIds = new KeyedHashSet(capacity);
        this.nodeClasses = new KeyedHashSet(capacity);
    }

    @Override
    public boolean addEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        int internalLabelKey = this.edgeLabels.getKey(label);
        if (internalLabelKey == -1) {
            internalLabelKey = this.edgeLabels.addAndReturnKey(label);
        }
        if (this.hasEdge(sourceNodeId, targetNodeId, label)) {
            return false;
        }
        return this.addEdgeEvent(context, sourceNodeId, targetNodeId, internalLabelKey);
    }

    private boolean addEdgeEvent(IAPIContext<K> context, K sourceNodeId, K targetNodeId, int internalLabelKey) {
        NodeInfo sourceNodeInfo = this.getNodeInfo((Object)sourceNodeId, true);
        NodeInfo targetNodeInfo = this.getNodeInfo((Object)targetNodeId, true);
        boolean addedToOutgoing = sourceNodeInfo.getAdjacentNodesTupleStore(false, this.adjacentNodesTupleStoreConfig).addTuple(targetNodeInfo.getInternalNodeId(), internalLabelKey, sourceNodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig).size(), this.getInternalEventId(context));
        boolean addedToIncoming = targetNodeInfo.getAdjacentNodesTupleStore(false, this.adjacentNodesTupleStoreConfig).addTuple(-1 * sourceNodeInfo.getInternalNodeId(), internalLabelKey, targetNodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig).size(), this.getInternalEventId(context));
        if (addedToOutgoing != addedToIncoming) {
            throw new IllegalStateException("The outgoing and incoming node adjacency lists are out of synch.");
        }
        return addedToOutgoing;
    }

    @Override
    public Object addNodeProperty(IAPIContext<K> context, K nodeId, String propertyName, Object propertyValue) {
        NodeInfo nodeInfo = this.getNodeInfo((Object)nodeId, true);
        int propertyValueKey = this.nodePropertyValues.getKey(propertyValue);
        if (propertyValueKey == -1) {
            propertyValueKey = this.nodePropertyValues.addAndReturnKey(propertyValue);
        }
        Object oldPropertyValue = null;
        Tuple propTuple = this.getNodePropertyTupleStore(propertyName, true).getTuple(this.getTimeTupleFilter((IAPIContext)context, 2), nodeInfo.getInternalNodeId());
        if (propTuple != null) {
            int oldPropValueKey = propTuple.getElement(1);
            if (oldPropValueKey == propertyValueKey) {
                return propertyValue;
            }
            oldPropertyValue = this.nodePropertyValues.get(oldPropValueKey);
        }
        boolean added = this.getNodePropertyTupleStore(propertyName, false).addTuple(nodeInfo.getInternalNodeId(), propertyValueKey, this.getInternalEventId(context));
        assert (added);
        return oldPropertyValue;
    }

    @Override
    public Object addEdgeProperty(IAPIContext<K> context, K sourceNode, K targetNode, String label, String propertyName, Object propertyValue) {
        NodeInfo sourceNodeInfo = this.getNodeInfo((Object)sourceNode, true);
        NodeInfo targetNodeInfo = this.getNodeInfo((Object)targetNode, true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            throw new IllegalArgumentException("There is no edge between '" + sourceNode + "' and '" + targetNode + "' with the label '" + label + "'.");
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getAdjacentNodesTupleStore().getTuple(targetNodeInfo.getInternalNodeId(), edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            throw new IllegalArgumentException("There is no edge between '" + sourceNode + "' and '" + targetNode + "' with the label '" + label + "'.");
        }
        int edgePropertyNameIndex = this.edgePropertyNames.getKey(propertyName);
        if (edgePropertyNameIndex == -1) {
            edgePropertyNameIndex = this.edgePropertyNames.addAndReturnKey(propertyName);
        }
        Object oldPropertyValue = null;
        List<Tuple> outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(2), edgePropertyNameIndex);
        if (outgoingEdgePropertyTuples.size() > 1) {
            throw new IllegalStateException("Multiple edge property value identifiers are mapped to the same edge.");
        }
        if (!outgoingEdgePropertyTuples.isEmpty() && (oldPropertyValue = (Object)this.edgePropertyValues.get(outgoingEdgePropertyTuples.get(0).getElement(2))).equals(propertyValue)) {
            return oldPropertyValue;
        }
        int edgePropertyValueIndex = this.edgePropertyValues.getKey(propertyValue);
        if (edgePropertyValueIndex == -1) {
            edgePropertyValueIndex = this.edgePropertyValues.addAndReturnKey(propertyValue);
        }
        sourceNodeInfo.getEdgePropertyTupleStore(false, this.edgePropertyTupleStoreConfig).addTuple(outgoingEdgeTuple.getElement(2), edgePropertyNameIndex, edgePropertyValueIndex, this.getInternalEventId(context));
        return oldPropertyValue;
    }

    @Override
    public boolean addNode(IAPIContext<K> context, K nodeId, Long classId) {
        assert (classId != null);
        NodeInfo nodeInfo = this.getNodeInfo((Object)nodeId, false);
        if (nodeInfo != null) {
            return false;
        }
        nodeInfo = new VersionedNodeInfo(this.nodeIds.size(), this.getInternalEventId(context, true), this.nodeClasses.addAndReturnKey(classId));
        this.nodeInfos.put(nodeId, nodeInfo);
        this.nodeIds.add(nodeId);
        return true;
    }

    private Tuple applyAdditionalEdgeFiltering(IAPIContext<K> context, Tuple tuple, TupleStore tupleStore, Iterator<Tuple> it) {
        List<Tuple> allHistoricalTuples = tupleStore.getTuples(tuple.getElement(0), tuple.getElement(1));
        assert (!allHistoricalTuples.isEmpty());
        Tuple activeEdge = tuple;
        int edgeEventId = activeEdge.getElement(3);
        Long edgeTime = this.eventIds.get(edgeEventId).getEventTime();
        if (edgeTime > context.getTime()) {
            return null;
        }
        int state = 0;
        int i = 1;
        while (i < allHistoricalTuples.size()) {
            Tuple edge = it.next();
            edgeEventId = edge.getElement(3);
            edgeTime = this.eventIds.get(edgeEventId).getEventTime();
            if (edgeTime > context.getTime()) break;
            ++state;
            activeEdge = edge;
            ++i;
        }
        return state % 2 == 0 ? activeEdge : null;
    }

    @Override
    public ITransaction<K> beginTransaction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITransaction<K> beginTransaction(TransactionDefinition definition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkIntegrity() {
        super.checkIntegrity();
    }

    @Override
    public boolean containsNode(IAPIContext<K> context, K nodeId) {
        NodeInfo nodeInfo = this.getNodeInfo((Object)nodeId, false);
        if (nodeInfo == null) {
            return false;
        }
        return this.isNodeActive(context, (VersionedNodeInfo)nodeInfo);
    }

    @Override
    public boolean deleteEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        Event latestEdgeEvent;
        int internalLabelKey = this.edgeLabels.getKey(label);
        if (internalLabelKey == -1) {
            internalLabelKey = this.edgeLabels.addAndReturnKey(label);
        }
        if ((latestEdgeEvent = this.getLatestEdgeEvent(sourceNodeId, targetNodeId, internalLabelKey)) == null || !latestEdgeEvent.isActive()) {
            return false;
        }
        if (context.getTime() <= latestEdgeEvent.getEventId().getEventTime()) {
            return false;
        }
        return this.addEdgeEvent(context, sourceNodeId, targetNodeId, internalLabelKey);
    }

    @Override
    public boolean deleteNode(IAPIContext<K> context, K nodeId) {
        int[] nodeEvents;
        NodeInfo nodeInfo = this.getNodeInfo((Object)nodeId, false);
        if (nodeInfo != null && (nodeEvents = ((VersionedNodeInfo)nodeInfo).getNodeEventHistory()).length % 2 != 0) {
            EventId eventId = this.eventIds.get(nodeEvents[nodeEvents.length - 1]);
            if (context.getTime() > eventId.getEventTime()) {
                return ((VersionedNodeInfo)nodeInfo).delete(this.getInternalEventId(context));
            }
        }
        return false;
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public Collection<K> findNodes(IAPIContext<K> context, VersionedPropertyGraphNodeFilter<K> filter) {
        return this.filterNodes(context, this.nodeIds, filter);
    }

    private Collection<K> filterInActiveNodes(IAPIContext<K> context, Collection<K> nodes, VersionedPropertyGraphNodeFilter<K> filter) {
        ArrayList<K> newFilteredNodeKeys = new ArrayList<K>();
        for (K nodeId : nodes) {
            NodeInfo nodeInfo;
            if (nodeId == null || !this.isNodeActive(context, (VersionedNodeInfo)(nodeInfo = this.getNodeInfo((Object)nodeId, true)))) continue;
            if (filter != null) {
                if (!filter.evaluate(context, nodeId)) continue;
                newFilteredNodeKeys.add(nodeId);
                continue;
            }
            newFilteredNodeKeys.add(nodeId);
        }
        return newFilteredNodeKeys;
    }

    private Collection<K> filterNodes(IAPIContext<K> context, Collection<K> nodesToFilter, VersionedPropertyGraphNodeFilter<K> filter) {
        NodePropertyFilters propFilters;
        assert (nodesToFilter != null);
        assert (filter != null);
        Collection<K> filteredNodes = nodesToFilter;
        List<K> nodeTypeFilters = filter.getNodeTypeFilters();
        if (nodeTypeFilters != null && !nodeTypeFilters.isEmpty()) {
            ArrayList<K> newFilteredNodeKeys = new ArrayList<K>();
            for (K nodeId : filteredNodes) {
                NodeInfo nodeInfo;
                if (nodeId == null || !this.isNodeActive(context, (VersionedNodeInfo)(nodeInfo = this.getNodeInfo((Object)nodeId, true))) || !nodeTypeFilters.contains(this.nodeClasses.get(((VersionedNodeInfo)nodeInfo).getNodeClass()))) continue;
                newFilteredNodeKeys.add(nodeId);
            }
            filteredNodes = newFilteredNodeKeys;
        }
        if ((propFilters = filter.getNodePropertyFilters()) != null) {
            Map<String, List<Object>> filters = propFilters.getFilters();
            TupleElementFilterGreaterThan tupleElementFilter = new TupleElementFilterGreaterThan(this, 2, context.getTime());
            for (Map.Entry<String, List<Object>> entry : filters.entrySet()) {
                String propertyName = entry.getKey();
                if (!this.nodePropertyTupleStores.containsKey(propertyName)) continue;
                List<Object> propertyValues = entry.getValue();
                int[] propertyValueKeys = new int[propertyValues.size()];
                int i = 0;
                while (i < propertyValues.size()) {
                    propertyValueKeys[i] = this.nodePropertyValues.getKey(propertyValues.get(i));
                    ++i;
                }
                ArrayList<K> newFilteredNodeKeys = new ArrayList<K>();
                block3: for (K nodeId : filteredNodes) {
                    NodeInfo nodeInfo;
                    if (nodeId == null || !this.isNodeActive(context, (VersionedNodeInfo)(nodeInfo = this.getNodeInfo((Object)nodeId, true)))) continue;
                    TupleStore nodePropTupleStore = this.getNodePropertyTupleStore(propertyName, true);
                    int i2 = 0;
                    while (i2 < propertyValueKeys.length) {
                        if (nodePropTupleStore.containsTuple(tupleElementFilter, nodeInfo.getInternalNodeId(), propertyValueKeys[i2])) {
                            newFilteredNodeKeys.add(nodeId);
                            continue block3;
                        }
                        ++i2;
                    }
                }
                filteredNodes = newFilteredNodeKeys;
            }
        }
        if (filter.callEvaluate()) {
            return this.filterInActiveNodes(context, filteredNodes, filter);
        }
        return filteredNodes;
    }

    @Override
    public int getEdgeCount(IAPIContext<K> context) {
        return super.getEdgeCount();
    }

    @Override
    public Collection<String> getEdgeLabels(IAPIContext<K> context, K sourceNodeId, K targetNodeId) {
        return super.getEdgeLabels(sourceNodeId, targetNodeId);
    }

    @Override
    public Map<String, Object> getEdgeProperties(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return super.getEdgeProperties(sourceNodeId, targetNodeId, label);
    }

    @Override
    public Object getEdgeProperty(IAPIContext<K> context, K sourceNode, K targetNode, String label, String propertyName) {
        List<Tuple> outgoingEdgePropertyTuples;
        NodeInfo sourceNodeInfo = this.getNodeInfo((Object)sourceNode, true);
        NodeInfo targetNodeInfo = this.getNodeInfo((Object)targetNode, true);
        int edgeLabelKey = this.edgeLabels.getKey(label);
        if (edgeLabelKey == -1) {
            throw new IllegalArgumentException("There is no edge between '" + sourceNode + "' and '" + targetNode + "' with the label '" + label + "'.");
        }
        Tuple outgoingEdgeTuple = sourceNodeInfo.getAdjacentNodesTupleStore().getTuple(targetNodeInfo.getInternalNodeId(), edgeLabelKey);
        if (outgoingEdgeTuple == null) {
            throw new IllegalArgumentException("There is no edge between '" + sourceNode + "' and '" + targetNode + "' with the label '" + label + "'.");
        }
        int edgePropertyNameIndex = this.edgePropertyNames.getKey(propertyName);
        if (edgePropertyNameIndex == -1) {
            edgePropertyNameIndex = this.edgePropertyNames.addAndReturnKey(propertyName);
        }
        if ((outgoingEdgePropertyTuples = sourceNodeInfo.getEdgePropertyTupleStore().getTuples(outgoingEdgeTuple.getElement(2), edgePropertyNameIndex)).size() > 1) {
            throw new IllegalStateException("Multiple edge property value identifiers are mapped to the same edge.");
        }
        return !outgoingEdgePropertyTuples.isEmpty() ? this.edgePropertyValues.get(outgoingEdgePropertyTuples.get(0).getElement(2)) : null;
    }

    @Override
    public Collection<String> getEdgePropertyNames(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return super.getEdgePropertyNames(sourceNodeId, targetNodeId, label);
    }

    @Override
    public Long getEventTime(int internalEventId) {
        return this.eventIds.get(internalEventId).getEventTime();
    }

    @Override
    public K getIncomingNode(IAPIContext<K> context, K nodeId) {
        return super.getIncomingNode(nodeId);
    }

    @Override
    public int getIncomingNodeCount(IAPIContext<K> context, K nodeId, int hopCount) {
        return this.getIncomingOutgoingNodes(context, nodeId, hopCount, null, null, true).size();
    }

    @Override
    public int getIncomingNodeCount(IAPIContext<K> context, K nodeId, int hopCount, VersionedPropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getIncomingOutgoingNodes(context, nodeId, hopCount, nodeFilter, edgeFilter, true).size();
    }

    @Override
    public Collection<K> getIncomingNodes(IAPIContext<K> context, K nodeId, int hopCount) {
        return this.getIncomingNodes(context, nodeId, hopCount, null, null);
    }

    @Override
    public Collection<K> getIncomingNodes(IAPIContext<K> context, K nodeId, int hopCount, VersionedPropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getIncomingOutgoingNodes(context, nodeId, hopCount, nodeFilter, edgeFilter, true);
    }

    private Collection<K> getIncomingOutgoingNodes(IAPIContext<K> context, K nodeId, int hopCount, VersionedPropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter, boolean isIncoming) {
        Iterator<Tuple> it;
        if (hopCount > 1) {
            throw new UnsupportedOperationException("Do not support multi-hop yet.");
        }
        NodeInfo nodeInfo = this.getNodeInfo((Object)nodeId, true);
        if (!this.isNodeActive(context, (VersionedNodeInfo)nodeInfo)) {
            return Collections.emptyList();
        }
        TupleStore tupleStore = nodeInfo.getAdjacentNodesTupleStore(true, this.adjacentNodesTupleStoreConfig);
        if (nodeFilter == null && edgeFilter == null) {
            return new InternalNodeKeyProxyCollection(this, tupleStore, isIncoming ? InternalNodeKeyProxyCollection.NODE_KEY_SIGN.NEGATIVE : InternalNodeKeyProxyCollection.NODE_KEY_SIGN.POSITIVE);
        }
        if (edgeFilter != null && !edgeFilter.getEdgeLabelsToFilterOn().isEmpty()) {
            int[] edgeLabelIds = new int[edgeFilter.getEdgeLabelsToFilterOn().size()];
            int i = 0;
            for (String edgeLabel : edgeFilter.getEdgeLabelsToFilterOn()) {
                edgeLabelIds[i] = this.edgeLabels.getKey(edgeLabel);
                ++i;
            }
            it = tupleStore.getFilteredIterator(1, edgeLabelIds);
        } else {
            it = tupleStore.iterator();
        }
        Collection<K> filteredAdjacentParentNodeKeys = null;
        while (it.hasNext()) {
            Tuple tuple = (Tuple)it.next();
            int adjacentNodeKey = tuple.getElement(0);
            if (isIncoming) {
                if (adjacentNodeKey > 0) break;
                adjacentNodeKey = Math.abs(adjacentNodeKey);
            } else if (adjacentNodeKey < 0) continue;
            tuple = this.applyAdditionalEdgeFiltering(context, tuple, tupleStore, it);
            if (tuple == null) continue;
            Object adjacentNodeId = this.nodeIds.get(adjacentNodeKey);
            boolean add = true;
            if (edgeFilter != null && edgeFilter.callEvaluate()) {
                String edgeLabel = (String)this.edgeLabels.get(tuple.getElement(1));
                add = edgeFilter.evaluate(isIncoming ? adjacentNodeId : nodeId, isIncoming ? nodeId : adjacentNodeId, edgeLabel);
            }
            if (!add) continue;
            if (filteredAdjacentParentNodeKeys == null) {
                filteredAdjacentParentNodeKeys = new ArrayList<K>();
            }
            filteredAdjacentParentNodeKeys.add(adjacentNodeId);
        }
        Collection<K> toReturn = filteredAdjacentParentNodeKeys;
        if (toReturn != null) {
            toReturn = nodeFilter != null ? this.filterNodes(context, filteredAdjacentParentNodeKeys, nodeFilter) : this.filterInActiveNodes(context, filteredAdjacentParentNodeKeys, null);
        }
        return toReturn == null ? Collections.emptySet() : Collections.unmodifiableCollection(toReturn);
    }

    private Event getLatestEdgeEvent(K sourceNodeId, K targetNodeId, int internalLabelKey) {
        NodeInfo sourceNodeInfo = this.getNodeInfo((Object)sourceNodeId, true);
        NodeInfo targetNodeInfo = this.getNodeInfo((Object)targetNodeId, true);
        TupleStore tupleStore = null;
        int internalNodeId = -1;
        if (sourceNodeInfo.getAdjacentNodesTupleStore().size() < targetNodeInfo.getAdjacentNodesTupleStore().size()) {
            tupleStore = sourceNodeInfo.getAdjacentNodesTupleStore();
            internalNodeId = targetNodeInfo.getInternalNodeId();
        } else {
            tupleStore = targetNodeInfo.getAdjacentNodesTupleStore();
            internalNodeId = -1 * sourceNodeInfo.getInternalNodeId();
        }
        List<Tuple> allHistoricalTuples = tupleStore.getTuples(internalNodeId, internalLabelKey);
        if (allHistoricalTuples.isEmpty()) {
            return null;
        }
        EventId latestEdgeEventId = this.eventIds.get(allHistoricalTuples.get(allHistoricalTuples.size() - 1).getElement(3));
        return new Event(latestEdgeEventId, allHistoricalTuples.size() % 2 != 0);
    }

    @Override
    public Long getNodeClass(K nodeId) {
        return this.nodeClasses.get(((VersionedNodeInfo)this.getNodeInfo((Object)nodeId, true)).getNodeClass());
    }

    @Override
    public int getNodeCount(IAPIContext<K> context) {
        return super.getNodeCount();
    }

    @Override
    public List<NodeHistory<K>> getNodeHistory(K nodeId) {
        NodeInfo nodeInfo = this.getNodeInfo((Object)nodeId, false);
        if (nodeInfo == null) {
            return Collections.emptyList();
        }
        ArrayList<NodeHistory<K>> nodeHistory = new ArrayList<NodeHistory<K>>();
        EventId eventId = this.eventIds.get(((VersionedNodeInfo)nodeInfo).getNodeEventHistory()[0]);
        nodeHistory.add(new NodeHistory<K>(nodeId, eventId.getEventTime(), this.nodeIds.get(eventId.getEventUserId()), 0));
        int i = 1;
        while (i < ((VersionedNodeInfo)nodeInfo).getNodeEventHistory().length) {
            eventId = this.eventIds.get(((VersionedNodeInfo)nodeInfo).getNodeEventHistory()[i]);
            nodeHistory.add(new NodeHistory<K>(nodeId, eventId.getEventTime(), this.nodeIds.get(eventId.getEventUserId()), i % 2 == 0 ? 2 : 1));
            ++i;
        }
        return nodeHistory;
    }

    @Override
    public Collection<K> getNodeIds(IAPIContext<K> context) {
        ArrayList nodeIds = new ArrayList(this.nodeIds);
        Iterator it = nodeIds.iterator();
        while (it.hasNext()) {
            Object nodeId = it.next();
            if (nodeId == null || this.isNodeActive(context, (VersionedNodeInfo)this.nodeInfos.get(nodeId))) continue;
            it.remove();
        }
        return nodeIds;
    }

    @Override
    public Map<String, Object> getNodeProperties(IAPIContext<K> context, K nodeId) {
        return super.getNodeProperties(nodeId);
    }

    @Override
    public Object getNodeProperty(IAPIContext<K> context, K nodeId, String propertyName) {
        if (!this.nodePropertyTupleStores.containsKey(propertyName)) {
            return null;
        }
        NodeInfo nodeInfo = this.getNodeInfo((Object)nodeId, true);
        if (!this.isNodeActive(context, (VersionedNodeInfo)nodeInfo)) {
            return null;
        }
        Tuple propTuple = this.getNodePropertyTupleStore(propertyName, true).getTuple(this.getTimeTupleFilter((IAPIContext)context, 2), nodeInfo.getInternalNodeId());
        if (propTuple == null) {
            return null;
        }
        int propValueKey = propTuple.getElement(1);
        return this.nodePropertyValues.get(propValueKey);
    }

    @Override
    public Collection<String> getNodePropertyNames(IAPIContext<K> context, K nodeId) {
        return super.getNodePropertyNames(nodeId);
    }

    @Override
    public int getOutgoingNodeCount(IAPIContext<K> context, K nodeId, int hopCount) {
        return this.getIncomingOutgoingNodes(context, nodeId, hopCount, null, null, false).size();
    }

    @Override
    public int getOutgoingNodeCount(IAPIContext<K> context, K nodeId, int hopCount, VersionedPropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getIncomingOutgoingNodes(context, nodeId, hopCount, nodeFilter, edgeFilter, false).size();
    }

    @Override
    public Collection<K> getOutgoingNodes(IAPIContext<K> context, K nodeId, int hopCount) {
        return this.getOutgoingNodes(context, nodeId, hopCount, null, null);
    }

    @Override
    public Collection<K> getOutgoingNodes(IAPIContext<K> context, K nodeId, int hopCount, VersionedPropertyGraphNodeFilter<K> nodeFilter, EdgeFilter<K> edgeFilter) {
        return this.getIncomingOutgoingNodes(context, nodeId, hopCount, nodeFilter, edgeFilter, false);
    }

    @Override
    public TupleElementFilterGreaterThan<K> getTimeTupleFilter(IAPIContext<K> context, int timeElementPosition) {
        return new TupleElementFilterGreaterThan(this, timeElementPosition, context.getTime());
    }

    private boolean hasDirectedEdge(IAPIContext<K> context, NodeInfo sourceNodeInfo, NodeInfo targetNodeInfo, int edgeLabelKey) {
        List<Tuple> allHistoricalTuples = null;
        allHistoricalTuples = sourceNodeInfo.getAdjacentNodesTupleStore().size() < targetNodeInfo.getAdjacentNodesTupleStore().size() ? sourceNodeInfo.getAdjacentNodesTupleStore().getTuples(targetNodeInfo.getInternalNodeId(), edgeLabelKey) : targetNodeInfo.getAdjacentNodesTupleStore().getTuples(-1 * sourceNodeInfo.getInternalNodeId(), edgeLabelKey);
        int state = 0;
        for (Tuple edge : allHistoricalTuples) {
            int edgeEventId = edge.getElement(3);
            Long edgeTime = this.eventIds.get(edgeEventId).getEventTime();
            if (edgeTime > context.getTime()) break;
            ++state;
        }
        return state % 2 != 0;
    }

    @Override
    public boolean hasEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        NodeInfo sourceNodeInfo = this.getNodeInfo((Object)sourceNodeId, true);
        NodeInfo targetNodeInfo = this.getNodeInfo((Object)targetNodeId, true);
        int internalLabelKey = this.edgeLabels.getKey(label);
        if (internalLabelKey == -1) {
            return false;
        }
        if (this.hasDirectedEdge(context, sourceNodeInfo, targetNodeInfo, internalLabelKey)) {
            return true;
        }
        return this.hasDirectedEdge(context, targetNodeInfo, sourceNodeInfo, internalLabelKey);
    }

    @Override
    public boolean hasEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName) {
        return super.hasEdgeProperty(sourceNodeId, targetNodeId, label, propertyName);
    }

    @Override
    public boolean hasIncomingNodes(IAPIContext<K> context, K nodeId, VersionedPropertyGraphNodeFilter<K> filter, EdgeFilter<K> edgeFilter) {
        return this.getIncomingOutgoingNodes(context, nodeId, 1, filter, edgeFilter, true).size() > 0;
    }

    @Override
    public boolean hasNodeProperties(IAPIContext<K> context, K nodeId) {
        return super.hasNodeProperties(nodeId);
    }

    @Override
    public boolean hasNodeProperty(IAPIContext<K> context, K nodeId, String propertyName) {
        if (!this.nodePropertyTupleStores.containsKey(propertyName)) {
            return false;
        }
        NodeInfo nodeInfo = this.getNodeInfo((Object)nodeId, true);
        if (!this.isNodeActive(context, (VersionedNodeInfo)nodeInfo)) {
            return false;
        }
        return this.getNodePropertyTupleStore(propertyName, true).containsTuple(this.getTimeTupleFilter((IAPIContext)context, 2), nodeInfo.getInternalNodeId());
    }

    @Override
    public boolean hasOutgoingNodes(IAPIContext<K> context, K nodeId, VersionedPropertyGraphNodeFilter<K> filter, EdgeFilter<K> edgeFilter) {
        return this.getIncomingOutgoingNodes(context, nodeId, 1, filter, edgeFilter, false).size() > 0;
    }

    @Override
    public boolean isIncomingNode(IAPIContext<K> context, K potentialIncomingNodeId, K nodeId) {
        return this.getIncomingOutgoingNodes(context, nodeId, 1, null, null, true).contains(potentialIncomingNodeId);
    }

    @Override
    public boolean isOutgoingNode(IAPIContext<K> context, K potentialOutgoingNodeId, K nodeId) {
        return this.getIncomingOutgoingNodes(context, nodeId, 1, null, null, false).contains(potentialOutgoingNodeId);
    }

    @Override
    public boolean removeEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return super.removeEdge(sourceNodeId, targetNodeId, label);
    }

    @Override
    public boolean removeEdgeProperties(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        return super.removeEdgeProperties(sourceNodeId, targetNodeId, label);
    }

    @Override
    public Object removeEdgeProperty(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label, String propertyName) {
        return super.removeEdgeProperty(sourceNodeId, targetNodeId, label, propertyName);
    }

    @Override
    public K removeNode(IAPIContext<K> context, K nodeId) {
        return super.removeNode(nodeId);
    }

    @Override
    public K removeNode(IAPIContext<K> context, K nodeId, boolean cascadeToOutgoingNodes) {
        return super.removeNode(nodeId, cascadeToOutgoingNodes);
    }

    @Override
    public boolean removeNodeProperties(IAPIContext<K> context, K nodeId) {
        return super.removeNodeProperties(nodeId);
    }

    @Override
    public Object removeNodeProperty(IAPIContext<K> context, K nodeId, String propertyName) {
        return super.removeNodeProperty(nodeId, propertyName);
    }

    @Override
    public boolean restoreEdge(IAPIContext<K> context, K sourceNodeId, K targetNodeId, String label) {
        Event latestEdgeEvent;
        int internalLabelKey = this.edgeLabels.getKey(label);
        if (internalLabelKey == -1) {
            internalLabelKey = this.edgeLabels.addAndReturnKey(label);
        }
        if ((latestEdgeEvent = this.getLatestEdgeEvent(sourceNodeId, targetNodeId, internalLabelKey)) == null || latestEdgeEvent.isActive()) {
            return false;
        }
        if (context.getTime() <= latestEdgeEvent.getEventId().getEventTime()) {
            return false;
        }
        return this.addEdgeEvent(context, sourceNodeId, targetNodeId, internalLabelKey);
    }

    @Override
    public boolean restoreNode(IAPIContext<K> context, K nodeId) {
        int[] nodeEvents;
        NodeInfo nodeInfo = this.getNodeInfo((Object)nodeId, false);
        if (nodeInfo != null && (nodeEvents = ((VersionedNodeInfo)nodeInfo).getNodeEventHistory()).length % 2 == 0) {
            EventId eventId = this.eventIds.get(nodeEvents[nodeEvents.length - 1]);
            if (context.getTime() > eventId.getEventTime()) {
                return ((VersionedNodeInfo)nodeInfo).delete(this.getInternalEventId(context));
            }
        }
        return false;
    }

    @Override
    public VersionedNodeInfo getNodeInfo(K nodeId, boolean throwExceptionOnNotFound) {
        NodeInfo nodeInfo = (NodeInfo)this.nodeInfos.get(nodeId);
        if (nodeInfo == null && throwExceptionOnNotFound) {
            throw new IllegalArgumentException("The node with key '" + nodeId + "' doesn't exist in the graph.");
        }
        return (VersionedNodeInfo)nodeInfo;
    }

    public boolean isNodeActive(IAPIContext<K> context, VersionedNodeInfo nodeInfo) {
        assert (context != null);
        if (nodeInfo == null) {
            return false;
        }
        Long time = this.eventIds.get(nodeInfo.getNodeEventHistory()[0]).getEventTime();
        if (time.compareTo(context.getTime()) > 0) {
            return false;
        }
        int i = 1;
        i = 1;
        while (i < nodeInfo.getNodeEventHistory().length) {
            time = this.eventIds.get(nodeInfo.getNodeEventHistory()[i]).getEventTime();
            assert (time != null);
            if (time.compareTo(context.getTime()) > 0) break;
            ++i;
        }
        return (i - 1) % 2 == 0;
    }

    private int getInternalEventId(IAPIContext<K> context) {
        return this.getInternalEventId(context, false);
    }

    private int getInternalEventId(IAPIContext<K> context, boolean isAllowUnknownUser) {
        assert (context.getTime() != null && context.getUserId() != null);
        EventId eventId = new EventId(context.getTime(), this.getInternalUserId(context.getUserId(), isAllowUnknownUser));
        int iEvent = this.eventIds.getKey(eventId);
        if (iEvent == -1) {
            iEvent = this.eventIds.addAndReturnKey(eventId);
        }
        return iEvent;
    }

    private int getInternalUserId(K userId, boolean isAllowUnknownUser) {
        assert (userId != null);
        NodeInfo nodeInfo = (NodeInfo)this.nodeInfos.get(userId);
        if (nodeInfo == null) {
            if (!isAllowUnknownUser) {
                throw new IllegalStateException("User " + userId + " is not known. It must be defined via addNode().");
            }
            return -1;
        }
        return nodeInfo.getInternalNodeId();
    }

    @Override
    public String toString(boolean detailed, Comparator<K> comparator) {
        StringWriter sw = new StringWriter();
        if (!detailed) {
            sw.append("[");
            Iterator it = this.nodeInfos.values().iterator();
            while (it.hasNext()) {
                VersionedNodeInfo nodeInfo = (VersionedNodeInfo)it.next();
                sw.append(nodeInfo.toString());
                if (!it.hasNext()) continue;
                sw.append(", ");
            }
            sw.append("]");
            return sw.toString();
        }
        ArrayList nodeKeys = null;
        if (comparator != null) {
            ArrayList nodeKeysAsList = new ArrayList(this.nodeIds);
            Collections.sort(nodeKeysAsList, comparator);
            nodeKeys = nodeKeysAsList;
        } else {
            nodeKeys = this.nodeIds;
        }
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Nodes");
        pw.println("-----");
        for (Object nodeKey : nodeKeys) {
            if (nodeKey == null) continue;
            pw.print(nodeKey.toString());
            pw.print(":");
            pw.println(((VersionedNodeInfo)this.getNodeInfo(nodeKey, true)).toString(this));
        }
        pw.println();
        pw.println("Edges");
        pw.println("-----");
        for (Object nodeKey : nodeKeys) {
            if (nodeKey == null) continue;
            NodeInfo nodeInfo = this.getNodeInfo(nodeKey, true);
            Collection adjacentChildNodeKeysSorted = null;
            if (comparator != null) {
                ArrayList adjacentNodeKeysSorted = new ArrayList(new InternalNodeKeyProxyCollection(this, nodeInfo.getAdjacentNodesTupleStore(), InternalNodeKeyProxyCollection.NODE_KEY_SIGN.POSITIVE));
                Collections.sort(adjacentNodeKeysSorted, comparator);
                adjacentChildNodeKeysSorted = adjacentNodeKeysSorted;
            } else {
                adjacentChildNodeKeysSorted = new InternalNodeKeyProxyCollection(this, nodeInfo.getAdjacentNodesTupleStore(), InternalNodeKeyProxyCollection.NODE_KEY_SIGN.POSITIVE);
            }
            for (Object adjacentChildNodeKey : adjacentChildNodeKeysSorted) {
                pw.print(nodeKey.toString());
                NodeInfo adjacentChildNodeInfo = this.getNodeInfo(adjacentChildNodeKey, true);
                if (adjacentChildNodeInfo.getAdjacentNodesTupleStore().containsTuple(nodeInfo.getInternalNodeId())) {
                    pw.print(" <-------> ");
                } else {
                    pw.print(" --------> ");
                }
                pw.println(adjacentChildNodeKey.toString());
            }
        }
        pw.close();
        return sw.toString();
    }

    @Override
    public String toString() {
        return this.toString(false, null);
    }

    private class Event {
        private final EventId eventId;
        private final boolean isActive;

        public Event(EventId eventId, boolean isActive) {
            this.eventId = eventId;
            this.isActive = isActive;
        }

        public EventId getEventId() {
            return this.eventId;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public String toString() {
            return String.valueOf(this.eventId.toString()) + (this.isActive ? ",isActive" : ",isDeleted");
        }
    }

    private class EventId {
        private final Long eventTime;
        private final int eventUser;

        public EventId(Long eventTime, int eventUser) {
            this.eventTime = eventTime;
            this.eventUser = eventUser;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof EventId)) {
                return false;
            }
            EventId thatEventId = (EventId)that;
            return (this.eventTime == null ? thatEventId == null : this.eventTime.equals(thatEventId.eventTime)) && this.eventUser == thatEventId.eventUser;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.eventTime.hashCode();
            result = 37 * result + Integer.valueOf(this.eventUser).hashCode();
            return result;
        }

        public Long getEventTime() {
            return this.eventTime;
        }

        public int getEventUserId() {
            return this.eventUser;
        }

        public String toString() {
            return "eventId=" + this.eventTime.toString() + ":" + this.eventUser;
        }
    }
}

