/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.primitives;

import com.ibm.cognos.fpm.common.primitives.AbstractObjectIntPrimitiveMap;
import com.ibm.cognos.fpm.common.primitives.ObjectIntPrimitiveMap;
import com.ibm.cognos.fpm.common.primitives.ObjectIntPrimitiveMapEntry;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ObjectIntPrimitiveHashMap<K>
extends AbstractObjectIntPrimitiveMap<K>
implements ObjectIntPrimitiveMap<K> {
    int elementCount;
    Entry<K>[] elementData;
    final float loadFactor;
    int threshold;
    int modCount = 0;
    private int[] cache;
    private static final int CACHE_BIT_SIZE = 15;
    private static final int DEFAULT_SIZE = 16;

    public ObjectIntPrimitiveHashMap() {
        this(16);
    }

    Entry<K>[] newElementArray(int s) {
        return new Entry[s];
    }

    public ObjectIntPrimitiveHashMap(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        capacity = ObjectIntPrimitiveHashMap.calculateCapacity(capacity);
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity);
        this.loadFactor = 0.75f;
        this.computeMaxSize();
    }

    private static final int calculateCapacity(int x) {
        if (x >= 0x40000000) {
            return 0x40000000;
        }
        if (x == 0) {
            return 16;
        }
        if (x == 1) {
            return 2;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public ObjectIntPrimitiveHashMap(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        capacity = ObjectIntPrimitiveHashMap.calculateCapacity(capacity);
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity == 0 ? 1 : capacity);
        this.loadFactor = loadFactor;
        this.computeMaxSize();
    }

    public ObjectIntPrimitiveHashMap(ObjectIntPrimitiveHashMap<? extends K> map) {
        this(map.size() < 6 ? 11 : map.size() * 2);
        this.putAll(map);
    }

    @Override
    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
            this.cache = null;
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    @Override
    public boolean containsKey(Object key) {
        Entry<K> m = this.getEntry(key);
        return m != null;
    }

    @Override
    public boolean containsValue(int value) {
        int i = this.elementData.length;
        while (--i >= 0) {
            Entry<K> entry = this.elementData[i];
            while (entry != null) {
                if (value == entry.value) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }

    @Override
    public int get(Object key) {
        int index;
        if (key != null && this.cache != null && key instanceof Integer && (index = ((Integer)key).intValue()) >> 15 == 0) {
            return this.cache[index];
        }
        Entry<K> m = this.getEntry(key);
        if (m != null) {
            return m.value;
        }
        return -1;
    }

    @Override
    public int hashCode() {
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return ObjectIntPrimitiveHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return ObjectIntPrimitiveHashMap.this.size();
                }

                @Override
                public void clear() {
                    ObjectIntPrimitiveHashMap.this.clear();
                }

                @Override
                public boolean remove(Object key) {
                    Entry entry = ObjectIntPrimitiveHashMap.this.removeEntry(key);
                    return entry != null;
                }

                @Override
                public Iterator<K> iterator() {
                    return new KeyIterator(ObjectIntPrimitiveHashMap.this);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public int put(K key, int value) {
        Entry<Object> entry;
        if (key == null) {
            entry = this.findNullKeyEntry();
            if (entry == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                }
                entry = this.createHashedEntry(null, 0, 0);
            }
        } else {
            int hash = key.hashCode();
            int index = hash & this.elementData.length - 1;
            entry = this.findNonNullKeyEntry(key, index, hash);
            if (entry == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                    index = hash & this.elementData.length - 1;
                }
                entry = this.createHashedEntry(key, index, hash);
            }
            if (this.cache != null && hash >> 15 == 0 && key instanceof Integer) {
                this.cache[hash] = value;
            }
        }
        int result = entry.value;
        entry.value = value;
        return result;
    }

    Entry<K> createEntry(K key, int index, int value) {
        Entry<K> entry = new Entry<K>(key, value);
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    Entry<K> createHashedEntry(K key, int index, int hash) {
        Entry<K> entry = new Entry<K>(hash, key);
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    void rehash() {
        this.rehash(this.elementData.length);
    }

    void rehash(int capacity) {
        int length = ObjectIntPrimitiveHashMap.calculateCapacity(capacity == 0 ? 1 : capacity << 1);
        Entry<K>[] newData = this.newElementArray(length);
        int i = 0;
        while (i < this.elementData.length) {
            Entry<K> entry = this.elementData[i];
            while (entry != null) {
                int actualHash = i & 1 | entry.storedKeyHash & 0xFFFFFFFE;
                int index = actualHash & length - 1;
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
            ++i;
        }
        this.elementData = newData;
        this.computeMaxSize();
        if (this.cache == null && this.elementCount > 8192) {
            this.analyzeMap();
        }
    }

    private synchronized void analyzeMap() {
        int count = 0;
        int critical = this.elementCount - (this.elementCount >> 3);
        for (K k : this.keySet()) {
            if (!(k instanceof Integer) || (Integer)k >> 15 != 0) continue;
            ++count;
        }
        if (count >= critical) {
            this.cache = new int[32768];
            for (Entry entry : this.entrySet()) {
                if (!(entry.getKey() instanceof Integer) || (Integer)entry.getKey() >> 15 != 0) continue;
                this.cache[((Integer)entry.getKey()).intValue()] = entry.getValue();
            }
        }
    }

    @Override
    public int remove(Object key) {
        Entry<K> entry = this.removeEntry(key);
        if (entry != null) {
            return entry.value;
        }
        return -1;
    }

    final Entry<K> removeEntry(Object key) {
        Entry<K> entry;
        int index = 0;
        Entry<K> last = null;
        if (key != null) {
            int keyHash = key.hashCode();
            index = keyHash & this.elementData.length - 1;
            entry = this.elementData[index];
            if (key instanceof Integer) {
                if (this.cache != null && keyHash >> 15 == 0) {
                    this.cache[keyHash] = -1;
                }
                int storedKeyHash = keyHash | 1;
                while (entry != null && entry.storedKeyHash != storedKeyHash) {
                    last = entry;
                    entry = entry.next;
                }
            } else {
                int storedKeyHash = keyHash & 0xFFFFFFFE;
                while (!(entry == null || entry.storedKeyHash == storedKeyHash && ObjectIntPrimitiveHashMap.areEqualKeys(key, entry.key))) {
                    last = entry;
                    entry = entry.next;
                }
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && entry.key != null) {
                last = entry;
                entry = entry.next;
            }
        }
        if (entry == null) {
            return null;
        }
        if (last == null) {
            this.elementData[index] = entry.next;
        } else {
            last.next = entry.next;
        }
        ++this.modCount;
        --this.elementCount;
        return entry;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    public int[] values() {
        return null;
    }

    @Override
    public Set<ObjectIntPrimitiveMap.Entry<K>> entrySet() {
        return new ObjectIntHashMapEntrySet(this);
    }

    final Entry<K> getEntry(Object key) {
        Entry<K> m;
        if (key == null) {
            m = this.findNullKeyEntry();
        } else {
            int hash = key.hashCode();
            int index = hash & this.elementData.length - 1;
            m = this.findNonNullKeyEntry(key, index, hash);
        }
        return m;
    }

    final Entry<K> findNonNullKeyEntry(Object key, int index, int keyHash) {
        Entry<K> m = this.elementData[index];
        if (key instanceof Integer) {
            int storedKeyHash = keyHash | 1;
            while (m != null && m.storedKeyHash != storedKeyHash) {
                m = m.next;
            }
        } else {
            int storedKeyHash = keyHash & 0xFFFFFFFE;
            while (!(m == null || m.storedKeyHash == storedKeyHash && ObjectIntPrimitiveHashMap.areEqualKeys(key, m.key))) {
                m = m.next;
            }
        }
        return m;
    }

    final Entry<K> findNullKeyEntry() {
        Entry<K> m = this.elementData[0];
        while (m != null && m.key != null) {
            m = m.next;
        }
        return m;
    }

    static boolean areEqualKeys(Object key1, Object key2) {
        return key1 == key2 || key1.equals(key2);
    }

    private static class AbstractMapIterator<K> {
        private int position = 0;
        int expectedModCount;
        Entry<K> futureEntry;
        Entry<K> currentEntry;
        Entry<K> prevEntry;
        final ObjectIntPrimitiveHashMap<K> associatedMap;

        AbstractMapIterator(ObjectIntPrimitiveHashMap<K> hm) {
            this.associatedMap = hm;
            this.expectedModCount = hm.modCount;
            this.futureEntry = null;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.futureEntry == null) ** GOTO lbl7
            return true;
lbl-1000:
            // 1 sources

            {
                if (this.associatedMap.elementData[this.position] == null) {
                    ++this.position;
                    continue;
                }
                return true;
lbl7:
                // 2 sources

                ** while (this.position < this.associatedMap.elementData.length)
            }
lbl8:
            // 1 sources

            return false;
        }

        final void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        final void makeNext() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.futureEntry == null) {
                this.currentEntry = this.associatedMap.elementData[this.position++];
                this.futureEntry = this.currentEntry.next;
                this.prevEntry = null;
            } else {
                if (this.currentEntry != null) {
                    this.prevEntry = this.currentEntry;
                }
                this.currentEntry = this.futureEntry;
                this.futureEntry = this.futureEntry.next;
            }
        }

        public final void remove() {
            int index;
            this.checkConcurrentMod();
            if (this.currentEntry == null) {
                throw new IllegalStateException();
            }
            if (((ObjectIntPrimitiveHashMap)this.associatedMap).cache != null && this.currentEntry.key instanceof Integer && (index = ((Integer)this.currentEntry.key).intValue()) >> 15 == 0) {
                ((ObjectIntPrimitiveHashMap)this.associatedMap).cache[index] = -1;
            }
            if (this.prevEntry == null) {
                index = this.currentEntry.storedKeyHash & this.associatedMap.elementData.length - 1;
                if (this.associatedMap.elementData[index &= 0xFFFFFFFE] == this.currentEntry) {
                    this.associatedMap.elementData[index] = this.associatedMap.elementData[index].next;
                } else {
                    this.associatedMap.elementData[index |= 1] = this.associatedMap.elementData[index].next;
                }
            } else {
                this.prevEntry.next = this.currentEntry.next;
            }
            this.currentEntry = null;
            ++this.expectedModCount;
            ++this.associatedMap.modCount;
            --this.associatedMap.elementCount;
        }
    }

    static class Entry<K>
    extends ObjectIntPrimitiveMapEntry<K> {
        final int storedKeyHash;
        Entry<K> next;

        Entry(int hash, K theKey) {
            super(theKey);
            this.storedKeyHash = theKey instanceof Integer ? hash | 1 : hash & 0xFFFFFFFE;
        }

        Entry(K theKey, int theValue) {
            super(theKey, theValue);
            this.storedKeyHash = theKey == null ? 0 : (theKey instanceof Integer ? theKey.hashCode() | 1 : theKey.hashCode() & 0xFFFFFFFE);
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value;
        }

        @Override
        public String toString() {
            return this.key + "=" + Integer.toString(this.value);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public int setValue(int theValue) {
            int oldValue = this.value;
            this.value = theValue;
            return oldValue;
        }
    }

    private static class EntryIterator<K>
    extends AbstractMapIterator<K>
    implements Iterator<ObjectIntPrimitiveMap.Entry<K>> {
        EntryIterator(ObjectIntPrimitiveHashMap<K> map) {
            super(map);
        }

        @Override
        public ObjectIntPrimitiveMap.Entry<K> next() {
            this.makeNext();
            return this.currentEntry;
        }
    }

    private static class KeyIterator<K>
    extends AbstractMapIterator<K>
    implements Iterator<K> {
        KeyIterator(ObjectIntPrimitiveHashMap<K> map) {
            super(map);
        }

        @Override
        public K next() {
            this.makeNext();
            return (K)this.currentEntry.key;
        }
    }

    static class ObjectIntHashMapEntrySet<KT>
    extends AbstractSet<ObjectIntPrimitiveMap.Entry<KT>> {
        private final ObjectIntPrimitiveHashMap<KT> associatedMap;

        public ObjectIntHashMapEntrySet(ObjectIntPrimitiveHashMap<KT> hm) {
            this.associatedMap = hm;
        }

        ObjectIntPrimitiveHashMap<KT> hashMap() {
            return this.associatedMap;
        }

        @Override
        public int size() {
            return this.associatedMap.elementCount;
        }

        @Override
        public void clear() {
            this.associatedMap.clear();
        }

        @Override
        public boolean remove(Object object) {
            Entry oEntry;
            Entry<KT> entry;
            if (object instanceof Entry && ObjectIntHashMapEntrySet.valuesEq(entry = this.associatedMap.getEntry((oEntry = (Entry)object).getKey()), oEntry)) {
                this.associatedMap.removeEntry(entry.key);
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Entry) {
                Entry oEntry = (Entry)object;
                Entry<KT> entry = this.associatedMap.getEntry(oEntry.getKey());
                return entry.value == oEntry.value;
            }
            return false;
        }

        private static boolean valuesEq(Entry<?> entry, Entry<?> oEntry) {
            return entry != null && entry.value == oEntry.value;
        }

        @Override
        public Iterator<ObjectIntPrimitiveMap.Entry<KT>> iterator() {
            return new EntryIterator<KT>(this.associatedMap);
        }
    }
}

