/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fpm.common.utility;

import com.ibm.cognos.fpm.common.primitives.ObjectIntPrimitiveHashMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class KeyedHashSet<E>
extends AbstractSet<E>
implements Set<E> {
    private final ObjectIntPrimitiveHashMap<E> backingMap;
    private final List<E> backingArray;

    public KeyedHashSet() {
        this(new ObjectIntPrimitiveHashMap(), new ArrayList());
    }

    public KeyedHashSet(int capacity) {
        this(new ObjectIntPrimitiveHashMap(capacity), new ArrayList(capacity));
    }

    public KeyedHashSet(int capacity, float loadFactor) {
        this(new ObjectIntPrimitiveHashMap(capacity, loadFactor), new ArrayList(capacity));
    }

    public KeyedHashSet(Collection<? extends E> collection) {
        this(new ObjectIntPrimitiveHashMap(collection.size() < 6 ? 11 : collection.size() * 2), new ArrayList(collection.size()));
        for (E e : collection) {
            this.add(e);
        }
    }

    private KeyedHashSet(ObjectIntPrimitiveHashMap<E> backingMap, List<E> backingArray) {
        this.backingMap = backingMap;
        this.backingArray = backingArray;
    }

    @Override
    public boolean add(E object) {
        if (this.contains(object)) {
            return false;
        }
        this.backingMap.put(object, this.backingArray.size());
        this.backingArray.add(object);
        return true;
    }

    public int addAndReturnKey(E object) {
        int key = this.backingMap.get(object);
        if (key != -1 && this.backingArray.get(key) != null) {
            return key;
        }
        key = this.backingArray.size();
        this.backingMap.put(object, key);
        this.backingArray.add(object);
        return key;
    }

    @Override
    public boolean contains(Object object) {
        int index = this.backingMap.get(object);
        return index != -1 && this.backingArray.get(index) != null;
    }

    public boolean contains(int key) {
        if (key < 0 || key >= this.backingArray.size()) {
            return false;
        }
        return this.backingArray.get(key) != null;
    }

    public int getKey(E object) {
        return this.backingMap.get(object);
    }

    public E get(E object) {
        int index = this.backingMap.get(object);
        if (index == -1) {
            return null;
        }
        return this.backingArray.get(index);
    }

    public E get(int key) {
        if (key < 0 || key >= this.backingArray.size()) {
            return null;
        }
        return this.backingArray.get(key);
    }

    public E remove(int key) {
        if (!this.contains(key)) {
            return null;
        }
        E removedObj = this.backingArray.set(key, null);
        this.backingMap.remove(removedObj);
        return removedObj;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<E> it;
            private E lastKey;
            {
                this.it = KeyedHashSet.this.backingMap.keySet().iterator();
                this.lastKey = null;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public E next() {
                this.lastKey = this.it.next();
                return this.lastKey;
            }

            @Override
            public void remove() {
                if (this.lastKey == null) {
                    throw new IllegalStateException();
                }
                int index = KeyedHashSet.this.backingMap.get(this.lastKey);
                KeyedHashSet.this.backingArray.set(index, null);
                this.lastKey = null;
                this.it.remove();
            }
        };
    }

    @Override
    public boolean remove(Object object) {
        int index = this.backingMap.get(object);
        if (index == -1 || this.backingArray.get(index) == null) {
            return false;
        }
        this.backingMap.remove(object);
        this.backingArray.set(index, null);
        return true;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }
}

