/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.tds.pdc;

import com.ibm.cognos.pdc.CacheException;
import com.ibm.cognos.pdc.CacheMap;
import com.ibm.cognos.pdc.CompoundKey;
import com.ibm.cognos.pdc.PDC;
import com.ibm.cognos.pdc.PDCGrid;
import com.ibm.cognos.pdc.Session;
import com.ibm.cognos.pdc.SessionContext;
import com.ibm.cognos.tds.TDS;
import com.ibm.cognos.tds.TDSException;
import com.ibm.cognos.tds.pdc.PDCSessionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TDSImpl
implements TDS {
    private PDCGrid grid;
    private String passportID = null;

    public TDSImpl(String componentID, String passportID) {
        PDC pdc = new PDC();
        this.grid = pdc.getPDCGrid(componentID);
        this.passportID = passportID;
    }

    TDSImpl(PDCGrid pdcGrid) {
        this.grid = pdcGrid;
    }

    @Override
    public String getValue(String mapID, String sessionID) {
        return this.getValueWithKey(mapID, sessionID, sessionID);
    }

    private SessionContext createSessionContext(String sessionID) {
        if (this.passportID == null) {
            return PDCSessionUtil.createSessionContext(sessionID);
        }
        return PDCSessionUtil.createSessionContext(this.passportID);
    }

    private String getValueWithKey(String mapID, String sessionID, Object key) {
        String value = null;
        try {
            Session session = this.grid.getSession(this.createSessionContext(sessionID));
            session.begin();
            CacheMap map = session.getMap(mapID);
            value = (String)map.get(key);
            session.commit();
        }
        catch (CacheException ex) {
            throw new TDSException(ex);
        }
        return value;
    }

    @Override
    public String putValue(String mapID, String sessionID, String value) {
        return this.putValueWithKey(mapID, sessionID, sessionID, value);
    }

    private String putValueWithKey(String mapID, String sessionID, Object key, String value) {
        String oldValue = null;
        try {
            Session session = this.grid.getSession(this.createSessionContext(sessionID));
            session.begin();
            CacheMap map = session.getMap(mapID);
            oldValue = (String)map.put(key, (Object)value);
            session.commit();
        }
        catch (CacheException ex) {
            throw new TDSException(ex);
        }
        return oldValue;
    }

    @Override
    public void removeValue(String mapID, String sessionID) {
        this.removeValueWithKey(mapID, sessionID, sessionID);
    }

    private void removeValueWithKey(String mapID, String sessionID, Object key) {
        try {
            Session session = this.grid.getSession(this.createSessionContext(sessionID));
            session.begin();
            CacheMap map = session.getMap(mapID);
            map.remove(key);
            session.commit();
        }
        catch (CacheException ex) {
            throw new TDSException(ex);
        }
    }

    @Override
    public String getMappedValue(String mapID, String sessionID, String key) {
        CompoundKey compKey = new CompoundKey((Object)sessionID, (Object)key);
        return this.getValueWithKey(mapID, sessionID, compKey);
    }

    @Override
    public String putMappedValue(String mapID, String sessionID, String key, String value) {
        CompoundKey compKey = new CompoundKey((Object)sessionID, (Object)key);
        return this.putValueWithKey(mapID, sessionID, compKey, value);
    }

    @Override
    public void removeMappedValue(String mapID, String sessionID, String key) {
        CompoundKey compKey = new CompoundKey((Object)sessionID, (Object)key);
        this.removeValueWithKey(mapID, sessionID, compKey);
    }

    @Override
    public List<String> getMappedValuesForSession(String mapID, String sessionID) {
        ArrayList<String> mapList = new ArrayList<String>();
        try {
            Session session = this.grid.getSession(this.createSessionContext(sessionID));
            session.begin();
            CacheMap map = session.getMap(mapID);
            Object sessionObj = map.get((Object)sessionID);
            if (sessionObj instanceof Map) {
                mapList.addAll(((Map)sessionObj).keySet());
            }
            session.commit();
        }
        catch (CacheException ex) {
            throw new TDSException(ex);
        }
        return mapList;
    }
}

